@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
<style>
</style>
@stop
@section('content')
@include("layouts.Cmodal")
<div class="row" >
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewPurchaseOrder') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'purchaseOrderRoll.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form'])}}
                {{ csrf_field() }}
                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                          <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Vendor')</label>
                                      <div class="input-group">
                                          <v-select  label="name" @input="memberChange()" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                          <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                          <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                              <i class="fa fa-plus" style="color: white"></i>
                                          </span> 
                                      </div>
                                  </div>
                              </div> 
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">                               
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Number')</label>
                                       <input type="number" name="number" value="{{$number}}" class="form-control">
                                  </div>
                              </div> 
                            </div>
                            
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">                                
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Code')</label>
                                       <input type="text" name="orderNumber" value="{{$number}}" class="form-control">
                                  </div>
                              </div> 
                            </div>
                          </div>

                        <div class="row">
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">                         
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Currency')</label>           
                                      <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                      <input type="hidden" name="currency" :value="selected_currency.code">
                                  </div>
                            </div> 
                          </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">                                 
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Rate')</label>  
                                       <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                  </div>
                              </div> 
                          </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">         
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Discount')</label>
                                        <div class="input-group">
                                        <input  v-model="discountFiled" class="form-control"
                                       type="number" min="0" max="100">
                                            <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                              <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                          </span>
                                          <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                                              <input type="hidden" name="discount_type" value="percent">
                                          </span>
                                          <input type="hidden" name="discountTotal" :value="discount">
                                          <input type="hidden" name="discount" :value="discountFiled">
                                     </div>
                                  </div>
                              </div> 
                          </div>
                        </div>
                        <div class="row">
                            <!--<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Account')</label>
        
                                       <v-select  label="name"  :options="approperiateBank" v-model="selected_banks"></v-select>
                                       <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                  </div>
                              </div> 
                          </div> -->
                           <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Code') @lang('layout.Prepaid')</label>      
                                       <input type="number" name="prepaid_code"  class="form-control" autocomplete="off">
                                  </div>
                              </div> 
                            </div>
                           <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.DeliveryDate')</label>
        
                                       <input type="text" name="delivery_date"  class="form-control date" autocomplete="off">
                                  </div>
                              </div> 
                          </div>
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Date')</label>
        
                                       <input type="text" name="date"  class="form-control date" autocomplete="off">
                                  </div>
                              </div> 
                          </div>
                        </div>
                        <div class="row">
                       
							              <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
        
                                        <textarea  name="description" class="form-control" rows="1"></textarea>
                                  </div>
                              </div> 
                          </div>
						                
                          
                        </div>
                          <!-- end inputs -->
                      </div>
                       <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                        <!-- begin total -->
                           <div class="dashboard-stat2 ">
                            <table class="dashboard-tabel" width="100%">
                              <tr>
                                  <td>
                                      <small>@lang('layout.Total') :</small>
                                  </td>
                                  <td class="text-right"><span data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                     <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                 </td>
                             </tr>

                             <tr>
                              <td>
                                  <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
                              </td>
                              <td class="text-right">
                               <span class="text-right" data-counter="counterup"
                               data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                               <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                               <input type="hidden" name="totalAmountes" v-model="totalAmountes">
                           </td>
                       </tr>

                      <tr>
                          <td>
                              <small>@lang('layout.Payment'):</small>
                          </td>
                          <td class="text-right">
                              <small class="font-green-sharp">
                                  <span class="text-right" data-counter="counterup"
                                  data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </small>
                          </td>
                      </tr>


                      <tr>
                          <td>
                              <small>@lang('layout.Sub-Total'):</small>
                          </td>
                          <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                              data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                          </td>
                      </tr>


                  </table>

                           </div>

                        <!-- end total -->
                       </div>

                      </div>


                     
                     <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                         <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                          <thead>
                              <tr>
                                  <th>#</th>
                                  <th v-show="showWhat('sale_category')=='yes'" style="min-width: 100px">@lang('layout.Category') </th>
                                  <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                  <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                  <th style="min-width: 100px">@lang('layout.Code') </th>
                                  <th>@lang('layout.Description') </th>
                                  <th>@lang('layout.ExpireDate') </th>
                                  <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                  <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                  <th style="min-width: 100px">@lang('layout.Measure') </th>
                                  <th style="min-width: 50px">@lang('layout.NewCost') </th>
                                  <th style="min-width: 50px">@lang('layout.Total') </th>
                                  <th></th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in inventories">
                                  <td>@{{index+1}}</td>
                                  <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                                      <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                                @input="itemCategoryChange(index)" @click.native="addNew('inventory',index)"></v-select>
                                      <input type="hidden" :name="'inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                                  </td>
                                  <td class="highlight">
                                      <v-select label="name" v-model="item.inventory" :options="temp_items" @keyup.native="onItemLoadCode(index)" @click.native="onItemLoadCode(index), addNew('inventory',index)" @search="onItemSearch"></v-select>
                                      <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                  </td>
								  <td class="highlight">
                                      <v-select label="name" v-model="(item.item==null)?null:item.item.site" :options="(item.item==null)?site_list:item.item.site_list"></v-select>
                                      <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.id)">
                                  </td>
								  <td class="highlight">
                                        <input type="text" name="code[]" v-model="(item.item==null)?null:item.item.code"
                                        oninput = "autowidths(event)" class="form-control input-style input-number chan_length"  placeholder="@lang('layout.Code')">
                                  </td>
                                   
                                  <td>
                                     <input type="text" placeholder="@lang('layout.Description')" name="inventory_description[]"
                                     oninput = "autowidths(event)"
                                      class="form-control chan_length">
                                  </td>
                                  <td>
                                     <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                     oninput = "autowidths(event)" class="date form-control chan_length">
                                  </td>
                                  <td>
                                     <input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity"
                                     oninput = "autowidths(event)" class="form-control input-style input-number chan_length"  placeholder="@lang('layout.Quantity')">
                                  </td>

                                  <td>
                                  <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                     @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                  </td>
                                  <td class="highlight">
                                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                          <option value="null">@lang('layout.Select')</option>
                                          <span v-if="(item.item ==null)?false:true">
                                              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                          
                                         
                                      </select>
                                     
                                      <input type="hidden" name="measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                  </td>
                                  <td>
                                    <div class="input-group">
                                      <input type="number" name="inventory_price[]"  placeholder="@lang('layout.Cost')"   :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="in" @input="setNewRate(index)"
                                      oninput = "autowidths(event)" class="form-control chan_length">
                                      <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                     
                                  </td>
                                  <td>
                                     <div>
                                         <div class="input-group">
                                            <input type="number" class="form-control inner_input chan_length"  oninput = "autowidths(event)" :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate, null, null, null, null, null, selected_currency.static_rate)" placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon" >
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                         </div>
                                     </div>
                                  </td>
                                  <td>
                                       <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                  </td>
                              </tr>
                          </tbody>
                      </table>
                     <hr>

                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" :name="'payment_id['+index+']'"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                    <span v-if="payment.item !=null">
                                     @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                   </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate"
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_rate['+index+']'"
                                           v-bind:value="payment.item.rate">
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_rate_hq['+index+']'"
                                           v-bind:value="payment.item.hq_rate">
                                </td>
                                <td>
                                    <input type="text" :name="'payment_currency['+index+']'" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" :name="'payment_currency['+index+']'"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" :name="'payment_amount['+index+']'"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    @{{ (payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                     class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->
                 
                     </div>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button"  @click="submitForm" class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                        <a href="{{route('purchaseOrderRoll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">
                  
                </cmodal>
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">

    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

  Vue.use(VueInputAutowidth);
  Vue.component('v-select', VueSelect.VueSelect);
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
        return {
            types: [],
            receivables: [],
            payables: [],
            code: null,
            selectType: null,
            selectPay: null,
            selectReceive: null,

classes:[],
            selectedClass: null,

        }
    },
    created(){
      
      axios.get('{{route("customer.create")}}').then(
        response=>{
          this.types = response.data.types;
          if(this.types)
          {
            for(var i=0;i<this.types.length;i++)
            {
              if(this.types[i].type=="Vendor")
              {
                 this.selectType=this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
           this.classes = response.data.member_class;
            if (this.receivables.length > 0) {
                this.selectReceive = this.receivables[0];
            }
            if (this.payables.length > 0) {
                this.selectPay = this.payables[0];
            }

        }).catch(error=> console.log(error));
    },
    methods:{
      onSubmit(){

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers:{'X-CSRF-TOKEN':"{{csrf_token()}}"},
          url:'{{route("customer.store")}}',
          method:'post',
          data: {
          "name": datas[0]['value'],
          'code': datas[1]['value'],
          'email': datas[2]['value'],
          'phone': datas[3]['value'],
          'address1': datas[4]['value'],
          'type':this.selectType.id,
          'receivable':this.selectReceive.id,
          'payable':this.selectPay.id,
          'class':(this.selectedClass)?this.selectedClass.id:null
        },
          dataType: 'json',

        }).done(function(response){
          if (response) {
              v.selected_vendor = response.customer;
          }
        }).fail(function(error){
          console.log('error',error);
        });
        
      }
    }
  });


  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var inventory_category = {!! $inventory_category !!};
  var v = new Vue({
    el: '#app',
    data: {
       showModal: false,
       vendor: [],
       selected_vendor:null,
       banks:banks,
       selected_banks:null,
       currency:currency,
       selected_currency: {!! json_encode(getHomeCurrency()) !!},
       rate:0,
       discountFiled: 0,
       selectedIndex: 0,
       inventory_category: inventory_category,
       discountIsAmount:false,
       temp_items:[],
       site_list:[],
       totalAmountes: [],
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
          {item:null, inventory:null, item_category:null},
          {item:null, inventory:null, item_category:null},
          {item:null, inventory:null, item_category:null},
          {item:null, inventory:null, item_category:null}
       ],
        payments: [
                {
                    items: banks,
                    item: null,
                }
        ],
    },
    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },
        discount()
        {
          if(this.discountIsAmount){

              if(this.subtotal>0 && this.discountFiled) {
                  return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
              }else {
                  return 0;
              }
              }else {

                  return this.discountFiled
              }

          },

          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  

                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                          @if(systemConfig()[30] == 1)
                           sum +=new_rate*quantity*this.selected_currency.static_rate / this.selected_currency.rate;
                           @else 
                           sum +=new_rate*quantity*this.selected_currency.rate;
                           @endif

                        }
                        else
                        {
                          @if(systemConfig()[30] == 1)
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.static_rate / this.selected_currency.rate);
                          @else 
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          @endif

                        }
                        
                    }
                    this.totalAmountes=sum;

                }
                // for (var i = 0; i < this.services.length; i++) {
                //     if (this.services[i].item)
                //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                // }
                return sum;
          },

          // check payed amount
          payeds: function ()
           {
              var sum = 0;
              for (var i = 0; i < this.payments.length; i++)
               {

                  if(this.payments[i].item !=null && this.payments[i].item)
                  {
                     if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
                     {
                      //

                      @if(systemConfig()[30] == 1)
                      sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                      @else 
                      sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                      @endif
                    }
                  }
                }
                return sum;
            },

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 for (var i = 0; i < this.inventories.length; i++)
                 {
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    }
                 }
                 if(this.inventories.length==0 || this.selected_vendor==undefined || this.selected_vendor==null  || flag==false)
                 {
                    isError = true;
                 }
                 
                return isError;
              

            },
            // filter the banks according to selected currency
            approperiateBank:function()
           {
                var bankCopy=this.banks.slice();
                var tempBank=bankCopy.filter((account)=>{
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if(tempBank.length>0)
                {
                    this.selected_banks=tempBank[0];
                }
                return tempBank;
           },
    },
    methods:
    {
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
           if(this.selected_vendor)
           {
            // get member contract
           }
       },

       MemberSearch: _.debounce((search, loading) => {
          loading(true);
          let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
          
          axios.get("{{route('callMethod.search')}}", {
              params: {
                  method_name: 'SearchMember', 
                  keyword: search,
                  class_id: class_id,
                  type: 'Vendor'
              }
          })
          .then(function(response) {
              if (response.data.length > 0) {
                  // console.log(response.data);
                  v.vendor = [];
                  v.vendor = response.data;
              }
              loading(false);
          })
          .catch(function(error) {
              loading(false);
              console.log(error);
          })
      }, getDebounceTime()),

       // set new price
       setNewRate(index)
       {
           if(this.inventories[index].item){
            @if(systemConfig()[30] == 1)
            this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.static_rate * this.selected_currency.rate;
            @else 
            this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            @endif
            }

       },
      // begin item search

      itemCategoryChange(index) {
        
        v.selectedIndex = index;
        v.selected_iventory_category = this.inventories[index]['item_category'];
        if (this.inventories[index]['item_category'] != null) {
              let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
              axios.get("{{route('callMethod.search')}}", {
                  params: {
                      method_name: 'itemSearchNameRoll',
                      inventory_category_id: inventory_category_id
                  }
              })
                  .then(function (response) {
                      v.inventories[index]['item'] = null;
                      v.inventories[index]['inventory'] = null;
                      v.inventories[index]['selectedBrand'] = null;
                      v.temp_items = [];

                      if (response.data.length > 0) {
                          v.temp_items = response.data;
                      }

                  })
                  .catch(function (error) {
                      console.log(error);
                  });

            }

        },

       onItemSearch:_.debounce((search,loading) =>{
        var selectedIndex = v.selectedIndex;
        let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
        loading(true);
        axios.get("{{route('callMethod.search')}}",{
          params:{
            method_name:'itemSearchNameRoll',
            keyword:search,
            inventory_category_id:inventory_category_id
          }
        })
        .then(function(response){
          if(response.data.length >0)
          {
			      v.temp_items = [];
            v.temp_items = response.data;
          // console.log('123',v.temp_items);
          }
          loading(false);
        })
        .catch(function(error){
          console.log(error);
        })
       },getDebounceTime()),
       // end item search
	   
	   //ajax call to get items code
		onItemLoadCode(selectedIndex) {
			// v.selectedIndex = selectedIndex;
			
			if (v.inventories[selectedIndex].inventory != null) {
				var inventory_id = v.inventories[selectedIndex].inventory.id;
				
				axios.get("{{route('callMethod.search')}}", {
					params: {
						member_id: v.member_id,
						method_name: 'itemSearchPurchaseRoll',
						inventory_id: inventory_id,
						// inventory_category_id: inventory_category_id,
					}
				})
				.then(function (response) {
					v.inventories[selectedIndex].item = null;
					if (response.data.length > 0) {
						v.inventories[selectedIndex].item = response.data[0];
            v.temp_items = [];
					console.log('gg');
					
					// v.onItemSearchCodeSelect(selectedIndex);
					
					}
				})
				.catch(function (error) {
					console.log(error);
				})
			}
			
		},

       // end item search

    

       // generic function for adding item to list
       addNew(type=null,index)
       {
        v.selectedIndex = index;
          // this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {                                
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null, inventory:null, item_category:null});
                }
             }
             if(type=='payment')
             {
                if(this.payments[index+1]==undefined)
                {
                  this.checkExistingPayment(index,'');
                  this.payments.push({
                    items: this.banks,
                    item: null,
                });
                }
             }
          }
          
       },

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
              var bank_temp=this.banks.slice();
              var bank_temp1=[];
              for(var i=0;i<this.payments.length;i++)
              {
                  if(this.payments[i].item !=null)
                  {
                      var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
                      if(fined !=-1)
                      {
                        var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
                      }
                  }
              }
              this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
              if(type=='payment')
             {
                this.payments.splice(index, 1);
             }
         }
          
       },
       // submit the form
       submitForm() 
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete)
                {
                    document.getElementById("purchase-form").submit()

                }
                else
                {

                }
            });

        },
        saveAndNew()
        {
            this.$validator.validate()
            .then(valid =>{
                if(valid)
                {
                    
                    var url="{{route('purchaseOrderRoll.store')}}";
                    form_id='purchase-form';
                    var data= $('#'+form_id).serialize();
                    // console.log(444, data);
                    toggleBlock(true);
                    axios.post(url,data)
                    .then(function(response){
                            toggleBlock(0);
                            if(response.data.result==1)
                            {
                                $('#'+form_id).trigger('reset');
                                
                                toastr.success('',response.data.message); 
                                location.reload();
                            
                            }
                            else
                            {
                                var message="{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('',message);
                            }
                    })
                    .catch(function(error){
                    toggleBlock(0);
                        console.log(error);
                        var message="{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('',message);
                    });
                
                }
            })
        },
    },
    created:function()
    {
           
    }

  });

</script>


@endpush