@extends('layouts.factor-master')

@section('content')


<h3 class="table-caption" style="text-align: center;">@lang('layout.ContractList')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>


<table class="main-table">
	<thead>
		<tr class="bg">
		   <th class="center" >@lang('layout.Code')</th>
		   <th class="center" >@lang('layout.Vendor')</th>
		   <th class="center" >@lang('layout.Date')</th>
		   <th class="center" >@lang('layout.Description')</th>
		   <th class="center" >@lang('layout.ItemName')</th>
		   <th class="center" >@lang('layout.Quantity')</th>
		   <th class="center" >@lang('layout.Delivered')</th>
		   <th class="center" >@lang('layout.Remain')</th>
		   <th class="center" >@lang('layout.Measure')</th>
		   <th class="center" >@lang('layout.User')</th>
		</tr>
	</thead>
	<tbody>
		@if(isset($data))
		@foreach ($data as $item)
		<tr>
			<td>{{$item['orderNumber']}}</td>
			<td>{{$item['name']}}</td>
			<td>{{convertDate($item['date'])}}</td>
			<td>{{$item['description']}}</td>

			<td>{{$item['item']}}</td>
			<td>{{myRound($item['quantity'])}}</td>
			<td>{{($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']}}</td>
			<td>{{myRound($item['quantity'] - (($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']))}}</td>
			<td>{{$item['sale_order_measur']}}</td>
			<td>{{$item['user']}}</td>
		 </tr>
	   @endforeach
	   @endif
	</tbody>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection