@extends('layouts.app')
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PurchaseInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.Vendor')
                            </th>
                            <th>
                                <i class="fa fa-text-width"></i> @lang('layout.Category')
                            </th>
                            <th>
                                <i class="fa fa-text-width"></i> @lang('layout.Type')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency')
                            </th>
                            <th>
                                <i class="fa fa"></i>@lang('layout.Rate')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="center"> {{ $purchaseOrder->vendor}}  </td>
                            <td class="center"> {{ __('layout.'.ucfirst($purchaseOrder->category))}}  </td>
                            <td class="center"> {{ $purchaseOrder->type}}  </td>
                            <td class="center"> {{ $purchaseOrder->currency }}  </td>
                            <td class="center"> {{ $purchaseOrder->rate }} </td>
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.Description')
                            </th>
                            <th width=" ">
                                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $purchaseOrder->description}}  </td>
                            <td class=" "> {{ $purchaseOrder->memo}}  </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.PurchaseDetails') </span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="Purchase_Order_Details"/>
                        <input type="hidden" name="id" value="{{$purchaseOrder->id}}"/>
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                        </button>
                        {{Form::close()}}
                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="Purchase_Order_Details"/>
                        <input type="hidden" name="id" value="{{$purchaseOrder->id}}"/>
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') 
                        </button>
                        {{Form::close()}}
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="purchases">
                        <thead>
                            <tr>
                                <th>@lang('layout.ItemCode') </th>
                                <th>@lang('layout.ItemName') </th>
                                @if(getOtherMeasure()=="true")
                                <th>@lang('layout.OMeasureValue1')</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th>@lang('layout.OMeasureValue2')</th>
                                @endif
                                <th>@lang('layout.Quantity') </th>
                                <th>@lang('layout.Price') </th>
                                <th>@lang('layout.Cost') {{getHomeCurrency()[getCurrencyType()]}}</th>
                                <th>@lang('layout.Measure') </th>
                                <th>@lang('layout.Total') </th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#purchases').DataTable({
                ajax: '{{route("purchaseOrder.show",$purchaseOrder->id)}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'item_number', name: 'items.number'},
                    {data: 'item_name', name: 'items.name'},
                    @if(getOtherMeasure()=="true")
                    { data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
                    @endif
                    @if(getOtherMeasure2()=="true")
                    { data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
                    @endif
                    {data: 'quantity', name: 'quantity', orderable: false, searchable: false},
                    {data: 'cost', name: 'cost', orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'measure', name: 'measure', orderable: false, searchable: false},
                    {data: 'total', name: 'total', orderable: false, searchable: false},
                ]
            });
        });
    </script>
@endpush