@extends('layouts.app')

@section('style')
<style>
    .modal-container{
	width: 60% !important;
}
</style>
@endsection
@section('content') 
    <!-- END PAGE HEADER-->
     <!-- BEGIN CONTENT -->
     <div id="print-modal"> 
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'purchaseorderlistSimple'"
                      @closed="closeModal"> 
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">

                            <ul class="nav nav-tabs">
                                
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">
                                            <div class="row">
                                                <div class="form-group">
                            
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.Category') </label>
                                                        <v-select class="vue-select2" v-model="selectedCategory" label="name"
                                                                  :options="inventoryCategory">
                                                        </v-select>
                                                        <input type="hidden" name="category_id"
                                                               v-model.number="(!selectedCategory)?null:selectedCategory.id">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.SelectMember') </label>
                                                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="vendor">
                                                        </v-select>
                                                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Type')</label>
                                                        <select name="report_type" class="form-control">
                                                            <option value="">@lang('layout.SelectType')</option>
                                                            <option value="with_item">@lang('layout.WithItem')</option>
                                                            <option value="with_item_and_purchase">@lang('layout.WithItemAndPurchases')</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div  class="col-md-5">
                                                    <label class="control-label ">@lang('layout.Number') </label>
                                                    <input type="text" name="code" class="form-control"  autocomplete="off">
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <h4> <label class="control-label"> @lang('layout.All') <input name="all" type="checkbox" value="true"> </label> </h4>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                                    <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" >
                                                    </v-select>
                                                    <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id" >
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <h4> <label class="control-label"> @lang('layout.All') @lang('layout.Items') <input name="all_item" type="checkbox" value="true"> </label> </h4>
                                                    </div>
                                                </div>
                                            </div>
                            
                                            <div class="row">
                                                <div class="form-group">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Date')</label>
                                                            <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                            <option value="CustomDates">@lang('type.CustomDates')</option>
                                                            <option value="Today">@lang('type.Today')</option>
                                                            <option value="Yesterday">@lang('type.Yesterday')</option>
                                                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                            <option value="LastWeek">@lang('type.LastWeek')</option>
                                                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                            <option value="ThisYear">@lang('type.ThisYear')</option>
                                                            <option value="YearToDate">@lang('type.YearToDate')</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-8" v-show="period == 'CustomDates'">
                                                        <div class="form-group">
                                                            <label class="control-label"> @lang('layout.Date')</label>
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" name="from_date" v-model="from_date"
                                                                       autocomplete="off">
                            
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" name="to_date" v-model="to_date"
                                                                       autocomplete="off">
                            
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="purchase_order_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>

                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                             <!-- <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>










    {{-- End of print modal --}}
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.PurchaseOrder') </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <a href="{{route('purchaseOrder.graphicalshow')}}"><button class="btn btn-success">@lang('layout.GraphicalPresintation')</button></a>

                    @permission('purchaseOrder-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>

                    @endpermission
                    @permission('purchaseOrder-create')
                    <a href="{{route('purchaseOrder.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="purchaseOrder">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number') </th>
                        <th>@lang('layout.Vendor') </th>
                        <th>@lang('layout.Category') </th>
                        <th>@lang('layout.Type') </th>
                        <th>@lang('layout.Date') </th>
                        <th>@lang('layout.Amount') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
         var cust_rep = {!!customeReportNewData('purchase_order_index')!!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        //factorPrint("{{Session('sale_id')}}")
        @endif

        function orderPrint(id, sendWhatsapp = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            var a = document.createElement('a');
            a.href = "{{url('purchaseOrderFactorPrint')}}/" + id + "/" + sendWhatsapp;
            // a.href = "{{url('purchaseOrderFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#purchaseOrder').DataTable({
                ajax: '{{route("purchaseOrder.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                serverSide: true,
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'purchase_orders.number'},
                    {data: 'vendor', name: 'members.name'},
                    {data: 'category', name: 'purchase_orders.category' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'type', name: 'purchase_orders.type', orderable: false, searchable: false},
                    {data: 'date', name: 'purchase_orders.date', searchable: false},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'currency', name: 'purchase_orders.currency', width: "10%" @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'rate', name: 'purchase_orders.rate'},
                    {data: 'description', name: 'purchase_orders.description'},
                    {data: 'user', name: 'user', searchable: false},
                    {
                        data: 'actions',
                        name: 'actions',
                        width: "25%",
                        class: 'acctions',
                        orderable: false,
                        searchable: false
                    },


                ],

            });
        });


        Vue.component('v-select', VueSelect.VueSelect)

        var inventoryCategory = {!! json_encode($inventoryCategory)!!}
        // for new modal
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: null,
                vendor: [],
                inventoryCategory:inventoryCategory,
                selectedCategory:null,
                itemlist: [],
                selectedItem:null,
                customReportData:
                [
                 
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.DeliveryDate")', column_name: 'delivery_date',checkedColumn:(cust_rep.delivery_date)?'checked':'',column_percentage:(cust_rep.delivery_date___percent)?cust_rep.delivery_date___percent:''},
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(cust_rep.vendor)?'checked':'',column_percentage:(cust_rep.vendor___percent)?cust_rep.vendor___percent:''},
                 {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_rep.item)?'checked':'',column_percentage:(cust_rep.item___percent)?cust_rep.item___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Delivered")', column_name: 'delivered',checkedColumn:(cust_rep.delivered)?'checked':'',column_percentage:(cust_rep.delivered___percent)?cust_rep.delivered___percent:''},
                 {Name: '@lang("layout.Remain")', column_name: 'remain',checkedColumn:(cust_rep.remain)?'checked':'',column_percentage:(cust_rep.remain___percent)?cust_rep.remain___percent:''},
                 {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_rep.cost)?'checked':'',column_percentage:(cust_rep.cost___percent)?cust_rep.cost___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Rate") $', column_name: 'rate1',checkedColumn:(cust_rep.rate1)?'checked':'',column_percentage:(cust_rep.rate1___percent)?cust_rep.rate1___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Total1")', column_name: 'total1',checkedColumn:(cust_rep.total1)?'checked':'',column_percentage:(cust_rep.total1___percent)?cust_rep.total1___percent:''},
                  ],
                  cust_rep:cust_rep

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.vendor = [];
                            vm.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                onItemSearch(search, loading) {
                        loading(true);
                        this.searchItem(search, loading, this);
                    },
                    //ajax call to get items
                    searchItem(search, loading, vm) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'anyTable',
                                    'search_column': 'name',
                                    'table_name': 'items',
                                    keyword: search,
                                }
                            })
                            .then(function(response) {
                                this.itemlist = [];
                                if (response.data.length > 0) {
                                    vm.itemlist = response.data;
                                    // console.log('data', vm.itemlist);
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });

        
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal


        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   window.location.reload();
                }
            }
        });

    </script>


@endpush
















