@extends('layouts.app')
@section('content')
    @include('purchases.modal')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
		    <!-- BEGIN TAB PORTLET-->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'purchaseOrder.graphicalshow','method' => 'DELETE','class' => 'inline'])}}
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name"  @search="MemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">                         
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h3> <label class="control-label"> @lang('layout.All') <input name="all" type="checkbox" value="true"> </label> </h3>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
	    <div id="app1" v-cloak>
		{{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
			<input type="hidden" name="type" value="graphicalshowPurchase"/>
        <button id="show-modal1" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">                         
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h3> <label class="control-label"> @lang('layout.All') <input name="all" type="checkbox" value="true"> </label> </h3>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.PurchaseOrder')</span>
                </div>
                <div class="tools">
                 </div>
                <div class="pull-right">
                    <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-search"></i> @lang('layout.Search') </button>
                    <button type="button" class="btn green hidden-print" id="print_pdf_all1"> <i class="fa fa-print"></i> @lang('layout.Print') </button>
                    <!-- a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()"/><i class="fa fa-print"></i>  @lang('layout.Print')</a -->
                </div>
            </div>
            <div class="row">
                    <?php foreach ($saleOrderAll as $so): ?> 
                <div class="col-md-6 col-sm-12">
                    <div class="portlet green-meadow box">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="icon-user"></i>&nbsp; {{$so['name']}}
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="col-md-12 value">
                                     <table class="table">
                                        <thead>
                                            <tr class="active">
                                                <td style="text-align: center;">@lang('layout.Number')</td>
                                                <td style="text-align: center;">@lang('layout.Date')</td>
                                                <td style="text-align: center;">@lang('layout.Currency')</td>
                                                <td style="text-align: center;">@lang('layout.Rate')</td>
                                                <td style="text-align: center;">@lang('layout.Description')</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="active">
                                                <td style="text-align: center;">{{$so['number']}}</td>
                                                <td style="text-align: center;">{{convertDate($so['date'])}}</td>
                                                <td style="text-align: center;">{{$so['currency']}}</td>
                                                <td style="text-align: center;">{{$so['rate']}}</td>
                                                <td style="text-align: center;">{{$so['description']}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <br>
                                    <div >
                                        <table class="table table-bordered" >
                                            <thead>
                                                <tr>
                                                   <th style="text-align: center;">@lang('layout.ItemName')</th>
                                                   <th style="text-align: center;">@lang('layout.Inventory')</th>
                                                   <th style="text-align: center;">@lang('layout.Category')</th>
                                                   <th style="text-align: center;">@lang('layout.Quantity')</th>
                                                   <th style="text-align: center;">@lang('layout.Delivered')</th>
                                                   <th style="text-align: center;">@lang('layout.Remain')</th>
                                                   <th style="text-align: center;">@lang('layout.Measure')</th>
                                                   <th style="text-align: center;">@lang('layout.Price')</th>
                                                   <th style="text-align: center;">@lang('layout.Cost') {{getHomeCurrency()[getCurrencyType()]}}</th>
                                                   <th style="text-align: center;">@lang('layout.TotalPrice')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($so['items']))
                                                <?php $totalSome = 0; ?>
                                                @foreach ($so['items'] as $item)
                                                <?php
                                                    $totalSome += ($item['quantity'] - $item['qut_out'])*$item['cost'];
                                                ?>
                                                <tr>
                                                    <td style="text-align: center;">{{$item['item']}}</td>
                                                    <td style="text-align: center;">{{$item['site_name']}}</td>
                                                    <td style="text-align: center;">{{$item['cat_name']}}</td>
                                                    <td style="text-align: center;">{{myRound($item['quantity'])}}</td>
                                                    <td style="text-align: center;">{{($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']}}</td>
                                                    <td style="text-align: center;">{{myRound($item['quantity'] - (($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']))}}</td>
                                                    <td style="text-align: center;">{{$item['sale_order_measur']}}</td>    
                                                    <td style="text-align: center;">{{$item['cost']}}</td> 
                                                    @if(systemConfig()[30] == 1)
                                                    <td style="text-align: center;">{{$item['cost'] /$item['static_rate'] * $item['rate']}}</td> 
                                                    @else 
                                                    <td style="text-align: center;">{{$item['cost'] / $item['rate']}}</td> 
                                                    @endif

                                                    <td style="text-align: center;">{{($item['quantity'] - $item['qut_out'])*$item['cost']}}</td> 
                                                 </tr>
                                               @endforeach
                                               <tr>
                                                    <td class="text-center" colspan="8" style="text-align: center;">@lang('layout.TotalPcs')</td>
                                                    <td class="text-center" style="text-align: center;">{{$totalSome}}</td>
                                                </tr>
                                               @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    <?php endforeach ?>  
            </div>
            {{-- <div class="row" style="    background-color: #a8b5cc; padding-left: 20px; padding-right: 20px;"> --}}
                @if($saleOrderpage)
                {{ $saleOrderpage->links() }}
                @endif
            {{-- </div> --}}
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <!-- END CONTENT BODY -->
@stop
@push('scripts')
<script>
	    Vue.component('v-select', VueSelect.VueSelect);
    var Modal=Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
    // start app
    var app = new Vue({
        el: '#app',
        data: {
            showModal: false,
            selectedMember:null,
            member: [],
        },
        methods:{
            ok:function(){
                // alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){
                //Your other code that launches the modal
                this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                    $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Vendor'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        app.member = [];
                        app.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
        },
    });
	    // start app
    var app1 = new Vue({
        el: '#app1',
        data: {
            showModal: false,
            selectedMember:null,
            member: [],
        },
        methods:{
            ok:function(){
                // alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){
                //Your other code that launches the modal
                this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                    $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Vendor'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        app1.member = [];
                        app1.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
        },
    });
    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    });
    $('#print_pdf_all1').on('click',function(e){
        $('#show-modal1').click();
        e.preventDefault();
    });
	</script>
@endpush