@extends('layouts.report')
<?php 
$reportTitle = __('layout.PurchaseOrder');
?>
@section('content')
    <!-- END PAGE HEADER-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <h3 style="text-alin:center;">@lang('layout.PurchaseOrder')</h3>
            <div class="row">
                    <?php foreach ($data as $so): ?> 
                <div style=" margin-bottom: 15px; padding-left: 10px;" >
                    <div class="portlet green-meadow box" style=" border: 1px solid #2ae0bb;">
                        <div class="portlet-title" style=" background-color: #1BBC9B">
                            <div class="caption">
                                <i class="icon-user"></i> {{$so['name']}}
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="col-md-12 value">
                                      <table class="main-table">
                                        <thead>
                                            <tr class="active">
                                                <td style="text-align: center;">@lang('layout.Number')</td>
                                                <td style="text-align: center;">@lang('layout.Date')</td>
                                                <td style="text-align: center;">@lang('layout.Currency')</td>
                                                <td style="text-align: center;">@lang('layout.Rate')</td>
                                                <td style="text-align: center;">@lang('layout.Description')</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="active">
                                                <td style="text-align: center;">{{$so['number']}}</td>
                                                <td style="text-align: center;">{{convertDate($so['date'])}}</td>
                                                <td style="text-align: center;">{{$so['currency']}}</td>
                                                <td style="text-align: center;">{{$so['rate']}}</td>
                                                <td style="text-align: center;">{{$so['description']}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <br>
                                    <div >
                                        <table class="main-table" >
                                            <thead>
                                                <tr class="bg">
                                                   <th style="text-align: center;">@lang('layout.ItemName')</th>
                                                   <th style="text-align: center;">@lang('layout.Inventory')</th>
                                                   <th style="text-align: center;">@lang('layout.Category')</th>
                                                   <th style="text-align: center;">@lang('layout.Quantity')</th>
                                                   <th style="text-align: center;">@lang('layout.Delivered')</th>
                                                   <th style="text-align: center;">@lang('layout.Remain')</th>
                                                   <th style="text-align: center;">@lang('layout.Measure')</th>
                                                   <th style="text-align: center;">@lang('layout.Price')</th>
                                                   <th style="text-align: center;">@lang('layout.Cost') {{getHomeCurrency()[getCurrencyType()]}}</th>
                                                   <th style="text-align: center;">@lang('layout.TotalPrice')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($so['items']))
                                                <?php $totalSome =0; ?>
                                                @foreach ($so['items'] as $item)
                                                <?php 
                                                    $totalSome +=$item['qty']*$item['cost'];
                                                ?>
                                                <tr>
                                                    <td style="text-align: center;">{{$item['item']}}</td>
                                                    <td style="text-align: center;">{{$item['site_name']}}</td>
                                                    <td style="text-align: center;">{{$item['cat_name']}}</td>
                                                    <td style="text-align: center;">{{myRound($item['quantity'])}}</td>
                                                    <td style="text-align: center;">{{($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']}}</td>
                                                    <td style="text-align: center;">{{myRound($item['qty'])}}</td>
                                                    <td style="text-align: center;">{{$item['sale_order_measur']}}</td>    
                                                    <td style="text-align: center;">{{$item['cost']}}</td>
                                                    @if(systemConfig()[30] == 1)
                                                    <td style="text-align: center;">{{$item['cost'] / $item['static_rate'] * $item['rate']}}</td>
                                                    @else 
                                                    <td style="text-align: center;">{{$item['cost'] / $item['rate']}}</td>
                                                    @endif

                                                    <td style="text-align: center;">{{($item['qty'] != 0)?myRound(($item['qty']*$item['cost'])):0}}</td>
                                                 </tr>
                                               @endforeach
                                               <tr>
                                                    <td style="text-align: center;" colspan="9">@lang('layout.TotalPcs')</td>
                                                    <td style="text-align: center;">{{$totalSome}}</td>
                                               </tr>
                                               @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                    <?php endforeach ?>
            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <!-- END CONTENT BODY -->
@stop