@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>


    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdatePurchaseOrder') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => ['purchaseOrderValue.update',$purchase->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'purchase-form'])}}

                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <div class="input-group">
                                                <v-select label="name" @input="memberChange()" :options="vendor" @search="MemberSearch" v-model="selected_vendor" disabled></v-select>
                                                <input type="hidden"  name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Number')</label>

                                            <input type="number" name="number" value="{{$purchase->number}}"
                                                   class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                               <span class="text-right" data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                <tr>
                                    <td>
                                        <small>@lang('layout.Payment'):</small>
                                    </td>
                                    <td class="text-right">
                                        <small class="font-green-sharp">
                                            <span class="text-right" data-counter="counterup"
                                            data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </small>
                                    </td>
                                </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                                    data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>


                                </table>

                            </div>

                            <!-- end total -->
                        </div>

                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th v-show="showWhat('expire_date')=='yes'">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 50px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 50px">@lang('layout.OMeasureValue2')
                                </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category"
                                              @input="itemCategoryChange()" disabled></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item"
                                              @search="onItemSearch" disabled></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                    <input type="hidden" name="purchaseOrderInfoId[]" :value="(!item.item)?null:item.item.purchaseOrderInfoId">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control" disabled>
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" v-model="(item.item==null)?null:item.item.description"
                                           placeholder="@lang('layout.Description')" name="inventory_description[]"
                                           class="form-control">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <input type="text" v-model="(item.item==null)?null:item.item.expire_date"
                                           placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                           class="date form-control">
                                </td>
                                <td>


                                    <input type="number" name="quantity[]" oninput = "autowidths(event)"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>

                                <td>
                                <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)" disabled>
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')" oninput = "autowidths(event)"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="in" @input="setNewRate(index)" class="form-control" readonly>
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td>
                                    <div>
                                        <div class="input-group">
                                            <input type="number" class="form-control inner_input" oninput = "autowidths(event)"
                                                   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate, null, null, null, null , null, selected_currency.static_rate)"
                                                   placeholder="@lang('layout.Total')" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                           
                            </tbody>
                        </table>
                        <hr/>
                   
                        <hr/>

                    </div>


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" @click="submitForm"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('purchaseOrder.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,

                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var purchase ={!! $purchase !!};
        var purchaseInfo = {!! $purchaseInfo !!};
        var selectedContract = {!! $selectedContract !!};
        var inventory_category = {!! $inventory_category !!};
        var selectedBank = {!! $selectedBank !!};
        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                vendor: [],
                selected_vendor: {!! $selectedVendor !!},
                contract: [],
                selected_contract: selectedContract,
                banks: banks,
                selected_banks: null,
                selected_pay_banks: selectedBank,
                currency:{!! $currency !!},
                selected_currency:{!! $selectedCurrency !!},
                selected_item:{!! $selectedItem !!},
                purchase: purchase,
                purchase_info: purchaseInfo,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                temp_items: [],
                totalAmountes: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_index: 0,
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                payments: [],
                category:'purchaseOrder'
            },


            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif

                            }   
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate * this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        }

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                // 
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif 
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    
                    if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                // initialize the selected item
                for (var i = 0; i < this.selected_item.length; i++) {
                    console.log('item', this.selected_item);
                    this.inventories.push({
                        item: this.selected_item[i],
                        item_category: this.selected_item[i].item_category
                    });
                }
                for (var m = 1; m > this.selected_item.length; m--) {
                    this.inventories.push({item: null});
                }
                // initialize payments

                for (var j = 0; j < this.banks.length; j++) {
                    if (this.banks[j].id == this.purchase_info.Account_id) {
                        this.selected_banks = this.banks[j];
                    }
                }

                // initialize payments
                for (var k = 0; k < this.selected_pay_banks.length; k++) {
                    var foundFlag = false;
                    var tempBank = null;
                    for (var j = 0; j < this.banks.length; j++) {
                        if (this.banks[j].id == this.selected_pay_banks[k].Account_id) {
                            foundFlag = true;
                            tempBank = this.banks[j];
                            tempBank.amount = this.selected_pay_banks[k].Amount;
                            tempBank.rate = this.selected_pay_banks[k].Rate;
                        }
                    }
                    if (foundFlag) {

                        this.payments.push({item: tempBank, items: this.banks});
                    }

                }

                for (var w = 1; w > this.selected_pay_banks.length; w--) {
                    this.payments.push({item: null, items: banks});
                }
                // end payment    

                // end payment

                if (this.purchase) {
                    this.discountFiled = this.purchase.discount;
                    if(this.purchase.category)
                    {
                        this.category=this.purchase.category;
                    }
                    if (this.purchase.discount_type) {
                        if (this.purchase.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
                
            },
            methods:
                {
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_vendor) {
                            // get member contract
                            this.contractSearch(this.selected_vendor.id, this);
                        }
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.vendor = [];
                                v.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()), 
                    
                    setNewRate(index) {
                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif
                        } 
                    },
                    // begin item search

                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchPurchase',
                                keyword: search
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        console.log('e', e);
                        // this.selected_index=[];
                        this.selected_index = e;
                        console.log('uuu', this.selected_index);
                    },
                    itemCategoryChange() {
                        console.log('inventory', this.inventories);
                        let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchPurchase',
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })


                    },

                    // end item search

                    // contract search


                    contractSearch(id, vm) {
                        vm.contract = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'member_contract',
                                member_id: id
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    vm.contract = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {

                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                swal({
                                    title: "@lang('layout.AreYouSure?')",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                                    text: "",
                                    icon: "info",
                                    dangerMode: true,
                                }).then((willDelete) => {
                                    if (willDelete) {
                                        this.inventories.splice(index, 1);
                                    }
                                    else {
                                    
                                    }
                                });
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("purchase-form").submit()

                            } else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush