@extends('layouts.factor-master')
@section('content')
    <?php
        $report = customeReport('Purchase_order_detail');
        $_code = in_array('code', $report);
        $_item_name = in_array('item_name', $report);
        $_code = in_array('code', $report);
        $_quantity = in_array('quantity', $report);
        $_measure = in_array('measure', $report);
        $_price = in_array('price', $report);
        $_total = in_array('total', $report);
        $_rate = in_array('rate', $report);
    ?>
    <table class="main-table">
        @if($info && $info !=[])
            <tr>
                <td>
                    <span>@lang('layout.Number')</span>:
                    <span>{{$info->number}}</span>
                </td>
                <td>
                    <span>@lang('layout.Code')</span>:
                    <span>{{$info->orderNumber}}</span>
                </td>
                <td>
                    <span>@lang('layout.Vendor')</span>:
                    <span>{{$info->vendor}}</span>
                </td>

                <td>
                    <span>@lang('layout.Type')</span>:
                    <span>{{$info->type}}</span>
                </td>
                <td>
                    <span>@lang('layout.Currency')</span>:
                    <span>{{$info->currency}}</span>
                </td>
				 <td>
					<span>@lang('layout.Description')</span>:
					<span>{{$info->description}}</span>
				  </td>
            </tr>
            <tr>
            </tr>
        @endif
    </table>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseOrderReport')</h3>
    <table class="main-table">
        <thead>
            <tr class="bg">
                <td class="center" >
                    <div >  @lang('layout.Record') </div>
                </td>
                @if($_code)
                    <td class="center" >
                        <div > @lang('layout.Code')</div>
                    </td>
                @endif
                @if($_item_name)
                    <td class="center" >
                        <div > @lang('layout.ItemName')</div>
                    </td>
                @endif
                @if($_code)
                    <td class="center" >
                        <div > @lang('layout.Code')</div>
                    </td>
                @endif
                @if(getOtherMeasure()=="true")
                    <td class="center" >
                        <div > @lang('layout.OMeasureValue1')</div>
                    </td>
                @endif
                @if(getOtherMeasure2()=="true")
                    <td class="center" >
                        <div > @lang('layout.OMeasureValue2')</div>
                    </td>
                @endif
                @if($_quantity)
                    <td class="center" >
                        <div > @lang('layout.Quantity')</div>
                    </td>
                @endif
                @if($_measure)
                    <td class="center" >
                        <div > @lang('layout.Measure')</div>
                    </td>
                @endif
                @if($_price)
                    <td class="center" >
                        <div > @lang('layout.Price')</div>
                    </td>
                @endif
                <td class="center">
                    <div>@lang('layout.Cost') {{getHomeCurrency()[getCurrencyType()]}}</div>
                </td>
                @if($_total)
                    <td class="center" >
                        <div > @lang('layout.Total')</div>
                    </td>
                @endif
            </tr>
        </thead>
        <?php
            $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_code)
                    <td class="center">{{$record->item_number}}</td>
                @endif
                @if($_item_name)
                    <td class="center">{{$record->item_name}}</td>
                @endif
                @if($_code)
                    <td class="center">{{$record->code}}</td>
                @endif
                @if(getOtherMeasure()=="true")
                    <td class="center">{{$record->other_measure}}</td>
                @endif
                @if(getOtherMeasure2()=="true")
                    <td class="center">{{$record->other_measure2}}</td>
                @endif
                @if($_quantity)
                    <td class="center">{{$record->quantity}}</td>
                @endif
                @if($_measure)
                    <td class="center">{{$record->measure}}</td>
                @endif
                @if($_price)
                    <td class="center">{{$record->cost}}</td>
                @endif
                <td class="center">{{myRound($record->cost)}}</td>
                @if($_total)
                    <td class="center">{{$record->total}}</td>
                @endif
            </tr>
        @endforeach
    </table>
    <table>
        <tr>
        </tr>
    </table>
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >              
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection