@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
    <style>
    </style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("layouts.Invmodal")
@include("bills.modal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewPurchaseOrder') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'purchaseOrder.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form'])}}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <div class="input-group">
                                                <v-select label="name" @input="memberChange()" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                                <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Number')</label>
                                            <input type="number" name="number" value="{{$number}}" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="{{ auth()->user()->company()->first()->tag != 1? "col-lg-3 col-md-3": "col-lg-4 col-md-4" }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" @input="selectedRate" :options="setRates" v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" :value="selected_currency.code">
                                        </div>
                                    </div>
                                </div>
                                <div class="{{ auth()->user()->company()->first()->tag != 1? "col-lg-3 col-md-3" : "col-lg-4 col-md-4" }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>
                                            <input type="number" name="currency_rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                        </div>
                                    </div>
                                </div>
                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ')</label>
                                                <input type="number" name="currency_rate_hq" v-model="!selected_currency?0:selected_currency.hq_rate" class="form-control" :class="{'has-error':rate<=0}">
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="{{ auth()->user()->company()->first()->tag != 1? "col-lg-3 col-md-3" : "col-lg-4 col-md-4" }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>
                                            <div class="input-group">
                                                <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                <input type="hidden" name="discount_type" value="percent">
                                                </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.DeliveryDate')</label>
                                            <input type="text" name="delivery_date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select name="category" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                <option selected value="purchaseOrder">@lang('layout.PurchaseOrder')</option>
                                                <option value="itemBorrow">@lang('layout.ItemBorrow')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="2"></textarea>
                                        </div>
                                    </div>
                                </div>
                                @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="5" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                                           <span class="text-right" data-counter="counterup"
                                                 data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            <input type="hidden" name="totalAmountes" v-model="totalAmountes">
                                        </td>
                                    </tr>

                                <tr>
                                      <td>
                                          <small>@lang('layout.Payment'):</small>
                                      </td>
                                      <td class="text-right">
                                          <small class="font-green-sharp">
                                              <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                          </small>
                                      </td>
                                  </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                          <span class="text-right" data-counter="counterup"
                                                data-value="7800">
                                              @{{ subtotal.toFixed(precision())}}
                                          </span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>


                                </table>

                            </div>

                            <!-- end total -->
                        </div>

                    </div>


                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th style="min-width: 150px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 50px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 50px">@lang('layout.OMeasureValue2')
                                </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <div class="input-group">
                                        <v-select label="name" @keyup.native="onItemload(index)"
                                                @Click.native="onItemload(index)" v-model="item.inventory" :options="temp_items" @search="onItemSearch"></v-select>
                                        <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                        <span class="btn btn-success input-group-addon " title="@lang('layout.AddNewItem')" @click="showInvModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div>
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>
                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                           name="inventory_description[]" class="form-control">
                                </td>

                                <td>


                                    <input type="number" name="quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>

                                <td>
                                <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                    oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="in" @input="setNewRate(index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td>
                                    @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, null, selected_currency.static_rate).result }}
                                    <b>@{{selected_currency.symbol}}</b> 
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>

                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" :name="'payment_id['+index+']'"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                    <span v-if="payment.item !=null">
                                     @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                   </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_rate['+index+']'"
                                           v-bind:value="payment.item.rate">
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_rate_hq['+index+']'"
                                           v-bind:value="payment.item.hq_rate">
                                </td>
                                <td>
                                    <input type="text" :name="'payment_currency['+index+']'" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" :name="'payment_currency['+index+']'"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" :name="'payment_amount['+index+']'"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    @{{ (payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                     class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->


                    </div>


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" @click="submitForm"  class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue" @click="saveAndNew($event)" v-if="!isError" >@lang('layout.SaveAndNew')</button>
                    <a href="{{route('purchaseOrder.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>

                <invmodal :show='showInvModal' @close="showInvModal=false">

                </invmodal>

                <modal v-if="showMeasureModal" @close="showMeasureModal = false">
                    <div slot="body">
                        <div class="row">
                            <div class="col-md-3">
                                <h4>@lang('layout.MetricType')</h4>
                                <span v-for="metric in metricList">
                                    <div class="mt-radio-list">
                                        <label class="mt-radio"> @{{ metric.name }}

                                            <input name="metric" type="radio" v-bind:value="metric"
                                            v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                            <span></span>
                                        </label>
                                    </div>
                                </span>
                            </div>
                            <div class="col-md-3">
                                <h4>@lang('layout.Measure') </h4>
                                <span v-for="measure1 in selectedMetric.measure">
                                    <div class="mt-radio-list">
                                        <label class="mt-radio">
                                        <b v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </b>
                                        <b v-if="measure1.text !='Other'">@{{ measure1.text }} </b>
                                            <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                            <span></span>
                                        </label>
                                    </div>
                                </span>
                            </div>
                            <div class="col-md-6">
                                <span v-if="selectedMeasure.text == 'Other'">
                                    <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                    <div>
                                        <div class="form-group">
                                            <label class="control-label col-md-5">
                                            @lang('layout.MeasureName')</label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureName')"
                                                v-model.trim="selectedMeasure.name">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="control-label col-md-5">
                                                @lang('layout.MeasureAmount')
                                            </label>
                                            <div class="col-md-7">
                                                <input type="number" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureuint')"
                                                v-model.number="selectedMeasure.unit">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>
                                        <div class="form-group ">
                                            <label class="control-label col-md-5">
                                                @lang('layout.MeasureSymbol')
                                            </label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureSymbol')"
                                                v-model.trim="selectedMeasure.symbol">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>
                                    </div>

                                </span>
                            </div>

                        </div>

                    </div>
                    <h3 slot="header">
                        <div class="col-md-4">
                            <h3>
                                @lang('layout.AddNewMeasure')
                            </h3>
                        </div>
                        <div class="col-md-4">
                            <div v-if="fieldErrors.length > 0">
                                <p class="text-danger" fieldErrors>
                                    <spna v-text="fieldErrors"></spna>
                                </p>
                            </div>
                        </div>
                    </h3>
                    <div slot="footer">
                        <button type=button class="modal-default-button" v-on:click="addMeasure">
                            @lang('layout.OK')
                        </button>
                        <button type=button class="modal-default-button"
                        v-on:click="showMeasureModal = false , showInvModal = true ,measure = null , type=null">
                        @lang('layout.Cancel')
                    </button>
                    </div>
                </modal>

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


<script type="text/javascript">

    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,

                    classes: [],
                    selectedClass: null,

                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],
            created() {
                console.log('rrrrr');
            }

        });  

        /// inventory model
        var invm = null;
        Vue.component("invmodal", {
            template: '#invmodal-template',

            props: ['show'],
            data() {
                return {
                    measureList: [],
                    categories: [],
                    income: [],
                    cost: [],
                    asset: [],
                    rate: 0,
                    description: null,
                    number: null,
                    category: null,
                    selectMeasure: null,
                    incomeAccount: null,
                    costAccount: null,
                    assetAccount: null,
                }
            },
            created() {
                axios.get('{{route("inventory.create")}}', {
                        params: {
                            add_item: 'on'
                        }
                    }).then(
                    response => {
                        this.measureList = response.data.measure;
                        this.categories = response.data.category;
                        this.number = response.data.number;
                        this.income = response.data.income;
                        this.cost = response.data.cost;
                        this.asset = response.data.asset;
                        if(this.measureList.length>0)
                        {
                            this.selectMeasure=this.measureList[0];
                        }
                        if(this.income.length>0)
                        {
                            this.incomeAccount=this.income[0];
                        }
                        if(this.cost.length>0)
                        {
                            this.costAccount=this.cost[0];
                        }
                        if(this.asset.length>0)
                        {
                            this.assetAccount=this.asset[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                showMeasureModal() {
                    invm = this;
                    v.showMeasureModal = true;
                    v.showInvModal = false;
                },

                onSubmit() {
                    var ivn = this;
                    v.showInvModal = false;
                    var datas = $("#modalFormInv").serializeArray();
                    // console.log(123,datas);
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("inventory.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'type': datas[1]['value'],
                            'number': datas[2]['value'],
                            'gauge': datas[3]['value'],
                            'rate': datas[4]['value'],
                            'description': datas[5]['value'],
                            'asset_account': this.assetAccount.id,
                            'um_id': this.selectMeasure.id,
                            'income_account': this.incomeAccount.id,
                            'cost_account': this.costAccount.id,
                            'cost': 1,
                            'category': (this.category) ? this.category.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        // console.log(123, response);
                        if (response) {
                            // v.temp_items = [];
                            // v.temp_items = response.item;
                        }
                        axios.get('{{route("inventory.create")}}', {
                            params: {
                                saveAndNew: 'on'
                            }
                        }).then(response => {
                            // console.log(1239, response);
                            ivn.number = response.data;
                            document.getElementById("modalFormInv").reset();
                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });
        /// inventory model

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var inventory_category = {!! $inventory_category !!};

        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                showInvModal: false,
                vendor: [],
                selected_vendor: null,
                banks: banks,
                selected_banks: null,
                currency: currency,
                selected_currency: {!! json_encode(getHomeCurrency()) !!},
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                temp_items: [],
                totalAmountes: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_index: 0,
               
                inventories: [
                    {item: null, inventory:null,item_category: null}
                ],
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],

                showMeasureModal: false,
                fieldErrors: [],
                selectedMetric: {},
                senddata: {},
                selectedMeasure: {},
                metricList:{!!json_encode(getMeasures())!!},
            },
            computed: {
                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    static_rate: a.static_rate,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });

                    return rates;

                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif

                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        }
                        this.totalAmountes = sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || flag == false) {
                        isError = true;
                    }

                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            methods:
                {
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_vendor) {
                            // get member contract
                        }
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.vendor = [];
                                v.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    // set new price
                    setNewRate(index) {
                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif
                        } 
                    },
                    // begin item search

                     onItemSearch: _.debounce((search, loading) => {

                        loading(true);

                        // console.log('klk',v.inventories[v.selected_index]['item_category']);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),
                      onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index]['item_category']);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchPurchase',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                  
                    itemCategoryChange(index) {
                        let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })


                    },
                    // end item search

                    addMeasure: function () {
                        let senddata = _.clone(this.selectedMetric);
                        senddata.measure = _.clone(this.selectedMeasure);

                        var req = axios.post("{{route('measure.store')}}",senddata)
                        .then(function (response) {
                            if (response) {
                                if (response.data) {
                                    // var measure_id = response.data.me.id;
                                    invm.selectMeasure = response.data.me;
                                    // console.log(444, response, measure_id);
                                }
                            }
                            v.showMeasureModal = false;
                            v.fieldErrors = [];
                            v.selectedMetric = {};
                            v.selectedMeasure = {};

                            axios.get("{{route('inventory.create')}}").then(function (response) {
                                invm.measureList = response.data;
                                v.showInvModal = true;
                            });
                        })
                        .catch(function (error) {
                            axios.get("{{route('inventory.create')}}").then(function (response) {
                                invm.measureList = response.data;
                                v.showInvModal = true;
                            });

                            v.fieldErrors = error.response.data

                        });

                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null,inventory:null});
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("purchase-form").submit()

                            }
                            else {

                            }
                        });

                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                
                                var url="{{route('purchaseOrder.store')}}";
                                form_id='purchase-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },
                },

        });

    </script>


@endpush