@extends('layouts.factor-master')
@section('content')
    <?php
        $report = customeReportNew('purchase_order_index');
        $_record = !in_array('record', $report);
        $_number = !in_array('number', $report);
        $_date = !in_array('date', $report);
        $_delivery_date = !in_array('delivery_date', $report);
        $_vendor = !in_array('vendor', $report);
        $_item = !in_array('item', $report);
        $_unit = !in_array('unit', $report);
        $_quantity = !in_array('quantity', $report);
        $_delivered = !in_array('delivered', $report);
        $_remain = !in_array('remain', $report);
        $_cost = !in_array('cost', $report);
        $_rate = !in_array('rate', $report);
        $_rate1 = !in_array('rate1', $report);
        $_total = !in_array('total', $report);
        $_user = !in_array('user', $report);
        $_total1 = !in_array('total1', $report);

        $report_percent = customeReportNewPercent('purchase_order_index');
        $_record_percent = (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
        $_number_percent = (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
        $_date_percent = (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
        $_delivery_date_percent = (array_key_exists('delivery_date___percent', $report_percent))?$report_percent['delivery_date___percent']:null;
        $_vendor_percent = (array_key_exists('vendor___percent', $report_percent))?$report_percent['vendor___percent']:null;
        $_item_percent = (array_key_exists('item___percent', $report_percent))?$report_percent['item___percent']:null;
        $_unit_percent = (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
        $_quantity_percent = (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
        $_delivered_percent = (array_key_exists('delivered___percent', $report_percent))?$report_percent['delivered___percent']:null;
        $_remain_percent = (array_key_exists('remain___percent', $report_percent))?$report_percent['remain___percent']:null;
        $_cost_percent = (array_key_exists('cost___percent', $report_percent))?$report_percent['cost___percent']:null;
        $_rate_percent = (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
        $_rate1_percent = (array_key_exists('rate1___percent', $report_percent))?$report_percent['rate1___percent']:null;
        $_total_percent = (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
        $_user_percent = (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
        $_total1_percent = (array_key_exists('total1___percent', $report_percent))?$report_percent['total1___percent']:null;
    ?>
    
    <h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseOrderReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <table class="main-table">
        <tr>
            @if($member_name)
                <td>
                    <span>@lang('layout.Vendor')</span>:
                    <BDO DIR="LTR">{{$member_name}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
        <thead>
            <tr class="bg">
                @if($_record)  <td class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif> @lang('layout.Record') </td> @endif 
                @if($_number)<td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif >@lang('layout.Number')</td>@endif
                @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif >@lang('layout.Date')</td>@endif
                @if($_delivery_date) <td class="center" @if($_delivery_date_percent) width="{{$_delivery_date_percent}}%" @endif >@lang('layout.DeliveryDate')</td>@endif
                @if($_vendor)<td class="center" @if($_vendor_percent) width="{{$_vendor_percent}}%" @endif >@lang('layout.Vendor')</td>@endif
                @if($_item)<td class="center" @if($_item_percent) width="{{$_item_percent}}%" @endif >@lang('layout.Item')</td> @endif 
                @if($_unit) <td class="center" @if($_unit_percent) width="{{$_unit_percent}}%" @endif >@lang('layout.Unit')</td>@endif
                @if($_quantity)<td class="center" @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif >@lang('layout.Quantity')</td>@endif
                @if($_delivered)<td class="center" @if($_delivered_percent) width="{{$_delivered_percent}}%" @endif >@lang('layout.Delivered')</td>@endif
                @if($_remain)<td class="center" @if($_remain_percent) width="{{$_remain_percent}}%" @endif >@lang('layout.Remain')</td>@endif
                @if($_cost) <td class="center" @if($_cost_percent) width="{{$_cost_percent}}%" @endif >@lang('layout.Cost')</td>@endif
                @if($_rate) <td class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif >@lang('layout.Rate')</td>@endif
                @if($_rate1) <td class="center" @if($_rate1_percent) width="{{$_rate1_percent}}%" @endif >@lang('layout.Cost') {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
                @if($_total)  <td class="center" @if($_total_percent) width="{{$_total_percent}}%" @endif >@lang('layout.Total')</td>@endif
                @if($_user) <td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif >@lang('layout.User')</td>@endif
            </tr>
        </thead>
        <?php
            $count = 0;
            $total_home_currency = 0;
            $currencies = [];
            $items = [];
        ?>
        @foreach($data AS $record)
            <tr>
                <?php
                if(systemConfig()[30] == 1){
                   $total_home_currency += ($record->cost/ $record->static_rate * $record->rate)*$record->quantity;
                }else{
                    $total_home_currency += ($record->cost/$record->rate)*$record->quantity;
                }
                    if (array_key_exists($record->currency, $currencies)) {
                        $currencies[$record->currency] = $currencies[$record->currency] + $record->quantity*$record->cost;
                    } else {
                        $currencies[$record->currency] = $record->quantity*$record->cost;
                    }
                    if (array_key_exists($record->item, $items)) {
                        $items[$record->item] = $items[$record->item] + $record->quantity-$record->quantity_out;
                    } else {
                        $items[$record->item] =  $record->quantity-$record->quantity_outw;
                    }
                ?>
                @if($_record) <td class="center">{{++$count}}</td>@endif
                @if($_number)<td class="center">{{$record->purchase_number}}</td> @endif
                @if($_date)<td class="center">{{convertDate($record->date)}}</td>  @endif
                @if($_delivery_date)<td class="center">{{convertDate($record->delivery_date)}}</td>  @endif
                @if($_vendor)<td class="center">{{$record->vendor}}</td>  @endif
                @if($_item) <td class="center">{{$record->item}}</td>  @endif
                @if($_unit)<td class="center">{{$record->unitmeasure}}</td> @endif
                @if($_quantity) <td class="center">{{$record->quantity}}</td> @endif
                @if($_delivered)<td class="center">{{$record->quantity_out}}</td> @endif
                @if($_remain)<td class="center">{{$record->quantity-$record->quantity_out}}</td>  @endif
                @if($_cost)<td class="center">{{$record->cost}}</td>   @endif
                @if($_rate)<td class="center">{{$record->rate}}</td>  @endif
                @if(systemConfig()[30] == 1)
                @if($_rate1)<td class="center">{{myRound($record->cost/ $record->static_rate * $record->rate)}}</td>  @endif
                @else 
                @if($_rate1)<td class="center">{{myRound($record->cost/$record->rate)}}</td>  @endif
                @endif
                @if($_total)<td class="center">{{myRound($record->quantity*$record->cost)}} {{$record->currency}}</td> @endif
                @if($_user)<td class="center">{{$record->user}}</td> @endif
            </tr>
        @endforeach
    </table>
    @if($_total1)
    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.Total')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($items As $key=>$item)
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($item,2)}}</div>
            </td>
        </tr>
        <?php
        }
        ?> 
    </table>
    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency)
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>
        </tr>
    </table>
    @endif
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                    
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection