@extends('layouts.factor-master')

@section('content')


    <h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseOrderReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <th>@lang('layout.Record')</th>  
            <th>@lang('layout.Item')</th>
            <th>@lang('layout.Unit')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.PurchasedQuantity')</th>
            <th>@lang('layout.Remain')</th>
            <th>@lang('layout.OnHand')</th>

        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->item}}</td>
                <td class="center">{{$record->unitmeasure}}</td>
                <td class="center">{{myRound($record->quantity)}}</td>
                <td class="center">{{myRound($record->quantity_in)}}</td>
                <td class="center">{{myRound($record->quantity-$record->quantity_in)}}</td>
                <td class="center">{{myRound($record->onHand)}}</td>
            </tr>
        @endforeach
    </table>


     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection