@extends('layouts.factor-master')
@section('style')
<style>

  /* hr.border_hr{
    border: 2px solid red !important;
  } */

  .tdata{
    font-weight: bold;
    height: 30px;
  }  
  .tdata1{
    height: 30px;
  }
</style>
@endsection
@section('content')
<?php
$report = customeReport('sales_order');
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_member=in_array('member', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_amount=in_array('amount', $report);
$_discount=in_array('discount', $report);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseOrderReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>


<!----------------------------------------
------Begin Data--------------------------
------------------------------------------>
<?php
  $count = 0;
?>
@foreach($data as $po)
<table class="main-table">
  <tbody>
    <tr>
      <td width="70%">
        <table class="main-table" style="width:100%">
        <thead>
          <tr class="bg">
            <td class="center tdata">@lang('layout.Record')</td>
            <td class="center tdata">@lang('layout.PONumber')</td>
            <td class="center tdata">@lang('layout.Vendor')</td>
            <td class="center tdata">@lang('layout.Date')</td>
            <td class="center tdata">@lang('layout.Description')</td>
            <td class="center tdata">@lang('layout.Rate')</td>
            <td class="center tdata">@lang('layout.Total')</td> 
          </tr>
        </thead>
        <tr>

            <td class="center tdata1">{{++$count}}</td>
            <td class="center tdata1">{{$po['number']}}</td>
            <td class="center tdata1">{{$po['name']}}</td>
            <td class="center tdata1">{{convertDate($po['date'])}}</td>
            <td class="center tdata1">

                @if(isset($report_format))
                  {{$po['description']}}
                @else
                  {!! wordwrap($po['description'],40,"<br/>\n",false) !!}
                @endif

            </td>
            <td class="center tdata1">{{$po['rate']}}</td>
            <td class="center tdata1" style="font-size: 20px">{{myRound($po['total'])}} {{$po['currency']}}</td>
            

        </tr>


                                                    

            <tr style="background-color: #b2e7ec;">
                <td class="center tdata">@lang('layout.Record')</td>
                <td class="center tdata">@lang('layout.ItemName')</td>
                <td class="center tdata">@lang('layout.Inventory')</td>
                <td class="center tdata">@lang('layout.Unit')</td>
                <td class="center tdata">@lang('layout.Quantity')</td>
                <td class="center tdata">@lang('layout.Delivered')</td>
                <td class="center tdata">@lang('layout.Remain')</td>
            </tr>
            <?php $count1 = 0; ?>

            @if(isset($po['items']))
            @foreach ($po['items'] as $item)
            <tr>
                <td class="center">{{++$count1}}</td>
                <td class="center">{{$item['item']}}</td>
                <td class="center">{{$item['site_name']}}</td>
                <td class="center">{{$item['sale_order_measur']}}</td>
                <td class="center">{{myRound($item['quantity'])}}</td>
                <td class="center">{{($item['qut_out']*$item['item_unit'])/(($item['sale_order_unit'])?$item['sale_order_unit']:1)}}</td>
                <td class="center">{{myRound($item['quantity'] - (($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']))}}</td>
                                                    

{{-- 
                "id" => 21
                "vendor_id" => 328
                "currency" => "USD"
                "rate" => 1.0
                "discount" => 0.0
                "date" => "2024-02-08 15:07:57"
                "delivery_date" => null
                "type" => "purchase"
                "discount_type" => "percent"
                "description" => ""
                "status" => 0
                "created_at" => "2024-02-08 15:07:57"
                "updated_at" => "2024-02-08 15:07:57"
                "number" => 20.0
                "prepaid_code" => 0
                "orderNumber" => null
                "company_id" => 1
                "category" => "purchaseOrder"
                "hq_rate" => 1.0
                "alert_status" => null
                "memo" => ""
                "name" => "kafi vendor"
                "member_id" => 328
                "item" => "PO item"
                "item_unit" => "1000"
                "sale_order_measur" => "Ton"
                "sale_order_unit" => "1000000"
                "quantity" => 2.0
                "qty" => 0.0
                "qut_out" => 2000.0
                "site_name" => "گدام1"
                "cat_name" => null --}}


              </tr>
            @endforeach
            @endif






        </table>
      </td>
    </tr>
  </tbody>
</table>
<br>
@endforeach


<!----------------------------------------
------END Data--------------------------
------------------------------------------>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection