@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('Purchase_order');
    $_date = in_array('date', $report);
    $_expire_date = in_array('expire_date', $report);
    $_vendor = in_array('vendor', $report);
    $_item = in_array('item', $report);
    $_currency = in_array('currency', $report);
    $_cost = in_array('cost', $report);
    $_description = in_array('description', $report);
    $_rate = in_array('rate', $report);
    $_discount_type = in_array('discount_type', $report);
    $_discount = in_array('discount', $report);
    $_total = in_array('total', $report);
    ?>


    <h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseOrderReport')</h3>
    <table class="main-table">
        <tr>
          @if($from_date)
          <td>
          <span>@lang('layout.FromDate')</span>:
          <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
          <span>@lang('layout.ToDate')</span>:
          <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
        </td>
        @endif
      </tr>
      </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td class="center" >
                <div >  @lang('layout.Record') </div>
            </td>
            @if(systemConfig()[4] != 0 )
                <td class="center" >
                    <div > @lang('layout.Code')</div>
                </td>@endif
            @if($_date)
                <td class="center" >
                    <div > @lang('layout.Date')</div>
                </td>@endif
                <td class="center" >
                    <div > @lang('layout.Description')</div>
                </td>
                
            @if($_expire_date)
                <td class="center" >
                    <div > @lang('layout.DeliveryDate')</div>
                </td>@endif
            @if($_vendor)
                <td class="center" >
                    <div > @lang('layout.Vendor')</div>
                </td>@endif
            @if($_item)
                <td class="center" >
                    <div > @lang('layout.Item')</div>
                </td>@endif  
                <td class="center" >
                    <div > @lang('layout.Quantity')</div>
                </td>
          
            @if($_cost)
                <td class="center" >
                    <div > @lang('layout.Cost')</div>
                </td>@endif
            @if($_rate)
                <td class="center" >
                    <div > @lang('layout.Rate')</div>
                </td>@endif
            @if($_discount_type)
                <td class="center" >
                    <div > @lang('layout.DiscountType')</div>
                </td>@endif
            @if($_discount)
                <td class="center" >
                    <div > @lang('layout.Discount')</div>
                </td>@endif
                <td class="center" >
                    <div > @lang('layout.Total')</div>
                </td>
                <td class="center" >
                    <div > @lang('layout.User')</div>
                </td>
               

        </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>

            <?php

                if(systemConfig()[30] != 0 ){
                    $total_home_currency += ($record->cost/$record->static_rate * $record->rate)*$record->quantity;
                }else{
                    $total_home_currency += ($record->cost/ $record->rate)*$record->quantity;
                }

                

                if (array_key_exists($record->currency, $currencies)) {

                    $currencies[$record->currency] = $currencies[$record->currency] + $record->quantity*$record->cost;

                } else {

                    $currencies[$record->currency] = $record->quantity*$record->cost;
                    
                }
                ?>

                <td class="center">{{++$count}}</td>
                @if(systemConfig()[4] != 0 )
                    <td class="center">{{$record->orderNumber}}</td>@endif
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                    <td class="center">{{$record->description}}</td>
                @if($_expire_date)
                    <td class="center">{{convertDate($record->delivery_date)}}</td>@endif
                @if($_vendor)
                    <td class="center">{{$record->vendor}}</td>@endif
                @if($_item)
                    <td class="center">{{$record->item}}</td>@endif
                    <td class="center">{{$record->quantity}}</td>
             
                @if($_cost)
                    <td class="center">{{$record->cost}} {{$record->currency}}</td>@endif
                @if($_rate)
                    <td class="center">{{$record->rate}}</td>@endif
                @if($_discount_type)
                    <td class="center">{{$record->discount_type}}</td>@endif
                @if($_discount)
                    <td class="center">{{$record->discount}}</td>@endif
                
                    <td class="center">{{myRound($record->quantity*$record->cost)}}</td>
                    <td class="center">{{$record->user}}</td>
                  

            </tr>
        @endforeach
    </table>

    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency)
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection