@extends('layouts.app') 
 @section('style')
    <style type="text/css">
        .modal.in .modal-dialog {
            margin: 40px auto;
            width: 80%;
        } 
    </style>
 @stop
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ProjectInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
              <div class="tabbable-line">
                  <ul class="nav nav-tabs ">
                      <li class="active">
                          <a href="#CustomerDetailss" data-toggle="tab"> @lang('layout.ProjectDetail') <i class="fa fa-tasks"></i> </a>
                      </li>
                      <li>
                          <a href="#tab_15_2" data-toggle="tab"> @lang('layout.FinanceDetails') <i class="fa  "></i> </a>
                      </li> 
                  </ul>
                  <div class="tab-content">
                        <div class="tab-pane active" id="CustomerDetailss">
                          <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                              <thead>
                                <tr>
                                    <!-- <th class="">
                                        <i class="fa fa-bars"></i> @lang('layout.ProjectCode')
                                    </th> -->
                                    <th class="">
                                        <i class="fa fa-edit"></i> @lang('layout.ProjectName')  
                                    </th>
                                    <!-- <th>
                                        <i class="fa  "></i> @lang('layout.Currency') 
                                    </th>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.Rate')
                                    </th> -->
                                    <th class="">
                                        <i class="fa fa-user"></i> @lang('layout.Customer')  
                                    </th>
                                    <th>
                                        <i class="icon-phone"></i> @lang('layout.Phone')
                                    </th>
                                    <th class="">
                                        <i class="fa "></i> @lang('layout.ProjectProgress')
                                    </th>
                                    <th class="">
                                        <i class="fa "></i> @lang('layout.Status')
                                    </th>
                                    <th class="">
                                        <i class="fa "></i> @lang('layout.Percent')
                                    </th>
                                     <th>
                                        <i class="fa fa-clock-o"></i> @lang('layout.StartDate')
                                    </th> 
                                    <th>
                                        <i class="fa fa-calendar-times-o"></i> @lang('layout.EndDate')
                                    </th> 
                                     <th>
                                        <i class="fa fa-sun-o"></i> @lang('layout.TotalaDays')
                                    </th> 
                                    
                                </tr>
                              </thead>
                            <tbody> 
                                <tr>  
                                    <!-- <td class=""> {{ $project->number}}  </td> -->
                                    <td class=""> {{ $project->name}}  </td>
                                    <td class=""> {{ $project->member}}  </td>
                                    <td class=""> {{ $project->phone}}</td>
                                     <td class=""> 
                                        @if($project->project_progress_id != 1)
                                        {{$project->progress}}
                                        @else
                                        @lang('layout.Completed')
                                        @endif  
                                    </td>
                                     <td class=""> 
                                        @if($project->status == 'volunteering')
                                        @lang('layout.Volunteering')
                                        @else
                                        @lang('layout.Accepted')
                                        @endif  
                                    </td>
                                    <td class=""> {{ $project->percent}} %</td>
                                    <td class=""> {{ convertDate($project->startDate) }}</td>
                                    <td class=""> {{ convertDate($project->endDate) }}</td>
                                    <td class=""> {{ $remainDate->days}}</td>

                                </tr>
                            </tbody>
                          </table> 
                          <table class="table table-striped table-bordered table-advance table-hover">
                              <thead>
                              <tr>
                                  <th width="">
                                      <i class=" fa "></i> @lang('layout.Agent')
                                  </th>
                                  <th width="">
                                      <i class=" fa "></i> @lang('layout.GranteeAmount')
                                  </th>
                                  <th width="">
                                      <i class=" fa "></i> @lang('layout.VolunteeringDate')
                                  </th>
                                  <th width="">
                                      <i class=" fa "></i> @lang('layout.Times') @lang('layout.Volunteeres')
                                  </th>
                                  <th width="">
                                      <i class=" fa "></i> @lang('layout.Description')
                                  </th>
                                  <th width=" ">
                                      <i class=" fa "></i> @lang('layout.Memo')
                                  </th>
                              </tr>
                              </thead>
                              <tbody>
                              <tr>
                                  <td class=" "> {{ $project->employee_name}}  </td>
                                  <td class=" "> {{ $project->grantee_amount}}  </td>
                                  <td class=" "> {{ convertDate($project->volunteering_date) }}  </td>
                                  <td class=" "> {{ $project->volunteeres}}  </td>
                                  <td class=" "> {{ $project->description}}  </td>
                                  <td class=" "> {{ $project->memo}}  </td>
                              </tr>
                              </tbody>
                          </table>
                        </div> 
                        <div class="tab-pane" id="tab_15_2">
                            <table class="table table-striped table-bordered table-advance table-hover" id="table_payment">
                            <thead>
                                <tr>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.Currency') 
                                    </th>
                                    <th>
                                        <i class="fa "></i> @lang('layout.Rate')
                                    </th>
                                    
                                    <th class="">
                                        <i class="fa  " style="color:#3FABA4"></i> @lang('layout.Amount')
                                    </th>  
                                    @if($project->discount)
                                    <th class="">
                                        <i class="fa fa-minus-square"></i> @lang('layout.Discount')
                                    </th> 
                                    @endif
                                    <th class="">
                                        <i class="fa fa-get-pocket" style="color: green"></i> @lang('layout.Receive')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-building-o" style="color: #F2784B"></i> @lang('layout.MaintainanceAmount')  
                                    </th>
                                    <th>
                                        <i class="fa fa-minus-circle" style="color:#E87E04"></i> @lang('layout.RemainAmount')
                                    </th> 
                                    <th>
                                        <i class="fa fa-cart-plus" style="color: #F7CA18; font-size: 16px;"></i> @lang('layout.ExpensedAmount')
                                    </th>
                                    <th>
                                        <i class="fa fa-briefcase" style="color:green;font-size: 15px;"></i> @lang('layout.EarnedAmount')
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class=""> {{ $project->currency}}  </td>
                                    <td class=""> {{ $project->rate}}  </td>  
                                    <td class=""> @if($project->Amount){{myRound($project->Amount+$ExpenseNotFree)}} {{$project->currency}} @endif </td> 
                                    @if($project->discount) 
                                    <td class=""> @if($project->discount){{myRound($project->discount)}} {{$project->currency}} @endif </td>  
                                    @endif
                                    <td class="">@if($totalRecevie){{myRound($totalRecevie)}} {{$project->currency}} @endif
                                      </td>
                                    <td class="">@if($totalMaintain){{myRound($totalMaintain)}}{{$project->currency}} @endif
                                     </td>
                                    <td class="">@if($totalPAmount){{myRound($totalPAmount)}} {{$project->currency}} @endif</td>
                                    <td class="">@if($totalExpensedAmount){{myRound($totalExpensedAmount)}} {{$project->currency}} @endif</td>
                                    <td class="">@if($totalearnedAmount) {{myRound($totalearnedAmount)}}{{$project->currency}}@endif </td>
                                </tr>
                            </tbody>
                            </table>
                        </div>
                    </div>
                </div>
              <!-- '''''''''''''''''''''''' -->
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ProjectDetails')</span>
                    </div> 
                    <div class="actions" >
                        <div> 
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="Project_profitandlost"/>
                            <input type="hidden" name="id" value="{{$project->project_id}}"/>
                            <button type="submit" class="btn btn-success" style="">@lang('layout.ProfitAndLost')
                            </button>
                            {{Form::close()}}
                        </div>
                    </div>
                </div> 
                <div class="tabbable-line">
                    <ul class="nav nav-tabs ">
                        <li class="active">
                            <a href="#expense" data-toggle="tab" id="expensesd"> @lang('layout.Maintenance') </a>
                        </li>
                        <li>
                            <a href="#item" data-toggle="tab" id="items"> @lang('layout.ItemDetails') </a>
                        </li>
                        <li>
                            <a href="#deliveryItems" data-toggle="tab" id="deliveryItemsTab"> @lang('layout.ProjectDelivery') </a>
                        </li>
                        <li>
                            <a href="#deliveryRefund" data-toggle="tab" id="deliveryRefundTab"> @lang('layout.DeliveryRefund') </a>
                        </li>
                        <li>
                            <a href="#sentmoney" data-toggle="tab" id="money"> @lang('layout.ProjectServices') <i class="fa  "></i></a>
                        </li>
                        <li>
                            <a href="#projectDeliveryService" data-toggle="tab" id="projectDeliveryServiceTab"> @lang('layout.ProjectDeliveryService') </a>
                        </li>
                        <li>
                            <a href="#receivablePayment" data-toggle="tab" id="recevie"> @lang('layout.ProjectRecevies') </i></a>
                        </li>
                        <li>
                            <a href="#expenseAlls" data-toggle="tab" id="expenseAll"> @lang('layout.ExpenseList') </i></a>
                        </li>
                        <li>
                            <a href="#procurementAlls" data-toggle="tab" id="procurementAll"> @lang('layout.Procurement') </i></a>
                        </li>
                        <li>
                            <a href="#DailyExpenses" data-toggle="tab" id="DailyExpense"> @lang('layout.DailyExpense') </i></a>
                        </li>
                        <li>
                            <a href="#paySalaryExpenses" data-toggle="tab" id="paySalaryExpense"> @lang('layout.PayrollList')</a>
                        </li>
                        <li>
                            <a href="#contractPayrollExpenses" data-toggle="tab" id="contractPayrollExpense"> @lang('layout.ContractBasedPayroll')</a>
                        </li>
                        <li>
                            <a href="#shareholder_tab" data-toggle="tab" id="shareholder"> @lang('layout.Shareholder') </a>
                        </li>
                        <li>
                            <a href="#journalIncome" data-toggle="tab" id="journalIncomes"> @lang('layout.JournalIncome')</a>
                        </li>
                        <li>
                            <a href="#volunteer" data-toggle="tab" id="volunteeres"> @lang('layout.Volunteeres')</a>
                        </li>
                        <li>
                            <a href="#transferlist" data-toggle="tab" id="transferlistes"> @lang('layout.Transferlist')</a>
                        </li>
                        <li>
                          <a href="#attachments_tab" data-toggle="tab" id="attachments"> @lang('layout.Attachments') </a>
                      </li>
                       
                      <li>
                          <a href="#return_expense" data-toggle="tab" id="return_expenses"> @lang('layout.ReturnExpense') </a>
                      </li>
                      @permission('drawing-list')
                      <li>
                          <a href="#owners_equity" data-toggle="tab" id="owners_equities"> @lang('layout.OwnersEquity') </a>
                      </li>
                      @endpermission
                    </ul> 
                    <div class="tab-content">

                      <div class="tab-pane active" id="expense">
                        <div class="">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                          <div class="portlet-title">
                              <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Maintenance')</span>
                              </div>
                              <div class="actions">
                                @permission('maintenance-export')
                                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="projectExpense"/>
                                <input type="hidden" name="qut" value="in"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/> 
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                {{Form::close()}}
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="projectExpense"/>
                                <input type="hidden" name="qut" value="in"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/> 
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                {{Form::close()}}
                                @endpermission
                                @permission('maintenance-create') 
                                  <a href="{{route('maintenance.create',$project->project_id)}}">
                                    <button id="sample_editable_1_new" class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @endpermission
                              </div>
                            </div>
                            <div class="portlet-body" id="itemsshow">
                                <table class="table table-striped table-bordered table-hover" id="expense-table">
                                    <thead>
                                        <tr>
                                            <!-- <th>@lang('layout.ProjectName')</th> -->
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            </div>
                          <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                        </div>


                        <div class="tab-pane" id="item">
                        <div class="tab-pane" id="tab_15_1">

                        <div class="">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                          <div class="portlet-title">
                              <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.ItemDetails')</span>
                              </div>
                              <div class="actions">
                                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="projectshowItems"/>
                                <input type="hidden" name="qut" value="in"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/> 
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                {{Form::close()}}
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="projectshowItems"/>
                                <input type="hidden" name="qut" value="in"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/>                               
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                {{Form::close()}}
                              </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="item-table">
                                    <thead>
                                        <tr>   
                                            <th>@lang('layout.Item')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.OnHand')</th>
                                            <th>@lang('layout.Delivery')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.SalePrice')</th> 
                                            <th>@lang('layout.Total')</th> 
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            </div>
                          <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                        </div>
                        </div>

                        <div class="tab-pane" id="sentmoney">
                        <div class="tab-pane" id="tab_15_1">

                        <div class="">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                          <div class="portlet-title">
                              <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Services')</span>
                              </div>
                              <div class="actions">
                                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="projectShowService"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                {{Form::close()}}
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="projectShowService"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                {{Form::close()}}
                              </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="sentmoney-table">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.Number')</th>
                                                <th>@lang('layout.Item')</th>
                                                <th>@lang('layout.Quantity')</th>
                                                <th>@lang('layout.Measure')</th>
                                                <th>@lang('layout.Cost')</th>
                                            </tr>
                                        </thead>
                                    </table>
                            </div>
                            </div>
                          <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                        </div>
                        </div>           

                        <div class="tab-pane" id="receivablePayment">
                          <!-- BEGIN EXAMPLE TABLE PORTLET-->
                          <div class="portlet light bordered">
                            <div class="portlet-title">
                              <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Recevies')</span>
                              </div>
                              <div class="actions">
                                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="receivablePaymentShow"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                {{Form::close()}}
                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                <input type="hidden" name="type" value="receivablePaymentShow"/>
                                <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                {{Form::close()}}
                              </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="receivablePayment_table">
                                        <thead>
                                            <tr>
                                              <!-- <th>@lang('layout.Name')</th> -->
                                              <th>@lang('layout.Account')</th>
                                              <th>@lang('layout.Currency')</th>
                                              <th>@lang('layout.Rate')</th>
                                              <th>@lang('layout.Type')</th>
                                              <th>@lang('layout.Amount')</th>
                                              <th>@lang('layout.Date')</th>
                                              <th>@lang('layout.Status')</th>
                                              <th>@lang('layout.Actions')</th>
                                            </tr>
                                        </thead>
                                    </table>
                            </div>
                          </div>
                          <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                      
                        <div id="form_modal2" class="modal fade col-md-12" role="dialog" aria-hidden="true">
    
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2 class="modal-title">@lang("layout.ExpenseItems")</h2>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    
                                                    <div class="tabbable-line">
                                                        <ul class="nav nav-tabs ">
                                                            <li class="active">
                                                                <a href="#expenseItem" data-toggle="tab" id="expensesd"> @lang('layout.Item') <i class="fa fa-list-alt"></i></a>
                                                            </li>
                                                            <li>
                                                                <a href="#itemModal" data-toggle="tab" id="items"> @lang('layout.MaintenanceDetails') <i class="fa fa-list"></i> </a>
                                                            </li>
                                                        </ul> 
                                                        <div class="tab-content">

                                                          <div class="tab-pane active" id="expenseItem">
                                                            <div class="col-md-12">
                                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                            <div class="portlet light bordered">
                                                              <div class="portlet-title">
                                                                  <div class="caption font-dark">
                                                                    <i class="icon-settings font-dark"></i>
                                                                    <span class="caption-subject bold uppercase">@lang('layout.MaintenanceDetails')</span>
                                                                  </div>
                                                                  
                                                                </div>
                                                                <div class="portlet-body" id="itemshow">
                                                                    <table class="table table-striped table-bordered table-hover" id="expenseitem-table">
                                                                        <thead>
                                                                          <tr>
                                                                            <th>@lang('layout.Item')</th>
                                                                            <th>@lang('layout.Quantity')</th>
                                                                            <th>@lang('layout.Measure')</th>
                                                                            <th>@lang('layout.Price')</th>
                                                                            <th>@lang('layout.Details')</th>
                                                                            <th>@lang('layout.Amount')</th>
                                                                          </tr>
                                                                      </thead>
                                                                    </table>
                                                                </div>
                                                                </div>
                                                              <!-- END EXAMPLE TABLE PORTLET-->
                                                            </div>
                                                            </div>
 

                                                            <div class="tab-pane" id="itemModal">
                                                            <div class="tab-pane" id="tab_15_1">

                                                            <div class="col-md-12">
                                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                            <div class="portlet light bordered">
                                                              <div class="portlet-title">
                                                                  <div class="caption font-dark">
                                                                    <i class="icon-settings font-dark"></i>
                                                                    <span class="caption-subject bold uppercase">@lang('layout.MaintenanceDetails')</span>
                                                                  </div>
                                                                  <div class="actions">
                                                                     {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                                                       <input type="hidden" name="type" value="project_expense_Details"/>
                                                                       <input type="hidden" name="id" id="maintain_excel" /> 
                                                                       <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                                                    {{Form::close()}} 

                                                                     {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                                                       <input type="hidden" name="type" value="project_expense_Details"/>
                                                                       <input type="hidden" name="id" id="maintain_pdf" /> 
                                                                       <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                                                    {{Form::close()}}  
                                                                </div>
                                                                  
                                                                </div>
                                                                <div class="portlet-body">
                                                                    <table class="table table-striped table-bordered table-hover" id="itemshowsmodal-table">
                                                                        <thead>
                                                                            <tr> 
                                                                                <th>@lang('layout.Details')</th>
                                                                                <th>@lang('layout.Amount')</th>
                                                                                <th>@lang('layout.CreatedAt')</th>
                                                                            </tr>
                                                                        </thead>
                                                                    </table>
                                                                </div>
                                                                </div>
                                                              <!-- END EXAMPLE TABLE PORTLET-->
                                                            </div>
                                                            </div>
                                                            </div>                      

                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                    </div>
                                    <div class="modal-footer">
                                    <input type="hidden" id="item_id">
                                        <button class="btn btn-default btn-outline" data-dismiss="modal" aria-hidden="true">@lang("layout.Close")</button>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="expenseAlls">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ExpenseList')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="ExpenseList"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="ExpenseList"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="expenseAlls_table">
                                                <thead>
                                                    <tr>
                                                      <th>@lang('layout.Number')</th>
                                                      <th>@lang('layout.Vendor')</th>
                                                      <th>@lang('layout.Account') </th>
                                                      <th>@lang('layout.Date')</th>
                                                      <th>@lang('layout.Amount')</th>
                                                      <th>@lang('layout.Currency')</th>
                                                      <th>@lang('layout.Status')</th>
                                                      <th>@lang('layout.User')</th>
                                                      <th>@lang('layout.Description')</th>
                                                      <th>@lang('layout.Actions') </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                      </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="procurementAlls">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Procurement')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="procurementAlls"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="procurementAlls"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                          <table class="table table-striped table-bordered table-hover" id="procurementAlls_table">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.Number')</th>
                                                  <th>@lang('layout.ItemName') </th>
                                                  <th>@lang('layout.MeasureUnit')</th>
                                                  <th>@lang('layout.Quantity')</th>
                                                  <th>@lang('layout.Price')</th>
                                                  <th>@lang('layout.Date')</th>
                                                </tr>
                                            </thead>
                                          </table>
                                      </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="DailyExpenses">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.DailyExpense')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="dailyExpenses"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="dailyExpenses"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="dailyExpenses_table">
                                                <thead>
                                                    <tr>
                                                      <th>@lang('layout.Number')</th>
                                                      <th>@lang('layout.BankAccount')</th>
                                                      <th>@lang('layout.ExpenseAccount') </th>
                                                      <th>@lang('layout.Date')</th>
                                                      <th>@lang('layout.Amount')</th>
                                                      <th>@lang('layout.Currency')</th>
                                                      <th>@lang('layout.User')</th>
                                                      <th>@lang('layout.Description')</th>
                                                      <th>@lang('layout.Status')</th>
                                                      <th>@lang('layout.Actions') </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="paySalaryExpenses">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.PayrollList')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="all_payrolls"/>
                                        <!-- <input type="hidden" name="category" value="1"/> -->
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="all_payrolls"/>
                                        <!-- <input type="hidden" name="category" value="1"/> -->
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="paySalaryExpenses_table">
                                                <thead>
                                                    <tr>
                                                    <th>@lang('layout.Name')</th>
                                                    <th>@lang('layout.BasicSalary')</th>
                                                    <th>@lang('layout.Tax')</th>
                                                    <th>@lang('layout.WorkedDay')</th>
                                                    <th>@lang('layout.AbsentDays')</th>
                                                    <th>@lang('layout.NetPayable')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    <th>@lang('layout.Account')</th>
                                                    <th>@lang('layout.ExpenseAccount')</th>
                                                    <th>@lang('layout.FromDate')</th>
                                                    <th>@lang('layout.ToDate')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Status')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Actions')</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="contractPayrollExpenses">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ContractBasedPayroll')</span>
                                      </div>
                                      <div class="actions">
                                      {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="ContractBasedPayroll"/>
                                        <input type="hidden" name="category" value="1"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="ContractBasedPayroll"/>
                                        <input type="hidden" name="category" value="1"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                      {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="contractPayrollExpenses-table">
                                                <thead>
                                                    <tr>
                                                    <th>@lang('layout.Account')</th>
                                                    <th>@lang('layout.ExpenseAccount')</th>
                                                    <th>@lang('layout.Employee')</th>
                                                    <th>@lang('layout.Name')</th>
                                                    <th>@lang('layout.Type')</th>
                                                    <th>@lang('layout.Amount')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div>  
                        <div class="tab-pane" id="shareholder_tab">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Shareholder')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="project_shareholders"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="project_shareholders"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="shareholder-table">
                                                <thead>
                                                    <tr>
                                                      <th>@lang('layout.Shareholder')</th>
														                          <th>@lang('layout.Percentage')</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div>   
                        <div class="tab-pane" id="journalIncome">
                            <div class="tab-pane" id="tab_15_1">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.JournalIncome')</span>
                                      </div>
                                      <div class="actions">

                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="journalIncome"/>
                                        <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="journalIncome"/>
                                        <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="journalIncomes_table">
                                                <thead>
                                                    <tr>
                                                      <th>@lang('layout.Number')</th>
                                                      <th>@lang('layout.Member')</th>
                                                      <th>@lang('layout.Account')</th>
                                                      <th>@lang('layout.Currency')</th>
                                                      <th>@lang('layout.Amount')</th>
                                                      <th>@lang('layout.Date')</th>
                                                      <th>@lang('layout.Description')</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>  
                        <div class="tab-pane" id="volunteer">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                              <div class="portlet-title">
                                  <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Volunteeres')</span>
                                  </div>
                                  <div class="actions">

                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="volunteeres"/>
                                    <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="volunteeres"/>
                                    <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                  </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="volunteeres_table">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.Name')</th>
                                                  <th>@lang('layout.Price')</th>
                                                  <th>@lang('layout.Currency')</th>
                                                  <th>@lang('layout.Discount')</th>
                                                  <th>@lang('layout.Type')</th>
                                                  <th>@lang('layout.Description')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>  
                        <div class="tab-pane" id="transferlist">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                              <div class="portlet-title">
                                  <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Transferlist')</span>
                                  </div>
                                  <div class="actions">

                                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="transferAccounts"/>
                                    <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="transferAccounts"/>
                                    <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                  </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="transferlistes_table">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.Number') </th>
                                                  <th>@lang('layout.FromAccount') </th>
                                                  <th>@lang('layout.Currency')</th>
                                                  <th>@lang('layout.FromRate')</th>
                                                  <th>@lang('layout.Amount')</th>
                                                  <th>@lang('layout.ToAccount')</th>
                                                  <th>@lang('layout.Currency')</th>
                                                  <th>@lang('layout.ToRate')</th>
                                                  <th>@lang('layout.Amount')</th>
                                                  <th>@lang('layout.Date')</th>
                                                  <th>@lang('layout.User')</th>
                                                  <th>@lang('layout.Description')</th>
                                                  <th>@lang('layout.Actions')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div> 


                        {{-- Return Expense Start For project..................................... --}}
                        <div class="tab-pane" id="return_expense">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                              <div class="portlet-title">
                                  <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.ReturnExpense')</span>
                                  </div>
                                  <div class="actions">

                                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="return_expense_project"/>
                                    <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="return_expense_project"/>
                                    <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                  </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="returnExpensees_table">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.Number') </th>
                                                  <th>@lang('layout.Date') </th>
                                                  <th>@lang('layout.Description') </th>
                                                  <th>@lang('layout.ReferenceNumber') </th>
                                                  <th>@lang('layout.Account') </th>
                                                  <th>@lang('layout.Vendor') </th>
                                                  <th>@lang('layout.ExpenseAccount') </th>
                                                  <th>@lang('layout.Type') </th>
                                                  <th>@lang('layout.Amount') </th> 
                                                  <th>@lang('layout.Currency') </th> 
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div> 
                        {{-- End of Return Expense ........................................... --}}
                        {{-- owners equity Start For project..................................... --}}
                        @permission('drawing-list')
                        <div class="tab-pane" id="owners_equity">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                              <div class="portlet-title">
                                  <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.ReturnExpense')</span>
                                  </div>
                                  <div class="actions">
                                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="owners_equity_project"/>
                                    <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="owners_equity_project"/>
                                    <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                  </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="owners_equity_table">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.Number') </th>
                                                  <th>@lang('layout.Name') </th>
                                                  <th>@lang('layout.Account') </th>
                                                  <th>@lang('layout.Equity') </th>
                                                  <th>@lang('layout.Amount') </th> 
                                                  <th>@lang('layout.Currency') </th> 
                                                  <th>@lang('layout.Rate') </th>
                                                  <th>@lang('layout.Date') </th>
                                                  <th>@lang('layout.Description') </th>
                                                  <th>@lang('layout.User') </th>
                                                </tr>
                                            </thead>
                                        </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div> 
                        @endpermission
                        {{-- End of owners equity ........................................... --}}







                        <div class="tab-pane" id="projectDeliveryService">
                            <div class="tab-pane" id="tab_15_1">
                                <div class="col-md-12">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ProjectDeliveryService')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="ProjectDelivery_service_details"/>
                                        <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="ProjectDelivery_service_details"/>
                                        <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="projectDeliveryService_table">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.ItemName')</th>
                                                  <th>@lang('layout.MeasureUnit')</th>
                                                  <th>@lang('layout.Quantity')</th>
                                                  <th>@lang('layout.Price')</th>
                                                  <th>@lang('layout.Date')</th>
                                                  <th>@lang('layout.Status')</th>
                                                  <th>@lang('layout.Actions')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                        </div> 
                        <div class="tab-pane" id="deliveryItems">
                            <div class="tab-pane" id="tab_15_1">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ProjectDelivery')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="deliveryItems"/>
                                        <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="deliveryItems"/>
                                        <input type="hidden" name="id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="deliveryItems_table">
                                            <thead>
                                                <tr>
                                                      <th>@lang('layout.Item')</th>
                                                      <th>@lang('layout.Site')</th>
                                                      <th>@lang('layout.Quantity')</th>
                                                      <th>@lang('layout.Measure')</th>
                                                      <th>@lang('layout.Cost')</th>
                                                      <th>@lang('layout.Date')</th>
                                                      <th>@lang('layout.Status')</th>
                                                      <th>@lang('layout.Actions')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div> 
                        <div class="tab-pane" id="deliveryRefund">
                            <div class="tab-pane" id="tab_15_1">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                  <div class="portlet-title">
                                      <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.DeliveryRefund')</span>
                                      </div>
                                      <div class="actions">
                                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="RefundProjectDetail"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="RefundProjectDetail"/>
                                        <input type="hidden" name="project_id" value="{{$project->project_id}}"/>
                                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                      </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="delivery_refund">
                                            <thead>
                                                <tr>
                                                  <th>@lang('layout.Number')</th>
                                                  <th>@lang('layout.CustomerName')</th>
                                                  <th>@lang('layout.ItemName')</th>
                                                  <th>@lang('layout.Site')</th>
                                                  <th>@lang('layout.Quantity')</th>
                                                  <th>@lang('layout.Symbol')</th>
                                                  <th>@lang('layout.Price')</th> 
                                                  <th>@lang('layout.Date')</th>
                                                  <th>@lang('layout.Description')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                    </div>
                                  <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div> 
                        
                        <div class="tab-pane" id="attachments_tab">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                    </div>

                                </div>
                                <div class="portlet-body">
                                    <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                                @csrf
                                                <input type="hidden" name="redirect_route" value="project.show">
                                                <input type="hidden" name="foreign_data_id" value="{{$project->project_id}}">
                                                <input type="hidden" name="path" value="uploads/project">
                                                <input type="hidden" name="table_name" value="projects">

                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                            <input type="text" name="title" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Description')</label>
                                                            <textarea name="description" class="form-control"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-7">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="" alt=""> </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                                <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> </span>

                                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="margiv-top-10">
                                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                    <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <table class="table table-striped table-bordered table-hover" id="attachment">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.AttachmentTitle')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Action')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
@endsection
@push('scripts') 
<script>
 function ProjectGlassesPrint(id) {
   @if(!Session('project'))
    var a=document.createElement('a');
    a.href="{{url('projectGlassPrint')}}/"+id;
    a.target="_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    @else
    var u="{{url('projectGlassPrint')}}/"+id;
    window.location.href=u;
    @endif
    }
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
       $('#expense-table').DataTable({  
              scrollCollapse: true, 
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'expenses'}
                },
              columns: [
                // { data: 'name',             name: 'name' , orderable:false, searchable:false },
                { data: 'description',      name: 'description' },
                { data: 'date',             name: 'date' },
                { data: 'unit',             name: 'unit' },
                { data: 'amount',           name: 'amount' },
                { data: 'rate',             name: 'rate' }, 
                { data: 'actions', name: 'actions', orderable:false,searchable:false }
              ]
          });  
});
// Contract Date
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#items').on('shown.bs.tab', function(event){
       $('#item-table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                  url: '{{route("project.show",$project->project_id)}}',
                  data:{type:'items'}
                }, 
              columns: [ 
                { data: 'name'   ,      name: 'name' },
                { data: 'quantity',     name: 'quantity' },
                { data: 'OnHand',       name: 'OnHand'},
                { data: 'delivery_qty', name: 'delivery_qty' },
                { data: 'um',           name: 'um' },
                { data: 'price',        name: 'price'}, 
                { data: 'total',        name: 'total', orderable:false,searchable:false  }, 
              ]
          });  
          });
});
// Sent Money Table 
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#money').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#sentmoney-table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'services'}
                },
              columns: [
                { data: 'number',           name: 'number' },
                { data: 'name',             name: 'name' },
                { data: 'quantity',         name: 'quantity' },
                { data: 'um',               name: 'um' },
                { data: 'price',            name: 'price' },
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#recevie').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#receivablePayment_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'receivablePayment'}
                },
              columns: [
                  // { data: 'name',         name: 'members.name' },
                  { data: 'account',      name: 'account',orderable:false,searchable:false },
                  { data: 'currency',     name: 'currency',orderable:false,searchable:false },
                  { data: 'rate',         name: 'rate',orderable:false,searchable:false },
                  { data: 'type',         name: 'type' ,orderable:false,searchable:false},
                  { data: 'amount',       name: 'amount',orderable:false,searchable:false },
                  { data: 'date',         name: 'date' ,orderable:false,searchable:false},
                  {data: 'status', name: 'receivable_payments.status', searchable: false},
                  {data: 'actions', name: 'actions', orderable: false, searchable: false},
              ]
          });  
    });
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#expenseAll').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#expenseAlls_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'expenseAll'}
              },
              columns: [
                {data: 'number', name: 'number'},
                {data: 'vendor', name: 'members.name'},
                {data: 'account', name: 'accounts.name'},
                {data: 'date', name: 'purchases.date'},
                {data: 'amount', name: 'transactions.amount'},
                {data: 'currency', name: 'currency', orderable: false, searchable: false},
                {data: 'status', name: 'expenses.status', searchable: false},
                {data: 'username', name: 'username', orderable: false, searchable: false},
                {data: 'description', name: 'purchases.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#procurementAll').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#procurementAlls_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'procurementAll'}
              },
              columns: [
                {data: 'procurement_number', name: 'procurement_number'},
                {data: 'item', name: 'item'},
                {data: 'measure', name: 'measure'},
                {data: 'quantity', name: 'quantity'},
                {data: 'cost', name: 'cost'},
                {data: 'date', name: 'date'},
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#DailyExpense').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#dailyExpenses_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'DailyExpense'}
                },
              columns: [
                {data: 'number', name: 'number'},
                {data: 'Bank', name: 'accounts.name'},
                {data: 'expense_account', name: 'accounts.name'},
                {data: 'date', name: 'daily_expenses.date'},
                {data: 'amount', name: 'transactions.amount'},
                {data: 'currency', name: 'currency', orderable: false, searchable: false},
                {data: 'username', name: 'username', orderable: false, searchable: false},
                {data: 'description', name: 'daily_expenses.description'},
                {data: 'status', name: 'daily_expenses.status', searchable: false},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#paySalaryExpense').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#paySalaryExpenses_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'paySalaryExpenses'}
                },
              columns: [
                    {data: 'Employee', name: 'members.name'},
                    {data: 'BasicSalary', name: 'BasicSalary', orderabel: false, searchable: false},
                    {data: 'tax_amount', name: 'tax_amount', orderabel: false, searchable: false},
                    {data: 'Worked_Days', name: 'Worked_Days', orderabel: false, searchable: false},
                    {data: 'absent_day', name: 'absent_day', orderabel: false, searchable: false},
                    {data: 'Net_Payable', name: 'Net_Payable', orderabel: false, searchable: false},
                    {data: 'Curreny', name: 'Curreny', orderabel: false, searchable: false},
                    {data: 'account', name: 'account', orderabel: false, searchable: false},
                    {data: 'exAccount', name: 'exAccount', orderabel: false, searchable: false},
                    {data: 'From_Date', name: 'From_Date', orderabel: false, searchable: false},
                    {data: 'To_Date', name: 'To_Date', orderabel: false, searchable: false},
                    {data: 'Date', name: 'Date', orderabel: false, searchable: false},
                    {data: 'status', name: 'payrolls.status', searchable: false},
                    {data: 'description', name: 'payrolls.description'},
                    {data: 'actions', name: 'actions', orderabel: false, searchable: false},
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#contractPayrollExpense').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#contractPayrollExpenses-table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'contractPayrollExpenses'}
                },
              columns: [
                    {data: 'account', name: 'account', orderabel: false, searchable: false},
                    {data: 'exAccount', name: 'exAccount', orderabel: false, searchable: false},
                    { data: 'member_name', orderabel:false,searchable:false },
                    { data: 'name', orderabel:false,searchable:false },
                    { data: 'type', name:'item_type_payrolls.type',orderabel:false,searchable:false },
                    { data: 'amount', orderabel:false,searchable:false },
                    { data: 'currency', name: 'currencies.code', orderabel:false,searchable:false},
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#shareholder').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#shareholder-table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'shareholder'}
                },
              columns: [
					{data: 'name', name: 'members.name'},
					{data: 'percentage', name: 'project_shareholders.percentage'}
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#journalIncomes').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#journalIncomes_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'journalIncome'}
                },
              columns: [  
                  { data: 'number', name: 'number' },
                  { data: 'Member', name: 'Member' },
                  { data: 'Account', name: 'Account' },
                  { data: 'currency', name: 'currency' },
                  { data: 'amount', name: 'amount' },
                  { data: 'date', name: 'date' },
                  { data: 'Description', name: 'Description' },
              ]
          });  
          });
}); 
    $(document).ready(function(){
      $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#volunteeres').on('shown.bs.tab', function(event){
            // alert('adads');
        $('#volunteeres_table').DataTable({  
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                  pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax:{
                  url: '{{route("project.show",$project->project_id)}}',
                  data:{type:'volunteeres'}
                  },
                columns: [  
                    { data: 'name', name: 'project_volunteeres.name' },
                    { data: 'price', name: 'project_volunteeres.price' },
                    { data: 'currency', name: 'projects.currency' },
                    { data: 'discount', name: 'project_volunteeres.discount' },
                    { data: 'type', name: 'project_volunteeres.type' },
                    { data: 'description', name: 'project_volunteeres.description' },
                ]
          });  
      });
  }); 

$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#transferlistes').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#transferlistes_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'transferlistes'}
                },
              columns: [  
                {data: 'number', name: 'transfer_accounts.number'},
                {data: 'From_account', name: 'from_a.name'},
                {data: 'from_currency', name: 'from_currency', searchable: false, orderable: false},
                {data: 'from_rate', name: 'from.rate'},
                {data: 'amount', name: 'from.amount'},
                {data: 'to_Account', name: 'to_a.name'},
                {data: 'to_currency', name: 'to_currency', searchable: false, orderable: false},
                {data: 'to_rate', name: 'to.rate'},
                {data: 'to_amount', name: 'to.amount'},
                {data: 'Date', name: 'transfer_accounts.Date'},
                {data: 'username', name: 'username', searchable: false, orderable: false},
                {data: 'Description', name: 'transfer_accounts.description'},
                {data: 'actions', name: 'actions', searchable: false, orderable: false}
              ]
          });  
          });
}); 



// return Expense Startfor the project ......................................
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#return_expenses').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#returnExpensees_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'return_expenses'}
                },
              columns: [  
                { data: 'number', name: 'number' },
                { data: 'date', name: 'date' },
                { data: 'expense_ref', name: 'expense_ref' },
                { data: 'description', name: 'description' },
                { data: 'bank', name: 'bank' },
                { data: 'member_name', name: 'member_name' },
                { data: 'account', name: 'account' },
                { data: 'type', name: 'type' },
                { data: 'amount', name: 'amount' },
                { data: 'Currency', name: 'Currency' }
              ]
          });  
          });
}); 
// End of Expense Return for the projects ...................................
// return Expense Startfor the project ......................................
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#owners_equities').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#owners_equity_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
              pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'owners_equity'}
                },
              columns: [  
                { data: 'number', name: 'number' },
                { data: 'name', name: 'name' },
                { data: 'account', name: 'account' },
                { data: 'drawing_account', name: 'drawing_account' },
                { data: 'amount', name: 'amount' },
                { data: 'currency', name: 'currency' },
                { data: 'rate', name: 'rate' },
                { data: 'date', name: 'date' },
                { data: 'description', name: 'description' },
                { data: 'username', name: 'username' }
              ]
          });  
          });
}); 
// End of Expense Return for the projects ...................................


$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#deliveryItemsTab').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#deliveryItems_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'deliveryItems'}
                },
              columns: [  
                {data: 'item', name: 'item'},
                {data: 'site', name: 'site'},
                {data: 'qty', name: 'qty'},
                {data: 'measure', name: 'measure'},
                {data: 'cost', name: 'cost'},
                {data: 'date', name: 'date'}, 
                {data: 'status', name: 'status'}, 
                {data: 'actions', name: 'actions'}, 
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#deliveryRefundTab').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#delivery_refund').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'deliveryRefund'}
                },
              columns: [  
                    {data: 'number', name: 'number'},
                    {data: 'member', name: 'member'},
                    {data: 'itemName', name: 'itemName'},
                    {data: 'site', name: 'site'},
                    {data: 'qty', name: 'qty'},
                    {data: 'um', name: 'um', searchable: false, orderable: false},
                    {data: 'price', name: 'price', searchable: false, orderable: false},
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description'}
              ]
          });  
          });
});
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#projectDeliveryServiceTab').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#projectDeliveryService_table').DataTable({  
            retrieve: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
			ajax:{
                url: '{{route("project.show",$project->project_id)}}',
                data:{type:'deliveryServiceItems'}
                },
            columns: [
                { data: 'item', name: 'item' },
                { data: 'measure', name: 'measure_unit' },
                { data: 'qty', name: 'qty' },
                { data: 'cost', name: 'cost' },
                {data: 'date', name: 'date'}, 
                {data: 'status', name: 'status'}, 
                {data: 'actions', name: 'actions'}, 
        ]
          });  
          });
});
        $(document).ready(function(){
          $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            var id =  0;
            var table = $('#expenseitem-table').DataTable({  
                  scrollCollapse: true,
                  responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                  serverSide: true,
                  paging: true,
                  deferLoading: 0,
                ajax:{
                    url:'{{route("project.show",$project->project_id)}}',
                    data:function(d){
                        d.type = 'item';
                        d.item_id = $("#item_id").val();
                    }
                },
                        columns: [
                            { data: 'name', name: 'name' },
                            { data: 'quantity', name: 'quantity' },
                            { data: 'measure', name: 'measure' },
                            { data: 'price', name: 'price' },
                            { data: 'description', name: 'description' },
                            { data: 'amount', name: 'amount',orderable:false,searchable:false },
                    ]
                });
            $(document).on('click','#show_btn',function(){
                $("#item_id").val($(this).data('id'));
                $("#maintain_excel").val($(this).data('id'));
                $("#maintain_pdf").val($(this).data('id'));
                table.draw();     
                $('#form_modal2').modal('show'); 
            });
        });      
});
$(document).ready(function() {
      $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#attachment').DataTable({
          ajax: {
              url: '{{route("project.show",$project->project_id)}}',
              data: {
                  type: 'attachment'
              }
          },
          scrollCollapse: true,
          responsive:'{{responsiveDataTable()}}',
          pagingType:'{{paginationType()}}',
          serverSide: true,
          paging: true,
          columns: [
              {
                  data: 'title',
                  name: 'attachments.title'
              },
              {
                  data: 'description',
                  name: 'attachments.description'
              },
              {
                  data: 'actions',
                  name: 'actions',
                  orderable: false,
                  searchable: false
              },
          ]
      });
  });
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            var id =  0;
            var table = $('#itemshowsmodal-table').DataTable({  
                  scrollCollapse: true,
                  responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                  serverSide: true,
                  paging: true,
                  deferLoading: 0,
                ajax:{
                    url:'{{route("project.show",$project->project_id)}}',
                    data:function(d){
                        d.type = 'itemnotstock';
                        d.item_id = $("#item_id").val();
                    }
                },
                        columns: [
                            { data: 'description', name: 'expense_details.description' },
                            { data: 'amount', name: 'amount',orderable:false,searchable:false },
                            { data: 'created_at', name: 'created_at',orderable:false,searchable:false },
                    ]
            });
            $(document).on('click','#show_btn',function(){
                $("#item_id").val($(this).data('id'));
                $("#maintain_excel").val($(this).data('id'));
                $("#maintain_pdf").val($(this).data('id'));
                table.draw(); 
                $('#form_modal2').modal('show'); 
            }); 
        });
</script>
@endpush