@extends('layouts.factor-master')
<?php 
    $reportTitle = __('layout.ReturnExpenseReport');
?>
@section('content')
    <?php
    $report=customeReport('payments','index');
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.ReturnExpenseReport')</h3>
    <table class="main-table">
    <tr>  
        <td>
            @lang('layout.Project'):  {{$info->name}}
        </td>
    </tr>
    </table>
    @if(count($data) > 0)
        <table class="main-table">
            <thead>
                <tr class="bg">
                    <th>@lang('layout.Record')</th>
                    <th>@lang('layout.Number') </th>
                    <th>@lang('layout.Date') </th>
                    <th style="width: 30%">@lang('layout.Description') </th>
                    <th width="8%">@lang('layout.ReferenceNumber') </th>
                    <th>@lang('layout.Account') </th>
                    <th>@lang('layout.Vendor') </th>
                    <th>@lang('layout.ExpenseAccount') </th>
                    <th>@lang('layout.Type') </th>
                    <th>@lang('layout.Amount') </th> 
                    <th>@lang('layout.Currency') </th> 
                    <th>@lang('layout.Rate') </th> 
                    <th>@lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}} </th> 
                </tr>
            </thead>
            <tbody>
                <?php
                    $count = 0;
                    $total = 0;
                    $totalBase = 0;
                ?>
                @foreach($data AS $record) 
                    <?php 
                           $totalBase +=  $record->base_amount;
                    ?>
                    <tr>
                        <td class="center">{{++$count}}</td>
                        <td class="center">{{$record->number}}</td>
                        <td class="center">{{convertDate($record->date)}}</td>
                        <td class="center">{{$record->description}}</td>
                        <td class="center">{{$record->expense_ref}}</td>
                        <td class="center">{{$record->bank}}</td>
                        <td class="center">{{$record->member_name}}</td>
                        <td class="center">{{$record->account}}</td>
                        <td class="center">{{$record->type}}</td>
                        <td class="center">{{myRound($record->amount)}}</td>
                        <td class="center">{{$record->Currency}}</td>
                        <td class="center">{{$record->rate}}</td>
                        <td class="center">{{myRound($record->base_amount)}}</td>
                    </tr>
                @endforeach
                <tr class="bg">
                    <td colspan="12" class="center">  @lang('layout.Total') </td> 
                    <td class="center"> {{$totalBase}}  </td>
                </tr>
            </tbody>
        </table>
    @endif
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection