@extends('layouts.factor-master')
@section('content')
<?php
$report = customeReport('contract', 'index');
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ProjectDetail')</h3>

<table class="main-table">
    <thead>
        <tr class="bg">
            <th class="center">
                <i class="fa fa-bars"></i> @lang('layout.ProjectCode')
            </th>
            <th class="center">
                <i class="fa fa-edit"></i> @lang('layout.ProjectName')
            </th>
            <!-- <th>
                <i class="fa  "></i> @lang('layout.Currency') 
            </th>
            <th>
                <i class="fa  "></i> @lang('layout.Rate')
            </th> -->
            <th class="center">
                <i class="fa fa-user"></i> @lang('layout.Customer')
            </th>
            <th class="center">
                <i class="icon-phone"></i> @lang('layout.Phone')
            </th>
            <th class="center">
                <i class="fa fa-bars"></i> @lang('layout.ProjectProgress')
            </th>
            <th class="center">
                <i class="fa fa-bars"></i> @lang('layout.Status')
            </th>
            <th class="center">
                <i class="fa fa-bars"></i> @lang('layout.Percent')
            </th>
            <th class="center">
                <i class="fa fa-clock-o"></i> @lang('layout.StartDate')
            </th>
            <th class="center">
                <i class="fa fa-calendar-times-o"></i> @lang('layout.EndDate')
            </th>
            <th class="center">
                <i class="fa fa-sun-o"></i> @lang('layout.TotalaDays')
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="center"> {{ $project->number}} </td>
            <td class="center"> {{ $project->name}} </td>
            <td class="center"> {{ $project->member}} </td>
            <td class="center"> {{ $project->phone}}</td>
            <td class="center">
                @if($project->project_progress_id != 1)
                {{$project->progress}}
                @else
                @lang('layout.Completed')
                @endif
            </td>
            <td class="center"> 
                @if($project->status == 'volunteering')
                @lang('layout.Volunteering')
                @else
                @lang('layout.Accepted')
                @endif  
            </td>
            <td class="center"> {{ $project->percent}} %</td>
            <td class="center"> {{ $project->startDate}}</td>
            <td class="center"> {{ $project->endDate}}</td>
            <td class="center"> {{ $remainDate->days}}</td>
        </tr>
    </tbody>
</table>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th width="" class="center">
                <i class=" fa "></i> @lang('layout.Agent')
            </th>
            <th width="" class="center">
                <i class=" fa "></i> @lang('layout.GranteeAmount')
            </th>
            <th width="" class="center">
                <i class=" fa "></i> @lang('layout.VolunteeringDate')
            </th>
            <th width="" class="center">
                <i class=" fa "></i> @lang('layout.Times') @lang('layout.Volunteeres')
            </th>
            <th width="" class="center">
                <i class=" fa "></i> @lang('layout.Description')
            </th>
            <th width="" class="center">
                <i class=" fa "></i> @lang('layout.Memo')
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="center"> {{ $project->employee_name}}  </td>
            <td class="center"> {{ $project->grantee_amount}}  </td>
            <td class="center"> {{ convertDate($project->volunteering_date) }}  </td>
            <td class="center"> {{ $project->volunteeres}}  </td>
            <td class="center"> {{ $project->description}}  </td>
            <td class="center"> {{ $project->memo}}  </td>
        </tr>
    </tbody>
</table>
<br>
<hr>
@if($items)
@if(count($items) > 0)
<h3>@lang('layout.ItemDetails')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div> #</div>
            </td>
            <th class="center">@lang('layout.Item')</th>
            <th class="center">@lang('layout.Quantity')</th>
            <th class="center">@lang('layout.OnHand')</th>
            <th class="center">@lang('layout.Measure')</th>
            <th class="center">@lang('layout.SalePrice')</th>
            <th class="center">@lang('layout.Total')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    ?>
    @foreach($items AS $record)
    <tr>
        <?php
        $totalp += ($record->price * $record->quantity);
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->name}}</td>
        <td class="center">{{$record->quantity}}</td>
        <td class="center">{{$record->OnHand}}</td>
        <td class="center">{{$record->um}}</td>
        <td class="center">{{$record->price}}</td>
        <td class="center">{{($record->price * $record->quantity)}}</td>
    </tr>
    @endforeach
    <tr>
        <td colspan="6" class="center">@lang('layout.Total')</td>
        <td  class="center">{{$totalp}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($itemDelivery)
@if(count($itemDelivery) > 0)
<h3>@lang('layout.ProjectDelivery')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Item')</th>
            <th class="center">@lang('layout.Site')</th>
            <th class="center">@lang('layout.Quantity')</th>
            <th class="center">@lang('layout.Measure')</th>
            <th class="center">@lang('layout.Cost')</th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Total')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    ?>
    @foreach($itemDelivery AS $record)
    <tr>
        <?php
        $totalp += ($record->cost * $record->qty);
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->item}}</td>
        <td class="center">{{$record->site}}</td>
        <td class="center">{{$record->qty}}</td>
        <td class="center">{{$record->measure}}</td>
        <td class="center">{{$record->cost}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
        <td class="center">{{ ($record->cost * $record->qty) }}</td>
    </tr>
    @endforeach
    <tr>
        <td colspan="7" class="center">@lang('layout.Total')</td>
        <td class="center">{{$totalp}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($RefundItems) 
@if(count($RefundItems) > 0)
<h3>@lang('layout.DeliveryRefundReport')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Number')</th>
            <th class="center">@lang('layout.CustomerName')</th>
            <th class="center">@lang('layout.ItemName')</th>
            <th class="center">@lang('layout.Site')</th>
            <th class="center">@lang('layout.Quantity')</th>
            <th class="center">@lang('layout.Symbol')</th>
            <th class="center">@lang('layout.Price')</th> 
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Description')</th>
            <th class="center">@lang('layout.Total')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    ?>
    @foreach($RefundItems AS $record)
    <tr>
        <?php
        $totalp += ($record->price * $record->qty);
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->number}}</td>
        <td class="center">{{$record->member}}</td>
        <td class="center">{{$record->itemName}}</td>
        <td class="center">{{$record->site}}</td>
        <td class="center">{{$record->qty}}</td>
        <td class="center">{{$record->um}}</td>
        <td class="center">{{myRound($record->price)}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
        <td class="center">{{$record->description}}</td>
        <td class="center">{{ myRound($record->price * $record->qty) }}</td>
    </tr>
    @endforeach
    <tr>
        <td colspan="10" class="center">@lang('layout.Total')</td>
        <td class="center">{{$totalp}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>
<hr />
@endif
@endif

@if($serviceDelivery)
@if(count($serviceDelivery) > 0)
<h3>@lang('layout.ProjectDeliveryService')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.ItemName')</th>
            <th class="center">@lang('layout.MeasureUnit')</th>
            <th class="center">@lang('layout.Quantity')</th>
            <th class="center">@lang('layout.Price')</th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Total')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    ?>
    @foreach($serviceDelivery AS $record)
    <tr>
        <?php
        $totalp += ($record->cost * $record->qty);
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->item}}</td>
        <td class="center">{{$record->measure_unit}}</td>
        <td class="center">{{$record->qty}}</td>
        <td class="center">{{$record->cost}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
        <td class="center">{{ ($record->cost * $record->qty) }}</td>
    </tr>
    @endforeach
    <tr>
        <td colspan="4" class="center">@lang('layout.Total')</td>
        <td colspan="2" class="center">{{$totalp}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>
<hr />
@endif
@endif

@if($procurementAll)
@if(count($procurementAll) > 0)
<h3>@lang('layout.Procurement')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Number')</th>
            <th class="center">@lang('layout.ItemName')</th>
            <th class="center">@lang('layout.MeasureUnit')</th>
            <th class="center">@lang('layout.Quantity')</th>
            <th class="center">@lang('layout.Price')</th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Total')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    ?>
    @foreach($procurementAll AS $recordpro)
    <tr>
        <?php
        $totalp += $recordpro->total;
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$recordpro->procurement_number}}</td>
        <td class="center">{{$recordpro->item}}</td>
        <td class="center">{{$recordpro->measure}}</td>
        <td class="center">{{$recordpro->quantity}}</td>
        <td class="center">{{$recordpro->cost}}</td>
        <td class="center">{{convertDate($recordpro->date)}}</td>
        <td class="center">{{ ($recordpro->total) }}</td>
    </tr>
    @endforeach
    <tr>
        <td colspan="7" class="center" style="font-weight: bold;">@lang('layout.Total')</td>
        <td  class="center">{{$totalp}} {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($expenseAll)
@if(count($expenseAll) > 0)
<h3>@lang('layout.ExpenseList')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Number')</th>
            <th class="center">@lang('layout.Vendor')</th>
            <th class="center">@lang('layout.Account') </th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Rate')</th>
            <th class="center">@lang('layout.User')</th>
            <th class="center">@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($expenseAll AS $record)
    <tr>
        <?php
        $totalp += ($record->amount / $record->rate);
        if (array_key_exists($record->currency, $currencies)) {
            $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
        } else {

            $currencies[$record->currency] = $record->amount;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->number}}</td>
        <td class="center">{{$record->vendor}}</td>
        <td class="center">{{$record->account}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
        <td class="center">{{$record->amount}}</td>
        <td class="center">{{$record->currency}}</td>
        <td class="center">{{$record->rate}}</td>
        <td class="center">{{$record->username}}</td>
        <td class="center">{{$record->description}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3" class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td class="center">
            <div class="center"> #</div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif




@if($returnExpense)
@if(count($returnExpense) > 0)
<h3>@lang('layout.ReturnExpense')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Record')</th>
            <th>@lang('layout.Number') </th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.Description') </th>
            <th>@lang('layout.ReferenceNumber') </th>
            <th>@lang('layout.Account') </th>
            <th>@lang('layout.Vendor') </th>
            <th>@lang('layout.ExpenseAccount') </th>
            <th>@lang('layout.Type') </th>
            <th>@lang('layout.Amount') </th> 
            <th>@lang('layout.Currency') </th> 
            <th>@lang('layout.Rate') </th> 
            <th>@lang('layout.Amount')   {{getHomeCurrency()[getCurrencyType()]}} </th> 
        </tr>                    
    </thead>
    <?php
    $count = 0;
    $totalp = 0; 
    $currencies = [];
    ?>
    @foreach($returnExpense AS $returnExpens)
    <tr>
        <?php
        $totalp += ($returnExpens->rate > 0)?($returnExpens->amount / $returnExpens->rate):0;
        if (array_key_exists($returnExpens->Currency, $currencies)) {
            $currencies[$returnExpens->Currency] = $currencies[$returnExpens->Currency] + $returnExpens->amount;
        } else {

            $currencies[$returnExpens->Currency] = $returnExpens->amount;
        }
        ?>
        {{-- <td class="center">{{++$count}}</td>
        <td class="center">{{convertDate($returnExpens->date)}}</td>
        <td class="center">{{$returnExpens->description}}</td>
        <td class="center">{{$returnExpens->account}}</td>
        <td class="center">{{$returnExpens->type}}</td>
        <td class="center">{{myRound($returnExpens->amount)}}</td>
        <td class="center">{{$returnExpens->Currency}}</td> --}} 
        <td class="center">{{++$count}}</td>
        <td class="center">{{$returnExpens->number}}</td>
        <td class="center">{{convertDate($returnExpens->date)}}</td>
        <td class="center">{{$returnExpens->description}}</td>
        <td class="center">{{$returnExpens->expense_ref}}</td>
        <td class="center">{{$returnExpens->bank}}</td>
        <td class="center">{{$returnExpens->member_name}}</td>
        <td class="center">{{$returnExpens->account}}</td>
        <td class="center">{{$returnExpens->type}}</td>
        <td class="center">{{myRound($returnExpens->amount)}}</td>
        <td class="center">{{$returnExpens->Currency}}</td>
        <td class="center">{{$returnExpens->rate}}</td>
        <td class="center">{{myRound($returnExpens->base_amount)}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3" class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td class="center">
            <div class="center"> #</div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $Currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($Currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif














@if($dailyExpense)
@if(count($dailyExpense) > 0)
<h3>@lang('layout.DailyExpense')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Number')</th>
            <th class="center">@lang('layout.BankAccount')</th>
            <th class="center">@lang('layout.ExpenseAccount') </th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Rate')</th>
            <th class="center">@lang('layout.User')</th>
            <th class="center">@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($dailyExpense AS $record)
    <tr>
        <?php
        $totalp += ($record->amount / $record->Rate);
        if (array_key_exists($record->currency, $currencies)) {
            $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
        } else {
            $currencies[$record->currency] = $record->amount;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->number}}</td>
        <td class="center">{{$record->Bank}}</td>
        <td class="center">{{$record->expense_account}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
        <td class="center">{{$record->amount}}</td>
        <td class="center">{{$record->currency}}</td>
        <td class="center">{{$record->Rate}}</td>
        <td class="center">{{$record->username}}</td>
        <td class="center">{{$record->description}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3" class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td class="center">
            <div class="center"> #</div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($paySalaryExpense) 
@if(count($paySalaryExpense) > 0)
<h3>@lang('layout.PayrollList')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div> #</div>
            </td>
            <th class="center">@lang('layout.Name')</th>
            <th class="center">@lang('layout.BasicSalary')</th>
            <th class="center">@lang('layout.Tax')</th>
            <th class="center">@lang('layout.WorkedDay')</th>
            <th class="center">@lang('layout.AbsentDays')</th>
            <th class="center">@lang('layout.NetPayable')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Account')</th>
            <th class="center">@lang('layout.ExpenseAccount')</th>
            <th class="center">@lang('layout.FromDate')</th>
            <th class="center">@lang('layout.ToDate')</th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($paySalaryExpense AS $record)
    <tr>
        <?php
        $totalp += (($record->Amount) / $record->rate);
        if (array_key_exists($record->Curreny, $currencies)) {
            $currencies[$record->Curreny] = $currencies[$record->Curreny] + ($record->Amount);
        } else {
            $currencies[$record->Curreny] = ($record->Amount);
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->Employee}}</td>
        <td class="center">{{$record->BasicSalary}}</td>
        <td class="center">{{$record->tax_amount}} {{$record->tax_currency}}</td>
        <td class="center">{{$record->Worked_Days}}</td>
        <td class="center">{{$record->absent_day}}</td>
        <td class="center">{{($record->Amount)}}</td>
        <td class="center">{{$record->Curreny}}</td>
        <td class="center">{{$record->account}}</td>
        <td class="center">{{$record->exAccount}}</td>
        <td class="center">{{convertDate($record->From_Date)}}</td>
        <td class="center">{{convertDate($record->To_Date)}}</td>
        <td class="center">{{convertDate($record->Date)}}</td>
        <td class="center">{{$record->description}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3" class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td class="center">
            <div class="center"> #</div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($contractPayrollExpense)
@if(count($contractPayrollExpense) > 0)
<h3>@lang('layout.ContractBasedPayroll')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div> #</div>
            </td>
            <th class="center">@lang('layout.Account')</th>
            <th class="center">@lang('layout.ExpenseAccount')</th>
            <th class="center">@lang('layout.Employee')</th>
            <th class="center">@lang('layout.Name')</th>
            <th class="center">@lang('layout.Type')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Rate')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($contractPayrollExpense AS $record)
    <tr>
        <?php
        $totalp += ($record->amounts / $record->rate);
        if (array_key_exists($record->currency, $currencies)) {
            $currencies[$record->currency] = $currencies[$record->currency] + $record->amounts;
        } else {
            $currencies[$record->currency] = $record->amounts;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->account}}</td>
        <td class="center">{{$record->exAccount}}</td>
        <td class="center">{{$record->member_name}}</td>
        <td class="center">{{$record->name}}</td>
        <td class="center">{{__('layout.' . $record->type)}}</td>
        <td class="center">{{$record->amounts}}</td>
        <td class="center">{{$record->currency}}</td>
        <td class="center">{{$record->rate}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3" class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td class="center">
            <div class="center"> #</div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($miant_expense)
@if(count($miant_expense) > 0)
<h3>@lang('layout.Maintenance')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div> #</div>
            </td>
            <th class="center">@lang('layout.Description')</th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Rate')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($miant_expense AS $record)
    <tr>
        <?php
        $totalp += ($record->amount / (($record->rate>0)?$record->rate:1));
        if (array_key_exists($record->unit, $currencies)) {
            $currencies[$record->unit] = $currencies[$record->unit] + $record->amount;
        } else {
            $currencies[$record->unit] = $record->amount;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->description}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
        <td class="center">{{$record->unit}}</td>
        <td class="center">{{$record->amount}}</td>
        <td class="center">{{$record->rate}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3"  class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td  class="center">
            <div class="center"> #</div>
        </td>
        <td  class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td  class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td  class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td  class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td  class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2"  class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td  class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($recevies) 
@if(count($recevies) > 0)
<h3>@lang('layout.ProjectRecevies')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Account')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Rate')</th>
            <th class="center">@lang('layout.Type')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Date')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $currencies = [];
    ?>
    @foreach($recevies AS $record)
    <tr>
        <?php
        $totalp += ($record->amount / $record->rate);
        if (array_key_exists($record->currency, $currencies)) {
            $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
        } else {
            $currencies[$record->currency] = $record->amount;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->account}}</td>
        <td class="center">{{$record->currency}}</td>
        <td class="center">{{$record->rate}}</td>
        <td class="center">{{$record->type}}</td>
        <td class="center">{{$record->amount}}</td>
        <td class="center">{{convertDate($record->date)}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3"  class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td  class="center">
            <div class="center"> #</div>
        </td>
        <td  class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td  class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalp)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

<?php
    $totalJournalEntry = 0;
?>
@if($journalEntryDetails)
@if(count($journalEntryDetails) > 0)
<h3>@lang('layout.JournalIncome')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div>#</div>
            </td>
            <th class="center">@lang('layout.Number')</th>
            <th class="center">@lang('layout.Member')</th>
            <th class="center">@lang('layout.Account')</th>
            <th class="center">@lang('layout.Currency')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Date')</th>
            <th class="center">@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalJournalE = 0;
    $currencies = [];
    ?>
    @foreach($journalEntryDetails AS $record)
    <tr>
        <?php
        $totalJournalEntry += ($record->amount);
        $totalJournalE += ($record->amount / $record->rate);
        if (array_key_exists($record->currency, $currencies)) {
            $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
        } else {

            $currencies[$record->currency] = $record->amount;
        }
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->number}}</td>
        <td class="center">{{$record->Member}}</td>
        <td class="center">{{$record->Account}}</td>
        <td class="center">{{$record->currency}}</td>
        <td class="center">{{$record->amount}}</td>
        <td class="center">{{ convertDate($record->date) }}</td>
        <td class="center">{{$record->Description}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3"  class="center">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td  class="center">
            <div class="center"> #</div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td class="center">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td class="center">
                <div class="center">{{++$count}}</div>
            </td>
            <td class="center">
                <div class="center">{{$key}}</div>
            </td>
            <td class="center">
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2" class="center">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td class="center">
            <div class="center">{{myRound($totalJournalE)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
<br>
<hr />
@endif
@endif

@if($seletedShareholder)
@if(count($seletedShareholder) > 0)
<h3>@lang('layout.Shareholder')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td class="center">
                <div> #</div>
            </td>
            <th class="center">@lang('layout.Shareholder')</th>
			<th class="center">@lang('layout.Percentage')</th>
            <th class="center">@lang('layout.Amount')</th>
            <th class="center">@lang('layout.Currency')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $total = ($totalearnedAmount)?($totalearnedAmount):0;
    ?>
    @foreach($seletedShareholder AS $record)
    <tr>
        <?php
        $amount = 0;
        $amount = (($total * $record->percentage) / 100);
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->name}}</td>
        <td class="center">{{$record->percentage}}</td>
        <td class="center">{{$amount}}</td>
        <td class="center">{{$project->currency}}</td>
    </tr>
    @endforeach
</table>
<br>
<hr />
@endif
@endif
<br>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th class="center">
                <i class="fa  " style="color:#3FABA4"></i> @lang('layout.Amount')
            </th>
            <th  class="center">
                <i class="fa "></i> @lang('layout.Rate')
            </th>
            @if($project->discount)
            <th class="center">
                <i class="fa fa-minus-square"></i> @lang('layout.Discount')
            </th>
            @endif
            <th class="center">
                <i class="fa fa-get-pocket" style="color: green"></i> @lang('layout.Receive')
            </th>
            <th class="center">
                <i class="fa fa-building-o" style="color: #F2784B"></i> @lang('layout.MaintainanceAmount')
            </th>
            <th  class="center">
                <i class="fa fa-minus-circle" style="color:#E87E04"></i> @lang('layout.RemainAmount')
            </th>
            <th class="center">
                <i class="fa fa-cart-plus" style="color: #F7CA18; font-size: 16px;"></i> @lang('layout.ExpensedAmount')
            </th>
            @if($totalJournalEntry)
            <th class="center">
                <i class="fa fa"></i>@lang('layout.JournalIncome')
            </th>
            @endif
            <th class="center">
                <i class="fa fa-briefcase" style="color:green;font-size: 15px;"></i> @lang('layout.NetProfit')
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="center"> @if($project->Amount){{myRound($project->Amount+$ExpenseNotFree)}} {{$project->currency}} @endif </td>
            <td class="center"> {{ $project->rate}} </td>
            @if($project->discount)
            <td class="center"> @if($project->discount){{myRound($project->discount)}} {{$project->currency}} @endif </td>
            @endif
            <td class="center">@if($totalRecevie){{myRound($totalRecevie)}} {{$project->currency}} @endif
            </td>
            <td class="center">@if($totalMaintain){{myRound($totalMaintain)}} {{$project->currency}} @endif
            </td>
            <td class="center">@if($totalPAmount){{myRound($totalPAmount)}} {{$project->currency}} @endif</td>
            <td class="center">@if($totalExpensedAmount){{myRound($totalExpensedAmount)}} {{$project->currency}} @endif</td>
            @if($totalJournalEntry)<td class="center">{{myRound($totalJournalEntry)}} {{$project->currency}} </td>@endif
            <td class="center">@if($totalearnedAmount){{myRound($totalearnedAmount)}} {{$project->currency}} @endif </td>
        </tr>
    </tbody>
</table>

@endsection