@extends('layouts.factor-master')
<?php 
    $reportTitle = __('layout.OwnersEquity');
?>
@section('content')
    <?php
    $report=customeReport('payments','index');
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.OwnersEquity')</h3>
    <table class="main-table">
    <tr>  
        <td>
            @lang('layout.Project'):  {{$info->name}}
        </td>
    </tr>
    </table>
    @if(count($data) > 0)
        <table class="main-table">
            <thead>
                <tr class="bg">
                    <th>@lang('layout.Record')</th>
                    <th>@lang('layout.Name') </th>
                    <th>@lang('layout.Account') </th>
                    <th>@lang('layout.Equity') </th>
                    <th>@lang('layout.Amount') </th> 
                    <th>@lang('layout.Currency') </th> 
                    <th>@lang('layout.Rate') </th> 
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.User') </th>
                    <th>@lang('layout.Total') {{getHomeCurrency()[getCurrencyType()]}} </th>

                </tr>
            </thead>
            <tbody>
                <?php
                    $count = 0;
                    $totalBase = 0;
                ?>
                @foreach($data AS $record) 
                    <?php 
                    if(systemConfig()[30] == 1){
                        $totalBase += $record->Amount / $record->static_rate * $record->Rate;
                    }else{
                        $totalBase += $record->Amount / $record->Rate;
                    }
                    ?>
                    <tr>
                        <td class="center">{{++$count}}</td>
                        <td class="center">{{$record->Name}}</td>
                        <td class="center">{{$record->Account}}</td>
                        <td class="center">{{$record->DrawingAccount}}</td>
                        <td class="center">{{$record->Amount}}</td>
                        <td class="center">{{$record->Currency}}</td>
                        <td class="center">{{$record->Rate}}</td>
                        <td class="center">{{convertDate($record->Date)}}</td>
                        <td class="center">{{$record->Description}}</td>
                        <td class="center">{{$record->user}}</td>
                        @if(systemConfig()[30] == 1)
                        <td class="center">{{$record->Amount / $record->static_rate * $record->Rate}}</td>
                        @else 
                        <td class="center">{{$record->Amount / $record->Rate}}</td>
                        @endif
                    </tr>
                    <tr class="bg">
                        <td colspan="10" class="center"> @lang('layout.Total') </td>
                        <td class="center"> {{$totalBase}} </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection