@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('layout.Project')</h3>
                <div >
                    <div class="btn-group">
                        @if(systemConfig()[5] != 0 )
                        @permission('project-create')
                        <a href="{{route('project.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        @endif
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @if(systemConfig()[5] != 0 )
                            @permission('project-create')
                            <li>
                                <a href="{{route('project.create')}}">@lang('menu.Project')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('maintenance-create')
                            <li>
                                <a href="{{route('maintenance.create')}}">@lang('menu.Maintenance')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('itemassembly-create')
                            <li>
                                <a href="{{route('buildItem.create')}}">@lang('menu.ProjectBuild')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('projectDelivery-create')
                            <li>
                                <a href="{{route('delivery.create')}}">@lang('layout.ProjectDelivery')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('projectDelivery-create')
                            <li>
                                <a href="{{route('delivery_service.create')}}">@lang('layout.ProjectDeliveryService')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('worktype-create')
                            <li>
                                <a href="{{route('projectCategory.create')}}">@lang('layout.ProjectCategory')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('worktype-list')
                            <li>
                                <a href="{{route('workType.create')}}"> @lang('layout.ProjectWorkType')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[5] != 0 )
                            @permission('projectprogress-create')
                            <li>
                                <a href="{{route('projectProgress.create')}}"> @lang('layout.ProjectProgress')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('CargoContract-create')
                            <li>
                                <a href="{{route('cargoContract.create')}}">@lang('menu.CargoContract')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('CargoLoading-create')
                            <li>
                                <a href="{{route('cargoLoading.create')}}">@lang('menu.TransferAndLoading')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('CargoDelivery-create')
                            <li>
                                <a href="{{route('cargoDelivery.create')}}">@lang('menu.Delivery')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('CargoItemExpense-create')
                            <li>
                                <a href="{{route('cargoItemExpense.create')}}">@lang('menu.ItemExpense')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('itemExpenseCategory-list')
                            <li>
                                <a href="{{route('itemExpenseCategory.create')}}">@lang('menu.ItemExpenseCategory')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('CargoWastage-create')
                            <li>
                                <a href="{{route('cargoWastage.create')}}"> @lang('layout.Wastage')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('CargoContract-create')
                            <li>
                                <a href="{{route('cargoContractOrder.create')}}">@lang('menu.CargoContractOrder')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicleLocation.create')}}">@lang('layout.LastLocation')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('PriceList-create')
                            <li>
                                <a href="{{route('priceList.create')}}">@lang('menu.PriceList')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('inventorySite-list')
                            <li>
                                <a href="{{route('cargoSite.create')}}">@lang('menu.InventorySite')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicleType.create')}}">@lang('menu.VehicleType')</a>
                            </li>
                            @endpermission
                            @endif
                            @if(systemConfig()[25] == 1)
                            @permission('vehicle-create')
                            <li>
                                <a href="{{route('vehicle.create')}}">@lang('menu.Vehicle')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @if(systemConfig()[5] != 0 )
                @permission('project-list')
                <a href="{{route('project.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Project')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-edit"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$project}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('maintenance-list')
                <a href="{{route('maintenance.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Maintenance')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-edit"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$project_expences}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('itemassembly-list')
                <a href="{{route('buildItem.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ProjectBuild')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-bold"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$item}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('projectDelivery-list')
                <a href="{{route('delivery.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProjectDelivery')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-bold"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$delivery}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('projectDelivery-list')
                <a href="{{route('delivery_service.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProjectDeliveryService')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #259ce0;" class="fa fa-bold"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$delivery_service}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('projectDelivery-list')
                <a href="{{route('delivery_refund.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Refund')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-mail-forward"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$deliveryRefund}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('worktype-list')
                <a href="{{route('projectCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProjectCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgb(193, 179, 22);" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$projectCategories}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('worktype-list')
                <a href="{{route('workType.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProjectWorkType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$workType}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[5] != 0 )
                @permission('worktype-list')
                <a href="{{route('projectprogress.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProjectProgress')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$projedt_Progress}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
            </div>
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('layout.CargoContract')</h3>
            </div>
            <div class="cards">
                @if(systemConfig()[25] == 1)
                @permission('CargoContract-list')
                <a href="{{route('cargoContract.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.CargoContract')</p></div>
                            </div>
                            
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$contract}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('CargoLoading-list')
                <a href="{{route('cargoLoading.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.TransferAndLoading')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$cargoLoading}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('CargoDelivery-list')
                <a href="{{route('cargoDelivery.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Delivery')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$cargoDelivery}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('CargoItemExpense-list')
                <a href="{{route('cargoItemExpense.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemExpense')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$itemExpense}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('itemExpenseCategory-list')
                <a href="{{route('itemExpenseCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemExpenseCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #259ce0;" class="fa fa-text-width"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$itemExpenseCategory}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('CargoWastage-list')
                <a href="{{route('cargoWastage.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Westage')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$cargoDelivery}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('CargoContract-list')
                <a href="{{route('cargoContractOrder.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.CargoContractOrder')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgb(193, 179, 22);" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$contracts}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('vehicle-list')
                <a href="{{route('vehicleLastLocation.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.LastLocation')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-truck"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('PriceList-list')
                <a href="{{route('priceList.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.PriceList')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($priceList) {{$priceList}} @else  @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('PriceList-list')
                <a href="{{route('priceListAmount.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.PriceListAmount')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-industry"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($priceListAmount){{$priceListAmount}} @else  @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('inventorySite-list')
                <a href="{{route('cargoSite.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InventorySite')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 193, 191, 1);" class="fa fa-building-o"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($cargoSite){{$cargoSite}} @else  @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('vehicle-list')
                <a href="{{route('vehicleType.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.VehicleType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(32, 57, 87, 1);" class="fa fa-car"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($vehicleType){{$vehicleType}} @else  @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[25] == 1)
                @permission('vehicle-list')
                <a href="{{route('vehicle.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Vehicle')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(77, 94, 137, 1)s;" class="fa fa-truck"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($vehicle){{$vehicle}} @else  @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush