@extends('layouts.app')
@section('style')
<!--     <style type="text/css">
        .modal-container {
            width: 30% !important;
        }

        .modal.in .modal-dialog {
            margin: 40px auto;
            width: 32%;
        }
    </style> -->
@stop
@section('content')
    @include('layouts.modal')
        <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'Project_report'"
                      @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['project-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-5">
                                                    <label class="control-label ">@lang('layout.SelectProject') </label>
                                                    <v-select class="vue-select2" v-model="selectedproject" label="name" @search="onProjectSearch" :options="projectList">
                                                    </v-select>
                                                    <input type="hidden" name="project_id" v-model.number="(!selectedproject)?null:selectedproject.id">
                                                </div>
                                                <div class="col-md-5">
                                                    <label class="control-label ">@lang('layout.ProjectProgress') </label>
                                                    <v-select class="vue-select2" v-model="selectedProjectProgress" label="name" :options="project_progress"> </v-select>
                                                    <input type="hidden" name="project_progress_id" v-model.number="(!selectedProjectProgress)?null:selectedProjectProgress.id">
                                                </div>
                                                <div class="col-md-2">
                                                    <label class=" control-label">@lang('layout.Volunteering')</label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="status" value="volunteering">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                          
                                                <div class="col-md-5">
                                                    <label class="control-label ">@lang('layout.WorkType') </label>
                                                    <v-select class="vue-select2" v-model="selectedWork_types" label="name" :options="work_types"> </v-select>
                                                    <input type="hidden" name="work_type_id" v-model.number="(!selectedWork_types)?null:selectedWork_types.id">
                                                </div>
                                                <div class="col-md-5">
                                                    <label class="control-label ">@lang('layout.Type') </label>
                                                    <v-select class="vue-select2" v-model="selectedProjectCategory" label="name" :options="projectCategory"> </v-select>
                                                    <input type="hidden" name="project_category_id" v-model.number="(!selectedProjectCategory)?null:selectedProjectCategory.id">
                                                </div>
                                                
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-8" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="project_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">
                                                        <div class="form-group">
                                                            <table class="table table-striped table-bordered table-advance table-hover">
                                                                            <tr>
                                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td style="text-align: center;">
                                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
            
            
                                                                                    <label class="switch">
                                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                        :checked="row.checkedColumn" >
                                                                                        <span class="slider round"></span>
                                                                                    </label>
                                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="2">2 %</option>
                                                                                        <option value="6">6 %</option>
                                                                                        <option value="10">10 %</option>
                                                                                        <option value="15">15 %</option>
                                                                                        <option value="20">20 %</option>
                                                                                        <option value="25">25 %</option>
                                                                                        <option value="30">30 %</option>
                                                                                        <option value="40">40 %</option>
                                                                                        <option value="50">50 %</option>
                                                                                        <option value="60">60 %</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                            </div>
                                                    
                                                        </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>

    <!-- app -->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="Project_report"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedproject" label="name"
                                      @search="onProjectSearch" :options="projectList">
                            </v-select>
                            <input type="hidden" name="project_id"
                                   v-model.number="(!selectedproject)?null:selectedproject.id">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off"
                                               name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off"
                                               name="to_date">

                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>

            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="Project_report"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedproject" label="name" @search="onProjectSearch" :options="projectList">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedproject)?null:selectedproject.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.ProjectProgress') </label>
                            <v-select class="vue-select2" v-model="selectedProjectProgress" label="name" :options="{!! json_encode($project_progress) !!}"> </v-select>
                            <input type="hidden" name="project_progress_id" v-model.number="(!selectedProjectProgress)?null:selectedProjectProgress.id">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" autocomplete="off"
                                           name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" autocomplete="off"
                                           name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>

            </div>
        </modal>
        {{Form::close()}}
    </div>

    <!-- app -->
    <!-- {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}} -->
    <div id="form_modal2" class="modal fade col-md-12" role="dialog" aria-hidden="true">

        <div class="modal-dialog">
            <div class="modal-content">

                <div class="row">
                    <br><br><br><br>
                    <div class="form-group">
                        <div class="col-md-10 col-md-offset-1">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" autocomplete="off"
                                           name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" autocomplete="off"
                                           name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-8 col-md-offset-3">
                            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline','id'=>'itemForm'])}}
                            <input type="hidden" name="type" value="completedProjectExcel">
                            <input type="hidden" name="from_date" id="excel_sdate">
                            <input type="hidden" name="to_date" id="excel_edate">
                            <button type="submit" class="btn btn-success " id="excel_send">
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                            </button>
                            {{Form::close()}}
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="completedProjectExcel">
                            <input type="hidden" name="from_date" id="pdf_sdate">
                            <input type="hidden" name="to_date" id="pdf_edate">
                            <button type="submit" class="btn btn-danger" id="pdf_send">
                                <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')
                            </button>
                            {{Form::close()}}

                        


                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12 text-right" style="padding:20px; padding-right:40px;">

                            <br>
                            <hr>
                            <br>
                            <button class="btn red btn-outline" data-dismiss="modal"
                                    aria-hidden="true">@lang("layout.Close")</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ProjectList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('project-list')
                <!-- div class="btn-group">
                    <button type="button" class="btn green dropdown-toggle" data-toggle="dropdown" aria-expanded="false"> @lang('layout.MoreOption')
                        <i class="fa fa-angle-down"></i>
                    </button>
                    <ul class="dropdown-menu pull-right" role="menu">
                         @permission('glassdetails-list') 
                        <li>
                            <a href="{{route('glassDetail.create')}}">
                                <i class="fa fa-square-o" style="color:#31d0de;"> </i> @lang('layout.GlassDetails')
                        </a>
                    </li>
                    @endpermission
                     @permission('itemassembly-list')
                    <li>
                        <a href="{{route('itemAssembly.index')}}">
                                <i class="fa fa-cart-arrow-down" style="color:#31d0de;"> </i> @lang('layout.AddItemToProject')
                        </a>
                    </li>
                    @endpermission
                    @permission('builditem-list')
                    <li>
                        <a href="{{route('buildItem.index')}}">
                                <i class="fa fa-building-o" style="color:#31d0de;"></i> @lang('layout.BuildItem')</a>
                        </li>
                        @endpermission
                        <li class="divider"> </li>
                        <li>   
                        </li>
                    </ul>  
                </div -->
                    @permission('project-export')
                   <!--  <button type="submit" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                    <button type="button" class="btn btn-success" id="print_pdf_all"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button> -->

                                     <span id="anchore-modal">
                                 <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                    <i class="fa fa-print"></i>
                                 </a>
                             </span>

                    @endpermission
                    @endpermission
                    @permission('project-create')
                    <a href="{{route('project.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission


                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="project">
                    <thead>
                        <tr>
                            <th>@lang('layout.Code')</th>
                            <th>@lang('layout.ProjectName')</th>
                            <th>@lang('layout.Customer')</th>
                            <th>@lang('layout.StartDate')</th>
                            <th>@lang('layout.EndDate')</th>
                            <th>@lang('layout.Percent')</th>
                            <th>@lang('layout.ProjectProgress')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Location')</th>
                            <th>@lang('layout.Price')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Color')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <div id="factor-obj">

    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->

    <iframe id="saleFrames" style="display: none;"></iframe>


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        var cust_rep = {!!customeReportNewData('project_index')!!};

        @if(Session('project_id'))
        ProjectFactorPrint("{{Session('project_id')}}")

        @endif

        function ProjectFactorPrint(id) {

            var a = document.createElement('a');
            a.href = "{{url('projectFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);


        }

        @if(Session('project'))
        ProjectGlassesPrint("{{Session('project')}}")

        @endif

        function ProjectGlassesPrint(id) {

            var a = document.createElement('a');
            a.href = "{{url('projectGlassPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

        }

        Vue.component("v-select", VueSelect.VueSelect);


        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#project').DataTable({
                ajax: '{{route("project.index")}}',
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'name', name: 'name'},
                    {data: 'member', name: 'members.name'},
                    {data: 'startDate', name: 'startDate'},
                    {data: 'endDate', name: 'endDate', searchable: false},
                    {data: 'percent', name: 'percent', orderable: false, searchable: false},
                    {data: 'progress', name: 'progress', orderable: false, searchable: false},
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    {data: 'location', name: 'projects.location'},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'currency', name: 'projects.currency'},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'color', name: 'color', orderable: false, searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });


        // register modal component
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });

        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],
            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            'user_type': 'yes',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedproject: null,
                selectedProjectProgress: null,
                projectList: [],
            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            'user_type': 'yes',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },

                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })

        new Vue({
            el: '#app3',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
                sdate: null,
                edate: null,
            },
            methods: {
                ok: function () {
                    this.showModal = !this.showModal;

                },
                pdf: function () {
                    alert(this.sdate);
                    alert(this.edate);
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    });


                }
            },
        })

        $(document).ready(function () {
            var to, from;
            to = $("#range-to-example2").persianDatepicker(modelDate());
            from = $("#range-from-example2").persianDatepicker(modelDate());
        });

        $(document).on('click', '#completedProject', function () {

            $('#form_modal2').modal('show');
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        });
        $("#excel_send").on('click', function () {
            $('#excel_sdate').val($("#range-from-example2").val());
            $('#excel_edate').val($("#range-to-example2").val());

        });

        $("#pdf_send").on('click', function () {
            $('#pdf_sdate').val($("#range-from-example2").val());
            $('#pdf_edate').val($("#range-to-example2").val());

        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        var project_progress = {!! json_encode($project_progress) !!};
        var work_types = {!! json_encode($work_types) !!};
        var projectCategory = {!! json_encode($projectCategory) !!};
        //Begin Export Modal

        var vm = new Vue({

            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                project_progress: project_progress,
                selectedProjectProgress: null,
                work_types: work_types,
                selectedWork_types: null,
                projectCategory: projectCategory,
                selectedProjectCategory: null,
                selectedproject: null,
                projectList: [],
                customReportData:
                [
                 
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                 {Name: '@lang("layout.ProjectName")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.StartDate")', column_name: 'start_date',checkedColumn:(cust_rep.start_date)?'checked':'',column_percentage:(cust_rep.start_date___percent)?cust_rep.start_date___percent:''},
                 {Name: '@lang("layout.EndDate")', column_name: 'end_date',checkedColumn:(cust_rep.end_date)?'checked':'',column_percentage:(cust_rep.end_date___percent)?cust_rep.end_date___percent:''},
                 {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
                 {Name: '@lang("layout.ProjectProgress")', column_name: 'progress',checkedColumn:(cust_rep.progress)?'checked':'',column_percentage:(cust_rep.progress___percent)?cust_rep.progress___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.ExpensedAmount")', column_name: 'expense_amount',checkedColumn:(cust_rep.expense_amount)?'checked':'',column_percentage:(cust_rep.expense_amount___percent)?cust_rep.expense_amount___percent:''},
                 {Name: '@lang("layout.Receive")', column_name: 'receive',checkedColumn:(cust_rep.receive)?'checked':'',column_percentage:(cust_rep.receive___percent)?cust_rep.receive___percent:''},
                 {Name: '@lang("layout.RemainAmount")', column_name: 'remain_amount',checkedColumn:(cust_rep.remain_amount)?'checked':'',column_percentage:(cust_rep.remain_amount___percent)?cust_rep.remain_amount___percent:''},
                 {Name: '@lang("layout.EarnedAmount")', column_name: 'earned_amount',checkedColumn:(cust_rep.earned_amount)?'checked':'',column_percentage:(cust_rep.earned_amount___percent)?cust_rep.earned_amount___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},

              





                  ],
                  cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                 onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            'user_type': 'yes',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });



        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

    </script>
@endpush
