@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
    <link href="{{url('/assets/bootstrap-colorpicker/css/colorpicker.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/assets/jquery-minicolors/jquery.minicolors.css')}}" rel="stylesheet" type="text/css" />

    <link href="{{url('/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.css')}}" rel="stylesheet" type="text/css" />
<style type="text/css">
     .v-select .selected-tag{
        height: -2px !important;
    }
</style>
@stop
    

@section('content')
@include('inventories.cmodal')

    <div class="row" id="app" v-cloak>
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateProject')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div> 
            </div>               
            <div class="portlet-body form" id="item-service">
                
                <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                
                 {!! Form::model($projects, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['project.update_money',$projects->id]]) !!}

                    <div class="form-body" id="app" v-cloak>
                        <div class="col-md-12">
                            <div class="row">    
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.ProjectName')</label>
                                    {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.ContractName'),'disabled'])}}
                                </div>
								                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.SelectCustomer')</label>
                                     <v-select class="vue-select2" v-model="selectedMember" label="name" :options="member" disabled>
                                    </v-select>
                                    <input type="hidden" name="customer_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.ProjectProgress')</label>
                                    <v-select class="vue-select2" v-model="selectedProgress" label="name"
                                    :options="{{$project_progress}}">
                                    </v-select>
                                    <input type="hidden" name="project_progress_id" v-model.number="(!selectedProgress)?null:selectedProgress.id">
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                      
                                      <textarea  name="description" class="form-control" rows="2">{{$projects->description}}</textarea>
                                    </div>
                                  </div> 
                                </div>
                            </div>
                            <div class="row">
								              <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.Price')</label>
                                        {{Form::number('project_price',null,['class' => 'form-control','placeholder' => __('layout.Price'), 'step'=>'any' ])}}
                                    </div>
                                <div class="col-md-3" style="margin-bottom:1px;">
                                     <label class="control-label">@lang('layout.Currency')</label> 
                                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div> 
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <div class="input-group">
                                        <input  v-model="selected_currency.exchange_rate" class="form-control"
                                                       type="number" min="0" step="any" >
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                     </div>
                                        <input type="hidden" name="currency_rate" :value="selected_currency.exchange_rate">
                                </div>
								<div class="col-md-3 ">
									<div class="form-group"> 
										<div class="col-md-12">
											<label class="control-label">@lang('layout.Discount')</label> 
											<div class="input-group" :class="{'has-error':discount<0 || discount>100 }">
											<input  v-model="discountFiled" class="form-control"
												   type="number" min="0"
												   max="100"> 
											<span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}} 
												<input type="hidden" name="discount_type" value="currency">
											</span>
											<span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
												<input type="hidden" name="discount_type" value="percent">
											</span>
											<input type="hidden" name="discountTotal" :value="discount">
											<input type="hidden" name="discount" :value="discountFiled">
										 </div>
										</div>
									</div> 
							   </div>
								
								
                            </div>
							
							
							
							<div class="row"> 
                                <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                                <a href="{{route('project.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a> 
                            </div>
							
                        </div>  
                    </div>
                       
                {{Form::close()}}
            </div> 
            </div>

        </div>
    </div>

     
@endsection

@push('scripts') 
<script src="{{url('/assets/bootstrap-colorpicker/js/bootstrap-colorpicker.js')}}" type="text/javascript"></script><script src="{{url('/assets/jquery-minicolors/jquery.minicolors.min.js')}}" type="text/javascript"></script> 

<script src="{{url('/assets/bootstrap-wysihtml5/wysihtml5-0.3.0.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.js')}}" type="text/javascript"></script>

<script src="{{url('/assets/scripts/components-color-pickers.min.js')}}" type="text/javascript"></script> 

<script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

  Vue.component('v-select', VueSelect.VueSelect);
    var Expense            = {!! json_encode($Expense) !!}
    var asset              = {!! json_encode($asset) !!}
    var selectedCustomer             = {!! $selectedCustomer!!}
    var Worktype           = {!! $work_types!!}
    var projectCategory    = {!! $projectCategory!!}
    var currency           = {!! $currency!!}  
    var serviceAll         = {!! $serviceList !!}; 
    var projectItems       = {!! $projectItems !!};
    var progresses         = {!! $project_progress !!};
    var projectGlasses     = {!! $projectGlasses !!};
    var selectedItem       = {!! $selected_item !!};
    var selectedItems      = {!! $selectedItem !!};
    var selected_services  = {!! $selected_services !!};
    var selectedCurrency   = {!! $selectedCurrency !!};
    var projects           = {!! $projects !!};
	var inventory_category = {!! $inventory_category !!};
	var assemblies         = {!! $assemblies !!};

  var v = new Vue({
    el: '#app',
    data: {

			Expense:Expense,
			asset:asset,
			assemblies:assemblies,
			inventory_category:inventory_category,
            selected_item:selectedItem,
            selectedItems:selectedItems,
            selected_service:selected_services,
                currency:currency,
                selected_currency:selectedCurrency, 
                selectedMember: selectedCustomer,
                selectedWorkType:null,
				selectedCategory:null,
                selectedProgress:null,
                exchanged_rate: {!!currency()->exchange_rate!!},
				
				selected_index:0,
				temp_items:[],
                listAccounts:[], 
                type: 'bank',
                account: {},
                code: 0,
                inventories: [],  
                productions: [],
                services:[],
				FormulaItems: [],
				
				items:[],
				formula_list:[],
				selected_formula:null,
	
                roundData:1,
                selected_income:null,
                expenseAccount:null,
                assetAccount:null,
                income:{!!$income!!},
                projects:projects,
                inventoryIndex:0,
                GlassIndex:0,
                serviceIndex:0,
                ProductionIndex:0,  
                serviceList: serviceAll,
                all_services: serviceAll,
                worktype: Worktype,
                projectCategory: projectCategory,
                customer:null,
                
                discountFiled: 0,
                discount_type:null,
                discountIsAmount:false,
                temp_production: [],
                num: [], 
                defaultValue: 0,
                amount:null,
                member: [], 
                projectDetails:{!!$projects!!},
                projectItems: projectItems, 
                project_progress: progresses,
                projectGlasses: projectGlasses,
    },
    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },
        discount()
        {
          if(this.discountIsAmount){

              if(this.subtotal>0 && this.discountFiled) {
                  return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
              }else {
                  return 0;
              }
              }else {

                  return this.discountFiled
              }
          },

          // calculate subtotal
            subtotal: function ()
           {
			   var sum = 0; 
                    for(var p=0;p<this.productions.length;p++)
                    {
                        if(this.productions[p].items && this.productions[p].items.price)
                        {
						console.log('ppppttt',this.productions[p]);
                            var qty      = this.productions[p]['items']['w_build_qty'];
                            var price    = this.productions[p]['items']['price'];
                            sum         += qty*price;
                        }
                    }
					
					for(var i=0;i<this.FormulaItems.length;i++)
                    {
                        if(this.FormulaItems[i].selected_formula && this.FormulaItems[i].selected_formula.build_qty)
                        {
							
                        // console.log('fdfsdfsd',this.FormulaItems[i]);
                            var qty      = this.FormulaItems[i].selected_formula.build_qty;
                            var price    = this.FormulaItems[i].selected_formula.cost * this.selected_currency['rate'];
                            sum         += qty*price;
                        }
                    }
					
					for(var i=0;i<this.inventories.length;i++)
                    {
                        if(this.inventories[i].item)
                        {
							
                        // console.log('fdfsdfsd',this.inventories[i]);
                            var qty      = this.inventories[i].item.quantity;
                            var price    = this.inventories[i].item.new_rate * this.selected_currency['rate'];
                            sum         += qty*price;
                        }
                    }
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item !=null)
                    {
                        // console.log('ffffff',this.services[i]);
                        var rate=this.services[i]['item']['rate'];
                        var new_rate=this.services[i]['item']['new_rate'];
                        var smeasure_unit=this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.services[i]['item']['measure_unit'];
                         var quantity=this.services[i]['item']['quantity'];
                        if(new_rate !=rate && quantity>0)
                        { 
                           sum +=new_rate*quantity*this.selected_currency.exchange_rate;
                        }
                        else
                        {
                           sum += quantity *((rate*smeasure_unit/measure_unit)*this.selected_currency.exchange_rate);
                        }
                       
                    }
                }
                return (sum / this.projects.rate);
			   
			   
          },
 

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 
                return isError;
              

            },
            // filter the banks according to selected currency
            
    },
    mounted:function(){

      // initialize the selected item
      for(var i=0;i<this.selectedItems.length;i++)
      {
        this.inventories.push({item:this.selectedItems[i]});
      }
      // initialize the selected item
      for(var i=0;i<this.selected_item.length;i++)
      {
        this.productions.push({items:this.selected_item[i]});
      }
      // initialize the selected item
	  if(this.assemblies){
			this.FormulaItems = [];
			this.FormulaItems = this.assemblies;
      for(var i=0;i<this.assemblies.length;i++)
      {
			this.items.push({item:this.assemblies[i].selected_item});
      }
	  }
			console.log('lplpl',this.FormulaItems);
      // for(var m=2;m>this.selected_item.length;m--)
      // {
        // this.productions.push({item:null});
      // }
      // end item
      if(this.income)
      {
        this.selected_income=this.income[0];
      }
      
      // begin service

      for(var r=0;r<this.selected_service.length;r++)
        {
             var flag=false;
             var tempService;
             for(var h=0;h<this.all_services.length;h++)
             {
                if(this.all_services[h].id==this.selected_service[r].item_id)
                {
                   flag=true;
                   tempService           = this.all_services[h];
                   tempService.quantity  = this.selected_service[r].quantity;
                   tempService.rate      = this.selected_service[r].price;
                   tempService.new_rate  = this.selected_service[r].price;
                }
             }
             if(flag)
             {
                this.services.push({item:tempService,items:this.all_services})
             }
        }
      for(var w=1;w>this.selected_service.length;w--)
      {
         this.services.push({item:null,items:this.all_services});
      }
      // end service
            
            var n = 0;
            for(n = 0; n<this.worktype.length; n++){
                if(this.worktype[n].id == {{$projects->work_type}}){
                    this.selectedWorkType = this.worktype[n];
                }  
            }
            var t = 0;
            for(t = 0; t<this.projectCategory.length; t++){
                if(this.projectCategory[t].id == {{$projects->project_category_id}}){
                    this.selectedCategory = this.projectCategory[t];
                }  
            }

            var p = 0;
            for(p = 0; p<this.project_progress.length; p++){
                if(this.project_progress[p].id == {{ $projects->project_progress_id }}){
                    this.selectedProgress = this.project_progress[p];
                }
            }
			
            var ia = 0;
            for(ia = 0; ia<this.income.length; ia++){
                if(this.income[ia].id == {{ $projects->income_account_id }}){
                    this.selected_income = this.income[ia];
                }
            }
            var ea = 0; 
            for(ea = 0; ea<this.Expense.length; ea++){
                if(this.Expense[ea].id == {{ $projects->expense_account_id }}){
                    this.expenseAccount = this.Expense[ea];
                }
            }
            var aa = 0; 
            for(aa = 0; aa<this.asset.length; aa++){
                if(this.asset[aa].id == {{ $projects->asset_account_id }}){
                    this.assetAccount = this.asset[aa];
                }
            }
            
            
            if(this.projects)
            {
                if(this.projects.discount>0)
                {
                    this.discountFiled=this.projects.discount; 
                }
                else
                    this.discountFiled=0; 
                if(this.projects.discount_type)
                {
                    if(this.projects.discount_type=='percent')
                    {
                      if(this.projects.project_price){
                          this.discountFiled    = (parseFloat(this.discountFiled) * 100) / (this.projects.project_price);
                      } else if(this.subtotal){
                          this.discountFiled    = (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                      }
                       this.discountIsAmount =false;
                    }
                    else
                    {
                       this.discountIsAmount=true;
                    }
                } 
            }
    },
    methods:
    { 

        addItems(type)
       { 
            if(type !=null)
            {
                if(type=="production")
                { 
                  this.temp_production=[];
                  this.productions.push({item:null}); 
                }
                if(type=="service")
                {
                  this.services.push({item:null});
                }
            }
                 
          },
		  
		  
		  onItemSearchProject:_.debounce((search,loading) =>{
          loading(true);
          let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';

          axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemSearchSale',
              keyword:search,
              inventory_category_id:inventory_category_id,
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error){
            console.log(error);
          })
        },getDebounceTime()),
     


		//ajax call to get items
        setIndex(e)
        {
           //v.temp_items=[];
          this.selected_index=e;
          console.log('uuu',this.selected_index);
        },
		itemCategoryChange(index){
           v.setIndex(index);
           let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';
           
           axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemSearchSale',
              inventory_category_id: inventory_category_id
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
          })
          .catch(function(error){
            console.log(error);
          });

        },
		
		//ajax call to get items
           onItemSearch:_.debounce((search,loading)=>{
               //v.formula_list=[];
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblyList',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 v.items=[];
                 if(response.data.length>0)
                 {
                    v.items=response.data;
                    console.log('sssss',v.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
           // end item search	 
		  
		  getItemFormula(index)
            {
				//console.log('ggg',this.FormulaItems);
            //item
                if(this.FormulaItems[index].selected_item && this.FormulaItems[index].selected_item !=null)
                {
                     this.formulaSearch(this.FormulaItems[index].selected_item.item_id,this,index);
                }
            },
		  
		  //ajax call to get formula
           formulaSearch(item_id,vm,index)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                } 
               })
               .then(function (response)
               {
                 vm.FormulaItems[index].formula_list=[];
                 if(response.data.length>0)
                 {
                    vm.FormulaItems[index].formula_list=response.data;
					vm.addNew('FormulaItems',0)
					// console.log('formula',response.data);
					console.log('yyyyy',vm.FormulaItems[index]);
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
		  
        // Check selected Currency 
        checkSelected(){
            var allCarrencies = {!! json_encode(getCurrencies()) !!};
            for(var x in allCarrencies){
                for(z in allCarrencies[x]){
                    if(allCarrencies[x][z] == "{!! $projects->currency !!}"){
                        this.selectedCurrency = allCarrencies[x]; 
                    } 
                }
            } 
        },
        setData:function(){
        },
        setValuesAmount(index){ 
            if(this.inventories[index].item){
               this.inventories[index].item.rate = this.$refs.in[index].value/this.exchanged_rate; console.log('in refs',this.inventories[index].item.rate);
            }
        },
        setValuesAmountS(index){

            // console.log('amountes',this.$refs.ins[index].value);
            if(this.services[index].item){
                this.services[index].item.rate = this.$refs.ins[index].value/this.exchanged_rate; 
                console.log('in refs service',this.services[index].item.rate);
            }
        },
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       
           // calculate item price based on measure change
       measureChangeservice(index)
       {
    
           if(this.services[index].item !=null){
            var item=this.services[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.rate);
            result=Number.parseFloat(temp).toFixed(precision());

            this.services[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
           if(this.selected_customer)
           {
            // get member contract
             this.contractSearch(this.selected_customer.id,this);
           }
       },
       // set new price
       setNewRate(type=null,index)
       {
          
          if(type=='service')
          {
              if(this.services[index].item)
              {
                
                 this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.exchange_rate;
              }
          }
          

       },
     
       //ajax call to get items
   //ajax call to get items
    // onItemSearch:_.debounce((search,loading)=>{
       // loading(true);
       // axios.get("{{route('callMethod.search')}}",{
        // params:{
          // method_name:'productionItem',
          // keyword:search,
        // }
       // })
       // .then(function (response)
       // {
         // v.temp_production=[];
         // if(response.data.length>0)
         // {
            // v.temp_production=response.data;
         // }
         // loading(false);
       // })
       // .catch(function (error)
       // {
          // console.log(error);
       // });
       // },getDebounceTime()),

        contractSearch(id,vm)
       {
           vm.contract=[];
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'member_contract',
              member_id:id
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {
                vm.contract=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
       // end contract search

       // generic function for adding item to list
      
        // in here you can check and decide to allow duplicate service or not
       checkExistingService(index=null,name='')
        {      
              var service_temp=this.all_services.slice();
              var service_temp1=[];
              for(var i=0;i<this.services.length;i++)
              {
                  if(this.services[i].item !=null)
                  {
                      var fined=service_temp.findIndex((item)=> item.name == this.services[i].item.name);
                      if(fined !=-1)
                      {
                        var o=service_temp.splice(service_temp.findIndex((item)=>item.name == this.services[i].item.name),1);
                      }
                  }
              }
              this.services[index].items = service_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 
       },
	   
	   
	   
	   // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='production')
             {
                if(this.productions[index+1]==undefined)
                {
                  this.temp_production=[];
                  this.productions.push({item:null,items:[]});
                }
             }
             if(type=='FormulaItems')
             {
                if(this.FormulaItems[index+1]==undefined)
                {
                  this.items=[];
                  this.FormulaItems.push({item:null});
                }
             }
            if(type=='service')
             {
                if(this.services[index+1]==undefined)
                {
                  this.checkExistingService(index,'');
                  this.services.push({
                    items: this.all_services,
                    item: null,
                });
                }
             }
			 if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null,item_category:null});
                }
             }
             
          }
          
       },
	   
        // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         { 
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
             if(type=='FormulaItems')
             {
                this.FormulaItems.splice(index, 1);
             }
             if(type=='production')
             {
                this.productions.splice(index, 1);
             }
              if(type=='service')
             {
                this.services.splice(index, 1);
             }
               
         }
          
       },
	   

       // submit the form
       
    },
    created:function()
    {
          
    }

  });

</script>
 
@endpush