@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">
    <link href="{{url('/assets/bootstrap-colorpicker/css/colorpicker.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/assets/jquery-minicolors/jquery.minicolors.css')}}" rel="stylesheet" type="text/css" />

    <link href="{{url('/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.css')}}" rel="stylesheet" type="text/css" />
<style type="text/css">
     .v-select .selected-tag{
        height: -2px !important;
    }
</style>
@stop
    

@section('content')
@include('inventories.cmodal')

    <div class="row" id="app" v-cloak>
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateProject')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div> 
            </div> 
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item active">
                    <a class="nav-link active" data-toggle="tab" href="#home">@lang('layout.Project')</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-toggle="tab" href="#home2">@lang('layout.ProjectDetails')</a>
                </li>
            </ul>                
            <div class="portlet-body form" id="item-service">
                
                {!! Form::model($projects, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['project.update',$projects->id]]) !!}
 
                <div class="tab-content">
                    <div class="tab-pane active" id="home">
                        <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                
                 {!! Form::model($projects, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['project.update',$projects->id]]) !!}

                    <div class="form-body" id="app" v-cloak>
                        <div class="col-md-6">
                            <div class="row">    
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.ProjectName')</label>
                                    {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.ContractName')])}}
                                </div>
								<div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Price')</label>
                                        {{Form::number('project_price',null,['class' => 'form-control','placeholder' => __('layout.Price'), 'step'=>'any' ])}}
                                    </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="margin-bottom:1px;">
                                     <label class="control-label">@lang('layout.Currency')</label> 
                                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div> 
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <div class="input-group">
                                        <input  v-model="selected_currency.exchange_rate" class="form-control"
                                                       type="number" min="0" step="any" >
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                     </div>
                                        <input type="hidden" name="currency_rate" :value="selected_currency.exchange_rate">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Location')</label>
                                     <input type="text" name="location" class="form-control" value="{{$projects->location}}" placeholder="@lang('layout.Location')">
                                </div>
                                <div class="col-md-6" style="margin:0px;">
                                    <label class="control-label">@lang('layout.Province')</label>
                                     <input value="{{$projects->province}}" type="text" name="province" class="form-control" placeholder="@lang('layout.Province')">
                                      
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12" style="padding: 0px;">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.StartDate')</label>
                                        <input type="text" id="getdate" class="form-control date" autocomplete="off" name="start_date" value="{{$projects->start_date}}">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.EndDate')</label>
                                        <input type="text" id="dueDate" class="form-control date" autocomplete="off" name="end_date" value="{{$projects->end_date}}">
                                    </div> 
                                </div> 
                            </div>
                            <div class="row">
                                <div class=""> 
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.WorkType')</label>
                                        <v-select class="vue-select2" v-model="selectedWorkType" label="name"
                                                    :options="{{$work_types}}">
                                        </v-select>
                                        <input type="hidden" name="work_type_id" v-model.number="(!selectedWorkType)?null:selectedWorkType.id">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.MaintainanceDuration')</label>
                                        <input type="number" class="form-control" name="maintainance_duration" placeholder ="@lang('layout.MaintainanceDuration')" value="{{$projects->maintainance_duration}}">
                                    </div> 
                                </div> 
                            </div> 
                        </div>  
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.ProjectCode')</label>
                                    {{Form::text('number',null,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-6">
                                    <label class=" control-label">@lang('layout.Volunteering')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="status" v-model="status" value="volunteering">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.SelectCustomer')</label>
                                    <v-select label="name" @search="MemberSearch" :options="customer" v-model="selectedMember"></v-select>
                                    <input type="hidden" name="customer_id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selectedMember?null:selectedMember.id" required>
                                    <span class="required">@{{ errors.first('customer_id') }}</span>
                                </div>
                            </div>
                            <div class="row">
                                <div class="">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.District')</label>
                                        <input type="text" name="district" class="form-control" value="{{$projects->district}}" placeholder="@lang('layout.District')">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Color')</label>
                                        <input type="text" id="saturation-demo" class="form-control demo" data-control="saturation" name="color" value="{{$projects->color}}"> 
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.ProjectProgress')</label>
                                    <v-select class="vue-select2" v-model="selectedProgress" label="name"
                                    :options="{{$project_progress}}">
                                    </v-select>
                                    <input type="hidden" name="project_progress_id" v-model.number="(!selectedProgress)?null:selectedProgress.id">
                                </div>
								<div class="col-md-6">
                                        <label class="control-label">@lang('layout.Type')</label>
                                        <v-select class="vue-select2" v-model="selectedCategory" label="name"
                                                    :options="{{$projectCategory}}">
                                        </v-select>
                                        <input type="hidden" name="project_category_id" v-model.number="(!selectedCategory)?null:selectedCategory.id">
                                </div>
                            </div>
                                
                        </div> 
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Memo')</label>
                                        <textarea name="memo" class="form-control" rows="2">{{$projects->memo}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="" v-show="status">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Agent')</label>
                                        <v-select class="vue-select2" v-model="selectedEmployee" label="name" @search="EmployeeSearch" :options="employee" placeholder="@lang('layout.Agent')" >
                                        </v-select>
                                        <input type="hidden" name="employee_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                                    </div>

                                    <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.GranteeAmount')</label>
                                        {{Form::number('grantee_amount',null,['class' => 'form-control','placeholder' => __('layout.GranteeAmount'), 'step'=>'any' ])}}
                                    </div>

                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.VolunteeringDate')</label>
                                        <input type="text" class="form-control date" name="volunteering_date" value="{{$projects->volunteering_date}}" autocomplete="off">
                                    </div>

                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Times') @lang('layout.Volunteeres')</label>
                                        <input type="text" name="volunteeres" value="{{$projects->volunteeres}}" class="form-control">
                                    </div>
                                </div>
                                
                                <!-- begin volunteeres -->
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <caption>
                                        @lang('layout.Volunteeres') 
                                    </caption>
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Name')</th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Discount')</th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Type')</th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(record,index) in volunteeres">
                                        <td>@{{index+1}}</td>
                                        <td>
                                            <input class="form-control" type="text" name="vol_name[]" @click="addNew('volunteeres',index)" @input="addNew('volunteeres',index)"
                                                v-model="record.name" placeholder="@lang('layout.Name')">
                                        </td>
                                        <td>
                                            <input class="form-control" type="number" name="vol_price[]"
                                                v-model.number="record.price" placeholder="@lang('layout.Price')">
                                        </td>
                                        <td>
                                            <input class="form-control" type="number" name="vol_discount[]"
                                                v-model.number="record.discount" placeholder="@lang('layout.Discount')">
                                        </td>
                                        <td>
                                            <select name="vol_type[]" v-model="record.type" class="form-control">
                                                <option value="Simple">@lang('layout.Simple')</option>
                                                <option value="Assessment">@lang('layout.Assessment')</option>
                                                <option value="Offer">@lang('layout.Offer')</option>
                                            </select>
                                        </td>
                                        <td>
                                            <input class="form-control" type="text" name="vol_description[]"
                                                v-model="record.description" placeholder="@lang('layout.Description')">
                                        </td>

                                        <td>
                                            <span v-if="volunteeres.length > 1" v-on:click="deleteItem('volunteeres',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                                <!-- end volunteeres -->
                            </div>

                        <!-- begin shareholder -->
                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Shareholder')</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                                    <th></th>

                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(record,index) in shareholderData">
                                    <td>@{{index+1}}</td>
                                    <td class="highlight">
                                        <v-select label="name" v-model="record.selected" :options="(record.shareholder_list)"
                                                @click.native="addNew('shareholder',index)"
                                                placeholder="@lang('layout.Select')">

                                        </v-select>
                                        <input type="hidden" name="shareholder_id[]"
                                            :value="(record.selected==null)?null:record.selected.id">
                                    </td>

                                    <td>
                                        <input class="form-control" type="number" name="percentage[]"
                                            v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                                    </td>

                                    <td>
                                        <span v-on:click="deleteItem('shareholder',index)"><i
                                                    class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <!-- end shareholder -->

                    </div>
                        
                    </div>
                    </div> 
                    <div class="tab-pane fade" id="home2">
                        <div>
                            <div class="row">
							<div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                          <div class="form-group">
                                              <div class="col-md-12">
                                                <label class="control-label">@lang('layout.IncomeAccount')</label>
                                                     <v-select  label="name"  :options="income" v-model="selected_income"></v-select>
                                                      <input type="hidden" name="income_account" :value="(!selected_income)?null:selected_income.id">
                                                    
                                              </div>
                                          </div> 
                                        </div>
										<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                          <div class="form-group">
										  <div class="col-md-12">
											   <label class="control-label">@lang('layout.UnitCostAccount')</label>
											   <v-select placeholder="@lang('layout.UnitCostAccount')" tabindex = "5" label="name"  :options="{{ json_encode($Expense) }}" v-model="expenseAccount" ></v-select>
											   <input type="hidden" name="expense_account" v-validate="'required'" data-vv-as="@lang('layout.UnitCostAccount')" :value="(expenseAccount)?expenseAccount.id:null">
												<span class="required">@{{ errors.first('expense_account') }}</span>
										   </div>
										   </div>
										  
                                        </div>
										<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
										   <div class="form-group">
										   <div class="col-md-12">
											   <label class="control-label">@lang('layout.AssetAccount')</label>
											   <v-select placeholder="@lang('layout.SelectAssetAccount')" tabindex = "6" label="name"  :options="{{ json_encode($asset) }}" v-model="assetAccount" ></v-select>
											   <input type="hidden" name="asset_account" v-validate="'required'" data-vv-as="@lang('layout.AssetAccount')" :value="(assetAccount)?assetAccount.id:null">
												<span class="required">@{{ errors.first('asset_account') }}</span>
										   </div>
										   </div>
									   </div>
										
										
										
										
                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                              <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Description')</label>
                    
                                                    <textarea  name="description" class="form-control" rows="1">{{$projects->description}}</textarea>
                                              </div>
                                            </div> 
                                       </div>
                                       <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                            <div class="form-group"> 
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Discount')</label> 
                                                    <div class="input-group" :class="{'has-error':discount<0 || discount>100 }">
                                                    <input  v-model="discountFiled" class="form-control"
                                                           type="number" min="0"
                                                           max="100"> 
                                                    <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}} 
                                                        <input type="hidden" name="discount_type" value="currency">
                                                    </span>
                                                    <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                                                        <input type="hidden" name="discount_type" value="percent">
                                                    </span>
                                                    <input type="hidden" name="discountTotal" :value="discount">
                                                    <input type="hidden" name="discount" :value="discountFiled">
                                                 </div>
                                                </div>
                                            </div> 
                                       </div>
                                    </div>
                                </div>
							
							
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="dashboard-stat2 ">
                                        <table class="dashboard-tabel" width="100%">
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.Total') :</small>
                                                </td>
                                                <td class="text-right"><span data-counter="counterup"
                                                    data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))).toFixed(2)}}</span>
                                                    <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(2) }}%)</small>
                                                </td>
                                                <td class="text-right">
                                                           <span class="text-right" data-counter="counterup"
                                                    data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>
                                                    <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <small>Sub-Total:</small>
                                                </td>
                                                <td class="text-right">
                                                            <span class="text-right" data-counter="counterup"
                                                                  data-value="7800">@{{ subtotal.toFixed(2)}}</span>
                                                    <small class="font-green-sharp">@{{selectedCurrency.symbol}}  </small>
                                                    <input type="hidden" :value="subtotal" name="totalAmountss">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div v-if="inventories.length >0 " class="row">
                                <li class="list-group-item bg-green bg-font-green"> @lang('layout.StuffDetails') </li>
                                    <div class="table-responsive333">
                                   <table id="table_content" class="table table-bordered table-advance table-hover">
                                        <thead>
                                        <tr>
											<th>#</th>
											<th style="min-width: 100px">@lang('layout.Category') </th>
											<th style="min-width: 100px">@lang('layout.ItemName') </th>
											<th style="min-width: 100px">@lang('layout.SiteName') </th>
											<th style="min-width: 100px">@lang('layout.Quantity') </th>
											<th style="min-width: 100px">@lang('layout.OnHand') </th>
											<th style="min-width: 100px">@lang('layout.Measure') </th>
											<th style="min-width: 100px">@lang('layout.SalePrice') </th>
											<th style="min-width: 100px">@lang('layout.Total') </th>
											<th></th>
										</tr>
                                        </thead>
                                        <tbody>
										<tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td>
                                                          <v-select label="name" v-model="item.item_category" :options="inventory_category" @click.native="addNew('inventory',index)"  @input="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name" @Click.native="setIndex(index)" v-model="item.item" :options="temp_items" @search="onItemSearchProject"></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.item_id">
                            															<span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                            														</td>
                                                         <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                               <option value="null">@lang('layout.Select')</option>
                                                               <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>
                                                           
                                                            <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td>
															<input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
															<span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
														</td>

                                                        <td>
                                                           @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                          <td class="highlight">
                                                            <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option> 
                                                                </span>
                                                                
                                                               
                                                            </select>
                                                           
                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                          <div class="input-group">
                                                            <input type="number" name="inventory_price[]"  placeholder="@lang('layout.Price')"   :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="item_rate" @input="setNewRate('inventory',index)" class="form-control">
                                                            <span class="input-group-addon">
                                                              @{{selected_currency.symbol}}
                                                            </span>
                                                          </div>
                                                           
                                                        </td>
                                                        <td>
                                                               <div class="input-group">
                                                                <input type="number" class="form-control inner_input" :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate,null,null,null,null,null,selected_currency.static_rate)" placeholder="@lang('layout.Total')" disabled>
                                                              <span class="input-group-addon" >
                                                                    <b>@{{selected_currency.symbol}}</b>
                                                              </span>
                                                               </div>
                                                        </td>
                                                        <td>
                                                             <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                             <!--span  @click="addNew('inventory',index)"><i class="paddint-both glyphicon glyphicon-plus"></i></span -->
                                                        </td>
                                                    </tr>
										
                                        </tbody>
                                    </table>
                                </div>
                            </div> 
							<div v-if="FormulaItems.length >0 " class="row">
								<li class="list-group-item bg-green bg-font-green"> @lang('layout.Formula') </li>
                                    <div class="table-responsive333">
                                        <table id="table_content" class="table table-bordered table-advance table-hover">
                                            <thead>
                                            <tr> 
                                                <th class="text-center" style="min-width: 6px;">#</th>
                                                <th class="text-center" style="min-width: 100px;">@lang('layout.ItemName')</th>
                                                <th class="text-center" style="min-width: 60px;"> @lang('layout.FormulaName')</th>
                                                <th class="text-center" style="min-width: 50px;"> @lang('layout.QuantityToBuild')</th>
                                                <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                                <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>
                                                <th style="min-width: 20px;"></th>
                                            </tr>
                                            </thead>
                                            <tbody>
											
                                            <tr v-for="(Item,Index) in FormulaItems" class="even">
											
                                                <td class=""> @{{Index+1}} </span>
                                                    </td>
                                                <td class="highlight"> 
													<v-select label="name" v-model="Item.selected_item" :options="items" @input="getItemFormula(Index)" @search="onItemSearch" @click.native="addNew('FormulaItems',Index)"></v-select>
													<input type="hidden" name="formula_item[]" :value="(!Item.selected_item)?null:Item.selected_item.item_id">

												</td> 
                                                <td>
                                                    <select class="form-control" v-model="Item.selected_formula">
														<option>@lang('layout.Select')</option>
														<option v-for="formula in Item.formula_list" :value="formula">@{{formula.code+'-'+formula.name}}</option>
													</select>
													<input type="hidden" name="formula_id[]" :value="(!Item.selected_formula)?null:Item.selected_formula.id">
													<input type="hidden" name="formula_measure_id[]" :value="(!Item.selected_formula)?null:Item.selected_formula.um_id">
												
												</td> 
                                                <td>
													<input type="number" name="formula_qty[]" placeholder="@lang('layout.EnterQuantityToBuild')" v-model.number="(!Item.selected_formula)?null:Item.selected_formula.build_qty" class="form-control">
                                  
												</td>
                                                <td>
                                                    <div class="input-group input_style"> 
                                                        @if(systemConfig()[30] == 1)
                                                        <input type="number" name="formula_cost[]" :value="(!Item.selected_formula)?null:(Item.selected_formula.cost * ((selected_currency)?selected_currency.static_rate / selected_currency.rate:1))" class="form-control" placeholder="@lang('layout.Price')" readonly />
                                                        <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                        @else 
                                                        <input type="number" name="formula_cost[]" :value="(!Item.selected_formula)?null:(Item.selected_formula.cost * ((selected_currency)?selected_currency.rate:1))" class="form-control" placeholder="@lang('layout.Price')" readonly />
                                                        <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                        @endif 
                                                    </span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="input-group input_style">
                                                        @if(systemConfig()[30] == 1)
                                                        <input type="number" class="form-control inner_input" :value="(((!Item.selected_formula)?null:Item.selected_formula.cost) * ((selected_currency)?selected_currency.static_rate / selected_currency.rate:1)) * ((!Item.selected_formula)?null:Item.selected_formula.build_qty)"  placeholder="@lang('layout.Total')" 
                                                         disabled>
                                                         @else 
                                                         <input type="number" class="form-control inner_input" :value="(((!Item.selected_formula)?null:Item.selected_formula.cost) * ((selected_currency)?selected_currency.rate:1)) * ((!Item.selected_formula)?null:Item.selected_formula.build_qty)"  placeholder="@lang('layout.Total')" 
                                                          disabled>
                                                        @endif
                                                        <span class="input-group-addon">
                                                            <b>@{{selected_currency.symbol}}</b>
                                                        </span>
                                                    </div> 
                                                </td>

                                                <td>
                                                   <span  v-on:click="deleteItem('FormulaItems',Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                </td>
                                            </tr> 
                                            </tbody>
                                        </table>
                                    </div>
                                </div> 
							
							<div v-if="productions.length >0 " class="row">
								<li class="list-group-item bg-green bg-font-green"> @lang('menu.BuildWithoutFormula') </li>
                                    <div class="table-responsive333">
                                        <table id="table_content" class="table table-bordered table-advance table-hover">
                                            <thead>
                                            <tr> 
                                                <th class="text-center" style="min-width: 6px;">#</th>
                                                <th class="text-center" style="min-width: 100px;">@lang('layout.ItemName')</th>
                                                <th class="text-center" style="min-width: 50px;"> @lang('layout.QuantityToBuild')</th>
                                                <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                                <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>
                                                <th style="min-width: 20px;"></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(production,productionIndex) in productions" class="even">
                                                <td class=""> @{{productionIndex+1}} </span>
                                                    </td>
                                                <td class="highlight"> 
													<input type="text" name="w_formula_ItemName[]" v-model.name="(!production.items)?null:production.items.name" ref="name" @input="setProduction(productionIndex)" class="form-control" @click="addNew('production',productionIndex)">
												</td>
                                                <td>
													<input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="w_formula_qty[]" ref="w_build_qty" @input="setProduction(productionIndex)" v-model.number="(!production.items)?null:production.items.w_build_qty" class="form-control">
                                  
												</td> 
                                                <td>
                                                    <div class="input-group input_style">
                                                        <input type="number" name="w_formula_price[]" class="form-control" placeholder="@lang('layout.Price')" ref="price" @input="setProduction(productionIndex)" v-model.number="(!production.items)?null:production.items.price">
                                                        <span class="input-group-addon">
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="input-group input_style">
                                                        <input type="" class="form-control inner_input"  placeholder="@lang('layout.Total')" :value="(!production.items)?0:production.items.w_build_qty * ((!production.items)?0:production.items.price)"
                                                         disabled>
                                                        <span class="input-group-addon">
                                                            <b>@{{selected_currency.symbol}}</b>
                                                        </span>
                                                    </div> 
                                                </td>
                                                <td>
                                                   <span  v-on:click="deleteItem('production',productionIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                </td>
                                            </tr> 
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
							
						
                            <div v-if="services.length >0 " class="row">
                                <div class="table-responsive333"> 
                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="min-width: 8px;"> # </th>
                                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                
                                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                <th></th>
                                          
                                            </tr>
                                        </thead>
                                        <tbody>
                                             <tr v-for="(service,index) in services">
                                                    <td>@{{index+1}}</td>
                                                    <td class="highlight">
                                                        <v-select label="name" v-model="service.item"  :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)"></v-select>
                                                        <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                    </td>
                                                
                                                    <td>
                                                      <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                    </td>
                                                    <td class="highlight">
                                                        <select  v-model="(!service.item)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(service.item ==null)?false:true">
                                                                <option  v-for="measure in (!service.item)?null:service.item.measure_list" :value="measure">
                                                                @{{measure.measure_name}}
                                                              </option> 
                                                            </span>    
                                                        </select>
                                                       
                                                        <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                          <input type="number" name="service_price[]"  placeholder="@lang('layout.Price')"   :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.exchange_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                                          <span class="input-group-addon">
                                                            @{{selected_currency.symbol}}
                                                          </span>
                                                        </div>
                                                      
                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                              <input type="number" class="form-control inner_input"   :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.exchange_rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" disabled>
                                                          <span class="input-group-addon" >
                                                              <b>@{{selected_currency.symbol}}</b>
                                                          </span>
                                                           </div>
                                                    </td>
                                                    <td>
                                                         <span  v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    </td>
                                                </tr>
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                            <div class="row">  
                                <button v-if="productions.length <= 0 " type="button" class="btn default" @click="addItems('production')">@lang('layout.AddProduction')
                                </button>
                                <button v-if="services.length <= 0 " type="button" class="btn default" @click="addItems('service')">@lang('layout.Addservice')
                                </button>
                                <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                                <a href="{{route('project.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a> 
                            </div>
                            
                        </div> 
                    </div>
                </div>
                {{Form::close()}}
            </div> 
            </div>

        </div>
    </div>

     
@endsection

@push('scripts') 
<script src="{{url('/assets/bootstrap-colorpicker/js/bootstrap-colorpicker.js')}}" type="text/javascript"></script><script src="{{url('/assets/jquery-minicolors/jquery.minicolors.min.js')}}" type="text/javascript"></script> 

<script src="{{url('/assets/bootstrap-wysihtml5/wysihtml5-0.3.0.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.js')}}" type="text/javascript"></script>

<script src="{{url('/assets/scripts/components-color-pickers.min.js')}}" type="text/javascript"></script> 

<script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

  Vue.component('v-select', VueSelect.VueSelect);
    var Expense            = {!! json_encode($Expense) !!}
    var asset              = {!! json_encode($asset) !!}
    var Worktype           = {!! $work_types!!}
    var projectCategory    = {!! $projectCategory!!}
    var currency           = {!! $currency!!}  
    var serviceAll         = {!! $serviceList !!}; 
    var projectItems       = {!! $projectItems !!};
    var progresses         = {!! $project_progress !!};
    var projectGlasses     = {!! $projectGlasses !!};
    var selectedItem       = {!! $selected_item !!};
    var selectedItems      = {!! $selectedItem !!};
    var selected_services  = {!! $selected_services !!};
    var selectedCurrency   = {!! $selectedCurrency !!};
    var projects           = {!! $projects !!};
	var inventory_category = {!! $inventory_category !!};
	var assemblies         = {!! $assemblies !!};
    var shareholder        = {!! $shareholder !!};
    var seletedShareholder = {!! $seletedShareholder !!};
    var seletedVolunteer = {!! $seletedVolunteer !!};

  var v = new Vue({
    el: '#app',
    data: {

			Expense:Expense,
			asset:asset,
			assemblies:assemblies,
			inventory_category:inventory_category,
            selected_item:selectedItem,
            selectedItems:selectedItems,
            selected_service:selected_services,
                currency:currency,
                selected_currency:selectedCurrency, 
                customer:[],
                selectedMember: {!! $selectedCustomer !!},
                selectedWorkType:null,
				selectedCategory:null,
                selectedProgress:null,
                exchanged_rate: {!!currency()->exchange_rate!!},
				
                shareholderData: [],
                shareholder: shareholder,
                seletedShareholder: seletedShareholder,
                
				selected_index:0,
				temp_items:[],
                listAccounts:[], 
                type: 'bank',
                account: {},
                code: 0,
                inventories: [],  
                productions: [],
                services:[],
				FormulaItems: [],
				
				items:[],
				formula_list:[],
				selected_formula:null,
	
                roundData:1,
                selected_income:null,
                expenseAccount:null,
                assetAccount:null,
                income:{!!$income!!},
                projects:projects,
                inventoryIndex:0,
                GlassIndex:0,
                serviceIndex:0,
                ProductionIndex:0,  
                serviceList: serviceAll,
                all_services: serviceAll,
                worktype: Worktype,
                projectCategory: projectCategory,
                
                employee: [],
                selectedEmployee: {!! $selectedEmployee !!},
                status: false,
                volunteeres: [],
                seletedVolunteer: seletedVolunteer,

                discountFiled: 0,
                discount_type:null,
                discountIsAmount:false,
                temp_production: [],
                num: [], 
                defaultValue: 0,
                amount:null,
                projectDetails:{!!$projects!!},
                projectItems: projectItems, 
                project_progress: progresses,
                projectGlasses: projectGlasses,
    },
    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },
        discount()
        {
          if(this.discountIsAmount){

              if(this.subtotal>0 && this.discountFiled) {
                  return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
              }else {
                  return 0;
              }
              }else {

                  return this.discountFiled
              }
          },

          // calculate subtotal
            subtotal: function ()
           {
			   var sum = 0; 
                    for(var p=0;p<this.productions.length;p++)
                    {
                        if(this.productions[p].items && this.productions[p].items)
                        {
                            if(this.productions[p].items.w_build_qty && this.productions[p].items.price)
                            {
                            console.log('ppppttt',this.productions[p]);
                                var qty      = this.productions[p]['items']['w_build_qty'];
                                var price    = this.productions[p]['items']['price'];
                                sum         += qty*price;
                            }
                        }
                    }
					
					for(var i=0;i<this.FormulaItems.length;i++)
                    {
                        if(this.FormulaItems[i].selected_formula && this.FormulaItems[i].selected_formula.build_qty)
                        {
							
                        // console.log('fdfsdfsd',this.FormulaItems[i]);
                            var qty      = this.FormulaItems[i].selected_formula.build_qty;

                            @if(systemConfig()[30] == 1)
                            var price    = this.FormulaItems[i].selected_formula.cost * this.selected_currency['static_rate'] / this.selected_currency['rate'];
                            @else 
                            var price    = this.FormulaItems[i].selected_formula.cost * this.selected_currency['rate'];
                            @endif

                            sum  += qty*price;
                        }
                    }
					
					for(var i=0;i<this.inventories.length;i++)
                    {
                        if(this.inventories[i].item)
                        {
							
                        // console.log('fdfsdfsd',this.inventories[i]);
                            var qty      = this.inventories[i].item.quantity;
                            @if(systemConfig()[30] == 1)
                            var price    = this.inventories[i].item.new_rate * this.selected_currency['static_rate'] / this.selected_currency['rate'];
                            @else 
                            var price    = this.inventories[i].item.new_rate * this.selected_currency['rate'];
                            @endif
                            sum         += qty*price;
                        }
                    }
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item !=null)
                    {
                        var rate=this.services[i]['item']['rate'];
                        var new_rate=this.services[i]['item']['new_rate'];
                        var smeasure_unit=this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.services[i]['item']['measure_unit'];
                         var quantity=this.services[i]['item']['quantity'];
                        // console.log('ffffff',this.selected_currency.exchange_rate, quantity, new_rate, rate);
                        if(new_rate !=rate && quantity>0)
                        { 
                            @if(systemConfig()[30] == 1)
                            sum +=new_rate*quantity * this.selected_currency.static_rate / this.selected_currency.exchange_rate;
                            @else 
                            sum +=new_rate*quantity*this.selected_currency.exchange_rate;
                            @endif
                        }
                        else
                        {  
                           @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.exchange_rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.exchange_rate);
                            @endif
                        }
                       
                    }
                }
                return (sum);
			   
			   
          },
 

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 
                return isError;
              

            },
            // filter the banks according to selected currency
            
    },
    mounted:function(){

      // initialize the selected item
      for(var i=0;i<this.selectedItems.length;i++)
      {
        this.inventories.push({item:this.selectedItems[i]});
      }
        this.inventories.push({item: null, item_category: null});
      
      // initialize the selected item
      for(var i=0;i<this.selected_item.length;i++)
      {
        this.productions.push({items:this.selected_item[i]});
      }
      this.productions.push({item: null, items: []});

      // initialize the selected Shareholder
      if(this.seletedShareholder.length > 0)
      {
        for(var i=0;i<this.seletedShareholder.length;i++)
        {
            this.shareholderData.push({shareholder_list: this.shareholder,selected:this.seletedShareholder[i],percentage: this.seletedShareholder[i].percentage});
        }
      }else{
            this.shareholderData.push({shareholder_list: this.shareholder,selected:null,percentage: 0});
      }

      // initialize the selected Shareholder
      if(this.seletedVolunteer.length > 0)
      {
        for(var i=0;i<this.seletedVolunteer.length;i++)
        {
            this.volunteeres.push({name: this.seletedVolunteer[i].name, price: this.seletedVolunteer[i].price, discount: this.seletedVolunteer[i].discount, description: this.seletedVolunteer[i].description, type: this.seletedVolunteer[i].type});
        }
      }
        this.volunteeres.push({name: null, price: null, discount: null, description: null, type: 'Simple'});
      
      // initialize the selected item
	  if(this.assemblies){
			this.FormulaItems = [];
			this.FormulaItems = this.assemblies;
        for(var i=0;i<this.assemblies.length;i++)
        {
                this.items.push({item:this.assemblies[i].selected_item});
        }
	  }
      this.FormulaItems.push({item:null});

			// console.log('lplpl',this.FormulaItems);
      // for(var m=2;m>this.selected_item.length;m--)
      // {
        // this.productions.push({item:null});
      // }
      // end item
      if(this.income)
      {
        this.selected_income=this.income[0];
      }
      
      // begin service

      for(var r=0;r<this.selected_service.length;r++)
        {
             var flag=false;
             var tempService;
             for(var h=0;h<this.all_services.length;h++)
             {
                if(this.all_services[h].id==this.selected_service[r].item_id)
                {
                   flag=true;
                   tempService           = this.all_services[h];
                   tempService.quantity  = this.selected_service[r].quantity;
                   tempService.rate      = this.selected_service[r].price;
                   tempService.new_rate  = this.selected_service[r].price;
                }
             }
             if(flag)
             {
                this.services.push({item:tempService,items:this.all_services})
             }
        }
      for(var w=1;w>this.selected_service.length;w--)
      {
         this.services.push({item:null,items:this.all_services});
      }
    //   this.services.push({items: this.all_services, item: null});
      // end service
            
            var n = 0;
            for(n = 0; n<this.worktype.length; n++){
                if(this.worktype[n].id == {{$projects->work_type}}){
                    this.selectedWorkType = this.worktype[n];
                }  
            }
            var t = 0;
            for(t = 0; t<this.projectCategory.length; t++){
                if(this.projectCategory[t].id == {{$projects->project_category_id}}){
                    this.selectedCategory = this.projectCategory[t];
                }  
            }

            var p = 0;
            for(p = 0; p<this.project_progress.length; p++){
                if(this.project_progress[p].id == {{ $projects->project_progress_id }}){
                    this.selectedProgress = this.project_progress[p];
                }
            }
			
            var ia = 0;
            for(ia = 0; ia<this.income.length; ia++){
                if(this.income[ia].id == {{ $projects->income_account_id }}){
                    this.selected_income = this.income[ia];
                }
            }
            var ea = 0; 
            for(ea = 0; ea<this.Expense.length; ea++){
                if(this.Expense[ea].id == {{ $projects->expense_account_id }}){
                    this.expenseAccount = this.Expense[ea];
                }
            }
            var aa = 0; 
            for(aa = 0; aa<this.asset.length; aa++){
                if(this.asset[aa].id == {{ $projects->asset_account_id }}){
                    this.assetAccount = this.asset[aa];
                }
            }
            
            
            if(this.projects)
            {
                if(this.projects.discount>0)
                {
                    this.discountFiled=this.projects.discount; 
                }
                else {
                     this.discountFiled=0; 
                }

                if(this.projects.discount_type)
                {
                    if(this.projects.discount_type=='percent')
                    {
                        if(this.projects.project_price){
                            this.discountFiled    = (parseFloat(this.discountFiled) * 100) / (this.projects.project_price);
                        } else if(this.subtotal){
                            this.discountFiled    = (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        }
                        this.discountIsAmount =false;
                    }
                    else
                    {
                       this.discountIsAmount=true;
                    }
                } 

                if(this.projects.status)
                {
                    this.status = true;
                }
            }
    },
    methods:
    { 

        addItems(type)
       { 
            if(type !=null)
            {
                if(type=="production")
                { 
                  this.temp_production=[];
                  this.productions.push({item:null, items:{
                        name:null,
                        w_build_qty:0,
                        price:0
                    }}); 
                }
                if(type=="service")
                {
                  this.services.push({item:null});
                }
            }
                 
          },
		  
		  
		  onItemSearchProject:_.debounce((search,loading) =>{
          loading(true);
          let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';

          axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemSearchSale',
              keyword:search,
              inventory_category_id:inventory_category_id,
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error){
            console.log(error);
          })
        },getDebounceTime()),
     
        MemberSearch: _.debounce((search, loading) => {
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Customer'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    v.customer = [];
                    v.customer = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

        EmployeeSearch: _.debounce((search, loading) => {
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Employee'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    v.employee = [];
                    v.employee = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

		//ajax call to get items
        setIndex(e)
        {
           //v.temp_items=[];
          this.selected_index=e;
          console.log('uuu',this.selected_index);
        },
		itemCategoryChange(index){
           v.setIndex(index);
           let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';
           
           axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemSearchSale',
              inventory_category_id: inventory_category_id
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
          })
          .catch(function(error){
            console.log(error);
          });

        },
		
		//ajax call to get items
           onItemSearch:_.debounce((search,loading)=>{
               //v.formula_list=[];
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'assemblyList',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 v.items=[];
                 if(response.data.length>0)
                 {
                    v.items=response.data;
                    console.log('sssss',v.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
           // end item search	 
		  
		  getItemFormula(index)
            {
				//console.log('ggg',this.FormulaItems);
            //item
                if(this.FormulaItems[index].selected_item && this.FormulaItems[index].selected_item !=null)
                {
                     this.formulaSearch(this.FormulaItems[index].selected_item.item_id,this,index);
                }
            },
		  
		  //ajax call to get formula
           formulaSearch(item_id,vm,index)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                } 
               })
               .then(function (response)
               {
                 vm.FormulaItems[index].formula_list=[];
                 if(response.data.length>0)
                 {
                    vm.FormulaItems[index].formula_list=response.data;
					vm.addNew('FormulaItems',0)
					// console.log('formula',response.data);
					console.log('yyyyy',vm.FormulaItems[index]);
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
		  
        // Check selected Currency 
        checkSelected(){
            var allCarrencies = {!! json_encode(getCurrencies()) !!};
            for(var x in allCarrencies){
                for(z in allCarrencies[x]){
                    if(allCarrencies[x][z] == "{!! $projects->currency !!}"){
                        this.selectedCurrency = allCarrencies[x]; 
                    } 
                }
            } 
        },
        setData:function(){
        },
        setValuesAmount(index){ 
            if(this.inventories[index].item){
                @if(systemConfig()[30] == 1)
                    this.inventories[index].item.rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.exchanged_rate; console.log('in refs',this.inventories[index].item.rate);
               @else 
                    this.inventories[index].item.rate = this.$refs.in[index].value/this.exchanged_rate; console.log('in refs',this.inventories[index].item.rate);
                @endif
            }
        },
        setValuesAmountS(index){

            // console.log('amountes',this.$refs.ins[index].value);
            if(this.services[index].item){
                @if(systemConfig()[30] == 1)
                this.services[index].item.rate = this.$refs.ins[index].value/this.selected_currency.static_rate * this.exchanged_rate; 
                @else 
                this.services[index].item.rate = this.$refs.ins[index].value/this.exchanged_rate; 
                @endif
                console.log('in refs service',this.services[index].item.rate);
            }
        },
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       
           // calculate item price based on measure change
       measureChangeservice(index)
       {
    
           if(this.services[index].item !=null){
            var item=this.services[index].item;
            @if(systemConfig()[30] == 1)
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.static_rate / this.selected_currency.rate);
            @else 
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.rate);
            @endif


            result=Number.parseFloat(temp).toFixed(precision());

            this.services[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
           if(this.selected_customer)
           {
            // get member contract
             this.contractSearch(this.selected_customer.id,this);
           }
       },
       // set new price
       setNewRate(type=null,index)
       {
          if(type=='service')
          {
              if(this.services[index].item)
              {
                @if(systemConfig()[30] == 1)
                this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.static_rate * this.selected_currency.exchange_rate;
                @else 
                this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.exchange_rate;
                @endif
              }
          }
       },
       
       // set new price
       // set new price
       setProduction(ind)
       {
            for(var i=0;i<this.productions.length;i++)
            {
                if (this.productions[i].items != null) {
                    this.productions[i].items.name = this.$refs.name[i].value;
                    this.productions[i].items.w_build_qty = this.$refs.w_build_qty[i].value;
                    this.productions[i].items.price = this.$refs.price[i].value;

                }
            }
       },
     
       //ajax call to get items
   //ajax call to get items
    // onItemSearch:_.debounce((search,loading)=>{
       // loading(true);
       // axios.get("{{route('callMethod.search')}}",{
        // params:{
          // method_name:'productionItem',
          // keyword:search,
        // }
       // })
       // .then(function (response)
       // {
         // v.temp_production=[];
         // if(response.data.length>0)
         // {
            // v.temp_production=response.data;
         // }
         // loading(false);
       // })
       // .catch(function (error)
       // {
          // console.log(error);
       // });
       // },getDebounceTime()),

        contractSearch(id,vm)
       {
           vm.contract=[];
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'member_contract',
              member_id:id
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {
                vm.contract=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
       // end contract search

       // generic function for adding item to list
      
        // in here you can check and decide to allow duplicate service or not
       checkExistingService(index=null,name='')
        {      
              var service_temp=this.all_services.slice();
              var service_temp1=[];
              for(var i=0;i<this.services.length;i++)
              {
                  if(this.services[i].item !=null)
                  {
                      var fined=service_temp.findIndex((item)=> item.name == this.services[i].item.name);
                      if(fined !=-1)
                      {
                        var o=service_temp.splice(service_temp.findIndex((item)=>item.name == this.services[i].item.name),1);
                      }
                  }
              }
              this.services[index].items = service_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 
       },
	   
	   
	   
	   // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='production')
             {
                if(this.productions[index+1]==undefined)
                {
                  this.temp_production=[];
                  this.productions.push({item:null,items:{
                        name:null,
                        w_build_qty:0,
                        price:0
                    }});
                }
             }
             if (type == 'volunteeres') {
                if (this.volunteeres[index + 1] == undefined) {
                    this.volunteeres.push({name: null, price: null, discount: null, description: null, type: 'Simple'});
                }
            }
             if(type=='FormulaItems')
             {
                if(this.FormulaItems[index+1]==undefined)
                {
                  this.items=[];
                  this.FormulaItems.push({item:null});
                }
             }
             if (type == 'shareholder') {
                    if (this.shareholderData[index + 1] == undefined) {
                        this.shareholderData.push({percentage: 0, shareholder_list: this.shareholder, selected: null});
                    }
                }
            if(type=='service')
             {
                if(this.services[index+1]==undefined)
                {
                  this.checkExistingService(index,'');
                  this.services.push({
                    items: this.all_services,
                    item: null,
                });
                }
             }
			 if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null,item_category:null});
                }
             }
             
          }
          
       },
	   
        // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         { 
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
             if (type == 'volunteeres') {
                this.volunteeres.splice(index, 1);
            }
             if (type == 'shareholder') {
                this.shareholderData.splice(index, 1);
             }
             if(type=='FormulaItems')
             {
                this.FormulaItems.splice(index, 1);
             }
             if(type=='production')
             {
                this.productions.splice(index, 1);
             }
              if(type=='service')
             {
                this.services.splice(index, 1);
             }
               
         }
          
       },
	   

       // submit the form
       
    },
    created:function()
    {
          
    }

  });

</script>
 
@endpush