@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ProjectInformation') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
                <a href="" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                <a href="" class="reload" data-original-title="" title=""> </a>
                <a href="" class="remove" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::model($project,['method' => 'PATCH','route' => ['project.close',$project->id],'class'=>'form-horizontal'])!!}
            {{ csrf_field() }}
            <div class="form-body">

                <div class="portlet-body">
                    <div class="table-scrollable">
                        <div class="tabbable-line">

                            <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                                <thead>
                                    <tr>
                                        <!-- <th class="hidden-xs">
                                        <i class="fa fa-bars"></i> @lang('layout.ProjectCode')
                                    </th> -->
                                        <th class="hidden-xs">
                                            <i class="fa fa-edit"></i> @lang('layout.ProjectName')
                                        </th>
                                        <!-- <th>
                                        <i class="fa  "></i> @lang('layout.Currency') 
                                    </th>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.Rate')
                                    </th> -->
                                        <th class="hidden-xs">
                                            <i class="fa fa-user"></i> @lang('layout.Customer')
                                        </th>
                                        <th>
                                            <i class="icon-phone"></i> @lang('layout.Phone')
                                        </th>
                                        <th class="hidden-xs">
                                            <i class="fa fa-bars"></i> @lang('layout.Status')
                                        </th>
                                        <th>
                                            <i class="fa fa-clock-o"></i> @lang('layout.StartDate')
                                        </th>
                                        <th>
                                            <i class="fa fa-calendar-times-o"></i> @lang('layout.EndDate')
                                        </th>
                                        <th>
                                            <i class="fa fa-sun-o"></i> @lang('layout.TotalaDays')
                                        </th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <!-- <td class="hidden-xs"> {{ $project->number}}  </td> -->
                                        <td class="hidden-xs"> {{ $project->name}} </td>
                                        <td class="hidden-xs"> {{ $project->member}} </td>
                                        <td class="hidden-xs"> {{ $project->phone}}</td>
                                        <td class="hidden-xs">
                                            @if($project->project_progress_id != 1)
                                            {{$project->progress}}
                                            @else
                                            @lang('layout.Completed')
                                            @endif
                                        </td>
                                        <td class="hidden-xs"> {{ $project->startDate}}</td>
                                        <td class="hidden-xs"> {{ $project->endDate}}</td>
                                        <td class="hidden-xs"> {{ $remainDate->days}}</td>

                                    </tr>
                                </tbody>
                            </table>
                            <table class="table table-striped table-bordered table-advance table-hover" id="table_payment">
                                <thead>
                                    <tr>
                                        <th>
                                            <i class="fa  "></i> @lang('layout.Currency')
                                        </th>
                                        <th>
                                            <i class="fa "></i> @lang('layout.Rate')
                                        </th>

                                        <th class="hidden-xs">
                                            <i class="fa  " style="color:#3FABA4"></i> @lang('layout.Amount')
                                        </th>
                                        @if($project->discount)
                                        <th class="hidden-xs">
                                            <i class="fa fa-minus-square"></i> @lang('layout.Discount')
                                        </th>
                                        @endif
                                        <th class="hidden-xs">
                                            <i class="fa fa-get-pocket" style="color: green"></i> @lang('layout.Receive')
                                        </th>
                                        <th class="hidden-xs">
                                            <i class="fa fa-building-o" style="color: #F2784B"></i> @lang('layout.MaintainanceAmount')
                                        </th>
                                        <th>
                                            <i class="fa fa-cart-plus" style="color:#E87E04"></i> @lang('layout.RemainAmount')
                                        </th>
                                        <th>
                                            <i class="fa fa-plus-circle" style="color:green;font-size: 15px;"></i> @lang('layout.JournalIncome')
                                        </th>
                                        <th>
                                            <i class="fa  fa-minus-circle" style="color: #F7CA18; font-size: 16px;"></i> @lang('layout.ExpensedAmount')
                                        </th>
                                        <th>
                                            <i class="fa fa-briefcase" style="color:green;font-size: 15px;"></i> @lang('layout.EarnedAmount')
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="hidden-xs"> {{ $project->currency}} </td>
                                        <td class="hidden-xs"> {{ $project->rate}} </td>
                                        <td class="hidden-xs"> @if($project->Amount){{$project->Amount+$ExpenseNotFree}} {{$project->currency}} @endif </td>
                                        @if($project->discount)
                                        <td class="hidden-xs"> @if($project->discount){{$project->discount}} {{$project->currency}} @endif </td>
                                        @endif
                                        <td class="hidden-xs">@if($totalRecevie){{$totalRecevie}} {{$project->currency}} @endif
                                        </td>
                                        <td class="hidden-xs">@if($totalMaintain){{$totalMaintain}}{{$project->currency}} @endif
                                        </td>
                                        <td class="hidden-xs">@if($totalPAmount){{$totalPAmount}} {{$project->currency}} @endif</td>
                                        <td class="hidden-xs">@if($JournalTotal){{$JournalTotal}}{{$project->currency}} @endif </td>
                                        <td class="hidden-xs">@if($totalExpensedAmount){{$totalExpensedAmount}} {{$project->currency}} @endif</td>
                                        <td class="hidden-xs">@if($totalearnedAmount) {{$totalearnedAmount}}{{$project->currency}}@endif </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-12">
                        <label class="control-label">@lang('layout.OtherIncome')</label>
                        <v-select label="name" :options="otherIncome" v-model="selected_income"></v-select>
                        <input type="hidden" name="income_id" :value="(selected_income==null)?null:selected_income.id">
                    </div>
                    <div class="col-md-4 col-sm-12">
                        <label class="control-label">@lang('layout.OtherExpense')</label>
                        <v-select label="name" :options="otherExpense" v-model="selected_expense"></v-select>
                        <input type="hidden" name="expense_id" :value="(selected_expense==null)?null:selected_expense.id">
                    </div>

                    <div class="col-md-12" style="padding: 0px;">
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Date')</label>
                            <input class="form-control date" id="range-from-example" name="date" autocomplete="off" />
                        </div>
                        <div class="col-md-5">
                            <label class="control-label">@lang('layout.Description')</label>
                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}

                        </div>

                    </div>
                    <div class="col-md-12">
                        <!-- begin shareholder -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Shareholder')</th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>


                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(record,index) in shareholderData">
                                    <td>@{{index+1}}</td>
                                    <td class="highlight">
                                        <v-select label="name" v-model="record.selected" :options="(record.shareholder_list)" placeholder="@lang('layout.Select')" disabled>

                                        </v-select>
                                        <input type="hidden" name="shareholder_id[]" :value="(record.selected==null)?null:record.selected.id">
                                    </td>

                                    <td>
                                        <input class="form-control" type="number" name="percentage[]" v-model.number="record.percentage" placeholder="@lang('layout.Percentage')" readonly="readonly">
                                    </td>


                                </tr>
                            </tbody>
                        </table>
                        <!-- end shareholder -->
                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('contract.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                <input type="hidden" name="timps" class="observer-example-alt">
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

    @endsection
    @push('scripts')




    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);

        var shareholder ={!! $seletedShareholder!!};
        var otherIncome ={!! $otherIncome!!};
        var otherExpense ={!! $otherExpense!!};

        new Vue({
            el: '#app',
            data: {

                selectedMember: null,
                listAccounts: [],
                type: 'bank',
                account: {},
                contract: null,
                shareholder: shareholder,
                owner: [],
                selected_owner: null,
                otherIncome: otherIncome,
                selected_income: null,
                otherExpense: otherExpense,
                selected_expense: null,
                shareholderData: []
            },

            computed: {},
            mounted: function() {
                this.selected_owner = _.find(this.owner, (o) => o.id == this.contract.owner_id);

                for (var i = 0; i < this.shareholder.length; i++) {
                    var percent = this.shareholder[i].percentage;
                    this.shareholderData.push({
                        percentage: percent,
                        shareholder_list: this.shareholder,
                        selected: this.shareholder[i]
                    });
                }


            },
            methods: {

                handleSubmit(e) {

                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                onComplete: function() {
                    document.getElementById("account-form").submit()
                    //                this.$emit('on-complete')
                    //                alert('Yay. Done!');
                },
                submitform() {
                    swal({
                            title: "Are you sure?",
                            text: "",
                            icon: "info",
                            buttons: true,
                            dangerMode: true,
                        })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("bill-submit").submit()
                            } else {}
                        });
                },
                // generic function for adding item to list
                addNew(type = null, index) {

                    if (type != null) {
                        if (type == 'shareholder') {

                            if (this.shareholderData[index + 1] == undefined) {
                                //this.temp_items=[];
                                this.shareholderData.push({
                                    percentage: 0,
                                    shareholder_list: this.shareholder,
                                    selected: null
                                });
                            }
                        }
                    }
                },
                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'shareholder') {
                            this.shareholderData.splice(index, 1);
                        }

                    }

                },
            }
        });
    </script>

    @endpush