@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('invoice','index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.CompletedProjectsReport')</h3>
<table class="main-table">

<thead>
<tr> 
 <td><div class="center"> #</div></td>
 <td><div class="center"> @lang('layout.Code') </div></td>
 <td><div class="center"> @lang('layout.ProjectName')</div></td>
 <td><div class="center"> @lang('layout.Customer')</div></td>
 <td><div class="center"> @lang('layout.Amount')</div></td>
 <td><div class="center"> @lang('layout.ExpensedAmount')</div></td>
 <td><div class="center"> @lang('layout.EarnedAmount')</div></td>
 <td><div class="center"> @lang('layout.StartDate')</div></td>
 <td><div class="center"> @lang('layout.EndDate')</div></td>
 <td><div class="center"> @lang('layout.Days')</div></td>
 <td><div class="center"> @lang('layout.Location')</div></td> 
 <td><div class="center"> @lang('layout.Type')</div></td>  

</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
  
?>

@foreach($data AS $record)
<tr>
<?php
   $total_home_currency+=$record['amount']/$record['rate'];
   if(array_key_exists($record['currency'], $currencies))
   {
    $currencies[$record['currency']]=$currencies[$record['currency']]+$record['amount'];
  }
  else
  {

    $currencies[$record['currency']]=$record['amount'];
  }
  ?>
<tr>
 
<td class="center">{{++$count}}</td>
<td class="center">{{$record['code']}}</td>
<td class="center">{{$record['name']}}</td>
<td class="center">{{$record['member']}}</td>
<td class="center">{{$record['amount']}}{{$record['currency']}}</td>
<td class="center">{{ $record['totalExpensedAmount']}}{{$record['currency']}}</td>
<td class="center">{{$record['totalearnedAmount']}}{{$record['currency']}}</td>
<td class="center">{{$record['startDate']}}</td>
<td class="center">{{$record['endDate']}}</td>
<td class="center">{{$record['days']}}</td>
<td class="center">{{$record['location']}}</td> 
<td class="center">{{$record['type']}}</td> 

</tr>
@endforeach

</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> #</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency )
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection