@extends('layouts.app')
@section('style')


    <link href="{{url('css/custome-table.css')}}" rel="stylesheet">

    <link href="{{url('/assets/bootstrap-colorpicker/css/colorpicker.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/jquery-minicolors/jquery.minicolors.css')}}" rel="stylesheet" type="text/css"/>

    <link href="{{url('/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.css')}}" rel="stylesheet" type="text/css"/>

    <style>

    </style>

@stop


@section('content')
    @include("layouts.Cmodal")
    <div class="row" id="app" v-cloak>
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPorject')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item active">
                    <a class="nav-link active" data-toggle="tab" href="#home">@lang('layout.Project')</a>
                </li>
            </ul>
            <div class="portlet-body form" id="item-service">
                {!! Form::model($projects, ['method' => 'POST','class'=>'form-horizontal','route' => ['project.add_item_store',$projects->id]]) !!}

                <div class="tab-content">
                    <div class="tab-pane active" id="home">
                        <div class="row">
                            <div class="col-md-12">

                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.ProjectName')</label>
                                    <input type="text" value="{{$projects->name}}" readonly class="form-control">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.ProjectCode')</label>
                                    <input type="text" readonly value="{{$projects->number}}" class="form-control">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Customer')</label>
                                    <input type="text" readonly value="{{$projects->member}}" class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div v-if="productions.length >0 " class="row">
                                    
                                <br/>
                                <br/>
                                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.StuffDetails') </li>
                                    <div class="table-responsive333">
                                        <table id="table_content" class="table table-bordered table-advance">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th style="min-width: 100px">@lang('layout.Category') </th>
                                                <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                <th style="min-width: 100px">@lang('layout.SalePrice') </th>
                                                <th style="min-width: 100px">@lang('layout.Total') </th>

                                                @if(getCompanyTag() != 1)
                                                    <th style="min-width: 100px">@lang('layout.TotalHQ') </th>
                                                @endif
                                                <th></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(item,index) in inventories">
                                                <td>@{{index+1}}</td>
                                                <td>
                                                    <v-select label="name" v-model="item.item_category"
                                                                :options="inventory_category"
                                                                @click.native="addNew('inventory',index)"
                                                                @input="itemCategoryChange(index)"></v-select>
                                                    <input type="hidden" name="inventory_category_id[]"
                                                            :value="(!item.item_category)?null:item.item_category.id">
                                                </td>
                                                <td class="highlight">
                                                    <v-select label="name" @Click.native="setIndex(index)"
                                                                v-model="item.item" :options="temp_items"
                                                                @search="onItemSearchProject"></v-select>
                                                    <input type="hidden" :name="'inventory_id['+index+']'"
                                                            v-validate="''" data-vv-as="@lang('layout.ItemName')"
                                                            :value="(!item.item)?null:item.item.item_id">
                                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                </td>
                                                <td class="highlight">
                                                    <select v-model="(item.item==null)?null:item.item.site"
                                                            class="form-control">
                                                        <option value="null">@lang('layout.Select')</option>
                                                        <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                                        :value="site">
                                                                    @{{site.site_name}}
                                                                </option> 
                                                                </span>
                                                    </select>

                                                    <input type="hidden" name="inventory_site[]"
                                                            :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                </td>
                                                <td>
                                                    <input type="number" :name="'inventory_quantity['+index+']'"
                                                            v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                            v-model.number="(item.item==null)?null:item.item.quantity"
                                                            class="form-control input-style input-number"
                                                            placeholder="@lang('layout.Quantity')">
                                                    <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                </td>

                                                <td>
                                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                </td>
                                                <td class="highlight">
                                                    <select v-model="(item.item == null)?null:item.item.measure"
                                                            class="form-control" @change="measureChange(index)">
                                                        <option value="null">@lang('layout.Select')</option>
                                                        <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                            :value="measure">
                                                                    @{{measure.measure_name}}
                                                                    </option> 
                                                                </span>


                                                    </select>

                                                    <input type="hidden" name="inventory_measure[]"
                                                            :value="(item.item==null)?null:item.item.measure.measure_id">
                                                </td>
                                                <td>
                                                    <div class="input-group">
                                                        <input type="number" name="inventory_price[]"
                                                                placeholder="@lang('layout.Price')"
                                                                :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)"
                                                                ref="item_rate" @input="setNewRate('inventory',index)"
                                                                class="form-control">
                                                            <span class="input-group-addon">
                                                                @{{selected_currency.symbol}}
                                                            </span>
                                                    </div>

                                                </td>
                                                <td>
                                                    @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate, null, null,selected_currency.hq_rate).result }}
                                                    <b>@{{selected_currency.symbol}}</b>
                                                </td>

                                                @if(getCompanyTag() != 1)
                                                    <td>
                                                        @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,null,null, selected_currency.hq_rate).resultHQ }}
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </td>
                                                @endif

                                                <td>
                                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    <!--span  @click="addNew('inventory',index)"><i class="paddint-both glyphicon glyphicon-plus"></i></span -->
                                                </td>
                                            </tr>
                                            <!--tr style="background-color: #ffffff;">
                                                <td></td>
                                                <td><center>
                                                    <button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
                                                </center></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            
                                <div v-if="services.length >0 " class="row">
                                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.Service') </li>
                                    <div class="table-responsive333">
                                        <table id="table_content"
                                               class="table table-bordered table-advance table-hover">
                                            <thead>
                                            <tr>
                                                <th class="text-center" style="min-width: 8px;"> #</th>
                                                <th class="text-center"
                                                    style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                <th class="text-center"
                                                    style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                <th class="text-center"
                                                    style="min-width: 160px;">@lang('layout.Measure')</th>
                                                <th class="text-center"
                                                    style="min-width: 160px;">@lang('layout.Price')</th>

                                                <th class="text-center"
                                                    style="min-width: 120px;">@lang('layout.Total')</th>

                                                @if(getCompanyTag() != 1)
                                                    <th class="text-center"
                                                        style="min-width: 120px;">@lang('layout.TotalHQ')</th>
                                                @endif
                                                <th></th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(service,index) in services">
                                                <td>@{{index+1}}</td>
                                                <td class="highlight">
                                                    <v-select label="name" v-model="service.item"
                                                              :options="(service.items)"
                                                              @click.native="addNew('service',index)"
                                                              @input="checkExistingService(index)">

                                                    </v-select>
                                                    <input type="hidden" name="service_id[]"
                                                           :value="(service.item==null)?null:service.item.id">
                                                </td>

                                                <td>
                                                    <input class="form-control" name="service_quantity[]"
                                                           v-model.number="(!service.item)?null:service.item.quantity"
                                                           placeholder="@lang('layout.Quantity')">
                                                </td>
                                                <td class="highlight">
                                                    <select v-model="(!service.item)?null:service.item.measure"
                                                            class="form-control" @change="measureChangeservice(index)">
                                                        <option value="null">@lang('layout.Select')</option>
                                                        <span v-if="(service.item ==null)?false:true">
                                                                <option v-for="measure in (!service.item)?null:service.item.measure_list"
                                                                        :value="measure">
                                                                @{{measure.measure_name}}
                                                              </option> 
                                                            </span>
                                                    </select>

                                                    <input type="hidden" name="service_measure[]"
                                                           :value="(service.item==null)?null:service.item.measure.measure_id">
                                                </td>
                                                <td> 
                                                    <div class="input-group">
                                                        <input type="number" name="service_price[]"
                                                               placeholder="@lang('layout.Price')"
                                                               :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.exchange_rate)"
                                                               ref="ser" @input="setNewRate('service',index)"
                                                               class="form-control">
                                                        <span class="input-group-addon">
                                                            @{{selected_currency.symbol}}
                                                          </span>
                                                    </div>

                                                </td>
                                                <td>
                                                    @{{ (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate).result }}
                                                    <b>@{{selected_currency.symbol}}</b>
                                                </td>
                                                @if(getCompanyTag() != 1)
                                                    <td>
                                                        @{{  (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate).resultHQ }}
                                                        <b>@{{selected_currency.symbol}}</b>
                                                    </td>
                                                @endif
                                                <td>
                                                    <span v-on:click="deleteItem('service',index)"><i
                                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                            </div>
                        </div>
                    </div>
                </div>
                {{Form::close()}}
            </div>
        </div>
        <cmodal :show='showModal' @close="showModal=false">

        </cmodal>
    </div>
    </div>

@endsection

@push('scripts')
    <script src="{{url('/assets/bootstrap-colorpicker/js/bootstrap-colorpicker.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/jquery-minicolors/jquery.minicolors.min.js')}}" type="text/javascript"></script>

    <script src="{{url('/assets/bootstrap-wysihtml5/wysihtml5-0.3.0.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.js')}}" type="text/javascript"></script>

    <script src="{{url('/assets/scripts/components-color-pickers.min.js')}}" type="text/javascript"></script>
    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {

                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;

                        if (this.receivables.length > 0) {
                            this.selectReceive = this.receivables[0];
                        }
                        if (this.payables.length > 0) {
                            this.selectPay = this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'email': datas[1]['value'],
                            'phone': datas[2]['value'],
                            'address1': datas[3]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        axios.get('{{route("invoice.create")}}').then(response => {

                            v.customer = response.data.customer;
                            document.getElementById("modalForm").reset();

                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency = {!! $currency !!};
        var all_services = {!! $all_services !!};
        var inventory_category = {!! $inventory_category !!};
        // company group

        let ratesFetched = {!! $rates !!};

        var v = new Vue({
            el: '#app',
            data: {

                inventories: [
                    {item: null, item_category: null},
                ],
                shareholderData: [],
                shareholder: null,
                temp_items: [],
                selected_index: 0,
                inventory_category: inventory_category,
                selected_item: null,
                items: [],
                formula_list: [],
                selected_formula: null,
                customer: null,
                showModal: false,
                selected_currency: defaultCurrency(),
                currency: currency,
                selectedMember: null,
                selectedWorkType: null,
                selectedCategory: null,
                selectedProgress: null,
                exchanged_rate: {!!currency()->exchange_rate!!},
                listAccounts: [],
                currencyList: currency,
                account: {},
                code: 0,
                measure: null,
                all_services: all_services,
                incomeAccount: null,
                expenseAccount: null,
                assetAccount: null,
                FormulaItems: [
                    {
                        item: null,
                    },
                    {
                        item: null,
                    },
                ],

                productions: [
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                ],

                services: [
                    {
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ],

                inventoryIndex: 0,
                serviceIndex: 0,
                productionIndex: 0,
                worktype: null,
                projectCategories: null,

                discountFiled: 0,
                discountIsAmount: false,
                num: [],
                defaultValue: 0,
                amount: null,
                temp_production: [],
            },
            computed: {
                setRates(){
                    let rates = [];
                    this.currency.forEach((b)=>{

                        ratesFetched.forEach((a)=>{

                            if(a.currency_id == b.id){
                                rates.push({
                                    name: a.name,
                                    code:a.code,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null? Number.parseFloat(a.hq_rate) : 1,
                                    currency:b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a)=>{
                        let found = false;
                        rates.forEach((b)=>{
                            if(a.id == b.id){
                                found = true;
                                return;
                            }
                        });

                        if(!found){
                            rates.push({
                                name: a.name,
                                code:a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency:a.id,
                                id: a.id
                            })
                        }
                    });

                    return rates;

                },
                selectedRate() {
                    console.log('eeett', this.currencyList);
                    console.log('eee', this.selected_currency);
                    this.selected_currency['rate'] = (this.selected_currency) ? this.selected_currency.exchange_rate : 1;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {
                        return this.discountFiled
                    }
                },

                // calculate subtotal
                subtotal: function () {

                    var sum = 0;
                    for (var p = 0; p < this.productions.length; p++) {
                        if (this.productions[p].items && this.productions[p].items.price) {
                            console.log('ppppttt', this.productions[p]);
                            var qty = this.productions[p]['items']['w_build_qty'];
                            var price = this.productions[p]['items']['price'];
                            sum += qty * price;
                        }
                    }

                    for (var i = 0; i < this.FormulaItems.length; i++) {
                        if (this.FormulaItems[i].selected_formula && this.FormulaItems[i].selected_formula.build_qty) {

                            // console.log('fdfsdfsd',this.FormulaItems[i]);
                            var qty = this.FormulaItems[i].selected_formula.build_qty;
                            var price = this.FormulaItems[i].selected_formula.cost * this.selected_currency['rate'];
                            sum += qty * price;
                        }
                    }

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {

                            // console.log('fdfsdfsd',this.inventories[i]);
                            var qty = this.inventories[i].item.quantity;
                            var price = this.inventories[i].item.new_rate * this.selected_currency['rate'];
                            sum += qty * price;
                        }
                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {
                            // console.log('ffffff',this.services[i]);
                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.exchange_rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.exchange_rate);
                            }

                        }
                    }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;

                    return isError;


                },
                // filter the banks according to selected currency
                //  approperiateBank:function()
                // {
                //      var bankCopy=this.banks.slice();
                //      var tempBank=bankCopy.filter((account)=>{
                //          return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                //      });
                //      if(tempBank.length>0)
                //      {
                //          this.selected_banks=tempBank[0];
                //      }
                //      return tempBank;
                // },
            },
            methods:
                {
                    // calculate item price based on measure change


                    // calculate item price based on measure change

                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            // get member contract
                            this.contractSearch(this.selected_customer.id, this);
                        }
                    },
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {

                            if (this.inventories[index].item) {
                                console.log('ppp', this.inventories);

                                this.inventories[index].item.new_rate = this.$refs.item_rate[index].value / this.selected_currency.exchange_rate;
                            }

                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.exchange_rate;
                            }
                        }
                    },

                    //ajax call to get items
                    // onItemSearch:_.debounce((search,loading)=>{
                    // loading(true);
                    // axios.get("{{route('callMethod.search')}}",{
                    // params:{
                    // method_name:'productionItem',
                    // keyword:search,
                    // }
                    // })
                    // .then(function (response)
                    // {
                    // v.temp_production=[];
                    // if(response.data.length>0)
                    // {
                    // v.temp_production=response.data;
                    // }
                    // loading(false);
                    // })
                    // .catch(function (error)
                    // {
                    // console.log(error);
                    // });
                    // },getDebounceTime()),

                    //ajax call to get items
                    onItemSearch: _.debounce((search, loading) => {
                        //v.formula_list=[];
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'assemblyList',
                                keyword: search,
                            }
                        })
                            .then(function (response) {
                                v.items = [];
                                if (response.data.length > 0) {
                                    v.items = response.data;
                                    console.log('sssss', v.items);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }, getDebounceTime()),

                    // end item search


                    onItemSearchProject: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    //ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                        console.log('uuu', this.selected_index);
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },

                    // end item search


                    getItemFormula(index) {
                        //console.log('ggg',this.FormulaItems);
                        //item
                        if (this.FormulaItems[index].selected_item && this.FormulaItems[index].selected_item != null) {
                            this.formulaSearch(this.FormulaItems[index].selected_item.item_id, this, index);
                        }
                    },

                    //ajax call to get formula
                    formulaSearch(item_id, vm, index) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'item_formula',
                                item_id: item_id,
                            }
                        })
                            .then(function (response) {
                                vm.FormulaItems[index].formula_list = [];
                                if (response.data.length > 0) {
                                    vm.FormulaItems[index].formula_list = response.data;
                                    vm.addNew('FormulaItems', 0)
                                    // console.log('formula',response.data);
                                    console.log('yyyyy', vm.FormulaItems[index]);

                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end formula search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'production') {
                                if (this.productions[index + 1] == undefined) {
                                    this.temp_production = [];
                                    this.productions.push({item: null, items: []});
                                }
                            }
                            if (type == 'shareholder') {
                                if (this.shareholderData[index + 1] == undefined) {
                                    this.shareholderData.push({percentage: 0, shareholder_list: this.shareholder, selected: null});
                                }
                            }
                            if (type == 'FormulaItems') {
                                if (this.FormulaItems[index + 1] == undefined) {
                                    this.items = [];
                                    this.FormulaItems.push({item: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }

                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'shareholder') {
                                this.shareholderData.splice(index, 1);
                            }
                            if (type == 'FormulaItems') {
                                this.FormulaItems.splice(index, 1);
                            }
                            if (type == 'production') {
                                this.productions.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }

                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    measureChangeservice(index) {
                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.exchange_rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // Add new row when the whole rows in deleted
                    addItems(type) {
                        if (type != null) {
                            if (type == "production") {
                                this.temp_production = [];
                                this.productions.push({item: null});
                            }
                            if (type == "service") {
                                this.temp_items = [];
                                this.services.push({item: null});
                            }
                        }

                    },
                },
            created: function () {
                console.log('test 22', this.all_services);
                console.log('test 33', this.services);
                console.log('selected currency', this.selected_currency)
            }

        });

    </script>

@endpush