@extends('layouts.app')
@section('content')



<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- app -->

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bortdered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.ProjectProgressList')</span>
            </div>
            <div class="tools"> </div>
            <div class="pull-right">
       
                @permission('projectprogress-create')
                <a href="{{route('projectProgress.create')}}">
                    <button id="sample_editable_1_new" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission 
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="worktype">
                <thead>
                    <tr>
                        {{--<th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead> 
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET--> 


<!-- END CONTENT BODY -->
@endsection

@push('scripts')
 

<script>
    
$(document).ready(function() { 
        $('#worktype').DataTable( {
            ajax:           '{{route("projectprogress.index")}}',
            // order: [[ 2, "desc" ]],
                scrollCollapse: true,
                paging:         true,
                serverSide: true,
            columns: [  
            // { data: 'id', name: 'id' },
            { data: 'name', name: 'name'},
            { data: 'Date', name: 'Date'},
            { data: 'actions', name: 'actions', orderable:false,searchable:false }
            ] 
    } );
    } );
</script>
@endpush
