@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.BuildInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.BuildNumber')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.ItemName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-user"></i> @lang('layout.CreatedBy')
                        </th> 
                        <th>
                            <i class="fa fa-shopping-cart"></i> @lang('layout.Quantity')
                        </th>
                        <th>
                            <i class="fa fa-shopping-cart"></i> @lang('layout.Measure')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Cost')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.TotalExpense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Expense')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.CostWithExpenses')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.UnitCost')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr> 
                        <td class="hidden-xs"> {{ $build['b_number']}}  </td>
                        <td class="hidden-xs"> {{ $build['name']}}  </td>
                        <td class="hidden-xs"> {{ $build['username'] }}  </td>
                        <td class="hidden-xs"> {{ $build['qty'] }}  </td>
                        <td class="hidden-xs"> {{ $build['symbol'] }}  </td>
                        <td class="hidden-xs"> {{ $build['cost']}}  </td>
                        <td class="hidden-xs"> {{ $build['expense_amount']}}  </td>
                        <td class="hidden-xs"> {{ $build['expense_cost']}}  </td>
                        <td class="hidden-xs"> {{ ($build['cost']*$build['qty'])}}  </td>
                        <td class="hidden-xs"> {{ ($build['cost'])+$build['expense_cost']}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="tabbable tabbable-tabdrop">

    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.BuildDetails')</a>
        </li>
        <!-- li class="">
            <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Expense')</a>
        </li --->
    </ul>
<div class="tab-content">
<div class="tab-pane active" id="tab1">
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BuildDetails')</span>
                </div>
                <div class="tools"> </div>
                <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="project_simple_build_Details"/>
                           <input type="hidden" name="id" value="{{$build['id']}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="project_simple_build_Details"/>
                           <input type="hidden" name="id" value="{{$build['id']}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="builds">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.BuildNumber')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Total')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <div class="tab-pane" id="tab2"> 
                <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
                </div>
                <div class="tools"> </div>
              
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="expens">
                        <thead>
                        <tr>  
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Amount')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
            </div>
        </div>
    </div>
</div>
    </div>
@endsection
@push('scripts')
 <script>
    $(document).ready(function () {
        $('#builds').DataTable({
           ajax:{
            url:'{{route("pro_simple_build.show",$build['id'])}}',
                data:{type:'buildDetail'}
              },
            serverSide: true,
            scrollCollapse: true,
            paging: true,
            columns: [    
                { data: 'Name', name: 'items.name' },
                { data: 'Build_Number', name: 'builds.number' },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'Quantity', name: 'Quantity',orderable:false,searchable:false },
                { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                { data: 'Cost', name: 'Cost',orderable:false,searchable:false },
        
        ]

        });
    });

     $(document).ready(function () {
        $('#expens').DataTable({
           ajax:{
            url:'{{route("pro_simple_build.show",$build['id'])}}',
                data:{type:'expenseDetail'}
              },
            serverSide: true,
            scrollCollapse: true,
            paging: true,
            columns: [    
                { data: 'account', name: 'account' },
                { data: 'description', name: 'description' },
                { data: 'amount', name:'amount', orderable:true,searchable:false},
        
        ]

        });
    });



</script>
 
@endpush 