@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditBuild')</span>
                    {{--<span class="caption-helper"></span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                 {!! Form::model($build,['method' => 'PATCH','route' => ['pro_simple_build.update',$build->id],'files'=> true, 'id'=>'build-form'])!!}
                <div class="form-body">
                    <div class="row">
									<div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.SelectProject')</label> 
                                            <v-select label="name" v-model="selectedProject" :options="project_items"  @input="getFormulaItem(this)"  @search="ProjectSearch"></v-select> 
                                            <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.project_id">
                                        </div>
                                    </div> 
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            <v-select label="name" v-model="selected_item" :options="items" @input="setQty(this)" ></v-select>

                                            <input type="hidden" name="formula_item_id" :value="(!selected_item)?null:selected_item.id">

                                        </div>
                                    </div>
									<div class="col-md-4">
									   <div class="form-group">
											  <label class="control-label ">@lang('layout.QuantityToBuild')</label>
												<input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="buildQty" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.QuantityToBuild')">

												   <span class="required">@{{ errors.first('build_qty') }}</span>
							  
										  </div>
								   </div>
                           </div>
					
					
					
					<div class="row">
						
					
                        <div class="col-md-4">
                          <div class="form-group">
                                  <label class="control-label ">@lang('layout.SiteName')</label>

                                      <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site"  >
                                          
                                      </v-select>
                                      <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null"  v-validate="'required'" data-vv-as="@lang('layout.SiteName')">
                                      <span class="required">@{{ errors.first('site') }}</span>

                              </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                 <label class="control-label">@lang('layout.AssemblyCode') </label>
                                      <input type="number" name="number" value="{{$build->number}}" class="form-control">
                                       <span class="required">@{{ errors.first('number') }}</span>
              
                            </div>
                        </div>
						<div class="col-md-4">
                              <div class="form-group">
                                  <label class="control-label ">@lang('layout.Date')</label>
                                      <input class="form-control date" name="date" autocomplete="off" value="{{$build->date}}">
                              </div>
                          </div>
                        </div>

                        <div class="row">

                           <div class="col-md-8">
                              <div class="form-group">
                                  <label class="control-label col-md-4">@lang('layout.Description') </label>
                                  <textarea  name="description" class="form-control" rows="2">{{$build->description}}</textarea>
                              </div>
                          </div> 
                    </div>

                    <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                    <input type="hidden" name="stock_id" value="{{$stock_id}}">

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="assemlby_items.length >0 " class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                 <th class="text-center" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(inventory,InventoryIndex) in assemlby_items" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <v-select label="name" v-model="inventory.item" :options="temp_items" @search="onItemsSearch" @Click.native="setIndex(InventoryIndex)"></v-select>
                                      <input type="hidden" :name="'inventory_id['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(inventory.item==null)?null:inventory.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+InventoryIndex+']') }}</span>
                                            
                                </td> 
                                <td>
                                    <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure"  class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required">

                                       <span v-if="inventory.item.measure_list !=null">
                                            <option v-if="(inventory.item !=null)"
                                                v-for="measures in inventory.item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="inventory_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null" >
                                </td>
                                <td> 
                                    <!--  <input type="number"  v-model.number="(inventory.item==null)?null:inventory.item.on_hand" class="form-control input-style input-number"  placeholder="@lang('layout.OnHand')" readonly="readonly"> -->
                                 <input readonly type="number"  :value="(!inventory.item)?null:getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty,inventory.item.on_hand)"> 
                    
                               </td>

                                
                                <td> 
                                     <input type="number" :name="'inventory_qty['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(inventory.item==null)?null:inventory.item.qty" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                                <span class="required">@{{ errors.first('inventory_qty['+InventoryIndex+']') }}</span>
                              </td>

                                <td>
                                    <span v-if="(!assemlby_items)?null:assemlby_items.length > 1"  v-on:click="deleteItem('inventory',InventoryIndex)">
                                      <i class="paddint-both glyphicon glyphicon-trash"></i>
                                    </span>

                                </td>
                            </tr>
                          <tr style="background-color: #ffffff;">
                            <td></td>
                            <td><center>
                              <span @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></span>
                            </center></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                          </tr>

                            </tbody>
                        </table>

                    </div>
                    <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                    </button>

                    <div class="form-section"></div>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>

                    <div v-if="otherBuild.length >0 " class="">

                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(inventory,InventoryIndex) in otherBuild" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                </td>
                                <td class="td_one">
                                     
                                     <v-select label="name" v-model="inventory.item" :options="temp_items" @click.native="addNew('otherBuilds',InventoryIndex)" @search="onItemsSearch"></v-select>
                                      <input type="hidden" name="other_build_id[]" :value="(inventory.item==null)?null:inventory.item.id">

                                </td>
                                <td>
                                   <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure"   class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required">

                                       <span v-if="inventory.item.measure_list !=null">
                                            <option v-if="(inventory.item !=null)"
                                                v-for="measures in inventory.item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="other_build_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                </td>
                                <td >
                                        <input readonly type="number"  :value="(!inventory.item)?null:getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,inventory.item.qty,inventory.item.on_hand)"> 
                                </td>
                                <td >
                                    <input name="other_build_qty[]" class="form-control inpu-number-fild"  :class="" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" placeholder="@lang('layout.Quantity')" />
                                </td>
                                <td>
                                <div class="input-group">
                                        <input type="number" class="form-control" 
                                        placeholder="%" style="min-width: 100px"  name="other_build_cost[]" v-model.number="(!inventory.item)?null:inventory.item.other_build_cost" />
                                        <span class="input-group-addon">%</span>
                                    </div>
                              </td>
                                <td>
                                    <span  v-on:click="deleteItem('otherBuild',InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>

                            </tbody>
                        </table>

                    </div>

                    <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
                    </button>
                     @if(getBuildExpense() == "true")
                    <!-- build expense -->

                      <div class="form-section"></div>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>

                    <div v-if="expenses.length >0 " class="">

                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ExpenseAccount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(expense,index) in expenses" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one">
                                     
                                     <v-select label="name" v-model="expense.expense_account" :options="expense_account" @click.native="addNew('expense',index)" ></v-select>
                                      <input type="hidden" name="expense_id[]" :value="(expense.expense_account==null)?null:expense.expense_account.id">

                                </td>
                                <td>
                                  <input type="text" name="expense_description[]" class="form-control" placeholder="@lang('layout.Description')" v-model="(expense.info==null)?null:expense.info.description">
                                </td>
                                <td >
                                    <input type="number" name="expense_amount[]" class="form-control" placeholder="@lang('layout.Amount')" v-model="(expense.info==null)?null:expense.info.amount">
                                </td>
                                <td>
                                    <span  v-on:click="deleteItem('expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>

                            </tbody>
                        </table>

                    </div>
                    @endif

                    <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
                    </button>

                    <!-- end build expense -->

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button  type="button"  @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('buildItem.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>
     
@endsection
@push('scripts')

    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>



<script>
     Vue.component('v-select', VueSelect.VueSelect);

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        
    var site                 = {!! $site !!};
    var selectedSite         = {!! $selectedSite !!};
    var build                = {!! $build !!};
    var buildSelectedFormula = {!! $buildSelectedFormula !!};
    var buildSelectedItem    = {!! $buildSelectedItem !!};
    var buildDetail          = {!! $buildDetail !!};
    var otherBuildDetail     = {!! $otherBuildDetail !!};
    var projectSelect     = {!! $projectSelect !!};
    var itemSelect     = {!! $itemSelect !!};
    var buildQty;
    var expense_account = {!! $expense_account !!};
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            projectSelect:projectSelect,
            itemSelect:itemSelect,
            buildQty:null,
            selected_assembly_item:buildSelectedItem,
            assembly_item:[],
            temp_items:[],
            formula_items:[],
			
			project_items:[],
            selectedProject :null,
            selected_item:null,
            items:[],

            selected_site:selectedSite,
            buildSelectedFormula:buildSelectedFormula,
            build:build,
            buildQty:build.qty,
            buildDetail:buildDetail,
            otherBuildDetail:otherBuildDetail,

            assemlby_items: [
            ],
            otherBuild: [
            ],
            otherBuildIndex:0,
            inventoryIndex:0,
            inventoryItem:null, 
            expense_account:expense_account,
            expenses:[
            ],
        },
        created:function()
        {
           
           if(this.projectSelect)
           {
			   this.selectedProject = this.projectSelect;
			   this.selected_item = this.itemSelect;
		   };
	   
           if(this.build)
           {

              if(this.buildSelectedFormula)
              {
                var rows = this.buildSelectedFormula[0];

               
                
                  for(var x=0; x<rows.formula.length;x++)
                  {
                    rows.formula[x].new_quantity = buildDetail[x].quantity;
                    this.assemlby_items.push({
                      item:rows.formula[x]
                    });
                  }  

                  for(var x=0; x<rows.other_build.length;x++)
                  {
                    rows.other_build[x].new_quantity = buildDetail[x].quantity;
                    this.otherBuild.push({
                      item:rows.other_build[x]
                    });
                  }  

                  for(var m=4;m>rows.other_build.length;m--)
                  {
                    this.otherBuild.push({item:null});
                  }


                  for(var x=0; x<rows.expense.length;x++)
                  {
                    this.expenses.push({
                      expense_account:rows.expense[x].expense_account,info:rows.expense[x]
                    });
                  }  

                  for(var m=4;m>rows.expense.length;m--)
                  {

                    this.expenses.push({expense_account:null,info:null});
                  }
                
              }
           }
        },
        computed:{
                  buildQ: function () 
                {
                  var min = null;
                  if(this.selected_formula)
                  {
                     var rows = this.selected_formula.formula;
                    
                      if(rows.length >0) 
                      {
                          var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));

                          //var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].on_hand/temp;
                          for (var i = 1; i < rows.length; i++) 
                          {

                            var temp=((rows[i].new_quantity*rows[i].measure.measure_unit/rows[i].measure_unit));
                            var result= (rows[i].on_hand * rows[i].item_item_measure.measure_unit)/(rows[i].measure.measure_unit);

                            if (result / temp < min) 
                            {
                                min = result / temp;
                            }

                          }
                          min = min.toFixed(precision());

                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if((this.selected_item==null && !this.selected_item)  || this.selected_formula ==null || this.selected_site==null || this.buildQty<=0 || (this.buildQ - this.buildQty)<0)
                {
                  isError=true;
                }
                return isError;
             },
        },
        methods:{

			// Search Project 
      
        ProjectSearch:_.debounce((search,loading)=>{
           sales.project_items=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'serarchProject',  
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.project_items=[];
             if(response.data.length>0)
             {
                sales.project_items=response.data;
                console.log('test 22',sales.project_items);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
        },getDebounceTime()),
	   
	   
	   setQty(e)
            {
				
				// console.log('fff',this.selected_item);
				this.buildQty =	(!this.selected_item.quantity)?this.build.qty:this.selected_item.quantity;
				
				// if(this.selected_formula)
              // {
                // var rows = this.selected_formula.formula;

                  // for(var x=0; x<rows.length;x++)
                  // {
                    
                    // this.new_temp_items.push({
                      // item:rows[x]
                    // });
                  // }
				  
                  // }
			},
	   
	   
	    getFormulaItem(e)
            {
                if(this.selectedProject && this.selectedProject !=null)
                {
                     this.onProjectItemSearch(this.selectedProject.project_id,this);
                }
            },
          
         
           //ajax call to get items
           onProjectItemSearch:_.debounce((project_id,vm)=>{
               sales.formula_list=[];
               sales.selected_formula=null;
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'simpleProjectAssemblyList',
                  project_id:project_id,
                }
               })
               .then(function (response)
               {
                 sales.items=[];
                 if(response.data.length>0)
                 {
                    vm.items=response.data;
                    console.log('sssss',sales.items);
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
	   
	   



          getBuildOnHand(item_measure_unit=null,selected_measure_unit=null,qty=null,on_hand=null)
          {
            var result=0;
            if(on_hand !=null)
            {   
                if(qty)
                {
                  result= (on_hand * item_measure_unit)/(selected_measure_unit)-(qty);
                }
                else
                {
                  result= (on_hand * item_measure_unit)/(selected_measure_unit);
                }
            }   
            return result.toFixed(precision());
          },
          
          handleSubmit(e) 
          {
              this.$validator.validate().then(valid => {
                  if (valid) {
                      regForm(e.target);
                  }
              });
          },
          
            // begin item search

           onItemSearch:_.debounce((search,loading) =>{
              loading(true);
              axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name: 'anyTable',
                  'search_column':'name',
                  'table_name':'items',
                  keyword:search,
                }
              })
              .then(function(response){
                sales.formula_items = [];
                if(response.data.length >0)
                {
                  sales.formula_items = response.data;
                }
                loading(false);
              })
              .catch(function(error){
                console.log(error);
              })
           },getDebounceTime()),

     
       // end item search
       // items serarch method

         onItemsSearch:_.debounce((search,loading) =>{
            loading(true);
            axios.get("{{route('callMethod.search')}}",{
              params:{
                 method_name:'items_search_assebley',
                'type':'assembaly',
                keyword:search,
              }
            })
            .then(function(response){
              sales.temp_items = [];
              if(response.data.length >0)
              {
                sales.temp_items = response.data;
              }
              loading(false);
            })
            .catch(function(error){
              console.log(error);
            })
         },getDebounceTime()),

  setIndex()
        {
           this.temp_items=[];
        },
    
        addNew(type=null,index)
        { 
          
          if(type !=null)
          {
             if(type=='inventory')
             { 
              this.temp_items=[];
                if(this.assemlby_items[index+1]==undefined)
                {
                  this.assemlby_items.push({item:null});
				  console.log(this.assemlby_items);
                }
             } 
             if(type=='otherBuilds')
             { 
              this.temp_items=[];
                if(this.otherBuild[index+1]==undefined)
                {
                  this.otherBuild.push({item:null});
                }
             }
             if(type=='expense')
             { 
                if(this.expenses[index+1]==undefined)
                {
                  this.expenses.push({expense_account:null});
                }
             }
             

              
          }
          
       },
        deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.assemlby_items.splice(index, 1);
             }
             if(type=='otherBuild')
             {
                this.otherBuild.splice(index, 1);
             }
              if(type=='expense')
             {
                this.expenses.splice(index, 1);
             }
               
         }
          
       },

       addItems(type)
       { 
            if(type !=null)
            {
                if(type=="otherBuilds")
                { 
                    this.temp_items=[];
                  this.otherBuild.push({item:null}); 
                }
                if(type=="inventory")
                { 
                   this.temp_items=[];
                  this.assemlby_items.push({item:null});
                }
                 if(type=="expense")
                { 
                  this.expenses.push({expense_account:null});
                }
            }
                 
          },
        }
    });



</script>


@endpush