@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('build','detail');
?>

 <table class="main-table">
  @if($info && $info !=[])
    <tr>
   <td>
      <span>@lang('layout.BuildNumber')</span>:
      <span>{{$info['b_number']}}</span>
    </td>
    <td>
      <span>@lang('layout.ItemName')</span>:
      <span>{{$info['name']}}</span>
    </td>
     <td>
      <span>@lang('layout.Quantity')</span>:
      <span>{{$info['qty']}}</span>
    </td>
    <td>
      <span>@lang('layout.Measure')</span>:
      <span>{{$info['symbol']}}</span>
    </td>
     <td>
      <span>@lang('layout.Cost')</span>:
      <span>{{$info['cost']}}</span>
    </td>
    <td>
      <span>@lang('layout.TotalExpense')</span>:
      <span>{{$info['expense_amount']}}</span>
    </td>
    <td>
      <span>@lang('layout.Expense')</span>:
      <span>{{$info['expense_cost']}}</span>
    </td>
    <td>
      <span>@lang('layout.CostWithExpenses')</span>:
      <span>{{($info['cost'])*($info['qty'])+($info['expense_amount'])}}</span>
    </td>
    <td>
      <span>@lang('layout.UnitCost')</span>:
      <span>{{($info['cost'])+$info['expense_cost']}}</span>
    </td>

    </tr>
  @endif

   </table>
<h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>
<table class="main-table">
 
  <thead>
    <tr class="bg">
    <td  class="center" ><div>  @lang('layout.Record') </div></td>
    <td  class="center"  style="display: <?=(!show('build_number',$report))?'none':'';?>"><div> @lang('layout.BuildNumber') </div></td>
    <td  class="center"  style="display: <?=(!show('name',$report))?'none':'';?>"><div> @lang('layout.Name')</div></td>
    <td  class="center"  style="display: <?=(!show('measure',$report))?'none':'';?>"><div> @lang('layout.Measure')</div></td>
    <td  class="center"  style="display: <?=(!show('quantity',$report))?'none':'';?>"><div> @lang('layout.Quantity')</div></td>
    <td  class="center"  style="display: <?=(!show('purchase_rate',$report))?'none':'';?>"><div> @lang('layout.Cost')</div></td>
    <td  class="center"  style="display: <?=(!show('total',$report))?'none':'';?>"><div> @lang('layout.Total')</div></td>
    <td  class="center"  style="display: <?=(!show('date',$report))?'none':'';?>"><div> @lang('layout.Date')</div></td>
  </tr>
  </thead>
 

  <?php
  $count = 0;
  $total_cost=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
      $total_cost+=$record->Cost*$record->Quantity;
    ?>
    <td class="center">{{++$count}}</td>
    <td style="display: <?=(!show('build_number',$report))?'none':'';?>" class="center">{{$record->Build_Number}}</td>
    <td style="display: <?=(!show('name',$report))?'none':'';?>" class="center">{{$record->Name}}</td>
    <td style="display: <?=(!show('measure',$report))?'none':'';?>" class="center">{{$record->Measure}}</td>
    <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->Quantity}}</td>
    <td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>" class="center">{{Currency()->format($record->Cost)}}</td>
    <td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{Currency()->format($record->Cost*$record->Quantity)}}</td>
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
{{convertDate($record->Date)}}
</td>
  </tr>
  @endforeach
</table>
<h4>@lang('layout.Total')</h4>
<table class="main-table">

<tr class="bg">
  <td><div class="center"> @lang('layout.Amount') </div></td>
  <td><div class="center"> {{round($total_cost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</div></td>
</tr>

</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection