@extends('layouts.app')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.InvoiceInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="20px;">
                                <i class="fa  fa-bars"></i> @lang('layout.SalesNumber')
                            </th>
                            <th width="20px;">
                                <i class="fa  fa-bars"></i> @lang('layout.ReferenceNumber')
                            </th>
                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.Customer')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Forgivness')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th>
                            <th width="20px;">
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Amount')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Discount')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.CustomerCheck')
                            </th>
                            @if(showVendorInFactor() == 'true') 
                            <th>
                                <i class="fa  "></i> @lang('layout.VendorName')
                            </th>
                            @endif 

                            @if(getSaleCommission()=="true")
                            <th>
                                <i class="fa  "></i> @lang('layout.Commission') @lang('layout.Percentage')%
                            </th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $invoice->number}}  </td>
                            <td class=" "> {{ $invoice->ref_Number}}  </td>
                            <td class=""> {{ $invoice->member_name }}  </td>
                            <td class=""> {{ $invoice->account_name}}  </td>
                            <td> 
                                @if($invoice->forgivness) {{ __('layout.'.ucfirst($invoice->forgivness)) }} @endif
                            </td>
                            <td class=""> {{ convertDate($invoice->date)}}  </td>
                            <td class=""> {{ convertDate($invoice->overdue_date)}}  </td>
                            <td class=""> {{ $invoice->hour}} </td>
                            <td class=""> {{ $invoice->rate }}  </td>
                            <td class=""> {{ myRound($invoice->amount) }}  </td>
                            <td class=""> {{ myRound($invoice->discount) }}  </td>
                            <td class=""> {{ $invoice->currency }}  </td>
                            @if($invoice->customer_status)
                            <td class=""> @lang('layout.checked') </td>
                            @else 
                            <td class=""> </td>
                            @endif
                            @if(showVendorInFactor() == 'true') 
                            <td class=""> {{ $invoice->vendor_name }}  </td>
                            @endif
                            @if(getSaleCommission()=="true")
                            <td class=""> {{myRound($invoice->commission_percent)}}  </td>
                            @endif
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th width="">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th w   idth=" ">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ $invoice->description}}  </td>
                        <td class=" "> {{ $invoice->memo}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="tabbable tabbable-tabdrop"> 
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.InvoiceDetails')</a>
            </li> 
            @if(voucherOfferingType() == '1')
            <li class="">
                <a href="#tab2" data-toggle="tab" id="saleExpenseInfos">@lang('layout.TransferDetails')</a>
            </li>
            @endif
           

        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab1">
                <div class="row"> 
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.InvoiceDetails') </span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="Inoice_Details"/>
                                    <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>
                                    <button type="submit" class="btn btn-success"><i
                                      class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="Inoice_Details"/>
                                    <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>
                                    <button type="submit" class="btn btn-success">
                                        <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="invoices">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.ItemName')</th>
                                        <th>@lang('layout.Site')</th>
                                        <th>@lang('layout.Contract')</th>
                                        <th>@lang('layout.PurchaseDate')</th>
                                        <th>@lang('layout.SleepStaff')</th>
                                        @if(oilSale() == 'true')
                                        <th>@lang('layout.Unit/M')</th>
                                        <th>@lang('layout.Density')</th>
                                        <th>@lang('layout.OilQuantity')</th>
                                        <th>@lang('layout.Price')</th>
                                        @endif
                                        @if(getDriverInfo()=="true")
                                        <th>@lang('layout.Driver')</th>
                                        <th>@lang('layout.VehicleName')</th>
                                        @endif
                                        <th>@lang('layout.Unit/M')</th>
                                        <th>@lang('layout.Quantity')</th>
                                        @if(getmine() == 'true')
                                        <th>@lang('layout.Percentage')</th>
                                        <th>@lang('layout.PerPercentPrice')</th>
                                        <th>@lang('layout.LaboratoryPercentage')</th>
                                        <th>@lang('layout.Differ')</th>
                                        @endif
                                        @if(getSaleCommission()=="true")
                                        <th>@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                        <th>@lang('layout.Commission') @lang('layout.Amount')</th>
                                        @endif 
                                        <th>@lang('layout.Price')</th>
                                        <th>@lang('layout.Discount')</th>
                                        <th>@lang('layout.Cost')</th>
                                        <th>@lang('layout.GrossProfit')</th>
                                        <th>@lang('layout.Total')</th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div> 

            <div class="tab-pane" id="tab2">
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.TransferDetails')</span>
                        </div>
                    </div>
                    <div class="portlet-body">  
                        <table class="table table-striped table-bordered table-hover" id="saleExpenseInfo">
                            <thead>
                            <tr>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.AccountRegister')</th>
                                <th>@lang('layout.Description')</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>


            {{-- <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.InvoicePayment')</span>
                    </div>
                </div>
                <div class="portlet-body">

                    <table class="table table-striped table-bordered table-hover" id="invoice_payment">
                        <thead>
                        <tr>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div> --}}


             
        </div>
    </div>






<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
       
        <!-- END EXAMPLE TABLE PORTLET-->
        
        @if(getInvoicePayment()== "true")
        <br/>
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InvoicePayment')</span>
                </div>
            </div>
            <div class="portlet-body">

                <table class="table table-striped table-bordered table-hover" id="invoice_payment">
                    <thead>
                    <tr>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        @endif

    </div>
</div>



@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#invoices').DataTable({
            // ajax: '{{route("projectInvoice.show",$invoice->invoice_id)}}',

            ajax: {
                url: '{{route("projectInvoice.show",$invoice->invoice_id)}}',
                data: {type: 'projectInvoiceDetails'}
            },

            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [
                {data: 'name', name: 'name', orderable: false, searchable: false},
                {data: 'siteName', name: 'siteName', orderable: false, searchable: false},
                {data: 'company_name', name: 'company_name', orderable: false, searchable: false},
                {data: 'stocks_date', name: 'stocks_date', orderable: false, searchable: false},
                {data: 'sleepDate', name: 'sleepDate', orderable: false, searchable: false},
                @if(oilSale() == 'true')
                {data: 'oilSymbol', name: 'oilSymbol', orderable: false, searchable: false},
                {data: 'density', name: 'density', orderable: false, searchable: false},
                {data: 'oil_qty', name: 'oil_qty', orderable: false, searchable: false},
                {data: 'oilPrice', name: 'oilPrice', orderable: false, searchable: false},
                @endif
                @if(getDriverInfo()=="true")
                {data: 'driver_name', name: 'driver_name', orderable: false, searchable: false},
                {data: 'vehicle_name', name: 'vehicle_name', orderable: false, searchable: false},
                @endif
                {data: 'symbol', name: 'symbol', orderable: false, searchable: false},
                {data: 'qty', name: 'qty', orderable: false, searchable: false},
                @if(getmine() == 'true')
                {data: 'percentage', name: 'percentage', orderable: false, searchable: false},
                {data: 'per_percent_price', name: 'per_percent_price', orderable: false, searchable: false},
                {data: 'laboratory_percentage', name: 'laboratory_percentage', orderable: false, searchable: false},
                {data: 'differ_amount', name: 'differ_amount', orderable: false, searchable: false},
                @endif

                @if(getSaleCommission()=="true")
                { data: 'row_commission_percent', name: 'row_commission_percent', orderable:false,searchable:false },
                { data: 'total_commission', name: 'total_commission', orderable:false,searchable:false },
                @endif


                {data: 'price', name: 'price', orderable: false, searchable: false},
                {data: 'discount', name: 'discount', orderable: false, searchable: false},
                {data: 'avgCost', name: 'avgCost', orderable: false, searchable: false},
                {data: 'income', name: 'income', orderable: false, searchable: false},
                {data: 'total', name: 'total', orderable: false, searchable: false},
            ]
        });


        $('#saleExpenseInfo').DataTable({
            ajax: {
                url: '{{route("projectInvoice.show",$invoice->invoice_id)}}',
                data: {type: 'saleExpenseInfo'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [ 
                {data: 'name', name: 'name'},
                {data: 'amount', name: 'amount'},
                {data: 'date', name: 'date'},
                {data: 'register_account', name: 'register_account'},
                {data: 'description', name: 'description'}
            ]
        });


        @if(getInvoicePayment()== "true")
        $('#invoice_payment').DataTable({
            ajax: {
                url: '{{route("invoice.show",$invoice->invoice_id)}}',
                data: {type: 'invoice_payment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
                {data: 'description', name: 'sale_payments.description'},
                {data: 'amount', name: 'sale_payments.amount'},
                {data: 'currency', name: 'sale_payments.currency'},
                {data: 'rate', name: 'sale_payments.rate'}
            ]
        });
        @endif

    });
</script>


@endpush




