@extends('layouts.app')
@section('content')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'projectInvoicelist'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <input type="hidden" name="negative_sale" value="ok">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.MemberClass') </label>
                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                      :options="classlist">
                            </v-select>
                            <input type="hidden" name="class_id"
                                   v-model.number="(!selectedClass)?null:selectedClass.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SaleArea') </label>
                            <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch"
                                      :options="saleArealist">
                            </v-select>
                            <input type="hidden" name="sale_area_id"
                                   v-model.number="(!selectedArea)?null:selectedArea.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Contract') </label>
                            <v-select class="vue-select2" v-model="contract" label="company_name"
                                      :options="contracts">
                            </v-select>
                            <input type="hidden" name="contract_id"
                                   v-model.number="(!contract)?null:contract.id">
                        </div>

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectSite') </label>
                            <v-select class="vue-select2" v-model="selectedInventorySite" label="name" :options="InventorySite">
                            </v-select>
                            <input type="hidden" name="inventory_id" v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id">
                        </div>


                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="">
                                    <label class="control-label">@lang('layout.Forgivness')</label>
                                    <select name="forgivness" id="" class="form-control form-select" v-model="forgivness">
                                        <option selected value="">@lang('layout.Select')</option>
                                        <option value="forgivness">@lang('layout.Forgivness')</option>
                                        <option value="withoutForgivness">@lang('layout.WithoutForgivness')</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.NegativeInvoiceList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
					<a href="{{route('projectInvoice.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.Invoice')
                        </button>
                    </a>
                    @permission('ProjectInvoice-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('ProjectInvoice-create')
                    <a href="{{route('projectInvoice.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    <!-- <button class="btn btn-success" id="addNewRefundd">
                            <i class="icon-action-redo"></i> @lang('menu.Refund')
                    </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="invoice">
                    <thead>
                        <tr>
                            <th>@lang('layout.InvoiceNumber')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.CustomerName')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Hour')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Discount')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <!-- for factor begin -->
    <div id="factor-obj">
    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>
    <!-- end for factor -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var settingAll = {!! getUserSetting() !!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}", "{{Session('whatsapp')}}")
        @endif
        function factorPrint(id,sendWhatsapp = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            var a = document.createElement('a');
            a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        function sendVoucherToWhatsapp(id,sendWhatsapp) {
            if (id && sendWhatsapp) {
                axios.get("{{url('invoiceFactorPrint')}}/" + id + "/1", {
                    // params: {
                        // method_name: 'SearchMember',
                        // class_id: class_id
                    // }
                })
                .then(function(response) {
                    // console.log(response);
                    if (response.data) {
                        if (sendWhatsapp == 1) {
                            var a = document.createElement('a');
                            a.href = "https://wa.me/?text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                        if (sendWhatsapp == 2) {
                            var a = document.createElement('a');
                            a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        }
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#invoice').DataTable({
                ajax: '{{route("projectInvoice.index_na")}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'sales.number'},
                    {data: 'ref_no', name: 'sales.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'account_name', name: 'accounts.name'},
                    {data: 'date', name: 'sales.date', searchable: false},
                    {data: 'hour', name: 'sales.hour', searchable: false},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false},
                    {data: 'description', name: 'sales.description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'user', name: 'users.name' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//              { data: 'measure_unit_id', name: 'quantity' },
//              { data: 'measure_unit', name: 'rate' },

                ]
            });
        });

        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

        var inventorySite = {!! $inventorySite !!};

        var vm = new Vue({

            el: '#print-modal',
            data: {
                forgivness: '',
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                selectedInventorySite: null,
                InventorySite: inventorySite,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedArea: null,
                contracts: {!! $contracts !!},
                contract: null,
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get items
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()),
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>


@endpush
