@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")
    <div class="row">
        <div class="portlet light bordered"> 
            <div class="portlet light bordered">
                <div class="portlet-title" id="backbtn">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewInvoice')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appInvoice" class="portlet-body"> 
                    <div class="tabbable tabbable-tabdrop">
                        <div>
                            {{Form::open(['route' => 'projectInvoice.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form','files'=> true])}}
                            {{ csrf_field() }}
                            <div class="tab-content"> 
                                <div class="tab-pane active" id="tab1"> 
                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- begin sale order modal -->
                                        <div id="salOrderApp" v-cloak>
                                        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                                            <input type="hidden" name="type" value="invoicelist"/>
                                            <!-- use the modal component, pass in the prop -->
                                            <modal v-if="showModalSaleOrder" @close="showModalSaleOrder = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label ">@lang('layout.Select') </label>
                                                                <select class="form-control"
                                                                    style="border: 1px solid black !important"
                                                                    v-model="selected_sale_order"
                                                                    @input="saleOrderChang()">
                                                                    <option v-for="order in saleOrderList"
                                                                            :value="order">
                                                                      <span>
                                                                         @{{order.type+':'+order.number+' '+order.description}}
                                                                      </span>
                                                                    </option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Currency') </label>
                                                                <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.currency" class="form-control" disabled="disabled">
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Rate') </label>
                                                                <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.rate" class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Date') </label>
                                                                <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.date"  class="form-control" disabled="disabled">
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                                                <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.delivery_date" class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label ">@lang('layout.Description') </label>
                                                                <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.description"  class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br>
                                                    <p style="color: red">@lang('layout.SOmsg')
                                                </div>
                                                <div slot="footer">
                                                    <button type="button" v-if="selected_sale_order" @click="getsalesOrders" class="btn btn-success"> 
                                                        @lang('layout.Submit')
                                                    </button>
                                                    <button type="button" class="btn btn-danger" v-on:click="showModalSaleOrder=false"> 
                                                        @lang('layout.Cancel')
                                                    </button>
                                                </div>
                                            </modal>
                                        <!-- {{Form::close()}} -->
                                        </div>
                                        <!-- end sale order modal -->
                                        <!-- BEGIN FORM-->
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                    <!-- begin inputs -->
                                                    <div class="row">
                                                        @if(getShwoPriceLevel()=="general")
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                    <v-select label="name" :options="priceLevel" v-model="selected_priceLevel" @input="changePriceLevel()">
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent")
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                    <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral" @input="change_sale_rate_by_price_level_general()">
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Customer')</label>
                                                                    <v-select label="name" @input="memberChange()" @search="MemberSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Customer')"
                                                                           :value="!selected_customer?null:selected_customer.id"
                                                                           required>
                                                                    <span class="required">@{{ errors.first('customer') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label col-md-12"><br></label>
                                                                    <button type="button" class="btn blue btn-block" @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-2 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.InvoiceNumber')</label>
                                                                    <input type="number" name="number" @input="checkNo()" v-model="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" class="form-control">
                                                                    <span class="required">@{{ errors.first('number') }}</span>
                                                                    <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-2 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','referenceNumber')) displayNone @endif">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                    <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                    <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                                    {{-- <span class="required">@{{ errors.first('customer') }}</span> --}}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Currency')</label>
                                                                    <v-select label="code" @input="selectedRate" :options="setRates" v-model="selected_currency"></v-select>
                                                                    <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                    <span class="required">@{{ errors.first('currency') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Rate')</label>
                                                                    <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                    <input type="hidden" name="currency_rate_hq" v-model="!selected_currency?1:selected_currency.hq_rate">
                                                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>
                                                                    <div class="input-group" style="color: black !important">
                                                                        <input v-model="discountFiled" class="form-control" type="number" min="0" name="discount" max="100">
                                                                        <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount; discountIsAmounttwo = !discountIsAmounttwo" style="background-color: rgb(80, 129, 141)" class="input-group-addon">@{{selected_currency.symbol}}
                                                                            <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                        </span>
                                                                        <span v-else @click="discountIsAmount = !discountIsAmount; discountIsAmounttwo = !discountIsAmounttwo" class="input-group-addon" style="background-color: rgb(80, 129, 141);">%
                                                                            <input type="hidden" name="discount_type" value="percent">
                                                                        </span>
                                                                        <input type="hidden" name="discountTotal" :value="discount">
                                                                        <input type="hidden" name="discount" :value="discountFiled">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        @if(showVendorInFactor() == 'true') 
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.VendorName')</label>
                                                                    <input type="text" name="vendor_name" class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                        <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','description')) displayNone @endif">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control" rows="1" v-text="invoiceDescription"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-2 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','date')) displayNone @endif">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Date')</label>
                                                                    <input type="text" name="date" class="form-control date" autocomplete="off"
                                                                    @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                                                    <span class="required">@{{ errors.first('date') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','overdueDate')) displayNone @endif" style="margin-bottom: 20px;">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                    <input type="text" name="overdue_date" class="form-control date" autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @if(getSaleCommission()=="true")
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','commission')) displayNone @endif">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Commission')</label>
                                                                    <v-select v-model="selected_commission" label="name" :options="commission">
                                                                    </v-select>
                                                                    <input type="hidden" name="commission_id" :value="!selected_commission?null:selected_commission.id" />
                                                                    <input type="hidden" name="commission_vendor_id" :value="!selected_commission?null:selected_commission.member_id" />
                                                                    <input type="hidden" name="commission_expense_id" :value="!selected_commission?null:selected_commission.expense_id" />
                                                                    <input type="hidden" name="commission_value" :value="subTotalCommi" readonly />
                                                                </div>
                                                            </div>
                                                        </div> 
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','commission')) displayNone @endif">
                                                            <div class="form-group"> 
                                                                <div class="col-md-12">
                                                                    <label class="control-label"  v-if="commissionIsAmount">@lang('layout.Amount')</label>
                                                                    <label class="control-label"  v-else="!commissionIsAmount">@lang('layout.Percentage') %</label>
                                                                    <div class="input-group" style="color: black !important">
                                                                        <input class="form-control" type="number" min="0" max="100" name="camission_amount"  v-model="!selected_commission?null:selected_commission.percent">
                                                                        <span v-if="commissionIsAmount" @click="commissionIsAmount = !commissionIsAmount" style="background-color: rgb(80, 129, 141)" class="input-group-addon">@{{selected_currency.symbol}}
                                                                        <input type="hidden" class="input-group-addon" name="commission_type" value="currency">
                                                                    </span>
                                                                    <span v-else @click="commissionIsAmount = !commissionIsAmount" class="input-group-addon" style="background-color: rgb(80, 129, 141);">%
                                                                        <input type="hidden" name="commission_type" value="percent">
                                                                    </span>
                                                                    <input type="hidden" name="commissionTotal" :value="commission">
                                                                    <input type="hidden" name="commission" :value="commissionFiled"> 
                                                                </div>
                                                                </div>
                                                            </div>
                                                        </div>   
                                                        @endif
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12 @if(!getCustomeForm('projectInvoice','hour')) displayNone @endif">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Hour')</label>
                                                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                                        @if(getHourType() == 24)
                                                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                        @else
                                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                        @endif
                                                                        <span class="input-group-btn">
                                                                            <button class="btn default" type="button">
                                                                                <i class="fa fa-clock-o"></i>
                                                                            </button>
                                                                        </span>
                                                                    </div>
                                                                    {{-- <input type="text" name="overdue_date" class="form-control date" autocomplete="off"> --}}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12 @if(!getCustomeForm('projectInvoice','forgivness')) displayNone @endif">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Forgivness')</label>
                                                                    <select name="forgivness" id="" class="form-control form-select" v-model="forgivness">
                                                                        <option selected value="">@lang('layout.Select')</option>
                                                                        <option value="forgivness">@lang('layout.Forgivness')</option>
                                                                        <option value="withoutForgivness">@lang('layout.WithoutForgivness')</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @if(getSaleToBase() == 'true')
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','saleBaseCurrency')) displayNone @endif" style="margin-bottom: 10px !important;">
                                                            <table class="table table-striped table-bordered table-advance ">
                                                                <tr>
                                                                    <td class="t_body">
                                                                        <div style="display: flex; justify-content: center;">
                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaleBaseCurrency')
                                                                                <input type="checkbox" name="sale_base_currency" value="ok">
                                                                                <span></span>
                                                                            </label>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                        @endif
														@if(oilSale() == 'true')
														<div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
															<div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.Oil')</label>
                                                                <div>
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" @click="ChangeOil" name="oil_sale" value="ok" >
                                                                        <span></span>
                                                                    </label>
                                                                </div>
															</div>
													   </div>
														@endif
                                                        @if(ShowSaveTempItemToCustomer() == "true")
                                                        <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
															<div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.SaveTempItemToCustomer')</label>
                                                                <div>
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="save_temp_item" value="yes">
                                                                    <span></span>
                                                                    </label>
                                                                </div>
															</div>
                                                       </div>
                                                       </div>
                                                       <div class="row">
                                                        @endif
                                                        @if(getmine() == 'true')
                                                        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
															<div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.OtherTypeOfPercentage')</label>
                                                                <div>
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" name="other_type_of_percentage" value="on" v-model="other_type_of_percentage">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
															</div>
                                                        </div>
                                                        @endif
                                                        <!--Begin Sale Discount Date -->
                                                        @if(getSaleDiscountDate()=="true")
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('menu.DiscountDate')</label>
                                                                    <v-select 
                                                                        v-model="selected_discount_date"
                                                                        label="name" :options="discount_date" >
                                                                    </v-select>
                                                                    <input type="hidden" name="discount_date_id" :value="!selected_discount_date?null:selected_discount_date.id" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                        <!--End Sale Discount Date -->
                                                        @if(getNegativeSale() == 'true')
                                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <div style="display: flex; justify-content: center;">
                                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NegativeSale')
                                                                                    <input type="checkbox" name="negative_sale" value="ok">
                                                                                    <span></span>
                                                                                </label>
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        @endif  
                                                        @if(getTelegramBot()=="true")                  
                                                            <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                                <label class="control-label"> <span class="fa fa-telegram" style="color:rgb(14 177 177);"></span> @lang('layout.Telegram')</label>
                                                                <div class="col-md-12 mt-checkbox">
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" name="telegram" value="ok">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                                                            <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                                <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                                <div class="col-md-12 mt-checkbox">
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox"  name="whatsapp" value="5" />
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        @if(checkGift() =='true')                    
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('projectInvoice','checkGift')) displayNone @endif">
                                                            <label class="control-label"> @lang('layout.CheckGift')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="check_gift" style="cursor: pointer" autocomplete="off"> 
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                        @endif

                                                    </div>
                                                    {{-- <div class="row">
                                                        @if(getmine() == 'true')
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <label class="control-label">@lang('layout.Percentage') %</label>
                                                            {!! Form::number('percentage', null, array('placeholder' => __('layout.Percentage'),'v-model' => 'percentage','class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <label class="control-label">@lang('layout.PerPercentPrice')</label>
                                                            {!! Form::number('per_percent_price', null, array('placeholder' => __('layout.PerPercentPrice'),'v-model' => 'per_percent_price','class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <label class="control-label">@lang('layout.LaboratoryPercentage') %</label>
                                                            {!! Form::number('laboratory_percentage', null, array('placeholder' => __('layout.LaboratoryPercentage'),'v-model' => 'laboratory_percentage','class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <label class="control-label">@lang('layout.Differ')</label>
                                                            {!! Form::number('differ', null, array('placeholder' => __('layout.Differ'),'v-model' => 'differ','class' => 'form-control')) !!}
                                                        </div>
                                                        @endif
                                                    </div> --}}
                                                    <!-- end inputs -->
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <!-- begin total -->
                                                    <div class="dashboard-stat2" style="margin-bottom: 0px; padding-bottom: 10px;" >
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right"><span data-counter="counterup"
                                                                        data-value="7800"> 
                                                                        @{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow - discountFiledRowtwo)/100) - discountFiledRow - discountFiledRowtwo - payeds)))}}</span>
                                                                    <small class="font-green-sharp"> 
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr> 
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): 
                                                                        (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                   <span class="text-right" data-counter="counterup"
                                                                         data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow) +  Number.parseFloat(discounttwo*(subtotal - discountFiledRowtwo)/100)+Number.parseFloat(discountFiledRowtwo)) }}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr> 
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <small class="font-green-sharp">
                                                                      <span class="text-right" data-counter="counterup"
                                                                            data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </small>
                                                                </td>
                                                            </tr>  
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') @lang('layout.Commission'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                  <span class="text-right" data-counter="counterup"
                                                                        data-value="7800"> 
                                                                        @{{ myRound(Number.parseFloat(totalCommi) + Number.parseFloat(sum_commission))}}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                         @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Sub-Total'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                  <span class="text-right" data-counter="counterup"
                                                                        data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr> 
                                                        </table>  
                                                    </div>
                                                    <!-- end total -->
                                                    <div class="dashboard-stat2" v-if="selected_customer && summary" style="margin-bottom: 0px; padding-bottom: 10px;">
                                                        <table class="dashboard-tabel table-bordered" width="100%">
                                                            <thead>
                                                                <tr>
                                                                    <th class="text-center">@lang('layout.Currency') </th>
                                                                    <th class="text-center">@lang('layout.Payable')</th>
                                                                    <th class="text-center">@lang('layout.Receivable')</th>
                                                                    <th class="text-center">@lang('layout.AverageRate')</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <span>
                                                                    <tr v-for="summ in summary">
                                                                        <td class="highlight text-center">
                                                                            @{{ summ.currency }}
                                                                        </td>
                                                                        <td class="text-center"> 
                                                                            @{{ format_number(Number(summ.payment)) }}
                                                                        </td>
                                                                        <td class="text-center">
                                                                            @{{format_number(Number(summ.invoice)) }}
                                                                        </td>
                                                                        <td class="text-center">
                                                                            @{{format_number(Number(summ.rate))}}
                                                                        </td>
                                                                    </tr>
                                                                </span>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row" style="overflow-x: scroll;">
												<h3 style="margin-right:20px;">@lang('layout.ContractBased')</h3>
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            @if(getSaleCommission()=="true")
                                                            <th>@lang('layout.Commission')</th>
                                                            @endif 
                                                            <th style="min-width: 130px">@lang('layout.Contract') </th>
                                                            <th style="min-width: 130px">@lang('layout.WagonNumber') </th>
                                                            <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                            @if(searchByCodeLocation()=="true")
                                                            <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                            @endif
                                                            <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                            <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description1') </th>
                                                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                            <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')</th>
                                                            <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')</th>
                                                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                            @if(itemPicture()=="true")
                                                            <th style="min-width: 100px">@lang('layout.Photo') </th>
                                                            @endif
                                                            <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Density') </th>
                                                            <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.OilQuantity') </th>
                                                            <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Measure') </th>
                                                            @if(getShwoPriceLevel()=="per_item")
                                                            <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                            @endif
                                                            @if(getShwoPriceLevel()=="general_percent_per_item")
                                                            <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                            @endif
                                                            @if(getmine() == 'true')
                                                            <th style="min-width: 100px" v-if="other_type_of_percentage" >@lang('layout.Percentage') % </th>
                                                            <th style="min-width: 100px">@lang('layout.PerPercentPrice')</th>
                                                            <th style="min-width: 100px">@lang('layout.LaboratoryPercentage') % </th>
                                                            <th style="min-width: 100px" v-if="other_type_of_percentage" >@lang('layout.Differ')</th>
                                                            @endif
                                                            @if(getSaleCommission()=="true")
                                                            <th style="min-width: 100px" v-if="commissionIsAmount">@lang('layout.Commission') @lang('layout.Amount')</th>
                                                            <th style="min-width: 100px" v-else="!commissionIsAmount">@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                                            @endif 
                                                            <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.CostInInventory')</th>
                                                            <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.CostInInventory') ({{getHomeCurrency()['code']}})</th>
                                                            <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                                            <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                            <th style="min-width: 100px">@lang('layout.Driver') </th>
                                                            <th style="min-width: 100px">@lang('menu.Vehicle') </th>
                                                            <th style="min-width: 100px">@lang('layout.Total') </th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in inventories">
                                                            <td>@{{index+1}}</td>
                                                            <!--td>
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange()"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                            </td -->
                                                            @if(getSaleCommission() =="true") 
                                                            <td> 
                                                                <div class="mt-checkbox" style="padding-left: 0px;"> 
                                                                    <label class="mt-checkbox mt-checkbox-outline"> 
                                                                        <input type="checkbox" :name="'row_commission_stat['+index+']'" v-model="item.commission" checked /> 
                                                                        <span></span> 
                                                                    </label> 
                                                                </div> 
                                                            </td>
                                                            @endif  
                                                            <td>
                                                                <v-select label="company_name" v-model="item.contract" :options="contracts" @input="contractChange(index), contractWagon(index)"></v-select>
                                                                <input type="hidden" name="contract_id[]" :value="(!item.contract)?null:item.contract.id">
                                                            </td>
                                                            <td>
                                                                <v-select label="name" v-model="item.select_wagon" :options="wagon" @input="contractChange(index)"></v-select>
                                                                <input type="hidden" name="wagon_number[]" :value="(!item.select_wagon)?null:item.select_wagon.name">
                                                            </td>
                                                            <td class="highlight">
                                                                <!-- @click.native="addNew('inventory',index)" -->
                                                                <v-select label="name" @Click.native="setIndex(index)" v-model="item.item" :options="temp_items"  @search="onItemSearch"></v-select>
                                                                <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                                <input type="hidden" :value="(!item.item)?null:item.item.sale_order_detail_id" name="sale_order_detail_id[]">
                                                            </td>
                                                            @if(searchByCodeLocation()=="true")
                                                            <td class="highlight">
                                                                <v-select label="name" @Click.native="setIndex(index)" @input="locationItemload(index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                                <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                            </td>
                                                            @endif
                                                            <td class="highlight">
                                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                            </td>
                                                            <td v-show="showWhat('sale_description')=='yes'">
                                                                <input type="text" placeholder="@lang('layout.Description')" v-model="(item.item==null)?null:item.item.description" name="inventory_description[]" class="form-control">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity"  @input="change_oil_qty(index)"  oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                                <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                            </td>
                                                            <td>
                                                                @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                            </td>
                                                            <td v-show="showWhat('other_measure')=='yes'">
                                                                <input type="number" name="other_measure_amount[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                                                            </td>
                                                            <td v-show="showWhat('other_measure2')=='yes'">
                                                                <input type="number" name="other_measure_amount2[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>
                                                                </select> 
                                                                <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                            </td>
                                                            @if(itemPicture()=="true")
                                                            <td>  
                                                                <input :name="'photo['+index+']'" type="file" class ="form-control" placeholder="@lang('layout.Photo')">
                                                            </td>
                                                            @endif
                                                            <td v-if="oil_sale == true">
                                                                <input type="number" name="density[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Density')" @input="change_oil_qty(index)" v-model.number="(item.item==null)?null:item.item.density">
                                                            </td>
                                                            <td v-if="oil_sale == true">
                                                                <input type="number" name="oil_qty[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" @input="change_qty_by_oil(index)" placeholder="@lang('layout.OilQuantity')" v-model.number="(item.item==null)?null:item.item.oil_qty">
                                                            </td>
                                                            <td v-if="oil_sale == true">
                                                                <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option  v-for="measure in (item.item==null)?null:item.item.measureListAll" :value="measure.measure_id">
                                                                            @{{measure.measure_name}}
                                                                        </option> 
                                                                    </span>
                                                                </select>
                                                            </td>
                                                            @if(getShwoPriceLevel()=="per_item")
                                                            <td>
                                                                <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="price_level in (item.item==null)?null:item.item.item_price_level" :value="price_level">
                                                                            @{{price_level.name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                            </td>
                                                            @endif
                                                            @if(getShwoPriceLevel()=="general_percent_per_item")
                                                            <td>
                                                                <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                            @{{price_level.name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                            </td>
                                                            @endif
                                                            @if(getmine() == 'true')
                                                            {{-- 'percentage' 'per_percent_price' 'percent_rate' 'percent_currency' 'laboratory_percentage' 'differ' --}}
                                                            {{-- <td> 
                                                                <input type="number" name="percentage[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_price_by_percent(index)" v-model.number="(item.item==null)?null:item.item.percentage">
                                                            </td> --}}
                                                            <td v-if="other_type_of_percentage"> 
                                                                <input type="number" name="percentage[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_price_by_percent(index)" v-model.number="(item.item==null)?null:item.item.percentage">
                                                            </td>
                                                            <td> 
                                                                <input type="number" name="per_percent_price[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_price_by_percent(index)" v-model.number="(item.item==null)?null:item.item.per_percent_price">
                                                            </td>
                                                            <td> 
                                                                <input type="number" name="laboratory_percentage[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_price_by_percentage(index)" v-model.number="(item.item==null)?null:item.item.laboratory_percentage">
                                                            </td>
                                                            <td v-if="other_type_of_percentage"> 
                                                                <input type="number" name="differ_amount[]" oninput = "autowidths(event)" readonly
                                                                class="form-control input-style input-number chan_length" v-model.number="(item.item==null)?null:item.item.differ">
                                                            </td>
                                                            @endif
                                                            @if(getSaleCommission()=="true")
                                                            <td>
                                                                <div class="input-group" v-show="!item.commission"> 
                                                                    <input type="number" class="form-control chan_length" :name="'row_percent_commission['+index+']'" oninput = "autowidths(event)" v-model="item.row_commission_percent" />
                                                                    <span class="input-group-addon" v-if="commissionIsAmount">
                                                                        @{{selected_currency.symbol}}
                                                                    </span>
                                                                    <span class="input-group-addon" v-if="!commissionIsAmount">
                                                                        %
                                                                    </span>
                                                                    <input type="hidden" :name="'row_commission_amount['+index+']'" :value="item.row_commission_amount" />
                                                                </div>
                                                            </td>
                                                            @endif  
                                                            @if(systemConfig()[30] == 1)
                                                            <td v-show="seeCost==true"> 
                                                                @{{(item.item==null)? 0:myRound((((item.item.site)?item.item.site.cost:item.item.LasCost) * item.item.measure.measure_unit / item.item.measure_unit) * selected_currency.static_rate / selected_currency.rate)}}
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                            @else 
                                                            <td v-show="seeCost==true"> 
                                                                @{{(item.item==null)? 0:myRound((((item.item.site)?item.item.site.cost:item.item.LasCost) * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                            @endif
                                                            <td v-show="seeCost==true">
                                                                @{{(item.item==null)?0:myRound((((item.item.site)?item.item.site.cost:item.item.LasCost) * item.item.measure.measure_unit / item.item.measure_unit))}}
                                                            </td>
                                                            <td>
                                                                <vue-numeric v-if="item.item"
                                                                    class="form-control chan_length"
                                                                    oninput = "autowidths(event)"
                                                                    v-model="item.item.cost"
                                                                    :max="99999999999999"
                                                                    currency=""
                                                                    :precision="precision()"
                                                                    @input="setNewRate('inventory',index)"
                                                                    >
                                                                </vue-numeric>
                                                                <input type="hidden" name="inventory_price[]" placeholder="@lang('layout.Price')" v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="in" >
                                                                <span v-show="((item.item==null)?null:checkCheap(item.item,selected_currency.rate,selected_currency.static_rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                            </td>
                                                            <td v-show="showWhat('sale_discount')=='yes'">
                                                                <div class="input-group">
                                                                    <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                    <span class="input-group-addon" v-if="discountIsAmount">
                                                                        @{{selected_currency.symbol}}
                                                                    </span>
                                                                    <span class="input-group-addon" v-if="!discountIsAmount">
                                                                        %
                                                                    </span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <input type="text" oninput = "autowidths(event)" placeholder="@lang('layout.Driver')" name="driver_name[]" class="form-control chan_length" />
                                                            </td>
                                                            <td>
                                                                <input type="text" placeholder="@lang('menu.Vehicle')" name="vehicle_name[]" oninput = "autowidths(event)" class="form-control chan_length" />
                                                            </td>
                                                            <td v-if="oil_sale == false">
                                                                @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate, discountIsAmount, item.item.discount, 1, null, item.item.differ,selected_currency.static_rate).result}} 
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                            <td v-if="oil_sale == true">
                                                                @{{(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate, discountIsAmount, item.item.discount, 1, item.item.differ,selected_currency.static_rate).result}}
                                                                @{{selected_currency.symbol}}
                                                            </td> 
                                                            <td>
                                                                <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>
                                                        <tr style="background-color: #ffffff;">
                                                            <td></td>
                                                            <td>
                                                                <center>
                                                                    <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                                                        <i class="fa fa-plus"></i>
                                                                    </button>
                                                                </center>
                                                            </td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <hr>
												<h3 style="margin-right:20px;">@lang('layout.Factor') @lang('layout.Loading')</h3>
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th style="">@lang('layout.Off') </th>
                                                            <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                            <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                            <th style="min-width: 130px">@lang('layout.VehicleName') </th>
                                                            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                                                            <th style="min-width: 100px">@lang('layout.FromSite') </th>
                                                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 100px">@lang('layout.LoadQuantity') </th>
                                                            <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                            <th style="min-width: 100px">@lang('layout.Driver') </th>
                                                            <!-- th style="">@lang('layout.SourcePlace') </th>
                                                            <th style="">@lang('layout.Destination') </th -->
                                                            @if(getShwoPriceLevel()=="per_item")
                                                            <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                            @endif
                                                            @if(getShwoPriceLevel()=="general_percent_per_item")
                                                            <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                            @endif
                                                            @if(getmine() == 'true')
                                                            <th style="min-width: 100px" v-if="other_type_of_percentage" >@lang('layout.Percentage') % </th>
                                                            <th style="min-width: 100px">@lang('layout.PerPercentPrice')</th>
                                                            <th style="min-width: 100px">@lang('layout.LaboratoryPercentage') % </th>
                                                            <th style="min-width: 100px" v-if="other_type_of_percentage" >@lang('layout.Differ')</th>
                                                            @endif
                                                            <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.CostInInventory')</th>
                                                            <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                                            <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                            <th style="min-width: 100px">@lang('layout.Total') </th>
                                                            <th style="min-width: 100px">@lang('layout.Type') </th>
                                                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 100px">@lang('layout.FinedAmount') </th>
                                                            <th style="min-width: 100px">@lang('layout.Amount') </th>
                                                            <th style="min-width: 100px">@lang('layout.Currency') </th>
                                                            <th style="min-width: 100px">@lang('layout.Rate') </th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in load_inventories">
                                                            <td @click="addNew('load_inventory',index)">@{{index+1}}</td>
                                                            <td>
                                                                <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" :name="'load_off['+index+']'" v-model="item.load_off" checked />
                                                                <span></span>
                                                                </label>
                                                                </div>
                                                            </td>
                                                            <td @click="addNew('load_inventory',index)" v-show="showWhat('sale_category')=='yes'">
                                                                <v-select label="name" v-model="item.item_category" :options="inventory_category"  @input="loadItemCategoryChange(index)"></v-select>
                                                                <input type="hidden" :name="'load_inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                                                            </td>
                                                            <td @click="addNew('load_inventory',index)" class="highlight">
                                                                <v-select label="name" @keyup.native="editKey = true, setClearIndex(index)" @click.native="editKey = true, setClearIndex(index)" @input="(editKey)?loadOnItemload(index):''"
                                                                v-model="item.inventory" :options="load_temp_items" @search="loadOnItemSearch"></v-select>
                                                                <input type="hidden" :name="'load_inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                            </td>
                                                            <td @click="addNew('load_inventory',index)" class="highlight">
                                                                <v-select label="name" @keyup.native="editKey = true, setLoadIndex(index)" @click.native="editKey = true, setLoadIndex(index)" @input="(editKey)?loadOnItemloadTransfer(index):''"
                                                                v-model="item.loading" :options="item.temp_loading" @search="onItemSearchLoading"></v-select>
                                                                <input type="hidden" :name="'loading_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')"  :value="(!item.loading)?null:item.loading.id">
                                                                <span class="required">@{{ errors.first('loading_id['+index+']') }}</span>
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.cmr_number}}
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control" disabled>
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item != null)">
                                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                        </option> 
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" :name="'load_site['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                            </td>
                                                            <td @click="addNew('load_inventory',index)">
                                                                <input type="number" :name="'load_inventory_quantity['+index+']'"
                                                                    v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                                    v-model.number="(item.item==null)?null:item.item.quantity"
                                                                    oninput = "autowidths(event)"
                                                                    class="form-control input-style input-number chan_length"
                                                                    @input="selectLoadType(index)"
                                                                    placeholder="@lang('layout.Quantity')">
                                                                <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                            </td>
                                                            <td>
                                                                @{{myRound((item.item==null)?null:item.item.load_quantity)}}
                                                            </td>
                                                            <td>
                                                                @{{myRound((item.item==null)?null:saleItemQuantity(item.item, Number(item.item.quantity) + Number(item.fined_quantity) + Number((item.load_type=='Leakage')?(item.load_quantity):0)))}}
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(item.item == null)?null:item.item.measure" @change="loadMeasureChange(index)" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                            @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" :name="'load_inventory_measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.driver_name}}
                                                            </td>
                                                            <!-- td>
                                                                @{{(item.item==null)?null:item.item.source}}
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.destination}}
                                                            </td -->
                                                            @if(getShwoPriceLevel()=="per_item")
                                                            <td>
                                                                <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_load(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="price_level in (item.item==null)?null:item.item.item_price_level" :value="price_level">
                                                                            @{{price_level.name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" name="load_item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                            </td>
                                                            @endif
                                                            @if(getShwoPriceLevel()=="general_percent_per_item")
                                                            <td>
                                                                <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item_load(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                            @{{price_level.name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" name="load_item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                            </td>
                                                            @endif
                                                            @if(getmine() == 'true') 
                                                            <td v-if="other_type_of_percentage"> 
                                                                <input type="number" name="load_percentage[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_load_price_by_percent(index)" v-model.number="(item.item==null)?null:item.item.percentage">
                                                            </td>
                                                            <td> 
                                                                <input type="number" name="load_per_percent_price[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_load_price_by_percent(index)" v-model.number="(item.item==null)?null:item.item.per_percent_price">
                                                            </td>
                                                            <td> 
                                                                <input type="number" name="load_laboratory_percentage[]" oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" @input="change_load_price_by_percent(index)" v-model.number="(item.item==null)?null:item.item.laboratory_percentage">
                                                            </td>
                                                            <td v-if="other_type_of_percentage"> 
                                                                <input type="number" name="load_differ_amount[]" oninput = "autowidths(event)" readonly
                                                                class="form-control input-style input-number chan_length" v-model.number="(item.item==null)?null:item.item.differ">
                                                            </td>
                                                            @endif
                                                            <td v-show="seeCost==true">
                                                                @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                            <td>
                                                                <vue-numeric v-if="item.item"
                                                                    class="form-control chan_length"
                                                                    oninput = "autowidths(event)"
                                                                    v-model="item.item.temp_price"
                                                                    :max="99999999999999"
                                                                    currency=""
                                                                    :precision="precision()"
                                                                    @input="setNewRate('loadInventory',index)"
                                                                    >
                                                                </vue-numeric>
                                                                <input type="hidden" :name="'load_inventory_price['+index+']'" placeholder="@lang('layout.Price')"
                                                                v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null , selected_currency.static_rate)" ref="load_in" >
                                                                <span v-show="((item.item==null)?null:checkCheap(item.item,selected_currency.rate, selected_currency.static_rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                            </td>
                                                            <td v-show="showWhat('sale_discount')=='yes'">
                                                                <div class="input-group">
                                                                    <input type="number" name="inventory_load_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                    <span class="input-group-addon" v-if="discountIsAmounttwo">
                                                                        @{{selected_currency.symbol}}
                                                                    </span>
                                                                    <span class="input-group-addon" v-if="!discountIsAmounttwo">
                                                                        %
                                                                    </span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate, discountIsAmounttwo, item.item.discount, 1, null, item.item.differ, selected_currency.static_rate).result}} 
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(item==null)?null:item.load_type" class="form-control">
                                                                    <option value="OverLoad">@lang('layout.OverLoad')</option>
                                                                    <option value="Leakage">@lang('layout.Leakage')</option>
                                                                </select>
                                                                <input type="hidden" name="load_type[]" :value="(item==null)?null:item.load_type">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'load_quantity['+index+']'" v-model.number="(item==null)?null:item.load_quantity" oninput = "autowidths(event)" class="form-control input-style input-number chan_length"
                                                                :placeholder="(item.load_type=='OverLoad')?`@lang('layout.OverLoad')`:`@lang('layout.LoadDrop')`">
                                                            </td>
                                                            <td>
                                                                <input v-show="(item.load_type=='Leakage')" type="number" :name="'load_fined_quantity['+index+']'" v-model.number="(item==null)?null:item.fined_quantity" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.FinedAmount')">
                                                            </td>
                                                            <td>
                                                                <input v-show="(item.load_type=='Leakage')" type="number" :name="'load_fined_cost['+index+']'" v-model.number="(item.item==null)?null:item.item.cost" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Amount')">
                                                            </td>
                                                            <td>
                                                                <v-select label="code" v-model="item.currency" :options="currency_list"></v-select>
                                                                <input type="hidden" name="load_fined_currency[]" :value="(!item.currency)?null:item.currency.code">
                                                            </td>
                                                            <td>
                                                                <input type="number" name="load_fined_currency_rate[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" v-model="(!item.currency)?null:item.currency.rate">
                                                            </td>
                                                            <td>
                                                                <span v-on:click="deleteItem('loadInventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
												<br/>
											</div>
											<hr/>
                                            <div class="row" style="overflow-x: scroll;">
                                                <!-- begin service -->
                                                <table id="table_content"
                                                    class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;"> #</th>
                                                            <th class="text-center" style="min-width: 130px;">@lang('layout.Contract') </th>
                                                            <th class="text-center" style="min-width: 130px;">@lang('layout.WagonNumber') </th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(service,index) in services">
                                                            <td>@{{index+1}}</td>
                                                            <td>
                                                                <v-select label="company_name" v-model="service.contract" :options="contracts"  @input="serviceContractWagon(index)"></v-select>
                                                                <input type="hidden" name="service_contract_id[]" :value="(!service.contract)?null:service.contract.id">
                                                            </td>
                                                            <td>
                                                                <v-select label="name" v-model="service.select_wagon" :options="service_wagon" ></v-select>
                                                                <input type="hidden" name="service_wagon_number[]" :value="(!service.select_wagon)?null:service.select_wagon.name">
                                                            </td>
                                                            <td class="highlight">
                                                                <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">
                                                                </v-select>
                                                                <input type="hidden" name="sale_order_service_id[]" :value="(service.item==null)?null:service.item.sale_order_service_id">
                                                                <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                            </td>
                                                            <td>
                                                                <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(service.item == null)?null:service.item.measure" class="form-control"  @change="measureChangeservice(index)">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(service.item ==null)?false:true">
                                                                        <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                            @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                            </td>
                                                            <td>
                                                                <div class="input-group">
                                                                    <input type="number" name="service_price[]" placeholder="@lang('layout.Price')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null , selected_currency.static_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                                                    <span class="input-group-addon">
                                                                        @{{selected_currency.symbol}}
                                                                    </span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                @{{
                                                                (service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result
                                                                }}
                                                                @{{selected_currency.symbol}}
                                                            </td>
                                                            <td>
                                                                <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <!-- end service -->
                                                <hr>
                                                {{-- Start of Good .................... --}}
                                                @if(voucherOfferingType() == '1')
                                                <!-- begin service -->
                                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;"> #</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Name')</th>
                                                            <th class="center">@lang('layout.Amount') </th>
                                                            <th class="center">@lang('layout.Date') </th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.AccountRegister')</th> 
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th> 
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(sale_info_expens,index) in sale_info_expense">
                                                            <td>@{{index+1}}</td>
                                                            <td>
                                                                <input class="form-control" type="text" name="name_info_expense[]" @click="addNew('sale_info_expens',index)" v-model.number="sale_info_expens.name_expense" placeholder="@lang('layout.Name')">
                                                            </td>
                                                            <td>
                                                                <input class="form-control" type="number" step="any" name="amount_info_expense[]" v-model.number="sale_info_expens.amount_expense" placeholder="@lang('layout.Amount')">
                                                            </td>
                                                            <td>
                                                                {{-- <input class="form-control date" autocomplete="off" name="date_info_expense[]" v-model.number="sale_info_expens.date_expense" placeholder="@lang('layout.Date')"> --}}
                                                                <date_picker :name="'date_info_expense['+index+']'" v-model="sale_info_expens.date_expense" placeholder="@lang('layout.Date')" ></date_picker>
                                                            </td>
                                                            <td>
                                                                <input class="form-control" type="text" name="account_register_info_expense[]" v-model.number="sale_info_expens.account_register_expense" placeholder="@lang('layout.AccountRegister')">
                                                            </td>
                                                            <td>
                                                                <input class="form-control" type="text" name="description_expense[]" v-model.number="sale_info_expens.description_expense" placeholder="@lang('layout.Description')">
                                                            </td> 
                                                            <td>
                                                                <span v-on:click="deleteItem('sale_info_expens',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <!-- end sale_info_expens -->
                                                @endif
                                                <hr>
                                                <!-- begin payments -->
                                                @permission('receive-create')
                                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;"> #</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                            <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                            <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(payment,index) in payments">
                                                            <td>@{{index+1}}</td>
                                                            <td class="highlight">
                                                                <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">
                                                                </v-select>
                                                                <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                                            </td>
                                                            <td>
                                                                <span v-if="payment.item !=null">
                                                                    @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control"
                                                                placeholder="@lang('layout.Rate')"/>
                                                                <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                                                                <input v-if="payment.item !=null" type="hidden" name="payment_rate_hq[]" v-bind:value="payment.item.hq_rate">
                                                            </td>
                                                            <td>
                                                                <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured/>
                                                                <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code"/>
                                                            </td>
                                                            <td>
                                                                <vue-numeric v-if="payment.item" class="form-control" v-model="payment.item.amount" :max="99999999999999" :currency="payment.item.code" :precision="precision()" >
                                                                </vue-numeric>
                                                                <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">
                                                            </td>
                                                            <td>
                                                                <div class="input-group">
                                                                    <input type="number" class="form-control" readonly
                                                                        :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result"
                                                                        placeholder="@lang('layout.Total')" style="min-width: 100px"/>
                                                                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                @endpermission
                                                <!-- end payments -->
                                                <hr/>
                                                @if(getInvoicePayment()== "true")
                                                <!-- begin Invoic  payments -->
                                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th colspan="6" style="min-width: 100px;">
                                                                <i class="fa fa-money" style="color: green"></i>&nbsp; @lang('layout.InvoicePayment') : (@lang('message.InvoicePaymetNote'))
                                                            </th>
                                                        </tr>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;"> #</th>
                                                            <th class="text-center" style="min-width: 80px;">@lang('layout.Currency') <span class="required"> * </span></th>
                                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate') <span class="required"> * </span></th>
                                                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount') <span class="required"> * </span></th>
                                                            <th class="text-center" style="min-width: 100px;"> @lang('layout.Description') <span class="required"> * </span></th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(payment_invoice,index) in payment_invoices">
                                                            <td>@{{index+1}}</td>
                                                            <td>
                                                                <v-select label="code" @input="selectedRate" :options="setRates" v-model="payment_invoice.selected_payment_currency"></v-select>
                                                                <input type="hidden" :name="'currency_payment['+index+']'" :value="(!payment_invoice.selected_payment_currency)?null:payment_invoice.selected_payment_currency.code">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'currency_payment_rate['+index+']'" class="form-control" v-bind:readonly="(payment_invoice.selected_payment_currency==null)?false:(payment_invoice.selected_payment_currency.code =='{{getHomeCurrency()['code']}}')" v-model="(!payment_invoice.selected_payment_currency)?null:payment_invoice.selected_payment_currency.rate" :class="{'has-error':rate<=0}">
                                                            </td>
                                                            <td>
                                                                <input type="number" name="amount_payment[]" class="form-control">
                                                            </td>
                                                            <td>
                                                                <textarea class="form-control" name="payment_description[]"></textarea>
                                                            </td>
                                                            <td>
                                                                <span v-on:click="deleteItem('payment_invoice',index)">
                                                                    <i class="paddint-both glyphicon glyphicon-trash" style="color: red"></i>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <tr style="background-color: #ffffff;">
                                                            <td></td>
                                                            <td>
                                                                <center>
                                                                    <button type="button" @click="addNew('payment_invoice',1000)" class="btn btn-success">
                                                                        <i class="fa fa-plus"></i>
                                                                    </button>
                                                                </center>
                                                            </td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <!-- end Invoice payments -->
                                                <hr/>
                                                @endif
                                            </div>
                                            {{-- <div class="row">
                                            @if(getWhatsApp() =='true')                
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox"  name="whatsapp" value="2" />
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            </div> --}}
                                            <div class="row" style="margin-top: 20px;">
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <table class="table table-striped table-bordered table-advance ">
                                                        <tr>
                                                            <td class="t_body">
                                                                <div>
                                                                    <label class="">@lang('layout.PrintFactor') </label>
                                                                    <select name="print_factor_type" id="" class="form-control">
                                                                        <option value=""> @lang('layout.Select') </option>
                                                                        <option value="A4">A4</option>
                                                                        <option value="A5">A5</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                            <div class="row">
                                                @if(voucherOfferingType() == '1')
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.OtherCurrency')</label>
                                                            <v-select label="code" @input="selectedRateOther"  :options="currency" v-model="selected_currency_other" auto></v-select>
                                                            <input type="hidden" name="currency_other" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency_other.code">
                                                            <span class="required">@{{ errors.first('currency') }}</span>
                                                        </div>
                                                    </div>
                                                </div> 
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Rate')</label>
                                                            <input type="number" name="currency_rate_other" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency_other?0:selected_currency_other.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                            <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Memo')</label>
                                                            <textarea name="memo" class="form-control" rows="2"></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="((!isError) && (number_Error == false))" :disabled="disabled" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                            <button type="button" class="btn blue" @click="saveAndNew($event)" :disabled="disabled" v-if="((!isError) && (number_Error == false))" >@lang('layout.SaveAndNew')</button>
                                            <a href="{{route('projectInvoice.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>
                                        <cmodal :show='showModal' @close="showModal=false">
                                        </cmodal>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script type="text/javascript">
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        Vue.use(VueInputAutowidth);
        Vue.use(VueNumeric.default);
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });
        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();

                    console.log('Lala',datas)
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        // end new member
        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var all_services = {!! $all_services !!};
        var inventory_category = {!! $inventory_category !!};
        var contracts = {!!$contracts!!};

        var seePrice ={!! $seePrice !!};
        var seeCost ={!! $seeCost !!};

        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        let mainHomeCurrency = {!! $mainHomeCurrency !!};
        var site = {!! $site !!};
        var load_id = {!! $load_id !!};
        var wagon = {!! $wagon !!};
        var discountDate = {!! $discountDate !!};
        var priceLevel = {!!$priceLevel!!};
        var priceLevelGeneral = {!!$priceLevelGeneral!!};
        var commission = {!! $commission !!};

        var v = new Vue({
            el: '#appInvoice',
            data: {
                percentage:0,
                AmountPercentage: 0,
                per_percent_price:0,
                laboratory_percentage:0,
                differ:0,
                dynamic_time:'',
                number: "{{$number}}",
                number_msg: '',
                seePrice: seePrice,
                commission: commission,
                selected_commission: null,
                subTotalCommi:0,
                totalCommi:0,
                forgivness: '',
                seeCost: seeCost,
                number_Error: false,
                editKey: false,
                discount_date: discountDate,
                selected_discount_date: null,
                showModalSaleOrder: false,
                showModal: false,
                other_type_of_percentage: false,
                invoiceDescription: null,
                commissionFiled : 0,
                saleOrderList: [],
                percentages: [],
                selected_sale_order: null,
                oil_sale: false,
                setDatas: [],
                customer: [],
                site: site,
                isError1: false,
                contracts: contracts,
                service_wagon: [],
                wagon: wagon,
                wagon_all: wagon,
                discountFiledRow: 0,
                discountFiledRowtwo: 0,
                selected_customer: null,
                member_id: null,
                priceLevel: priceLevel,
                selected_priceLevel: null,
                priceLevelGeneral: priceLevelGeneral,
                selected_priceLevelGeneral: null,
                banks: banks,
                all_services: all_services,
                sum_commission: 0,
                selected_banks: null,
                currency: currency,
                selected_currency:  {!!json_encode(getHomeCurrency()) !!},
                selected_currency_other: {!!json_encode(getHomeCurrency()) !!},
                currency_list: currency,
                sale_info_expense: [
                    {
                    name_expense: null,
                    amount_expense: null,
                    date_expense: null,
                    account_register_expense: null,
                    description_expense: null
                    }
                ],
                rate: 0,
                discountFiled: 0,
                discountFiledtwo: 0,
                discountIsAmount: false,
                commissionIsAmount: false,
                discountIsAmounttwo: false,
                disabled: false,
                summary: [],
                temp_items: [],
                load_temp_items: [],
                temp_loading: [],
                totalAmountes: [],
                types: null,
                ref_no: '',
                inventory_category: inventory_category,
                selected_index: 0,
                selected_load_index: 0,
                NumberPercentage: 0,
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [
                    {item: null, location: null, commission: 'on', item_category: null, contract: null, select_wagon: null, price_level:null},
                ],
                load_inventories: [
                    {item: null,inventory:null, loading:null, temp_loading:[], load_type:'OverLoad', load_off:true, load_quantity:null, fined_quantity:null, item_category: null, driver: null,vehicle:null, currency: homeCurrency, price_level:null},
                ],
                services: [
                    {
                        items: all_services,
                        item: null,
                        contract: null,
                        select_wagon: null,
                    },
                    {
                        items: all_services,
                        item: null,
                        contract: null,
                        select_wagon: null,
                    },
                ],
                payment_invoices: [{
                    selected_payment_currency: null
                }],
                payments: [],
                CusTypes: null,
            },
            computed: {
                setRates() {
                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {
                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    static_rate: a.static_rate,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });
                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });
                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                static_rate: a.static_rate,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks = [];
                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    static_rate: a.static_rate,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });
                    return rates;
                },
                selectedRate() {
                    if(this.selected_currency){
                        var newrate = (this.selected_currency) ? this.selected_currency.rate : 0;
                        if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0) {
                            this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                        }
                        if (this.discountIsAmounttwo && this.discountFiledtwo && this.rate > 0 && newrate > 0) {
                            this.discountFiledtwo = ((this.discountFiledtwo / this.rate) * newrate);
                        }
                        this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                        for (var i = 0; i < this.inventories.length; i++) {
                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                if (this.inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                }
                            }
                        }
                        for (var i = 0; i < this.load_inventories.length; i++) {
                            if (this.load_inventories[i].item && this.load_inventories[i].item != null) {
                                if (this.load_inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                    this.load_inventories[i].item.temp_price = this.load_inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.load_inventories[i].item.temp_price = this.load_inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                }
                            }
                        }
                    }
                },
                selectedRateOther(){
                if (this.selected_currency_other) {
                    this.selected_currency_other ? this.selected_currency_other.rate : 0;
                    }
                },
                discount() {
                if (this.discountIsAmount) {
                    if (this.subtotal > 0 && this.discountFiled) {
                        return (Number.parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else {
                    return this.discountFiled
                }
            },
            discounttwo() {
                if (this.discountIsAmounttwo) {
                    if (this.subtotal > 0 && this.discountFiledtwo) {
                        return (Number.parseFloat(this.discountFiledtwo) * 100) / (this.subtotal - this.discountFiledRowtwo);
                    } else {
                        return 0;
                    }
                } else { 
                    return this.discountFiledtwo
                } 
            },
            // calculate subtotal
            subtotal: function () {
                var sum = 0;
                var sum_discount = 0;
                var sum_discounttwo = 0; 
                var sum_commission = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if(this.oil_sale == true){
                        var quantity = this.inventories[i]['item']['oil_qty'];
                        }else{
                        var quantity = this.inventories[i]['item']['quantity'];
                        }
                        var rate = this.inventories[i]['item']['rate'];
                        var new_rate = this.inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        var differ = this.inventories[i]['item']['differ'];
                        var discount = this.inventories[i]['item']['discount'];
                        var selected_row_commission = this.inventories[i]['row_commission_percent'];
                        if (new_rate != rate && quantity > 0) { 
                            @if(systemConfig()[30] == 1)
                            sum += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) + (differ * quantity));
                            @else 
                            sum += ((new_rate * quantity * this.selected_currency.rate) + (differ * quantity));
                            @endif
                            if (this.discountIsAmount) {
                            if (discount > 0) {
                                sum_discount += (discount * quantity);
                            }
                        } else {    
                            if (discount > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_discount += (Number.parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                @else 
                                sum_discount += (Number.parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                @endif 
                            }
                        } 
                        if (this.commissionIsAmount) {
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                sum_commission += (quantity * selected_row_commission);
                                this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                            }
                        }else{
                        if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                            @if(systemConfig()[30] == 1)
                            sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                            this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                            @else 
                            sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                            this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                            @endif
                        }
                        }   
                        }
                        else {
                            @if(systemConfig()[30] == 1)
                            sum += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) + (differ * quantity));
                            @else 
                            sum += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) + (differ * quantity));
                            @endif
                            if (this.discountIsAmount) {
                            if (discount > 0) {
                                sum_discount += (discount * quantity);
                            }
                        } else { 
                            if (discount > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_discount += (Number.parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                @else 
                                sum_discount += (Number.parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                @endif
                            }
                        } 
                        if (this.commissionIsAmount) {
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                sum_commission += (quantity * selected_row_commission);
                                this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                            }
                        }else{
                        if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                        @if(systemConfig()[30] == 1)
                        sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                        this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                        @else 
                        sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                        this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                        @endif
                        }
                        }
                        }
                    }
                }
                this.discountFiledRow = sum_discount;  
                for (var i = 0; i < this.load_inventories.length; i++) {
                    if (this.load_inventories[i].item && this.load_inventories[i].item != null) {
                        var quantity = this.load_inventories[i]['item']['quantity'];
                        var rate = this.load_inventories[i]['item']['rate'];
                        var new_rate = this.load_inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.load_inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.load_inventories[i]['item']['measure_unit'];
                        var differ = this.load_inventories[i]['item']['differ'];
                        var load_discount = this.load_inventories[i]['item']['discount'];
                        if (new_rate != rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) + (differ * quantity));
                            @else 
                            sum += ((new_rate * quantity * this.selected_currency.rate) + (differ * quantity));
                            @endif
                            if (this.discountIsAmounttwo) {
                                if (load_discount > 0) {
                                    sum_discounttwo += (load_discount * quantity);
                                }
                            } else { 
                                if (load_discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discounttwo += (Number.parseFloat(load_discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
                                    sum_discounttwo += (Number.parseFloat(load_discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif 
                                }
                            }
                        }
                        else {
                            @if(systemConfig()[30] == 1)
                            sum += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) + (differ * quantity));
                            @else 
                            sum += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) + (differ * quantity));
                            @endif
                                if (this.discountIsAmounttwo) {
                            if (load_discount > 0) {
                                sum_discounttwo += (load_discount * quantity);
                            }
                        } else { 
                            if (load_discount > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_discounttwo += (Number.parseFloat(load_discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                @else 
                                sum_discounttwo += (Number.parseFloat(load_discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                @endif
                            }
                        }
                        }

                    }
                }
                this.discountFiledRowtwo = sum_discounttwo; 
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) {
                        var rate = this.services[i]['item']['rate'];
                        var new_rate = this.services[i]['item']['new_rate'];
                        var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.services[i]['item']['measure_unit'];
                        var quantity = this.services[i]['item']['quantity'];
                        if (new_rate != rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif
                        }
                        else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                        }
                    }
                } 
                if (this.selected_commission) {
                    var percent = this.selected_commission.percent;
                    if (this.commissionIsAmount) {
                        this.totalCommi = percent;
                        this.subTotalCommi = percent;
                    } else {
                        this.totalCommi = ((sum * percent) / 100);
                        this.subTotalCommi = ((sum * percent) / 100);
                    }
                    }else{
                        this.totalCommi = 0;
                        this.subTotalCommi = 0;
                    }
                    this.sum_commission = sum_commission;
                    return sum;     
                },
                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },
                // check data validation
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {
                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }
                    //      }
                    //    }
                    // }
                    if (this.selected_customer == null) {
                        isError = true;
                    }
                    return isError;
                },
            },
			mounted: function (v = this) {	
				if(load_id != null){
					console.log('klk',load_id);
					axios.get("{{route('callMethod.search')}}", {
						params: {
							method_name: 'onItemloadTransfer',
							inventory_id: 0,
							loading_id: load_id,
						}
					})
                    .then(function (response) {
                        // v.load_inventories[0].item = null;
                        console.log('asdasdas',response.data);
                        if (response.data.length > 0) {
                            console.log('asdasdas1111',response.data[0]);
                            v.load_inventories = [];
                            // this.load_inventories[0].item = response.data[0];
                            v.load_inventories.push({
                                loading: response.data[0].vehicle,
                                vehicle: response.data[0].vehicle,
                                driver: null,
                                temp_loading: [],
                                inventory: response.data[0],
                                item: response.data[0],
                                item_category: null,
                                load_off:true, 
                                load_type:'OverLoad', 
                                load_quantity:null,
                                fined_quantity:null,
                                currency: homeCurrency,
                                price_level:null
                            });
                            v.load_inventories.push(
                                {
                                item: null
                                ,inventory:null, 
                                loading:null, 
                                temp_loading:[], 
                                load_type:'OverLoad',
                                commission: 'on',
                                load_off:true, 
                                load_quantity:null, 
                                fined_quantity:null, 
                                item_category: null, 
                                driver: null,
                                vehicle:null, 
                                currency: homeCurrency, 
                                price_level:null
                                }
                            );	
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
				}
                var selected_banks = null;
                var bank=_.find(this.banks,(v)=>v.id=={!! getDropdown('invoice', 'account') !!});
                if (bank) {
                    selected_banks = bank;
                }
                this.payments.push({
                    items: this.banks,
                    item: selected_banks
                });
                this.dynamicTime()
            },
            methods:
            {
                    checkRefNo() {
                        setTimeout(() => {
                            var chack = 'false';
                            var ref_no = v.ref_no;
                            var category = v.category;
                            if (ref_no != null) {
                                axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        category: v.category,
                                        table_name: 'sales'
                                    },
                                })
                                .then(function(response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    } else {
                                        v.msg = 'no';
                                        v.isError1 = false;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });
                            } 
                        }, 400);
                    },
                    //BEGIN - Used for dynamic input time
                    dynamicTime()
                    {
                        this.time_interval = setInterval(() => {
                            const now = new Date()
                            @if(getHourType() == 24)
                                const hours = now.getHours().toString().padStart(2,'0')
                                const minutes = now.getMinutes().toString().padStart(2,'0') 
                                // const seconds = now.getSeconds().toString().padStart(2,'0')
                                this.dynamic_time = `${hours}:${minutes}`
                            @else
                                const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                this.dynamic_time = `${timeString}`
                            @endif
                            
                        },1000);
                    },
                    stopDynamicTime()
                    {
                        clearInterval(v.time_interval)
                    },
                    changeTime()
                    {
                        v.dynamic_time = v.$refs.time_input.value
                    },
                    //END - Used for dynamic input time
                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level(index) {
                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;
                            var item_price_level = this.inventories[index].item.item_price_level;
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;
                            // console.log("SAEED", this.inventories[index].item.new_rate, temp)
                            var myDataArray = this.inventories[index].item.item_price_level;
                            if (this.inventories[index].price_level != undefined) {
                                var item = this.inventories[index].item;
                                for (var i = 0; i < myDataArray.length; i++) {
                                    if (myDataArray[i]['id'] == this.inventories[index].price_level.id) {
                                        var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                        result = Number.parseFloat(temp).toFixed(precision());
                                        // if (this.selected_currency.rate > 0) {
                                        //     item.new_rate = myRound((result) / this.selected_currency.rate);
                                        // } else {
                                            item.new_rate = myRound(result);
                                        // }
                                    }
                                }
                            }
                        }
                    },
                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_load(index) {
                        if (this.load_inventories[index].item != null) {
                            var item = this.load_inventories[index].item;
                            var item_price_level = this.load_inventories[index].item.item_price_level;
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.load_inventories[index].item.new_rate = result;
                            var myDataArray = this.load_inventories[index].item.item_price_level;
                            if (this.load_inventories[index].price_level != undefined) {
                                var item = this.load_inventories[index].item;
                                for (var i = 0; i < myDataArray.length; i++) {
                                    if (myDataArray[i]['id'] == this.load_inventories[index].price_level.id) {
                                        var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                        result = Number.parseFloat(temp).toFixed(precision());
                                        // if (this.selected_currency.rate > 0) {
                                        //     item.new_rate = myRound((result) / this.selected_currency.rate);
                                        // } else {
                                            item.new_rate = myRound(result);
                                        // }
                                    }

                                }
                            }
                        }
                    },
                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_general() {  
                        if (this.inventories != null && this.selected_priceLevelGeneral) {
                            var price_type = this.selected_priceLevelGeneral.price_type;
                            var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);
                            for (var i = 0; i < this.inventories.length; i++) {
                                if (this.inventories[i].item && this.inventories[i].item != null) {
                                    var rate = this.inventories[i]['item']['rate'];
                                    var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                    var measure_unit = this.inventories[i]['item']['measure_unit'];
                                    var rate1 = (rate * smeasure_unit / measure_unit);
                                    rate1 = Number.parseFloat(rate1);
                                    if(price_type == 'up' && percent > 0 && rate1 > 0){
                                        var result = Number.parseFloat((rate1 * percent) / 100);
                                        this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                    } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                        var result = Number.parseFloat((rate1 * percent) / 100);
                                        this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                    }  
                                }
                            }
                        }
                        if (this.load_inventories != null && this.selected_priceLevelGeneral) {
                            var price_type = this.selected_priceLevelGeneral.price_type;
                            var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);   
                            for (var i = 0; i < this.load_inventories.length; i++) {
                                if (this.load_inventories[i].item && this.load_inventories[i].item != null) {
                                    var rate = this.load_inventories[i]['item']['rate'];
                                    var smeasure_unit = this.load_inventories[i]['item']['measure']['measure_unit'];
                                    var measure_unit = this.load_inventories[i]['item']['measure_unit'];
                                    var rate1 = (rate * smeasure_unit / measure_unit);
                                    rate1 = Number.parseFloat(rate1);
                                    if(price_type == 'up' && percent > 0 && rate1 > 0){
                                        var result = Number.parseFloat((rate1 * percent) / 100);
                                        this.load_inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                    } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                        var result = Number.parseFloat((rate1 * percent) / 100);
                                        this.load_inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                    }  
                                }
                            }
                        }
                    },
                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_general_per_item(index) {  
                        if (this.inventories != null) {
                            if (this.inventories[index].item != null) {
                                var item = this.inventories[index].item;
                                var item_price_level = this.inventories[index].price_level;
                                var price_type = item_price_level.price_type;
                                var percent = Number.parseFloat(item_price_level.percent);
                                var rate = this.inventories[index]['item']['rate'];
                                var smeasure_unit = this.inventories[index]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[index]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);
                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                } 
                            }
                        }
                    },
                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_general_per_item_load(index) {
                        if (this.load_inventories != null) {
                            if (this.load_inventories[index].item != null) {
                                var item = this.load_inventories[index].item;
                                var item_price_level = this.load_inventories[index].price_level;
                                var price_type = item_price_level.price_type;
                                var percent = Number.parseFloat(item_price_level.percent);          
                                var rate = this.load_inventories[index]['item']['rate'];
                                var smeasure_unit = this.load_inventories[index]['item']['measure']['measure_unit'];
                                var measure_unit = this.load_inventories[index]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);
                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.load_inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.load_inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                } 
                            }
                        }
                    },
                    changePriceLevel() {
                        this.inventories = [];
                        this.inventories.push({
                            inventory: null,
                            item: null,
                            location: null,
                            item_category: this.selected_iventory_category,
                            item_brand: null,
                            tax: 'on',
                            commission: 'on',
                            selected_taxation: null,
                            sub_total: '',
                            inventory_site: this.selected_iventory_site,
                            price_level: null
                        });
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                //console.log(v.member_chack());
                                if (v.member_chack() == 'true') {
                                    var r = confirm("@lang('layout.member_payable_levels')");
                                    if (r == true) {
                                        v.disabled = true;
                                        v.submitForm(e.target);
                                    }
                                } else {
                                    v.disabled = true;
                                    v.submitForm(e.target);
                                }
                            }
                        });
                    },
                    checkNo() {
                        var chack = 'false';
                        var number = v.number;
                        if (number != null) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    number: v.number,
                                    method_name: 'Search_number',
                                    table_name: 'sales'
                                },
                            })
                            .then(function(response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    // console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    v.number_msg = "@lang('layout.DuplicateData')";
                                    v.number_Error = true;
                                } else {
                                    v.number_msg = 'no';
                                    v.number_Error = false;

                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                        }
                    },
					ChangeOil() {
                        if (v.oil_sale == false) {
							v.oil_sale = true;
                        }else{
							v.oil_sale = false;
						}
						// console.log(v.oil_sale);
                    },
					change_oil_qty(index) {
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
							var quantity = this.inventories[index]['item']['quantity'];
							var density = this.inventories[index]['item']['density'];
							if(quantity > 0 && density > 0){
							this.inventories[index]['item']['oil_qty'] = myRound(quantity / density);
							}
							// var oil_qty = this.inventories[index]['item']['oil_qty'];
                        }
                    },
                    change_qty_by_oil(index) {
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                            var oil_qty = this.inventories[index]['item']['oil_qty'];
                            var density = this.inventories[index]['item']['density'];
                            if (oil_qty > 0 && density > 0) {
                                this.inventories[index]['item']['quantity'] = myRound(oil_qty * density);
                            }
                        }
                    },
                    change_price_by_percent(index) {
                        //{{-- 'percentage' 'per_percent_price' 'percent_rate' 'percent_currency' 'laboratory_percentage' 'differ' --}}
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                            var percentage = this.inventories[index]['item']['percentage'];
                            var per_percent_price = this.inventories[index]['item']['per_percent_price'];
                            var percent_rate = this.inventories[index]['item']['percent_rate'];
                            var percent_currency = this.inventories[index]['item']['percent_currency'];
                            var laboratory_percentage = this.inventories[index]['item']['laboratory_percentage'];
                            var differ = this.inventories[index]['item']['differ'];
                            if (this.other_type_of_percentage) {
                                if (percentage > 0 && per_percent_price > 0 && laboratory_percentage > 0) {
                                    var differ = myRound((Number.parseFloat(laboratory_percentage) - Number.parseFloat(percentage)) * Number.parseFloat(per_percent_price));
                                    this.inventories[index]['item']['differ'] = differ;
                                    // if(this.selected_currency.code == percent_currency){
                                    //     var differ_amount = (differ * Number.parseFloat(per_percent_price));
                                    //     console.log(differ_amount);
                                    //     this.inventories[index].item.new_rate = (this.inventories[index].item.cost + differ_amount) / this.selected_currency.rate;
                                    // } else {
                                    //     var differ_amount = (differ * Number.parseFloat(per_percent_price));
                                    //     this.inventories[index].item.new_rate = (this.inventories[index].item.cost + differ_amount) / this.selected_currency.rate; 
                                    // }
                                    
                                    // this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                                } else {
                                    this.inventories[index]['item']['differ'] = 0;
                                }
                            } else {
                                if (per_percent_price > 0 && laboratory_percentage > 0) {
                                    var differ = myRound(Number.parseFloat(laboratory_percentage) * Number.parseFloat(per_percent_price));
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[index].item.new_rate = differ / this.selected_currency.static_rate * this.selected_currency.rate; 
                                    @else 
                                    this.inventories[index].item.new_rate = differ / this.selected_currency.rate; 
                                    @endif
                                    this.inventories[index].item.cost = differ; 
                                }
                                this.inventories[index]['item']['differ'] = 0;
                            }
                        }
                    },
                    change_price_by_percentage(index){
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                            var laboratory_percentage = Number.parseFloat(this.inventories[index]['item']['laboratory_percentage']);
                            var selected_sale_order = this.selected_sale_order;
                            // this.AmountPercentage
                            if (this.selected_sale_order && laboratory_percentage > 0) {
                                if (this.selected_sale_order.percentageData) {
                                    for(var i = 0; i<this.selected_sale_order.percentageData.length; i++){
                                        // console.log(1221, this.selected_sale_order.percentageData[i]);
                                        var from_percentage = Number.parseFloat(this.selected_sale_order.percentageData[i].from_percentage);
                                        var to_percentage = Number.parseFloat(this.selected_sale_order.percentageData[i].to_percentage);
                                        if (laboratory_percentage >= from_percentage && laboratory_percentage <= to_percentage) {
                                            this.inventories[index]['item']['per_percent_price'] = Number.parseFloat(this.selected_sale_order.percentageData[i].amount);
                                            this.inventories[index]['item']['percentage'] = from_percentage;
                                        }
                                    }
                                }
                            }
                        }
                        this.change_price_by_percent(index);  
                    },
                    change_load_price_by_percent(index) {
                        if (this.load_inventories[index]['item'] && this.load_inventories[index]['item'] != null) {
                            var percentage = this.load_inventories[index]['item']['percentage'];
                            var per_percent_price = this.load_inventories[index]['item']['per_percent_price'];
                            var percent_rate = this.load_inventories[index]['item']['percent_rate'];
                            var percent_currency = this.load_inventories[index]['item']['percent_currency'];
                            var laboratory_percentage = this.load_inventories[index]['item']['laboratory_percentage'];
                            var differ = this.load_inventories[index]['item']['differ'];
                            if (this.other_type_of_percentage) {
                                if (percentage > 0 && per_percent_price > 0 && laboratory_percentage > 0) {
                                    var differ = myRound((Number.parseFloat(laboratory_percentage) - Number.parseFloat(percentage)) * Number.parseFloat(per_percent_price));
                                    this.load_inventories[index]['item']['differ'] = differ;
                                } else {
                                    this.load_inventories[index]['item']['differ'] = 0;
                                }
                            } else {
                                if (per_percent_price > 0 && laboratory_percentage > 0) {
                                    var differ = myRound(Number.parseFloat(laboratory_percentage) * Number.parseFloat(per_percent_price));
                                    @if(systemConfig()[30] == 1)
                                    this.load_inventories[index].item.new_rate = differ / this.selected_currency.static_rate / this.selected_currency.rate; 
                                    @else 
                                    this.load_inventories[index].item.new_rate = differ / this.selected_currency.rate; 
                                    @endif
                                    this.load_inventories[index].item.cost = differ; 
                                }
                                this.load_inventories[index]['item']['differ'] = 0;
                            }
                        }
                    },
                    // chack_member_payable_levels
                    member_chack() {
                        var chack = 'false';
                        var member_id = v.member_id;
                        if (member_id != null) {
                            var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                            var currency = $("input[name=currency]").val();
                            $.ajax({
                                url: "{{route('callMethod.search')}}",
                                async: false,
                                data: {
                                    member_id: v.member_id,
                                    method_name: 'Search_member_payable_levels',
                                    currency: currency,
                                },
                                success: function (data) {
                                    var r_amount = Number.parseFloat(data.amount);
                                    var r_m_amount = Number.parseFloat(data.m_amount);
                                    var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                                    //console.log(r_m_amount);
                                    //console.log('--');
                                    //console.log(totals);
                                    if (r_amount != 0 && r_amount < totalss) {
                                        chack = 'true';
                                    } else {
                                        chack = 'false';
                                    }
                                }.bind(this),
                                error: function (error) {
                                    console.log(error)
                                }
                            });
                            /*
                            axios.get("{{route('callMethod.search')}}",
				        {
                        params:{
                        member_id:v.member_id,
                        method_name:'Search_member_payable_levels',
                        currency:currency,
                        
                        },
				        })
                        .then(function (response)
                        {
                                var r_amount = response.data.amount;
                                var r_m_amount = response.data.m_amount;
                                if(r_amount < (r_m_amount + totals)){
                                    chack = 'true';
                                }
                        })
                        .catch(function (error)
                        {
                        console.log(error);
                        });
                        */
                        }
                        return chack;
                    },
                    // calculate item price based on measure change
                    measureChange(index) {
                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;
                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
                        }
                    },
                    // calculate item price based on measure change
                    loadMeasureChange(index) {
                        console.log(this.load_inventories[index].item);
                        if (this.load_inventories[index].item != null) {
                            var item = this.load_inventories[index].item;
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.load_inventories[index].item.new_rate = result;
                            @if(systemConfig()[30] == 1)
                            var temp1 = (Number.parseFloat(item.LasCost * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / Number.parseFloat(this.selected_currency.rate));
                            @else 
                            var temp1 = (Number.parseFloat(item.LasCost * item.measure.measure_unit / item.measure_unit) * Number.parseFloat(this.selected_currency.rate));
                            @endif
                            result1 = Number.parseFloat(temp1).toFixed(precision());
                            this.load_inventories[index].item.cost = result1;
                            // this.load_inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
                        }
                    },
                    // calculate item price based on measure change
                    measureChangeservice(index) {
                        if (this.services[index].item != null) {
                            var item = this.services[index].item;
                            @if(systemConfig()[30] == 1)
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            @endif
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.services[index].item.new_rate = result;
                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            v.member_id = this.selected_customer.id;
                            // get member contract
                            this.saleOrderSearch(this.selected_customer.id, this);
                            @if(getShwoPriceLevel()=="general_percent")
                            var price_level_id = this.selected_customer.price_level_id;
                            if(price_level_id){
                                this.selected_priceLevelGeneral = _.find(this.priceLevelGeneral, (s) => s.id == price_level_id);
                            }else{
                                this.selected_priceLevelGeneral = null;
                            }
                            @endif
                            this.getSummaryRecor(this.selected_customer.id, this);
                        }
                    },
                    selectMemeber(id = null) {
                        if (id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    id: id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    // console.log(response.data);
                                    v.selected_customer = null;
                                    v.selected_customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    memberClassChange() {
                        if (v.selected_class) {
                            v.customer = [];
                            // v.selected_customer = null;
                            let class_id = v.selected_class.id;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.customer = [];
                                    v.customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),
                    getSummaryRecor(id, v) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.summary = response.data;
                            } else {
                                v.summary = [];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    },
                    // sale order change
                    saleOrderChang() {
                        console.log('test 33');
                    },
                    // end sale order change
                    // set new price
                    setNewRate(type = null, index = null) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                                @endif
                                // this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
						if (type == 'loadInventory') {
                            if (this.load_inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.load_inventories[index].item.new_rate = this.load_inventories[index].item.temp_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.load_inventories[index].item.new_rate = this.load_inventories[index].item.temp_price / this.selected_currency.rate;
                                @endif
                                // this.load_inventories[index].item.new_rate = this.$refs.load_in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                // console.log('service changed');
                                @if(systemConfig()[30] == 1)
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }
                    },
                    //ajax call to get items
                    onItemSearch: _.debounce((search, loading) => {
                        let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : '';
                        let wagon_number = (v.inventories[v.selected_index]['select_wagon'] != undefined)?v.inventories[v.selected_index]['select_wagon'].name:null;
                        let price_level_id = (v.selected_priceLevel) ? v.selected_priceLevel.id : '';
                        loading(true);
                        axios.get("{{route('callMethod.search')}}",
                        {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSaleContract',
                                keyword: search,
                                contract_id: contract_id,
                                wagon_number: wagon_number,
                                price_level_id: price_level_id
                                //inventory_category_id:inventory_category_id
                            },
                        })
                        .then(function (response) {
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                                @if(getShwoPriceLevel()=="general_percent")
                                setTimeout((function () {
                                    v.change_sale_rate_by_price_level_general(); 
                                }), 400);
                                @endif
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                    }, getDebounceTime()),
                    locationSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                        let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : '';
                        let wagon_number = (v.inventories[v.selected_index]['select_wagon'] != undefined)?v.inventories[v.selected_index]['select_wagon'].name:null;
                        if (inventory_id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLocation',
                                    keyword: search,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                    inventory_id: inventory_id
                                }
                            })
                            .then(function(response) {
                                // console.log(132, response.data);
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['item']['locationList'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        } else {
                            loading(false);
                        }
                    }, getDebounceTime()),
                    locationItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].item != null && v.inventories[index].location != null) {
                            var inventory_id = v.inventories[index].item.id;
                            var location = v.inventories[index].location.name;
                            let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : '';
                            let wagon_number = (v.inventories[v.selected_index]['select_wagon'] != undefined)?v.inventories[v.selected_index]['select_wagon'].name:null;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSiteByLocation',
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                    inventory_id: inventory_id,
                                    location: location
                                }
                            })
                            .then(function(response) {
                                // console.log(4444, response.data);
                                if (response.data.item.length > 0) {
                                    v.inventories[index].item.site_list = response.data.item;
                                    v.inventories[index].item.site = response.data.selectItem;
                                    @if(costByLocation()=="true")
                                    if (response.data.selectItem) {
                                        v.inventories[index].item.LasCost = response.data.selectItem.cost;
                                        v.inventories[index].item.description = response.data.selectItem.description;
                                    }
                                    @endif
                                } else {
                                    v.inventories[index].item.site_list = [];
                                    v.inventories[index].item.site = null;
                                }

                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    // end item search
                    setIndex(e) {
                        // console.log('e', e);
                        this.selected_index = e;
                        // console.log('uuu', this.selected_index);
                        @if(getShwoPriceLevel()=="general_percent")
                        setTimeout((function () {
                            v.change_sale_rate_by_price_level_general(); 
                        }), 400);
                        @endif
                    },
                    itemCategoryChange() {
                        let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                        .then(function (response) {
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                    },
                    //
                    contractChange(index) {
                        this.selected_index = index;
                        //let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                        if (this.inventories[this.selected_index]['contract']) {
                        let contract_id = this.inventories[this.selected_index]['contract'].id;
                        let wagon_number = (this.inventories[this.selected_index]['select_wagon'])?this.inventories[this.selected_index]['select_wagon'].name:null;
                        let price_level_id = (v.selected_priceLevel) ? v.selected_priceLevel.id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSaleContract',
                                //inventory_category_id: inventory_category_id,
                                sale_order_id: (this.selected_sale_order)?this.selected_sale_order.id:'',
                                wagon_number: wagon_number,
                                contract_id: contract_id,
                                price_level_id: price_level_id
                            }
                        })
                        .then(function (response) {
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.inventories[index]['item'] = null;
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                        }
                    },
                    contractWagon(index) {
                        this.wagon = this.wagon_all;
                        if (this.inventories[index]['contract']) {
                            // console.log(2222,v.inventories[index]['contract'], this.wagon)
                            // contract_id = this.inventories[index]['contract'].id;s
                            this.wagon = this.wagon_all.filter((wagon) => {
                                return v.inventories[index]['contract'].id == wagon.contract_id;
                            });
                        }
                    },
                    serviceContractWagon(index) {
                        this.service_wagon = this.wagon_all;
                        if (this.services[index]['contract']) {
                            this.services[index]['select_wagon'] = null;
                            this.service_wagon = this.wagon_all.filter((wagon) => {
                                return v.services[index]['contract'].id == wagon.contract_id;
                            });
                        }
                    },
                    // contract search
					/// load part
					loadOnItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        // console.log('klk',v.load_inventories[v.selected_load_index]['item_category']);
                        let inventory_category_id = (v.load_inventories[v.selected_load_index]['item_category'] != undefined) ? v.load_inventories[v.selected_load_index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchLoading',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                        .then(function (response) {
                            if (response.data.length > 0) {
                                v.load_temp_items = [];
                                v.load_temp_items = response.data;
                                @if(getShwoPriceLevel()=="general_percent")
                                setTimeout((function () {
                                    v.change_sale_rate_by_price_level_general();
                                }), 400);
                                @endif
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
						
                    }, getDebounceTime()),
                    loadOnItemload(index) {
                        v.selected_index = index;
                        if (v.load_inventories[index].inventory != null) {
                            // console.log('klk',v.load_inventories[index]);
                            var inventory_id = v.load_inventories[index].inventory.id;
                            // let price_level_id = (v.selected_priceLevel) ? v.selected_priceLevel.id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchLoading',
                                    inventory_id: inventory_id,
                                    // price_level_id: price_level_id,
                                }
                            })
                            .then(function (response) {
                                v.load_inventories[index].item = null;
                                v.load_inventories[index].loading = null;
                                v.load_inventories[index].temp_loading = [];
                                if (response.data.length > 0) {
                                    v.load_inventories[index].temp_loading = response.data;
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general();
                                    }), 400);
                                    @endif
                                    
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                        }
                    },
                    onItemSearchLoading: _.debounce((search, loading) => {
                        loading(true);
                        var index = v.selected_load_index;
                        if (v.load_inventories[index].inventory != null) {
                            var inventory_id = v.load_inventories[index].inventory.id;      
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchLoading',
                                    inventory_id: inventory_id,
                                    keyword: search
                                }
                            })
                            .then(function (response) {
                                v.load_inventories[index].item = null;
                                v.load_inventories[index].loading = null;
                                v.load_inventories[index].temp_loading = [];
                                if (response.data.length > 0) {
                                    v.load_inventories[index].temp_loading = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                        }
						
                    }, getDebounceTime()),
                    setLoadIndex(index) {
                    v.selected_load_index = index;
                    },
                    setClearIndex(index) {
                    v.load_inventories[index].temp_loading = [];
                    v.selected_load_index = index;
                    },
                    loadOnItemloadTransfer(index) {
                        if (v.load_inventories[index].inventory != null && v.load_inventories[index].loading != null) {
                            var inventory_id = v.load_inventories[index].inventory.id;
                            var loading_id = v.load_inventories[index].loading.id;
                            let price_level_id = (v.selected_priceLevel) ? v.selected_priceLevel.id : '';
                            // console.log('klk',inventory_id,loading_id);
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'onItemloadTransfer',
                                    inventory_id: inventory_id,
                                    loading_id: loading_id,
                                    price_level_id: price_level_id,
                                }
                            })
                            .then(function (response) {
                                v.load_inventories[index].item = null;
                                if (response.data.length > 0) {
                                    v.load_inventories[index].item = response.data[0];
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                        }
                    },
					loadItemCategoryChange(index) {
                        v.selected_load_index = index;
                        v.selected_iventory_category = this.load_inventories[index]['item_category'];
                        if (this.load_inventories[index]['item_category'] != null) {
                            let inventory_category_id = (v.load_inventories[index]['item_category'] != undefined) ? v.load_inventories[index]['item_category'].id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLoading',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                            .then(function (response) {
                                v.load_temp_items = [];
                                if (response.data.length > 0) {
                                    v.load_temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
					/// load part
                    saleOrderSearch(id, vm) {
                        vm.saleOrderList = [];
                        vm.percentages = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberSaleOrder',
                                member_id: id,
                            }
                        })
                        .then(function (response) {
                            if (response.data.length > 0) {
                                vm.showModalSaleOrder = true;
                                vm.saleOrderList = response.data;
                                var percentages = response.data.percentageData;
                                console.log(percentages);
                            }
                            // loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                    },
                    getsalesOrders() {
                        this.showModalSaleOrder = false;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SaleOrderItems',
                                sale_order_id: this.selected_sale_order.id,
                                type: 'saleOrder'
                            }
                        })
                        .then(function (response) {
                            if (response.data.length > 0) {
                                v.inventories = [];
                                v.services = [];
                                for (var r = 0; r < response.data.length; r++) {
                                    if (response.data[r].type == 'item') {
                                        v.inventories.push({item: response.data[r], location: null, commission: 'on', item_category: null, contract: null, select_wagon: null});
                                    }
                                    if (response.data[r].type == 'service') {
                                        v.services.push({item: response.data[r], items: v.all_services, contract: null, select_wagon: null});
                                    }
                                }
                                v.inventories.push({item: null, location: null, commission: 'on', item_category: null, contract: null, select_wagon: null});
                                v.services.push({item: null, items: all_services, contract: null, select_wagon: null});
                                // console.log('test check', v.inventories);
                                v.invoiceDescription = v.selected_sale_order.description;
                                v.discountFiled = v.selected_sale_order.discount;
                                v.discountFiledtwo = v.selected_sale_order.discount;
                                if (v.selected_sale_order.discount_type) {
                                    if (v.selected_sale_order.discount_type == 'currency') {
                                        v.discountIsAmount = true;
                                    } else {
                                        v.discountIsAmount = false;
                                    }
                                }
                                if (v.selected_sale_order.discount_type) {
                                    if (v.selected_sale_order.discount_type == 'currency') {
                                        
                                        v.discountIsAmounttwo = true;
                                    } else {
                                        v.discountIsAmounttwo = false;
                                    }

                                }
                                for (var a = 0; a < this.currency.length; a++) {
                                    if (v.currency[a].code == v.selected_sale_order.currency) {
                                        v.selected_currency = v.currency[a];
                                        v.selected_currency.rate = v.selected_sale_order.rate;
                                        v.rate = v.selected_sale_order.rate;
                                    }
                                }
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                    },
                    // end contract search
                    selectLoadType(index) {
                        if (v.load_inventories[index].item && v.load_inventories[index].load_off == true) {
                            var quantity = Number.parseFloat(v.load_inventories[index].item.quantity);
                            var load_quantity = Number.parseFloat(v.load_inventories[index].item.load_quantity);
                            if (quantity > load_quantity) {
                                v.load_inventories[index].load_type = 'OverLoad';
                                v.load_inventories[index].load_quantity = Number.parseFloat(quantity - load_quantity).toFixed(precision());
                            }else{
                                v.load_inventories[index].load_type = 'Leakage';
                                v.load_inventories[index].load_quantity = Number.parseFloat(load_quantity - quantity).toFixed(precision());
                            }
                        }
                    },
                    // generic function for adding item to list
                    addNew(type = null, index) {
                        // this.temp_items = [];
                        if (type != null) {
                            @if(getShwoPriceLevel()=="general_percent")
                            setTimeout((function () {
                                v.change_sale_rate_by_price_level_general();
                            }), 400);
                            @endif
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, location: null, commission: 'on', item_category: null, contract: null, select_wagon: null, price_level:null});
                                }
                            }
                            if (type == 'load_inventory') {
                                this.selected_load_index = index;
                                if (this.load_inventories[index + 1] == undefined) {
                                    // this.temp_items = [];
									this.load_inventories.push(
										{item: null,inventory:null, loading:null,commission: 'on',  temp_loading:[], load_type:'OverLoad', load_off:true, load_quantity:null, fined_quantity:null, item_category: null, driver: null,vehicle:null, currency: homeCurrency, price_level:null}
									);
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                        contract: null, 
                                        select_wagon: null
                                    });
                                }
                            }
                            if (type == 'sale_info_expens') {
                                if (this.sale_info_expense[index + 1] == undefined) {
                                this.sale_info_expense.push({
                                name_expense: null,
                                amount_expense: null, 
                                date_expense: null,
                                account_register_expense: null,
                                description_expense: null 
                                }); 
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment_invoice') {
                                if (this.payment_invoices[index + 1] == undefined) {
                                    this.payment_invoices.push({
                                        selected_payment_currency: null
                                    });
                                }
                            }
                        }
                    },
                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;
                    },
                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;
                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        this.editKey = false;
                        if (type != null) {
                            // console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
							if (type == 'loadInventory') {
                                this.load_inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                            if (type == 'payment_invoice') {
                                this.payment_invoices.splice(index, 1);
                            }
                            if (type == 'sale_info_expens') {
                                this.sale_info_expense.splice(index, 1);
                            }
                        }
                    },
                    // submit the form
                    submitForm() {
                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        v.disabled = true;
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()
                            }
                            else {
                                v.disabled = false;
                            }
                        });
                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                v.disabled = true;
                                var url="{{route('projectInvoice.store')}}";
                                form_id='sales-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                    toggleBlock(0);
                                    if(response.data.result==1)
                                    {
                                        $('#'+form_id).trigger('reset');
                                        toastr.success('',response.data.message); 
                                        location.reload();
                                    }
                                    else
                                    {
                                        v.disabled = false;
                                        var message="{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('',message);
                                    }
                                })
                                .catch(function(error){
                                    v.disabled = false;
                                    toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            }
                        })
                    },
                },
        });
    </script>
@endpush