@extends('layouts.app')
@section('style')
<style type="text/css">
.modal-container{
    width: 30% !important;
}
</style>
@stop
@section('content')
@include('layouts.modal')



<!-- app -->
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract"/>
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            
        <div class="row">
            <div class="form-group">

                            <div  class="col-md-12">
                                <label class="control-label ">@lang('layout.ContractNumber') </label>
                              <!--   <v-select class="vue-select2" v-model="selectedMember" label="name"
                                          :options="member">
                                </v-select> -->
                                <input type="number" name="number" class="form-control" >
                            </div>


                        </div>
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        
                    <div slot="date">
                         <div class="input-group">
                            <input class="form-control" id="range-from-example" autocomplete="off" name="from_date">
                        
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control" id="range-to-example" autocomplete="off" name="to_date">
                           
                        </div>
                    </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>

    </div>
</modal>
{{Form::close()}}
</div>
<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract"/>
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div  class="col-md-12">
                        <label class="control-label ">@lang('layout.ContractNumber') </label>
                        <input type="number" name="number" class="form-control" >
                    </div> 
                </div>
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control" id="range-from-example2" autocomplete="off" name="from_date">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control" id="range-to-example2" autocomplete="off" name="to_date">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- app -->

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bortdered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.ProjectDetailsList')</span>
            </div>
            <div class="tools"> </div>
            <div class="pull-right">
                @permission('customers-list')

                <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>

                @endpermission
                @permission('customers-list')
                <a href="{{route('projectDetails.create')}}">
                    <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                    <button id="sample_editable_1_new" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission 
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="contracts">
                <thead>
                    <tr>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.ProjectName')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Location')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead> 
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET--> 


<!-- END CONTENT BODY -->
@stop

@push('scripts')
 

<script>
    Vue.component("v-select", VueSelect.VueSelect);
    
$(document).ready(function() { 
        $('#contracts').DataTable( {
            ajax:           '{{route("projectDetails.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [[ 6, "desc" ]],
                scrollCollapse: true,
                paging:         true,
                serverSide: true,
            columns: [  
            
            { data: 'number',    name: 'number' },
            { data: 'name',      name: 'name'},
            { data: 'customer',  name: 'members.name'},
            { data: 'startDate', name: 'startDate' , orderable:false,searchable:false},
            { data: 'location',  name: 'location' , orderable:false,searchable:false},
            { data: 'type',      name: 'type', orderable:false,searchable:false },
            { data: 'actions',   name: 'actions', orderable:false,searchable:false }
            ] 
    } );
    } );

 
// register modal component
var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});

new Vue({
    el: '#app',
    data: {
        showModal: false,
        selectedMember:null,
            member:null,
    },
    methods:{
        ok:function(){
//alert('you clicked me');
this.showModal = !this.showModal;
},
close:function(e)
{
    this.showModal = !this.showModal;
},
editExample : function(){
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
    $(document).ready(function(){
        var to, from;
        to = $("#range-to-example").persianDatepicker(modelDate());
        from = $("#range-from-example").persianDatepicker(modelDate());
    });
})
}
},
})
$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
})
new Vue({
    el: '#app2',
    data: {
        showModal: false,
        selectedMember:null,
        member:null,
    },
    methods:{
        ok:function(){
//alert('you clicked me');
this.showModal = !this.showModal;
},
close:function(e)
{
    this.showModal = !this.showModal;
},
editExample2 : function(){
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
    $(document).ready(function(){
        var to, from;
        to = $("#range-to-example2").persianDatepicker(modelDate());
        from = $("#range-from-example2").persianDatepicker(modelDate());
    });
})
}
},
})
$('#excell_all').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
})

</script>
@endpush
