@extends('layouts.app')
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">

    <style>
        .dashboard-stat2 {
            padding: 0; 
        }
        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 1000 !important;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
 
        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }
    </style>

    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }

        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;

        }
        .input_style {
            min-width: 110px;


        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }

        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }


        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }


        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
        .cmodal-container
        {
            width: 800px !important;
        }
            /* border: none !important; */
        .have-border
        {
            border: 1px solid lightgray !important;

        }
        cmodal[v-cloak] {
            display: none;
        }

    </style>

@stop



@section('content')
    @include('inventories.cmodal')

    <div class="row" id="salse" v-cloak>
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                        <span class="caption-subject font-green-haze bold uppercase">              @lang('layout.ProjectDetails') </span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>                 
            <div class="portlet-body form" id="item-service">
                
                {{Form::open(['route' => 'projectDetails.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                <div class="tab-content">
                    <div class="tab-pane active" id="home">
                        <div class="row">
                            <div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.Project')</label>
                                            <div class="col-md-8">
                                                <v-autocomplete :items="customerList" v-model="customer" :get-label='getLabel'
                                                  :min-len='0'
                                                  :component-item='tpl'  
                                                  :input-attrs="{}"
                                                  placeholder="@lang('layout.SelectProject')">
                                                </v-autocomplete>
                                                <input type="hidden" name="project" :value="(customer)?customer.id:null">
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.Discount') </label>
                                            <div class="col-md-8 ">
                                                <div class="input-group" :class="{'has-error':discount<0 || discount>100 }">
                                                    <input  v-model="discountFiled" class="form-control"
                                                           type="number" min="0"
                                                           max="100">

                                                    <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon"> 
                                                        <input type="hidden" name="discount_type" value="currency">
                                                    </span>
                                                    <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                                                        <input type="hidden" name="discount_type" value="percent">
                                                    </span>
                                                    <input type="hidden" name="discountTotal" :value="discount">
                                                    <input type="hidden" name="discount" :value="discountFiled">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.Description') </label>
                                            <div class="col-md-8">
                                                 <textarea  name="description" class="form-control" rows="3.9"></textarea>
                                            </div>
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                <div class="dashboard-stat2 ">
                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right"><span data-counter="counterup"
                                                data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))).toFixed(2)}}</span>
                                                <small class="font-green-sharp"> </small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(2) }}%)</small>
                                            </td>
                                            <td class="text-right">
                                                       <span class="text-right" data-counter="counterup"
                                                data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>
                                                <small class="font-green-sharp"> </small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>Sub-Total:</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{ subtotal.toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency}}  </small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div v-if="productions.length >0 " class="row">
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                    <tr> 
                                        <th class="text-center" style="min-width: 6px;">#</th>
                                        <th class="text-center" style="min-width: 120px;">@lang('layout.StuffDetails')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Width')</th>
                                        <th class="text-center" style="min-width: 50px;"> @lang('layout.Height')</th>
                                        <th class="text-center" style="min-width: 90px;"> @lang('layout.Quantity')</th>
                                        <th class="text-center" style="min-width: 40px;"> @lang('layout.Size')</th>
                                        <th class="text-center" style="min-width: 40px;"> @lang('layout.Measure')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Price')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>
                                        <th style="min-width: 20px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(production,ProductionIndex) in productions" class="even">
                                        <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{ProductionIndex+1}} </span>
                                            </td>
                                        <td class="td_one">
                                            <v-autocomplete :items="production.items" v-model="production.item" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl'  
                                                            :input-attrs="{}"
                                                            @focus="setProductionFocus(ProductionIndex)"
                                                             placeholder="@lang('layout.SelectStuff')"
                                                            style="min-width: 220px  ;">
                                            </v-autocomplete>
                                            <input type="hidden" name="production_id[]" :value="(!production.item)?null:production.item.id">
                                        </td> 
                                        <td>
                                            <input name="width[]" class="form-control inpu-number-fild" type="number" placeholder="@lang('layout.Width')" v-model.number="(!production.item)?null:production.item.width" />
                                        </td>
                                        <td>
                                            <input class="form-control spinner input_style" type="number" placeholder="@lang('layout.Height')" v-model.number="(!production.item)?null:production.item.height"  />
                                        </td>
                                        <td> 
                                            <input type="number" name="pquantity[]" class="form-control" placeholder="@lang('layout.Quantity')" v-model.number="(!production.item)?null:production.item.pQuantity">
                                        </td>
                                        <td>
                                            <div class="input-group input_style">
                                                <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Size')" :value="(!production.item)?null:(production.item.pQuantity* production.item.height* production.item.width)    "   disabled>
                                            </div>
                                        </td>
                                        <td style="min-width:60px">
                                              <select  class="form-control input_style"
                                                     placeholder="@lang('layout.Measure')"
                                                     v-model="!production.item?null:production.item.measure"
                                                     required="required"> 
                                                <option v-if="production.item"
                                                        v-for="measures in (!production.item?null:production.item.measureList)"
                                                        :value="measures">@{{ measures.measure_name }}</option>
                                            </select>
                                        </td>
                                       
                                        <td>
                                            <div class="input-group input_style">
                                                <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Price')" v-model.number="(!production.item)?null:production.item.price" name="pPrice[]">
                                                <span class="input-group-addon">
                                                <b> </b>
                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group input_style">
                                                <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Total')" :value="(!production.item)?null:production.item.pQuantity * production.item.price" disabled>
                                                <span class="input-group-addon">
                                                    <b> </b>
                                                </span>
                                            </div> 
                                        </td>
                                        <td>
                                            <span  v-on:click="deleteProductionItem(ProductionIndex)"><i style="color:red" class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr> 
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div v-if="inventories.length >0 " class="row">
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                    <tr> 
                                        <th class="text-center" style="min-width: 6px;"> # </th>
                                        <th class="text-center" style="min-width: 120px;">@lang('layout.ItemName')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Width')</th>
                                        <th class="text-center" style="min-width: 50px;"> @lang('layout.Height')</th>
                                        <th class="text-center" style="min-width: 90px;"> @lang('layout.Quantity')</th>
                                        <th class="text-center" style="min-width: 40px;"> @lang('layout.MeasureUnit')</th>
                                        <th class="text-center" style="min-width: 40px;"> @lang('layout.WindowType')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.SpenserSize')</th> 
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Description')</th>
                                        <th style="min-width: 20px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(inventory,InventoryIndex) in inventories" class="even">
                                        <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                            </td>
                                        <td class="td_one">
                                            <v-autocomplete :items="inventory.items" v-model="inventory.item" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl'  
                                                            :input-attrs="{}"
                                                            @focus="setFocus(InventoryIndex)"
                                                             placeholder="@lang('layout.SelectItem')"
                                                            style="min-width: 220px  ;">
                                            </v-autocomplete>
                                            <input type="hidden" name="inventory_id[]" :value="(!inventory.item)?null:inventory.item.id">
                                        </td> 
                                        <td>
                                            <input name="inventory_qty[]" class="form-control inpu-number-fild" type="number" placeholder="@lang('layout.Width')"/>
                                        </td>
                                        <td>
                                            <input class="form-control spinner input_style" type="number"placeholder="@lang('layout.Height')"/>
                                        </td> 
                                        <td>
                                            <input class="form-control spinner input_style" type="number"placeholder="@lang('layout.Quantity')"/>
                                        </td>
                                        <td>
                                            <select  class="form-control input_style"
                                                     placeholder="@lang('layout.Measure')"
                                                     v-model="!inventory.item?null:inventory.item.measure"
                                                     required="required">

                                                <option v-if="inventory.item"
                                                        v-for="measures in (!inventory.item?null:inventory.item.measureList)"
                                                        :value="measures">@{{ measures.measure_name }}</option>
                                            </select>

                                            <input type="hidden" name="inventory_measure[]" :value="(!inventory.item)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                        </td>
                                         
                                        <td>
                                            <input type="text" class="form-control inner_input"  placeholder="@lang('layout.WindowType')">
                                        </td>
                                        <td>
                                            <input type="number" name="inventory_price[]" class="form-control inner_input" placeholder="@lang('layout.SpenserSize')">
                                                 
                                        </td>
                                        <td>
                                            <input type="text" class="form-control inner_input"  placeholder="@lang('layout.Description')">
                                                 
                                        </td>
                                        <td>
                                            <span  v-on:click="deleteItem(InventoryIndex)"><i  style="color:red" class="paddint-both glyphicon glyphicon-trash"></i></span>

                                            {{--<a href="#"><i class="glyphicon glyphicon-trash"></i></a>--}}
                                        </td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div v-if="services.length >0 " class="row">
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                    <tr> 
                                        <th class="text-center" style="min-width: 8px;"> # </th>
                                        <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Quantity') </th>
                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Measure')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Cost')</th>
                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Price')</th>
                                        <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th> 
                                        <th style="min-width: 20px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(service,Index) in services" class="even">
                                        <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                        </td>
                                        <td class="td_one">
                                            <v-autocomplete :items="service.items" v-model="service.item" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='updateService'
                                                            :input-attrs="{}"
                                                            @focus="setServiceIndex(Index)"
                                                            placeholder="@lang('layout.SelectServices')">
                                            </v-autocomplete> 
                                            <input type="hidden" name="service_id[]" :value="!service.item?null:service.item.id"> 
                                        </td> 
                                        <td>
                                            <input name="service_qty[]" class="form-control inpu-number-fild" type="number"  :class="{'input-has-error':(!service.item)?null:service.item.qty<0}" v-model.number="(!service.item)?null:service.item.qty" placeholder="@lang('layout.Quantity')" />
                                        </td> 
                                        <td>
                                            <select  class="form-control input_style"
                                                     placeholder="@lang('layout.Measure')"
                                                     v-model="!service.item?null:service.item.measure"
                                                     required="required"> 
                                                <option v-if="service.item"
                                                        v-for="measures in (!service.item?null:service.item.measureList)"
                                                        :value="measures">@{{ measures.measure_name }}</option>
                                            </select>
                                            <input type="hidden" name="service_measure[]" :value="!service.item?null:(service.item.measure)?service.item.measure.measure_id:null">
                                        </td>
                                        <td>
                                            <div class="input-group input_style"> 
                                                <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Cost')" :value="(!service.item)?null:((service.item.cost*service.item.measure.measure_unit/service.item.measure_unit)*customer.rate).toFixed(2)" disabled>
                                                <span class="input-group-addon">
                                                <b> </b>
                                            </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group input_style">
                                                <input type="number" name="service_price[]" class="form-control inner_input" :class="{'input-has-error':(!service.item)?null:service.item.rate<0}" placeholder="@lang('layout.Price')" :value="(!service.item)?null:Number.parseFloat(service.item.rate * exchanged_rate).toFixed(3)" ref="ins"  @input="setValuesAmountS(Index)">
                                                <span class="input-group-addon">
                                                <b> </b>
                                            </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group input_style">
                                                <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Total')" :value="(!service.item)?null:service.item.qty * (service.item.rate * exchanged_rate)" disabled>
                                                <span class="input-group-addon">
                                                <b> </b>
                                            </span>
                                            </div>
                                        </td>
                                        <td>
                                            <span  v-on:click="deleteService(Index)"><i  style="color:red" class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        </td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row"> 
                            <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')
                            </button> 
                            <button v-if="productions.length <= 0 " type="button" class="btn default" @click="addProduction">@lang('layout.AddProduction')
                            </button>
                            <button v-if="services.length <= 0 " type="button" class="btn default" @click="addService">@lang('layout.Addservice')
                            </button>
                            <button   type="button" class="btn green" @click="submitForm">@lang('layout.Submit')</button>
                        </div>
                    </div> 
                </div>
                {{Form::close()}}
            </div>
        </div>
    </div>
    <script type="text/x-template" id="checkbox-template">
        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div> 
        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span> 
        </div> 
    </script>
@endsection

@push('scripts')
    
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script>
      
        
        var CustomerAll     = {!! $project !!};
        var InventoryAll    = {!! $inventoryList!!};
        var serviceAll      = {!! $serviceList !!};
        var ProductionAll   = {!! $productionItem !!};
        Vue.use(VAutocomplete.default)
        Vue.use(VeeValidate);

        var temp = Vue.component('my-checkbox',{
            template: '#checkbox-template',
            props: {
                item: {required: true},
                searchText: {required: true}
            }
        });        

        Vue.component('cmodal', {
            template: '#cmodal-template',
            props: ['show']
        });

        var sales = new Vue({
            el:'#salse',
            data:{
                code: 0,
                inventories: [
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                     
                ], 
                productions: [
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                ],
                services:[
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    
                ],
                roundData:1,
                inventoryIndex:0,
                serviceIndex:0,
                productionIndex:0,
                selectedCurrency:null,
                inventoryList:InventoryAll,
                productionList:ProductionAll,
                serviceList: serviceAll ,
                customer:null,
                projects:{!!$project!!},
                customerList:CustomerAll,
                
                discountFiled: 0,
                discountIsAmount:false,
                num: [],
                tpl: temp,
                defaultValue: 0,
                amount:null,
            },
            
            computed:{ 
                discount(){
                    if(this.discountIsAmount){

                        if(this.subtotal>0 && this.discountFiled) {
                           return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        }else {
                           return 0;
                        }
                    }else {

                        return this.discountFiled
                    }

                }, 

               

                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.productions.length; i++) {
                        if (this.productions[i].item)
                            sum +=  (this.productions[i]['item']['pQuantity'] * (this.productions[i]['item']['price']));

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item)
                            sum +=  (this.services[i]['item']['qty'] * this.services[i]['item']['rate']*this.exchanged_rate);

                    }

                    return sum;
                },
                isError: function () {
                    var isError = false
             
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && ( this.services[i]['item']['qty'] < 0 || this.services[i]['item']['rate'] < 0)){
                            isError = true;
                        } 
                    }
                    if((isError) || (this.discount < 0) || (this.discount > 100 )){
                        return false;
                    }else {
                        return true;
                    }

                },

            },
            methods:{ 
                setValuesAmount(index){

                    // console.log('amountes',this.$refs.in[value].value);
                    if(this.inventories[index].item){
                        this.inventories[index].item.rate = this.$refs.in[index].value/this.exchanged_rate; 
                        console.log('in refs',this.inventories[index].item.rate);
                    }
                },
                setValuesAmountS(index){

                    // console.log('amountes',this.$refs.ins[index].value);
                    if(this.services[index].item){
                        this.services[index].item.rate = this.$refs.ins[index].value/this.exchanged_rate; 
                        console.log('in refs service',this.services[index].item.rate);
                    }
                },
 
                 
                getLabel (item) {
                    if (item) {
                        return item.name
                    }
                    return ''
                },
                deleteItem(index) {
                    this.inventories.splice(index, 1)
                }, 
                deleteProductionItem(index) {
                    this.productions.splice(index, 1)
                },
                deleteService(index) {
                    this.services.splice(index, 1)
                },
                update (text) {
                    var Animals1 = InventoryAll.slice();
                    
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item != null && i != this.inventoryIndex ) {
                            if (Animals1.findIndex((item) => item.name == this.inventories[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.inventories[i].item.name), 1)

                        }

                    }
                    this.inventories[this.inventoryIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.inventoryIndex == this.inventories.length - 1 && this.inventories.length-3 < InventoryAll.length ) {
                        this.addInventory()
                    }
                    // if (this.rows[this.inventoryIndex].item != null)
                    //     this.priceUpdate(this.inventoryIndex)
                },                
                updateProduction (text){
                    var Animals1 = InventoryAll.slice();
                    for (var i = 0; i < this.productions.length; i++) {
                        if (this.productions[i].item != null && i != this.productionIndex ){
                            if (Animals1.findIndex((item) => item.name == this.productions[i].item.name) != -1) 
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.productions[i].item.name),1)

                        }

                    }
                    this.productions[this.productionIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.productionIndex == this.productions.length - 1 && this.productions.length-3 < ProductionAll.length ) {
                        this.addProduction()
                    }
                    
                },
                updateService (text) {
                    var Animals1 = serviceAll.slice();

                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item != null && i != this.serviceIndex) {
                            if (Animals1.findIndex((item) => item.name == this.services[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.services[i].item.name), 1)

                        }

                    }
                    this.services[this.serviceIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.serviceIndex == this.services.length - 1 && this.services.length-3 < InventoryAll.length ) {
                        this.addService()
                    }
                    // if (this.rows[this.serviceIndex].item != null)
                    //     this.priceUpdate(this.serviceIndex)
                },
                setFocus(index){
                  this.inventoryIndex = index;
                  this.update('')
                }, 
                setProductionFocus(index){
                  this.productionIndex = index;
                  // console.log('test', this.productionIndex);
                    this.updateProduction('')

                  
                },
                setServiceIndex(index){
                    this.serviceIndex = index;
                    this.updateService('')
                },
                addInventory(){
                    this.inventories.push({
                        items: [],
                        item: null,
                        }
                    )
                }, 
                addProduction(){
                    this.productions.push({
                        items: [],
                        item: null,
                        }
                    )
                },
                addService(){
                    this.services.push({
                        items: [],
                        item: null,
                        }
                    )
                },
              
                
                


            }
        });


    </script>
 
@endpush