@extends('layouts.app')

@section('content')
    @include('builds.modal')

    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <!-- app -->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="project_build_reports"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">

                            <label class="control-label">@lang('layout.SelectItem'):</label>
                            <v-select placeholder="@lang('layout.SelectItem')" label="name" :options="itemList"
                                      v-model="items"></v-select>
                            <input type="hidden" name="item_id" :value="(items)?items.id:null">
                        </div>

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="summary">@lang('layout.Summary')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="project_build_reports"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.SelectItem'):</label>
                            <v-select placeholder="@lang('layout.SelectItem')" label="name" :options="itemList"
                                      v-model="items"></v-select>
                            <input type="hidden" name="item_id" :value="(items)?items.id:null">


                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="summary">@lang('layout.Summary')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon">@lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" autocomplete="off"
                                           name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- BEGIN TAB PORTLET-->

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BuildList')</span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    @permission('itemassembly-export')

                    <button type="submit" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>


                    <button type="submit" class="btn btn-success" id="print_pdf_all"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    @endpermission
                    @permission('itemassembly-create')
                    <a href="{{route('buildItem.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i>@lang('layout.AddNew')
                        </button>
                    </a>
                    <a href="{{route('pro_simple_build.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i>@lang('menu.BuildWithoutFormula')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="build">
                    <thead>
                    <tr>

                        <th>@lang('layout.BuildNumber') </th>
                        <th>@lang('layout.ProjectName')  </th>
                        <th>@lang('layout.ProjectCode')  </th>
                        <th>@lang('layout.ProductName')  </th>
                        <th>@lang('layout.Qty')</th>
                        <th>@lang('layout.Measure') </th>
                        <th>@lang('layout.Cost')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>

                    </tr>
                    </thead>
                    <tfoot>
                    {{--<tr>--}}
                    {{--<th>Code</th>--}}
                    {{--<th>Name</th>--}}
                    {{--<th>Description</th>--}}
                    {{--<th>Precent</th>--}}
                    {{--<th>Measure</th>--}}
                    {{--<th>Rate</th>--}}
                    {{--<th>Quantities</th>--}}
                    {{--<th>Actions</th>--}}
                    {{--</tr>--}}
                    </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#build').DataTable({
                ajax: '{{route("buildItem.index")}}',
                pageLength: '{{getPageRows()}}',
                serverSide: true,
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:7}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    // {data: 'id', name: 'id'},
                    {data: 'number', name: 'number', searchable: false},
                    {data: 'pro_name', name: 'projects.name'},
                    {data: 'pro_number', name: 'projects.number'},
                    {data: 'name', name: 'name', searchable: false},
                    {data: 'qty', name: 'qty', orderable: false, searchable: false},
                    {data: 'symbol', name: 'symbol', searchable: false},
                    {data: 'cost', name: 'cost', orderable: false, searchable: false},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]


            });
        });

        new Vue({

            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#app',
            data: {
                showModal: false,
                itemList:{!! json_encode($itemList) !!},
                items: null,
            },
            methods: {
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                itemList:{!! json_encode($itemList) !!},
                items: null,

            },
            methods: {
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })


    </script>


@endpush
