@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditBuild')</span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($build,['method' => 'PATCH','route' => ['buildItem.update',$build->id],'files'=> true, 'id'=>'build-form'])!!}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12">
                            <div class="">
                               
                                <div class="row">
								
									<div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.SelectProject')</label> 
                                            <v-select label="name" v-model="selectedProject" :options="project_items" disabled></v-select> 
                                            <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.project_id">
                                        </div>
                                    </div> 
								
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            <v-select label="name" v-model="selected_item" :options="items"  @search="onItemSearch" disabled></v-select>

                                            <input type="hidden" name="item" :value="(!selected_item)?null:selected_item.item_id">

                                        </div>
                                    </div>
                                </div>
								<div class="row">	
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.FormulaName')</label>
                                            <select class="form-control" v-model="selected_formula" disabled="disabled">
                                                <option>@lang('layout.Select')</option>
                                                <option v-for="formula in formula_list" :value="formula">@{{formula.code+'-'+formula.name}}</option>
                                            </select>
                                            <input type="hidden" name="formula" :value="(!selected_formula)?null:selected_formula.id">
                                            <input type="hidden" name="name" :value="(!selected_formula)?null:selected_formula.name">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                                    <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="buildQty" class="form-control">
                                  
                                          </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.SiteName')</label>

                                                <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site"  >
                                                    
                                                </v-select>
                                                <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null">

                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.AssemblyCode') </label>
                                              <input type="number" name="number" value="{{$build->number}}" class="form-control">
                                          </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-6">

                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.Description') </label>
                                              <textarea  name="description" class="form-control" rows="2">
                                              {{$build->description}}    
                                              </textarea>
                                          </div>
                                    </div>
                                     <div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.Date')</label>
                                                  <input class="form-control date" name="date" readonly="readonly" autocomplete="off" value="{{$assemblyInfo->date}}">
                                          </div>
                                    </div>
                                </div>

                                <div class="row">

                                     
                                  

                                </div>

                            </div>
                        </div>
                        <!--  calculation part -->
                        <div class="col-lg-4 col-md-4 col-sm-12">
                            <div class="row">
                              <label class="control-label"> @lang('layout.Formula')</label>
                                <div class="dashboard-stat2 ">

                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.ItemName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.name:null }}</span>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.MeasureName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.measure:null }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.FormulaName') :</small>
                                            </td>
                                            <td class="text-right">

                                                <span data-counter="counterup"
                                                data-value="">@{{ (selected_formula)?selected_formula.name:null }}</span>

                                            </td>
                                        </tr>


                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{ buildQ - buildQty}}</span>
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>


                                    </table>

                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                        <input type="hidden" name="stock_id" value="{{$stock_id}}">
                       <!-- end of calculation -->
                    
                    </div>

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="selected_formula" class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
								<th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.formula">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                      <input type="hidden" name="item_ids[]" :value="(!item.item_id)?null:item.item_id">
                                      <input type="hidden" name="item_id[]" :value="(!item.item_id)?null:item.item_id">

                                      
                                </td> 
                                <td>
                                    <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChange(index)"  class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required" disabled>

                                       <span v-if="item.measure_list !=null">
                                            <option v-if="(item !=null)"
                                                v-for="measures in item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="inventory_measure[]" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                              </td>
                              <td>
                                <input type="number" name="item_quantity[]" v-model="(!item)?null:item.quantity">
                              </td>
                               <td>
                              <!--   <input readonly type="number" name="item_quantity[]" v-model="(!item)?null:item.on_hand"> -->
                              </td>
                              <td>
                                <input readonly  type="number"  :value="(!item)?null:(item.quantity*buildQty)">
                              </td>
                                <td>
                                <input readonly  type="number"  :value="(!item)?null:(item.on_hand-(item.quantity*buildQty))">
                              </td>
							  <td>
                                    <span v-if="(!selected_formula)?null:selected_formula.formula.length > 1"  v-on:click="deleteItem('inventory',index)">
                                      <i class="paddint-both glyphicon glyphicon-trash"></i>
                                    </span>

                                </td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <hr>
                     <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>
                    <div v-if="selected_formula" class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                 <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.other_build">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                      <input type="hidden" name="other_build_id[]" :value="(!item.item_id)?null:item.item_id" class="form-control">
                                      
                                </td> 
                                <td>
                                    <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChangeOtherBuild(index)"  class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required" disabled>

                                       <span v-if="item.measure_list !=null">
                                            <option v-if="(item !=null)"
                                                v-for="measures in item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="other_build_measure[]" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                              </td>
                              <td>
                                <input type="number" name="other_build_qty[]" v-model="(!item)?null:item.new_quantity">
                              </td>
                               <td>
                                  <div class="input-group">
                                      <input type="number" class="form-control" 
                                      placeholder="%" style="min-width: 100px" v-model="(!item)?null:item.cost" required name="other_build_cost[]" />
                                      <span class="input-group-addon">%</span>
                                  </div>
                              </td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                    </button>
                    @if(getBuildExpense() == "true")
                      <!-- begin build expense -->
                              <hr>
                     <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table v-if="selected_formula.expense" id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Expense')</th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Description')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Amount')</th>
                             
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula.expense)?null:selected_formula.expense">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                  
                                        <input type="hidden" name="assembly_expense_id[]" :value="(!item.id)?null:item.id" class="form-control">
                                </td>
                                  <td class="td_one"> 
                                      <v-select label="name" v-model="(!item.expense_account)?null:item.expense_account" ></v-select>
                                      <input type="hidden" name="expense_id[]" :value="(!item.expense_account)?null:item.expense_account.id" class="form-control">


                                      
                                </td> 
                                <td class="td_one"> 
                                      <input type="text" name="expense_description[]" :value="(!item.description)?null:item.description" class="form-control">
                                      
                                </td> 
                              
                                <td class="td_one"> 
                                      <input type="text" name="expense_amount[]" :value="(!item.amount)?null:item.amount" class="form-control">
                                      
                                </td> 
                              
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <!-- end build expense -->
                    @endif


                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>
     
@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script>
    Vue.component('v-select', VueSelect.VueSelect);
    var site                 = {!! $site !!};
    var selectedSite         = {!! $selectedSite !!};
    var build                = {!! $build !!};
    var project              = {!! $project !!};
    var buildSelectedFormula = {!! $buildSelectedFormula !!};
    var buildSelectedItem    = {!! $buildSelectedItem !!};
    var buildDetail          = {!! $buildDetail !!};
    var otherBuildDetail     = {!! $otherBuildDetail !!};
    var buildQty;
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            selected_site:selectedSite,
            buildSelectedFormula:buildSelectedFormula,
            build:build,
            project:project,
            selected_item:buildSelectedItem,
            buildQty:build.qty,
            buildSelectedItem:buildSelectedItem,
            buildDetail:buildDetail,
            otherBuildDetail:otherBuildDetail,
            assembly_item:[],
            temp_items:[],
            items:[],
            formula_list:[],
			project_items:[],
            selectedProject :null,
            selected_formula:null,
            assemlby_items: [
              {item:null},
              {item:null},
              {item:null},
              {item:null},
            ], 
             daily_expense_info:null,
        },
        created:function()
        {
            if(this.selected_formula)
            {
                var rows = this.selected_formula.formula;
                if(rows.length>0)
                {
                    for(var x=0; x<rows.length;x++)
                    {
                      rows[x].new_quantity = buildDetail[x].quantity;
                    }  
                }
            }
        },
        computed:{
                buildQ: function () 
                {
                  var min = null;
                  if(this.selected_formula)
                  {
                     var rows = this.selected_formula.formula;
                    // console.log(this.selected_formula);
                      if(rows.length >0) 
                      {
                          var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));

                          var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].on_hand/temp;
                          for (var i = 1; i < rows.length; i++) 
                          {
                              var temp=((rows[0].new_quantity*rows[0].measure.measure_unit/rows[0].measure_unit));
                              if (rows[i].on_hand / temp < min) 
                              {
                                  min = rows[i].on_hand / temp;
                              }

                          }
                          min = min.toFixed(precision());

                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if((this.selected_item==null && !this.selected_item)  || this.selected_formula ==null || this.selected_site==null || this.buildQty<=0)
                {
                  isError=true;
                }
                return isError;
             },
        },
        
        mounted:function()
        {
             if(this.build && build.expense_id)
            {

              this.searchExpense();
            }
            // to initialize raw items
            if(this.buildSelectedFormula)
            {
                this.formula_list=this.buildSelectedFormula;
            }
			// to initialize raw items
            if(this.project)
            {
                this.selectedProject=this.project;
            }
            for(var i=0;i<this.buildSelectedFormula.length;i++)
            {
                if(this.build.assembly_id==this.buildSelectedFormula[i].id)
                {
                    this.selected_formula=this.buildSelectedFormula[i];
                }
            }
            // end item initialization
            if(this.selected_formula)
            {
                if(this.selected_formula.formula.length>0)
                {
                    for(var x=0; x<this.selected_formula.formula.length;x++)
                    {
                       
                       for(var w=0;w<this.buildDetail.length;w++)
                       {
                           if(this.selected_formula.formula[x].item_id == this.buildDetail[w].item_id)
                            {
                               this.selected_formula.formula[x].new_quantity=this.buildDetail[w].quantity;
                            
                            }
                           
                       }
                    }  
            
                }
                if(this.selected_formula.other_build.length>0)
                {

                    for(var x=0; x<this.selected_formula.other_build.length;x++)
                    {
                       for(var w=0;w<this.otherBuildDetail.length;w++)
                       {

                      

                           if(this.selected_formula.other_build[x].item_id == this.otherBuildDetail[w].item_id)
                            {
                              this.selected_formula.other_build[x].new_quantity=this.otherBuildDetail[w].quantity;

                                this.selected_formula.other_build[x].cost=this.otherBuildDetail[w].cost;


                            }
                           
                       }
                    }  
            
                }
            }

        },
        methods:{
           // begin expense

           searchExpense()
           {
               var id = document.getElementById('daily_expense_number').value;
             
               if(id)
               {    
                    this.daily_expense_info=null;
                    axios.get("{{route('callMethod.search')}}",{
                    params:{
                        method_name:'dailyExpenseForBuild',
                        type:this.selected_type,
                        expense_id:id,
                    }
                   })
                   .then(function(response){
                    if(response.data)
                    {
                      sales.daily_expense_info=response.data;
                    }
                  
                   })
                   .catch(function (error){
                     console.log(error);
                   });
               }
           },
           // end expense

           // calculate item price based on measure change
           measureChange(index)
           {
              
               if(this.selected_formula)
               { 
                  var item=this.selected_formula.formula[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.formula[index].new_quantity =result;  
              }
           },
           measureChangeOtherBuild(index)
           {
              if(this.selected_formula)
              {
                  var item=this.selected_formula.other_build[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.other_build[index].new_quantity =result;   
              }
           },
            getItemFormula(e)
            {
                if(this.selected_item && this.selected_item !=null)
                {
                     this.formulaSearch(this.selected_item.item_id,this);
                    
                }
            },
          
            // begin item search
           onItemSearch(search,loading)
           {  
               this.formula_list=[];
               this.selected_formula=null;
               loading(true);
               this.itemSearch(search,loading,this);
           },

           //ajax call to get items
           itemSearch(search,loading,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                   method_name:'assemblyList',
                   keyword:search,
                }
               })
               .then(function (response)
               {
                 this.items=[];
                 if(response.data.length>0)
                 {
                    vm.items=response.data;
                    console.log('data',vm.items);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end item search
            //ajax call to get formula
           formulaSearch(item_id,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'item_formula',
                  item_id:item_id,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.formula_list=response.data;
                  
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
           // items serarch method
            onItemsSearch(search,loading)
           {  
               loading(true);
               this.itemsSearch(search,loading,this);
           },
           itemsSearch(search,loading,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'items_search_assebley',
                  'type':'assembaly',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.temp_items=response.data;
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },

            addNew(type=null,index)
            { 
              if(type !=null)
              {
                 if(type=='inventory')
                 { 
                    if(this.assemlby_items[index+1]==undefined)
                    {
                      this.assemlby_items.push({item:null});
                    }
                 } 
                 if(type=='otherBuilds')
                 { 
                    if(this.otherBuild[index+1]==undefined)
                    {
                      this.otherBuild.push({item:null});
                    }
                 }
                  
              }
              
           },
            deleteItem(type=null,index)
           {
             if(type !=null)
             {
                 console.log(type);
                 if(type=='inventory')
                 {
                    (!this.selected_formula)?null:this.selected_formula.formula.splice(index, 1);
                 }
                 if(type=='otherBuild')
                 {
                    this.otherBuild.splice(index, 1);
                 }
                   
             }
              
           },

           addItems(type)
           { 
                if(type !=null)
                {
                    if(type=="otherBuilds")
                    { 
                        this.temp_items=[];
                      this.otherBuild.push({item:null}); 
                    }
                    if(type=="inventory")
                    { 
                       this.temp_items=[];
                      this.assemlby_items.push({item:null});
                    }
                }
                     
              },
        }
    });



</script>


@endpush