@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    
@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title hidden-print">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BuildAssembly')</span>
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
                <div class=" pull-right">
                  <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()"/><i class="fa fa-print"></i>  @lang('layout.PrintBuildOrder')</a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'buildItem.store','method' => 'POST','class' => '','id'=>'build-form'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12 hidden-print">
                            <div class="">
                               
                                <div class="row">
								<div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.SelectProject')</label> 
                                            <v-select label="name" v-model="selectedProject" :options="project_items"  @input="getFormulaItem(this)"  @search="ProjectSearch"></v-select> 
                                            <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.project_id">
                                        </div>
                                    </div> 
								
								
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            <v-select label="name" v-model="selected_item" :options="items" @input="getItemFormula(this)" ></v-select>

                                            <input type="hidden" name="item" :value="(!selected_item)?null:selected_item.item_id">

                                        </div>
                                    </div>
                                </div>
								<div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.FormulaName')</label>
                                            <select class="form-control" v-model="selected_formula" @click="setQty(this)">
                                                <option>@lang('layout.Select')</option>
                                                <option v-for="formula in formula_list" :value="formula">@{{formula.code+'-'+formula.name}}</option>
                                            </select>
                                            <input type="hidden" name="formula" :value="(!selected_formula)?null:selected_formula.id">
                                        </div>
                                    </div>
									<div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                                    <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')" name="build_qty" v-model="buildQty" class="form-control">
                                  
                                          </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label ">@lang('layout.SiteName')</label>

                                                <v-select placeholder=" @lang('layout.SelectSite')" label="name" v-model="selected_site" :options="site"  >
                                                    
                                                </v-select>
                                                <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null">

                                        </div>
                                    </div>
									<div class="col-md-6">
                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.AssemblyCode') </label>
                                              <input type="number" name="number" value="{{$number}}" class="form-control">
                                          </div>
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-md-6">

                                         <div class="form-group">
                                              <label class="control-label">@lang('layout.Description') </label>
                                              <textarea  name="description" class="form-control" rows="2">
                                                  
                                              </textarea>
                                          </div>
                                    </div>
									<div class="col-md-6">
                                          <div class="form-group">
                                              <label class="control-label ">@lang('layout.Date')</label>
                                                  <input class="form-control date" name="date" readonly="readonly" autocomplete="off" value="">
                                          </div>
                                    </div>
                                
                                     
                                </div>

                            </div>
                        </div>
                        <!--  calculation part -->
                        <div class="col-lg-4 col-md-4 col-sm-12">
                            <div class="row">
                              <label class="control-label"> @lang('layout.Formula')</label>
                                <div class="dashboard-stat2 ">

                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small>@lang('layout.ItemName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{ (selected_item)?selected_item.name:null }}</span>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.MeasureName') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup"
                                                      data-value="">@{{(selected_item)?selected_item.measure:null }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.FormulaName') :</small>
                                            </td>
                                            <td class="text-right">

                                                <span data-counter="counterup"
                                                data-value="">@{{ (selected_formula)?selected_formula.name:null }}</span>

                                            </td>
                                        </tr>


                                        <tr>
                                            <td>
                                                <small>@lang('layout.QuantityToBuild'):</small>
                                            </td>
                                            <td class="text-right">
                                                        <span class="text-right" data-counter="counterup"
                                                              data-value="7800">@{{ buildQ - buildQty}}</span>
                                                <small class="font-green-sharp"></small>
                                            </td>
                                        </tr>


                                    </table>

                                </div>
                            </div>
                        </div>
                       <!-- end of calculation -->
                    
                    </div>

                    <li class="list-group-item" style="background-color: rgb(80, 129, 141) !important;color: white;"> @lang('layout.FormulaItems') </li>
                    
					
					<div v-if="assemlby_items.length >0 " class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Formula')</th>
                                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.ToBuild')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.AfterBuild')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(inventory,InventoryIndex) in new_temp_items" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <v-select label="name" v-model="inventory.item" :options="newtemp_items" @search="onItemsSearchitems"></v-select>
                                      <input type="hidden" :name="'item_id['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(inventory.item==null)?null:inventory.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+InventoryIndex+']') }}</span>
                                            
                                </td> 
                                <td>
                                    <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure"  class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required">

                                       <span v-if="inventory.item.measure_list !=null">
                                            <option v-if="(inventory.item !=null)"
                                                v-for="measures in inventory.item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" :name="'inventory_measure['+InventoryIndex+']'" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null" >
                                </td>
								<td> 
                                     <input type="number" :name="'item_quantity['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(inventory.item==null)?null:inventory.item.new_quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                                <span class="required">@{{ errors.first('item_quantity['+InventoryIndex+']') }}</span>
                              </td>
							  <td> 
                                    <!--  <input type="number"  v-model.number="(inventory.item==null)?null:inventory.item.on_hand" class="form-control input-style input-number"  placeholder="@lang('layout.OnHand')" readonly="readonly"> -->
                                 <input readonly type="number"  :value="(inventory.item == null)?null:getBuildOnHand(inventory.item.measure_unit,inventory.item.measure.measure_unit,null,inventory.item.on_hand)"> 
                    
                               </td>
							   <td>
                                <input readonly  type="number"  :value="(inventory.item == null)?null:(inventory.item.new_quantity*buildQty)">
                              </td>
                                <td>
                                <input readonly  type="number"  :value="(inventory.item == null)?null:buildItemQuantity(inventory.item.item_item_measure.measure_unit,inventory.item.measure.measure_unit,inventory.item.new_quantity,inventory.item.on_hand,buildQty,inventory.item.um_exchange)">
                              </td>
                           
                                <td>
                                    <span v-if="new_temp_items.length > 1"  v-on:click="deleteItem('inventory',InventoryIndex)">
                                      <i class="paddint-both glyphicon glyphicon-trash"></i>
                                    </span>

                                </td>
                            </tr>
                          <tr style="background-color: #ffffff;">
                            <td></td>
                            <td><center>
                              <span @click="addNew('inventory',100)" class="btn btn-success" style="background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141);"><i class="fa fa-plus"></i></span>
                            </center></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                          </tr>

                            </tbody>
                        </table>

                    </div>
					
                    <hr>
                     <li class="list-group-item" style="background-color: rgb(80, 129, 141) !important; color: white;"> @lang('layout.AdjastmentItems') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                 <th class="text-center" style="min-width: 80px;"> @lang('layout.Cost')</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula)?null:selected_formula.other_build">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one"> 
                                      <input type="text" name="" :value="(!item.item_id)?null:item.item_name" class="form-control" disabled="disabled">
                                      <input type="hidden" name="other_build_id[]" :value="(!item.item_id)?null:item.item_id" class="form-control">
                                      
                                </td> 
                                <td>
                                    <select v-if="item" v-model="(!item)?null:item.measure" @change="measureChangeOtherBuild(index)"  class="form-control input_style"
                                             placeholder="Measure"
                                            
                                             required="required" disabled>

                                       <span v-if="item.measure_list !=null">
                                            <option v-if="(item !=null)"
                                                v-for="measures in item.measure_list"
                                                :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="other_build_measure[]" :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                              </td>


                              <td>
                                <input type="number" name="other_build_qty[]" v-model="(!item)?null:item.new_quantity">
                              </td>
                              <td>
                                  <div class="input-group">
                                      <input type="number" class="form-control" 
                                      placeholder="%" style="min-width: 100px" required name="other_build_cost[]" />
                                      <span class="input-group-addon">%</span>
                                  </div>
                              </td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                    </button>
                    <!-- begin build expense -->
                      <hr>
                     <li class="list-group-item" style="background-color: rgb(80, 129, 141) !important; color: white;"> @lang('layout.Expense') </li>
                    <div v-if="selected_formula" class="" id="printarea" style="overflow-x: scroll;">
                        <table v-if="selected_formula.expense" id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Expense')</th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.Description')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Amount')</th>
                             
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in (!selected_formula.expense)?null:selected_formula.expense">

                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                  <input type="hidden" name="assembly_expense_id[]" :value="(!item.id)?null:item.id" class="form-control">

                                </td>
                                  <td class="td_one"> 
                                      <v-select label="name" v-model="(!item.expense_account)?null:item.expense_account" ></v-select>
                                      <input type="hidden" name="expense_id[]" :value="(!item.expense_account)?null:item.expense_account.id" class="form-control">



                                      
                                </td> 
                                <td class="td_one"> 
                                      <input type="text" name="expense_description[]" :value="(!item.description)?null:item.description" class="form-control">
                                      
                                </td> 
                              
                                <td class="td_one"> 
                                      <input type="text" name="expense_amount[]" :value="(!item.amount)?null:item.amount" class="form-control">
                                      
                                </td> 
                              
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <!-- end build expense -->
                    

                    <div class="row hidden-print">
                        <div class="col-md-12 text-center" style="margin-top: 10px;">
                            <button v-if="!isError" type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('assembly.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>
     
@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>
<script>

 
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
  
     Vue.component('v-select', VueSelect.VueSelect);
    var site={!! $site !!};
    var sales = new Vue({
        el:'#assembaly',
        data:{
            site:site,
            selected_site:null,
            selected_item:null,
            buildQty:null,
            inventory:null,
            assembly_item:[],
            temp_items:[],
            newtemp_items:[],
            new_temp_items:[],
            items:[],
            project_items:[],
			assemlby_items: [],
            selectedProject :null,
            formula_list:[],
            selected_formula:null,
            assemlby_items: [
              {item:null},
              {item:null},
              {item:null},
              {item:null},
            ], 
        },

        computed:{
                buildQ: function () 
                {
					 
                  var min = null;
                  if(this.selected_formula && this.new_temp_items)
                  {
                     var rows = this.new_temp_items;
                    // console.log('llllllll',this.new_temp_items);
                      if(rows != null && rows.length >0) 
                      {
				
                          var temp=((rows[0].item.new_quantity*rows[0].item.measure.measure_unit/rows[0].item.item_item_measure.measure_unit));

                          //var temp_other_build=this.selected_formula.other_build;
                          min = rows[0].item.on_hand/temp;

                      
                          for (var i = 1; i < rows.length; i++) 
                          {
						if(rows[i] && rows[i].item != null)
						{

                            var temp=((rows[i].item.new_quantity*rows[i].item.measure.measure_unit/rows[i].item.item_item_measure.measure_unit));
                            var result= (rows[i].item.on_hand * rows[i].item.item_item_measure.measure_unit)/(rows[i].item.measure.measure_unit);

                            if (result / temp < min) 
                            {
                              min = result / temp;
                            }
							
							}

                          }
                          min = min.toFixed(precision());

                      
                      }

                  }
                  return min;
              },
             isError:function()
             {
                var isError=false;
                if((this.selected_item==null && !this.selected_item)  || this.selected_formula ==null || this.selected_site==null || this.buildQty<=0 || (this.buildQ - this.buildQty)<0)
                {
                  isError=true;
                }
                return isError;
             },
        },

        methods:{
			
			getBuildOnHand(item_measure_unit=null,selected_measure_unit=null,qty=null,on_hand=null)
          {
            // console.log('qty',qty);
            // console.log('item_measure_unit',item_measure_unit);
            // console.log('selected_measure_unit',selected_measure_unit);
            // console.log('on_hand',on_hand);
            // console.log('lala',sales.new_temp_items);
            var result=0;
            if(on_hand !=null)
            {   
                if(qty)
                {
                  result= (on_hand * item_measure_unit)/(selected_measure_unit)-(qty);
                }
                else
                {
                  result= (on_hand * item_measure_unit)/(selected_measure_unit);
                }
            }   
            return result.toFixed(precision());
          },
			
           // begin expense

           searchExpense()
           {
               var id = document.getElementById('daily_expense_number').value;
             
               if(id)
               {    
                    this.daily_expense_info=null;
                    axios.get("{{route('callMethod.search')}}",{
                    params:{
                        method_name:'dailyExpenseForBuild',
                        type:this.selected_type,
                        expense_id:id,
                    }
                   })
                   .then(function(response){
                    if(response.data)
                    {
                      sales.daily_expense_info=response.data;
                    }
                  
                   })
                   .catch(function (error){
                     console.log(error);
                   });
               }
           },
           // end expense
           // calculate item price based on measure change
           measureChange(index)
           {
              
               if(this.selected_formula)
               {
                  
                  var item=this.selected_formula.formula[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.formula[index].new_quantity =result;
              
                    
              }
           },
           measureChangeOtherBuild(index)
           {
              if(this.selected_formula)
              {
                  var item=this.selected_formula.other_build[index];
                  var temp=((item.quantity*item.measure_unit/item.measure.measure_unit));
                  result=Number.parseFloat(temp).toFixed(precision());

                  this.selected_formula.other_build[index].new_quantity =result;   
              }
           },
            getItemFormula(e)
            {
				
				if(this.selectedProject && this.selectedProject !=null && this.selected_item && this.selected_item !=null)
                {
                     this.formulaSearch(this.selected_item.item_id,this.selectedProject.project_id,this);
                }
            },
			
            setQty(e)
            {
				this.buildQty =	(!this.selected_formula)?null:this.selected_formula.project_quantity;
				
				if(this.selected_formula)
              {
                var rows = this.selected_formula.formula;
				 this.new_temp_items = [];
                 console.log('gegar11',rows)
                  for(var x=0; x<rows.length;x++)
                  {
                    
                    this.new_temp_items.push({
                      item:rows[x]
                    });
                  }
				  
                  }
			},
          
            getFormulaItem(e)
            {
                if(this.selectedProject && this.selectedProject !=null)
                {
                     this.onItemSearch(this.selectedProject.project_id,this);
                }
            },
          
         
           //ajax call to get items
           onItemSearch:_.debounce((project_id,vm)=>{
               sales.formula_list=[];
               sales.selected_formula=null;
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'projectAssemblyList',
                  project_id:project_id,
                }
               })
               .then(function (response)
               {
                 sales.items=[];
                 if(response.data.length>0)
                 {
                    vm.items=response.data;
                    console.log('sssss',sales.items);
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
           
           // end item search
            //ajax call to get formula
           formulaSearch(item_id,project_id,vm)
           {
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'project_item_formula',
                  item_id:item_id,
                  project_id:project_id,
                }
               })
               .then(function (response)
               {
                 this.formula_list=[];
                 if(response.data.length>0)
                 {
                    vm.formula_list=response.data;
					console.log('TTTTTT',response.data);
					
                 }
               })
               .catch(function (error)
               {
                  console.log(error);
               })
           },
           // end formula search
		   
		           // Search Project 
      
        ProjectSearch:_.debounce((search,loading)=>{
           sales.project_items=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'serarchProject',  
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.project_items=[];
             if(response.data.length>0)
             {
                sales.project_items=response.data;
                console.log('test 22',sales.project_items);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
        },getDebounceTime()),
		   
		   onItemsSearchitems:_.debounce((search,loading) =>{
            loading(true);
            axios.get("{{route('callMethod.search')}}",{
              params:{
                 method_name:'items_search_assebley',
                'type':'assembaly',
                keyword:search,
              }
            })
            .then(function(response){
              sales.newtemp_items = [];
              if(response.data.length >0)
              {
                sales.newtemp_items = response.data;
              console.log('onItemsSearchitems',sales.newtemp_items);
              console.log('onItemsSearchitems pp',sales.new_temp_items);
              }
              loading(false);
            })
            .catch(function(error){
              console.log(error);
            })
         },getDebounceTime()),
		   
           // items serarch method
            onItemsSearch(search,loading)
           {  
               this.temp_items=[];
               loading(true);
               this.itemsSearch(search,loading,this);
           },
           itemsSearch(search,loading,vm)
           {
               this.temp_items=[];
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'items_search_assebley',
                  'type':'assembaly',
                  keyword:search,
                }
               })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {

                    vm.temp_items=response.data;
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },

            addNew(type=null,index)
            { 
              if(type !=null)
              {
                 if(type=='inventory')
                 { 
			 if(this.selected_formula)
               {
                    if(this.new_temp_items[index+1]==undefined)
                    {
                      //this.assemlby_items.push({item:null});
					  this.new_temp_items.push({item:null});
                    }
					// console.log('ppp',this.new_temp_items);
					
                 } 
                 } 
                 if(type=='otherBuilds')
                 { 
                    if(this.otherBuild[index+1]==undefined)
                    {
                      this.otherBuild.push({item:null});
                    }
                 }
                  
              }
              
           },
            deleteItem(type=null,index)
           {
            if(type !=null)
            {
                 console.log(type);
                 if(type=='inventory')
                 {
                    this.new_temp_items.splice(index, 1);
                 }
                 if(type=='otherBuild')
                 {
                    this.otherBuild.splice(index, 1);
                 }
                   
            }
              
           },

           addItems(type)
           { 
                if(type !=null)
                {
                    if(type=="otherBuilds")
                    { 
                        this.temp_items=[];
                      this.otherBuild.push({item:null}); 
                    }
                    if(type=="inventory")
                    { 
                       this.temp_items=[];
                      this.assemlby_items.push({item:null});
                    }
                }
                     
              },
        }
    });



</script>


@endpush