@extends('layouts.factor-master')

@section('content')


<?php
$report = customeReport('build','detail');
?>

 <table class="main-table">
  @if($info && $info !=[])
    <tr>
   <td>
      <span>@lang('layout.ItemName')</span>:
      <span>{{$info[0]->name}}</span>
    </td>
     <td>
      <span>@lang('layout.Quantity')</span>:
      <span>{{$info[0]->qty}}</span>
    </td>
     <td>
      <span>@lang('layout.Cost')</span>:
      <span>{{$info[0]->cost}}</span>
    </td>
    </tr>
  @endif

   </table>
 <h3 class="table-caption" style="text-align: center;">@lang('layout.BuildReport')</h3>
<table class="main-table">
  <thead>
    <tr class="bg">
    <td class="center" ><div > #</div></td>
    <td class="center"  style="display: <?=(!show('build_number',$report))?'none':'';?>"><div > @lang('layout.BuildNumber') </div></td>
    <td class="center"  style="display: <?=(!show('name',$report))?'none':'';?>"><div > @lang('layout.Name')</div></td>
    <td class="center"  style="display: <?=(!show('measure',$report))?'none':'';?>"><div > @lang('layout.Measure')</div></td>
    <td class="center"  style="display: <?=(!show('quantity',$report))?'none':'';?>"><div > @lang('layout.Quantity')</div></td>
    <td class="center"  style="display: <?=(!show('purchase_rate',$report))?'none':'';?>"><div > @lang('layout.Cost')</div></td>
    <td class="center"  style="display: <?=(!show('total',$report))?'none':'';?>"><div > @lang('layout.Total')</div></td>
    <td class="center"  style="display: <?=(!show('date',$report))?'none':'';?>"><div > @lang('layout.Date')</div></td>
  </tr>
  </thead>
 

  <?php
  $count = 0;
  $total_cost=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
      $total_cost+=$record->Cost*$record->Quantity;
    ?>
    <td class="center">{{++$count}}</td>
    <td style="display: <?=(!show('build_number',$report))?'none':'';?>" class="center">{{$record->Build_Number}}</td>
    <td style="display: <?=(!show('name',$report))?'none':'';?>" class="center">{{$record->Name}}</td>
    <td style="display: <?=(!show('measure',$report))?'none':'';?>" class="center">{{$record->Measure}}</td>
    <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->Quantity}}</td>
    <td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>" class="center">{{Currency()->format($record->Cost)}}</td>
    <td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{Currency()->format($record->Cost*$record->Quantity)}}</td>
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
{{convertDate($record->Date)}}
</td>
  </tr>
  @endforeach
</table>
<h4>@lang('layout.Total')</h4>
<table class="main-table">

<tr class="bg">
  <td><div class="center"> @lang('layout.Amount') </div></td>
  <td><div class="center"> {{round($total_cost,2)}}{{getHomeCurrency()[getCurrencyType()]}}</div></td>
</tr>

</table>
<h4 class="center">@lang('layout.Expense')</h4>
<table class="main-table">
  <thead>
    
    <tr class="bg">
      <th class="center">@lang('layout.No')</th>
      <th class="center">@lang('layout.Account')</th>
      <th class="center">@lang('layout.Description')</th>
      <th class="center">@lang('layout.Amount')</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 0;
    ?>
    @foreach($expenseDetails as $ex)
    <tr >
      <td class="center">{{++$count}}</td>
      <td class="center">{{$ex->account}}</td>
      <td class="center">{{$ex->description}}</td>
      <td class="center">{{$ex->amount}}</td>
    </tr>
    @endforeach
  </tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection