@extends('layouts.app')

@section('content')
<!-- BEGIN CONTENT -->
<!-- BEGIN PAGE BAR -->
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <a href="index.html">Home</a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <a href="#">Tables</a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <span>Datatables</span>
        </li>
    </ul>
    <div class="page-toolbar">
        <div class="btn-group pull-right">
            @permission('product-create')
                <a href="{{route('product.create')}}">
                    <button id="sample_editable_1_new" class="btn green btn-sm btn-outline">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>
            @endpermission    
        </div>
    </div>
</div>
<!-- END PAGE BAR -->
<!-- BEGIN PAGE TITLE-->
<h1 class="page-title"> Responsive Extension
    <small>responsive extension demos</small>
</h1>
<!-- END PAGE TITLE-->
<!-- END PAGE HEADER-->
@if (Session('message'))
    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>
        <p >{{ Session('message') }}</p>
    </div>
    {{--<div class="alert alert-success ">--}}
        {{--<ul>--}}
            {{--<li >{{ Session('message') }}</li>--}}
        {{--</ul>--}}
    {{--</div>--}}
@endif
@if (count($errors) > 0)

    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>

    {{--</div>--}}
    {{--<div class="alert alert-danger">--}}
        {{--<ul>--}}
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        {{--</ul>--}}
    </div>

@endif

<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-globe"></i>Row & Column Reordering </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="product-datatable" cellspacing="0" width="100%">
                    <thead>
                    <tr>
                       {{-- <th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.ProductName')</th>
                        <th>@lang('layout.ProductCode')</th>
                        <th>@lang('layout.ProductSlug')</th>
                        <th>@lang('layout.Discription')</th>
                        <th>@lang('layout.UpdatedAt')</th>
                        <th>@lang('layout.CreatedAt')</th>
                        <th>@lang('layout.Actoins')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

<!-- END CONTENT BODY -->


@stop

@push('scripts')

<script>
    jQuery(document).ready(function() {
        $(function() {
            $('#product-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{route("product.index")}}',
                pageLength:'{{getPageRows()}}',
                columns: [
                   /* { data: 'id', name: 'id' },*/
                    { data: 'name', name: 'name' },
                    { data: 'code', name: 'code' },
                    { data: 'slug', name: 'slug' },
                    { data: 'description', name: 'description' },
                    { data: 'updated_at', name: 'Updated_at' },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'actions', name: 'actions' },


                ]
            });
        });
    });
</script>
<!-- END INTERNAL SCRIPT -->
@endpush
