@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    <div id="print-modal">
         <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'InventorySite'" @closed="closeModal">

                <div slot="body">
                    <input type="hidden" name="type" value="procurementRoll"/>
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Employee')</label>
                                <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                                <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Type') </label>
                                <select name="types" id="" class="form-control">
                                    <option value="">@lang('layout.Select')</option>
                                    <option value="detail">@lang('layout.Details')</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" 
                                            autocomplete="off" name="from_date">
                                        
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" 
                                            autocomplete="off" name="to_date">
                                       
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
         </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Procurement')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    <a href="{{route('procurementNa_roll.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-list"></i> @lang('layout.NegativeQuantity')
                        </button>
                    </a>
                    @permission('procurement-export')

                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                    </span>
                        @endpermission
                    @permission('procurement-create')
                        <a href="{{route('procurement_roll.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="procurement">
                    <thead>
                        <tr> 
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Account')</th> 
                            <th>@lang('layout.Amount')</th> 
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Employee')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- <div id="factor-obj" >
        @if (Session('message'))
            <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif
    </div> -->



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>

    function factorPrint(id) {


        $.ajax({
            // This PHP file will generate the PDF and save it to your server
            // $pdf->Output('path/to/pdf/file.pdf', 'F');
            url: "{{url('/')}}/salePrint/"+id,
            type: 'get',
            cache: false,

        }).done(function () {

            var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

            $('#factor-obj').html(s);


            // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
        })
            .fail(function () {
                console.log("error");
            });


    }

    let data_table = null;
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table =  $('#procurement').DataTable({
            ajax: '{{route("procurement_roll.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true, 
            paging:         true,
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns: [
            { data: 'procurement_number', name: 'procurement_number' },
            { data: 'name', name: 'name' },
            { data: 'total', name: 'total' },
            { data: 'dates', name: 'dates' },
            { data: 'member_name', name: 'member_name' },
            { data: 'description', name: 'description' },
            { data: 'user', name: 'user' },
            { data: 'actions', name: 'actions' }
 
            ] 
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });






var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                employee:[],
                selected_employee:null,

            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Employee'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.employee = [];
                            vm.employee = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
        }
    }
});




        $('#btnPrint').click(function() {
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: '{{route("sale.show",1)}}',
                type: 'get',
                cache: false,

            }).done(function () {

                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                $('#factor-obj').html(s);


                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
                .fail(function () {
                    console.log("error");
                });

            // window.print();
            // window.open("data:application/pdf," + escape(data=""));
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: '{{route("sale.show",1)}}',
                type: 'get',
                cache: false,

            }).done(function() {

                var s = ' <object  data="'+'{{url('factor22.pdf')}}'+'" type="application/pdf" width="0" height="0"> </object>'

                $('#factor-obj').html(s);





                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                .fail(function() {
                    console.log("error");
                });

        });


    } );

   
    // start app
    Vue.component('v-select', VueSelect.VueSelect)
</script>


@endpush
