@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")

<div class="" >

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewProcurement') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
           
            <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                  <!-- begin sale order modal -->
                
                <!-- end sale order modal -->

                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'procurement_roll.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                {{ csrf_field() }}

                    <div class="form-body">
                         <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                            <div class="row">
                                <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" class="form-control">
                                      </div>
                                    </div> 
                                </div -->
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                    <v-select placeholder="@lang('layout.ExpenseAccount')" tabindex = "5" label="name"  :options="{{ json_encode($Expense) }}" v-model="expenseAccount" ></v-select>
                                    <input type="hidden" name="expense_account" v-validate="'required'" data-vv-as="@lang('layout.ExpenseAccount')" :value="(expenseAccount)?expenseAccount.id:null">
                                    <span class="required">@{{ errors.first('expense_account') }}</span>
                                </div>
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" name="date"  class="form-control date" autocomplete="off">
                                    </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Employee')</label>
                                    <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                                    <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                                </div>
                            </div>  
                            <div class="row">
                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $number }}"
                                                data-vv-as="@lang('layout.Number')" />
                                        <span class="required">@{{ errors.first('number') }}</span>
                                      </div>
                                  </div> 
                              </div>
                              @if(getNegativeSale() == 'true')
                              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                  <div class="col-md-12 form-group">
                                      <label class=" control-label">@lang('layout.NegativeQuantity')</label>
                                      <div class="col-md-12 mt-checkbox">
                                          <label class="mt-checkbox mt-checkbox-outline">
                                              <input type="checkbox" name="negative_qty" value="ok">
                                              <span></span>
                                          </label>
                                      </div>
                                  </div>
                              </div>
                              @endif
                              <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea  name="description" class="form-control" rows="2"  ></textarea>
                                      </div>
                                  </div> 
                              </div>
                            </div>
                          <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                        <!-- begin total -->
                           <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                      <td>
                                        <small>@lang('layout.Total') :</small>
                                      </td>
                                      <td class="text-right"><span data-counter="counterup"
                                         data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                                        </td>
                                    </tr>
                                 </table>
                           </div>
                        </div>
                    </div> 
                    




                     <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                         <table id="table_content" class="table table-bordered table-advance">
                          <thead>
                          <tr>
                            <th class="text-center" style="min-width: 8px;"> # </th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.ItemName')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Measure')</th>
                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Westage')</th>
                            <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Length')</th>
                            <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                            <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                            <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Price')</th>
                            <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                            <th class="text-center" style="width: 10px;"></th>
                          </tr>
                          </thead>
                          <tbody>
                          <tr v-for="(service,index) in inventories">
                            <td>@{{index+1}}</td>
                            <td>
                              <v-select label="name" v-model="service.selected_sub_item_name" :options="FormilaItemsName" @search="onItemSearchName" @input="change_name(index)" @click.native="addNew('inventory',index)" placeholder="@lang('layout.Name')" style=""></v-select>
                            </td>
                            <td>
                              <v-select label="name" v-model="service.item" :options="temp_itemes" @click.native="getdata(index)" @search="onItemSearchFormila" placeholder="@lang('layout.Code')" style="width: 150px;"></v-select>
                              <input type="hidden" id="item_id" name="m_stocks_in_id[]" :value="(!service.item)?null:service.item.id">
                              <input type="hidden" name="main_stock_id[]" :value="(!service.item)?null:service.item.main_stock_id">
                              <input type="hidden" name="item[]" :value="(!service.item)?null:service.item.items_id">
                              <input type="hidden" name="inventory_id_out[]" :value="(!service.item)?null:service.item.inventory_id">
                              <input type="hidden" name="inventory_measure[]" :value="(!service.item)?null:service.item.measure_id">
                              <input type="hidden" name="inventory_site_id[]" :value="(!service.item)?null:service.item.inventory_site_id">
                            </td>
                            <td>
                              <input :value="(!service.item)?null:service.item.Measure" class="form-control" placeholder="@lang('layout.Measure')" readonly>
                            </td>
                            <td>
                              <input name="quantity[]" id="item_quantity" ref="OnHand" type="number" @input="change_qut(index)" :value="(!service.item)?null:service.item.OnHand" class="form-control" placeholder="@lang('layout.Quantity')">
                            </td>
                            <td>
                              <input name="lengths_out" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.item)?null:service.item.lengths" class="form-control" placeholder="@lang('layout.Length')">
                            </td>

                            <td>
                              <input type="number" name="quantityall[]" :value="(!service.item)?null:service.item.qut_temp" placeholder="@lang('layout.OnHand')" readonly class='form-control'>
                            </td>
                            <td>
                              <input type="number" readonly :value="(!service.item)?null:service.item.widths" class="form-control" placeholder="@lang('layout.Width')">
                            </td>
                            <td v-show="showWhat('other_measure')=='yes'">
                                <div class="input-group">
                                    <input type="number" name="other_measure[]"
                                    class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(service.item==null)?null:service.item.o_measure">
                                    <span class="input-group-addon">
                                        @{{myRound((service.item==null)?null:service.item.other_measure)}}
                                    </span>
                                </div>
                            </td>
                            <td v-show="showWhat('other_measure2')=='yes'">
                                <div class="input-group">
                                    <input type="number" name="other_measure2[]" 
                                    class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(service.item==null)?null:service.item.o_measure2">
                                    <span class="input-group-addon">
                                        @{{myRound((service.item==null)?null:service.item.other_measure2)}}
                                    </span>
                                </div>
                            </td>
                            <td>
                              <input name="cost[]" type="number" :value="(!service.item)?null:service.item.per_price" ref="per_price" @input="setNewRate(index)" readonly class="form-control" placeholder="@lang('layout.Price')">
                            </td>

                            <td>
                              @{{myRound((service.item==null)?null:(service.item.per_price)*((service.item==null)?null:service.item.OnHand))}}
                            </td>
                            <td>
                              <span v-if="index != 0" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>

                          </tr>
                          </tbody>
                      </table>

                     <hr>
                       <!-- begin service -->
                     
                     <!-- end service -->
                     <hr>
                     <!-- begin payments -->
                   
                     <!-- end payments -->
                     </div>
                    <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addItems('procurement')">@lang('layout.AddItem')
                    </button>

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <button type="button" class="btn blue" @click="saveAndNew($event)" v-if="!isError" >@lang('layout.SaveAndNew')</button>
                            <a href="{{route('procurement_roll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>               
                                   
                     
                    </div>
                     
                {!! Form::close() !!}
                 
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
  Vue.component('v-select', VueSelect.VueSelect);

// end new member

var inventory_category = {!! $inventory_category !!};
  
  var v = new Vue({
    el: '#appInvoice',
    data: {
       expenseAccount:null,
       temp_items:[],
	    inventory_category:inventory_category,
	    selected_index:0,
       selected_iventory_category:null,
        temp_itemes: [],
       FormilaItemsName: [],
       employee:[],
       selected_employee:null,
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
          {item:null},
          {item:null},
          {item:null},
          {item:null},
       ],
       
    },
    computed:{
       

          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  
                      var quantity = this.inventories[i]['item']['OnHand'];
                      var rate = this.inventories[i]['item']['per_price'];
                      var new_rate = this.inventories[i]['item']['per_price'];
                        // var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        // var measure_unit=this.inventories[i]['item']['measure_unit'];
                        // if(new_rate !=rate && quantity>0)
                        // {
                           sum +=new_rate*quantity;
                        // }
                        // else
                        // {
                        //   sum +=quantity*((rate*smeasure_unit/measure_unit));
                        // }
                        
                    }

                }
              
                return myRound(sum);
          },

          // check payed amount
        
            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 for (var i = 0; i < this.inventories.length; i++)
                 {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 }
                 if(this.inventories.length==0 || flag==false)
                 {
                    isError = true;
                 }
                return isError;
              

            },
    },
    methods:
    {
		
		handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
						// alert(e.target);
                        regForm(e.target);
                    }
                });
            },
		
         // set new price
       setNewRate(type=null,index)
       {
          if(type=='inventory')
          { 
              if(this.inventories[index].item)
              {
                 this.inventories[index].item.new_rate = this.$refs.in[index].value;
              }
          }
        
       },
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },

       MemberSearch: _.debounce((search, loading) => {
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Employee'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    v.employee = [];
                    v.employee = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),
       
           // calculate item price based on measure change
       
       // detect member change and searh

       change_lengths(index) {
        if (this.inventories[index].item) {
          var per_qut_in = this.inventories[index].item.per_qut_in;
          var lengths = this.$refs.lengths[index].value;
          this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          // this.inventories[index].item.OnHand = (per_qut_in * lengths).toFixed(1);
        }
        // setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
       
       change_qut(index) {

        if (this.inventories[index].item) {
          var per_qut_in = this.inventories[index].item.per_qut_in;
          var OnHand = this.$refs.OnHand[index].value;
          this.inventories[index].item.OnHand = this.$refs.OnHand[index].value;
          // this.inventories[index].item.lengths = (OnHand / per_qut_in).toFixed(1);
        }

        // setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
        },

       //ajax call to get items code
      onItemSearchName: _.debounce((search, loading) => {
        item_id = '';
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'assemblySubListNameProcurmentRoll',
              keyword: search,
              item_id: item_id,
            }
          })
          .then(function(response) {
            v.FormilaItemsName = [];
            if (response.data.length > 0) {
              v.FormilaItemsName = response.data;
              console.log('FormilaItemsName', v.FormilaItemsName);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),


      //ajax call to get items code
      change_name(index) {
        // console.log('in num',index,'aa',v.inventories[index].selected_sub_item_name.items_id);
        this.selected_index = index;
        var item_id = (v.inventories[index].selected_sub_item_name)?v.inventories[index].selected_sub_item_name.items_id:null;
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'itemSearchProcurmentRoll',
              item_id: item_id,
            }
          })
          .then(function(response) {
            v.temp_items[index] = [];
            if (response.data.length > 0) {
              v.temp_items[index] = response.data;
              v.inventories[index].item = null;
              console.log('temp_items', v.temp_items[index]);
            }
          })
          .catch(function(error) {
            console.log(error);
          });
      },




      //ajax call to get items code
      onItemSearchFormila: _.debounce((search, loading) => {
        console.log(12);
        if (v.inventories[v.selected_index].selected_sub_item_name) {
          item_id = v.inventories[v.selected_index].selected_sub_item_name.items_id;
          loading(true);
          axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'itemSearchProcurmentRoll',
              keyword: search,
              item_id: item_id,
            }
          })
          .then(function(response) {
            if (response.data.length > 0) {
              v.temp_itemes = [];
              v.temp_items[v.selected_index] = [];
              v.temp_items[v.selected_index] = response.data;
              v.temp_itemes = response.data;
              console.log('temp_items', v.temp_items[this.selected_index]);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
        }
      }, getDebounceTime()),

      // end contract search

      // generic function for adding item to list
      addNew(type = null, index) {
        // this.temp_items=[];
        if (type != null) {
          if (type == 'inventory') {
            if (this.inventories[index + 1] == undefined) {
              // this.temp_items=[];
              this.inventories.push({
                item: null
              });
            }
          }


        }

      },

      // generic function for adding item to list
      getdata(index) {
        this.selected_index = index;
        this.temp_itemes = this.temp_items[index];

      },

   
       //ajax call to get items
       onItemSearch:_.debounce((search,loading)=>{
          loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'itemSearchProcurment',
              keyword:search,
            }
           })
           .then(function (response)
           {
             v.temp_items=[];
             if(response.data.length>0)
             {
               console.log('ddddd',response.data)
                v.temp_items=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
      
        addItems(type)
       { 
            if(type !=null)
            {
                if(type=="procurement")
                { 
                    this.temp_items=[];
                   this.inventories.push({item:null}); 
                }
                
            }
                 
          },

       // end item search

       // contract search
		
		
		//ajax call to get items
        setIndex(e)
        {
           //v.temp_items=[];
          this.selected_index=e;
        },

		 itemCategoryChange(index){
           v.setIndex(index);
            v.selected_iventory_category=this.inventories[this.selected_index]['item_category'];
          if(this.inventories[this.selected_index]['item_category'] !=null)
			  {
			   let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';
			   
			   axios.get("{{route('callMethod.search')}}",{
				params:{
				  member_id:v.member_id,
				  method_name:'itemSearchProcurment',
				  inventory_category_id: inventory_category_id
				}
			  })
			  .then(function(response){
				v.temp_items = [];
				if(response.data.length >0)
				{
				  v.temp_items = response.data;
				}
			  })
			  .catch(function(error){
				console.log(error);
			  });
			}
		 },

      
        
       // end contract search

       // in here you can check and decide to allow duplicate bank for payment or not
       
       
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
             
         }
          
       },
       // submit the form

        saveAndNew()
        {
            this.$validator.validate()
            .then(valid =>{
                if(valid)
                { 
                    var url="{{route('procurement_roll.store')}}";
                    form_id='sales-form';
                    var data= $('#'+form_id).serialize();
                    // console.log(444, data);
                    toggleBlock(true);
                    axios.post(url,data)
                    .then(function(response){
                            toggleBlock(0);
                            if(response.data.result==1)
                            {
                                $('#'+form_id).trigger('reset');
                                
                                toastr.success('',response.data.message); 
                                location.reload();
                            
                            }
                            else
                            {
                                var message="{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('',message);
                            }
                    })
                    .catch(function(error){
                    toggleBlock(0);
                        console.log(error);
                        var message="{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('',message);
                    });
                
                }
            })
        },
       
    },
    

  });

</script>



@endpush