@extends('layouts.factor-master')
<?php 
$reportTitle = __('layout.ProcurementReport');
?>
@section('content')
<?php
$report=customeReport('adjustment','index');
?>

<?php
$reports=customeReport('adjustment_detail');
$_item_name=in_array('item_name', $reports);
$_site=in_array('site', $reports);
$_measure=in_array('measure', $reports);
$_quantity=in_array('quantity', $reports);
$_currency=in_array('currency', $reports);
$_price=in_array('price', $reports);
$_total_amount=in_array('total_amount', $reports);
?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.ProcurementReport')</h3>
  <table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>

@if(count($data) > 0) 
  <table class="main-table">
<thead>
<tr class="bg">
  <td class="center"><div > @lang('layout.Number')</div></td>
  <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">@lang('layout.Account')</td>
  <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Date')</td>
  <td style="display: <?=(!show('description',$report))?'none':'';?>" class="center">@lang('layout.Description')</td>
  <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Employee')</td>
  <!-- <td style="display: <?=(!show('reference_number',$report))?'none':'';?>" class="center">@lang('layout.ReferenceNumber')</td> 
  <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">@lang('layout.Quantity')</td> -->
  <td style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">@lang('layout.TotalAmount')</td>
  <td class="center">@lang('layout.User')</td>
 </tr>
</thead> 
<tbody>
 <?php
 $count = 0;
 $total = 0;
 ?>
 @foreach($data AS $record) 
 <?php
 $total += $record->total;
 ?>
 <tr>
 <td class="center">{{$record->procurement_number}}</td>
 <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->name}}</td>
 <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{convertDate($record->date)}}</td>
 <td style="display: <?=(!show('description',$report))?'none':'';?>" class="center">{{$record->description}}</td>

 <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{$record->employee}}</td>
 <!-- td style="display: <?=(!show('reference_number',$report))?'none':'';?>" class="center">{{$record->ref_no}}</td>
 <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->quantity}}</td -->
 <td style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">{{$record->total}}</td>
 <td class="center">{{$record->user}}</td>
</tr>
  @endforeach   
  <tr>
    <td colspan="2" class="center">@lang('layout.TotalAmount')</td>
    <td colspan="3" class="center">{{$total}} {{getHomeCurrency()[getCurrencyType()]}}</td>
  </tr>
</tbody>
</table>
@endif

@if(count($detail) > 0) 
<table class="main-table">
  <tr class="bg"> 
    <td class="center"><div > @lang('layout.Number')</div></td>
    <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">@lang('layout.Account')</td>
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Date')</td>
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Employee')</td>
    @if($_item_name)<td  class="center">@lang('layout.ItemName')</td>@endif
    @if($_site)<td  class="center">@lang('layout.Site')</td>@endif
    @if($_measure)<td  class="center">@lang('layout.MeasureUnit')</td>@endif
    @if($_quantity)<td class="center">@lang('layout.Quantity')</td>@endif
    @if($_currency)<td  class="center">@lang('layout.Currency')</td>@endif
    @if($_price)<td class="center">@lang('layout.Price')</td>@endif
    @if($_total_amount)<td  class="center">@lang('layout.TotalAmount')</td>@endif
  </tr>
  <?php
  $count = 0;
  $total=0;
  ?>
  @foreach($detail AS $record)
  <?php
  $total+=$record->cost*$record->quantity;
  ?>
  <tr>
    <td class="center">{{$record->procurement_number}}</td>
    <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->name}}</td>
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{convertDate($record->date)}}</td>
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{$record->employee}}</td>
    @if($_item_name)<td  class="center">{{$record->item}}</td>@endif
    @if($_site)<td  class="center">{{$record->site}}</td>@endif
    @if($_measure)<td  class="center">{{$record->measure}}</td>@endif
    @if($_quantity)<td  class="center">{{$record->quantity}}</td>@endif
    @if($_currency)<td  class="center">{{Currency()->code}}</td>@endif
    @if($_price)<td  class="center">{{round($record->cost,2)}}</td>@endif
    @if($_total_amount)<td  class="center">{{$record->cost*$record->quantity}}</td>@endif
  </tr>
  @endforeach
  <tr class="bg">
    <td class="center"></td>
    <td class="center" colspan="2">@lang('layout.Total')</td>
    <td class="center" colspan="5">{{$total}}&nbsp;{{Currency()->code}}</td>
  </tr> 
</table>
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection