@extends('layouts.app')
@section('content')
    <div class="portlet ">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ProcurementInfo')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th>   
                                <i class="fa  fa-bars"></i> @lang('layout.Number')
                            </th> 
                            <th>
                                <i class="fa fa-user"></i> @lang('layout.Customer')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-money"></i> @lang('layout.Amount')
                            </th>
                            <th>
                                <i class=""></i> @lang('layout.Project')
                            </th>
                            @if(systemConfig()[20] != 0 )
                            <th>
                                <i class=""></i> @lang('layout.Contract')
                            </th>
                            <th>
                                <i class="fa fa-user"></i> @lang('layout.Employee')
                            </th>
                            <th>
                                <i class=""></i> @lang('layout.WagonNumber')
                            </th>
                            @endif
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Description')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.User')
                            </th>
                        </tr> 
                    </thead>
                    <tbody>
                        <tr>  
                            <td class=""> {{ $procurement->procurement_number }} </td>
                            <td class=""> {{ $procurement->customer_name }} </td>
                            <td class=""> {{ convertDate($procurement->date) }} </td>
                            <td class=""> {{ $procurement->total }} </td>
                            <td class=""> {{ $procurement->project_name }} </td>
                            @if(systemConfig()[20] != 0 )
                            <td class=""> {{ $procurement->contract_name }} </td> 
                            <td class=""> {{ $procurement->member_name }} </td>
                            <td class=""> {{ $procurement->wagon_number }} </td> 
                            @endif
                            <td class=""> {{ $procurement->description }} </td>
                            <td class=""> {{ $procurement->user }} </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ProcurementDetails')</span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="procurement_details"/>
                            <input type="hidden" name="id" value="{{$procurement->id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="procurement_details"/>
                            <input type="hidden" name="id" value="{{$procurement->id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                            <tr>  
                                <th>@lang('layout.ItemName')</th>
                                <th>@lang('layout.Site')</th>
                                <th>@lang('layout.MeasureUnit')</th>
                                <th>@lang('layout.Quantity')</th>
                                <th>@lang('layout.Price')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div> 
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#sales').DataTable({
                ajax:'{{route("procurement.show",$procurement->id)}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    { data: 'item', name: 'item' },
                    { data: 'site', name: 'site' },
                    { data: 'measure', name: 'measure_unit' },
                    { data: 'quantity', name: 'quatity' },
                    { data: 'cost', name: 'cost' },
                ]
            });
        });
    </script>
@endpush 