@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'InventorySite'" @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="type" value="procurement"/>
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label class="control-label">@lang('layout.Employee')</label>
                                            <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                                            <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Type') </label>
                                            <select name="types" id="" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                <option value="detail">@lang('layout.Details')</option>
                                            </select>
                                        </div>
                                        @if(systemConfig()[20] == 1)
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.ContractName')</label>
                                                    <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name"  @input="contractWagon()" :options="{{$contract}}">
                                                    </v-select>
                                                    <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                                </div>
                                            </div>
                                        </div> 
                                        @endif
                                        <div class="col-md-3">
                                            <label class="control-label">@lang('layout.Customer')</label>
                                            <v-select label="name" :options="customer" v-model="selected_customer" @search="MemberSearch1" ></v-select>
                                            <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id" required v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                            <span class="required">@{{ errors.first('customer_id') }}</span>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">             
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="procurement_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 15px !important;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>  
                                                </div>
                                            </div>
                                            <div class="margin-top-10">
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue" title="@lang('layout.SaveChanges')"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Procurement')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <a href="{{route('procurementNa.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-list"></i> @lang('layout.NegativeQuantity')
                        </button>
                    </a>
                    @permission('procurement-export')
                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                    </span>
                    @endpermission
                    @permission('procurement-create')
                    <a href="{{route('procurement.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="procurement">
                    <thead>
                        <tr> 
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Account')</th> 
                            <th>@lang('layout.Customer')</th> 
                            <th>@lang('layout.Amount')</th> 
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Employee')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Project')</th>
                            @endif
                            @if(systemConfig()[20] != 0 )
                            <th>@lang('layout.Contract')</th>
                            <th>@lang('layout.WagonNumber')</th>
                            @endif
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- <div id="factor-obj" >
        @if (Session('message'))
            <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>
        @endif
    </div> -->
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('procurement_index')!!};

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        function factorPrint(id) {
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: "{{url('/')}}/salePrint/"+id,
                type: 'get',
                cache: false,
            }).done(function () {
                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
                $('#factor-obj').html(s);
                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
            .fail(function () {
                console.log("error");
            });
        }
        let data_table = null;
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =  $('#procurement').DataTable({
                ajax: '{{route("procurement.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true, 
                paging:         true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                { data: 'procurement_number', name: 'procurement_number' },
                { data: 'name', name: 'name' },
                { data: 'customer_name', name: 'customer_name'},
                { data: 'total', name: 'total' },
                { data: 'dates', name: 'dates' },
                { data: 'member_name', name: 'member_name' },
                @if(systemConfig()[5] != 0 )
                { data: 'project_name', name: 'project_name' },
                @endif
                @if(systemConfig()[20] != 0 )
                { data: 'contract_name', name: 'contract_name' },
                { data: 'wagon_number', name: 'wagon_number' },
                @endif
                { data: 'description', name: 'description' },
                { data: 'user', name: 'user' },
                { data: 'actions', name: 'actions', orderable:false, searchable:false }
                ] 
            });
            new Vue({
                el: '#company_ll',
                methods: {
                    setCompany: function (event) {
                        if (typeof data_table == 'object') {
                            data_table.clear();
                            data_table.ajax.reload();
                        }
                    }
                }
            });
            var contract = {!! $contract !!};
            var vm =new Vue({
                el: '#print-modal',
                data:{
                    is_show:false,
                    pdfRoute: '{!!route("export.PDFAll") !!}',
                    excelRoute: '{!! route("export.ExcelAll") !!}',
                    employee:[],
                    selected_employee:null,
                    selectedContract: null,
                    customer: [],
                    selected_customer: null,
                    customReportData:[
                        {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                        {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                        {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                        {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                        {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_rep.project)?'checked':'',checkedColumn:(cust_rep.project)?'checked':'',column_percentage:(cust_rep.project___percent)?cust_rep.project___percent:''},
                        {Name: '@lang("layout.Contract")', column_name: 'contract',checkedColumn:(cust_rep.contract)?'checked':'',checkedColumn:(cust_rep.contract)?'checked':'',column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''},
                        {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                        {Name: '@lang("layout.Employee")', column_name: 'employee',checkedColumn:(cust_rep.employee)?'checked':'',checkedColumn:(cust_rep.employee)?'checked':'',column_percentage:(cust_rep.employee___percent)?cust_rep.employee___percent:''},
                        {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                        {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                        {Name: '@lang("layout.MeasureUnit")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                        {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                        {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                        {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                        {Name: '@lang("layout.TotalAmount")', column_name: 'totalAmount',checkedColumn:(cust_rep.totalAmount)?'checked':'',checkedColumn:(cust_rep.totalAmount)?'checked':'',column_percentage:(cust_rep.totalAmount___percent)?cust_rep.totalAmount___percent:''},
                        {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                    ],
                    cust_rep:cust_rep
                },  
                methods:{
                    MemberSearch1: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.customer = [];
                                vm.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),
                    closeModal: function(){
                    this.is_show = !this.is_show
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Employee'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vm.employee = [];
                                vm.employee = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),
                }
            });
            new Vue({
                el:'#anchore-modal',
                methods:{
                    showModal:function(){
                        console.log('trr')
                        vm.$data.is_show = true;
                    }
                }
            });
            $('#btnPrint').click(function() {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,
                }).done(function () {
                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
                    $('#factor-obj').html(s);
                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                .fail(function () {
                    console.log("error");
                });
                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,
                }).done(function() {
                    var s = ' <object  data="'+'{{url('factor22.pdf')}}'+'" type="application/pdf" width="0" height="0"> </object>'
                    $('#factor-obj').html(s);
                        // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                    })
                    .fail(function() {
                        console.log("error");
                });
            });
        });
        // start app
        Vue.component('v-select', VueSelect.VueSelect)
    </script>
@endpush