@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
<style>
</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
  <div class="" >
    <div class="portlet light bg-inverse" style="min-height: 100%;">
      <div class="portlet-title">
        <div class="caption">
          <i class="icon-equalizer font-green-haze"></i>
          <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditProcurement') </span>
          <!-- <span class="caption-helper">some info...</span> -->
        </div>
        <div class="tools">
          <a href="" class="collapse" data-original-title="" title=""> </a>
          <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
          <a href="" class="reload" data-original-title="" title=""> </a>
          <a href="" class="remove" data-original-title="" title=""> </a>
        </div>
      </div>
      <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
        {{Form::model($procurement,['route' => ['procurement.update',$procurement->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
          <div class="form-body">
            <div class="row">
              <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                <div class="row">
                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                    <label class="control-label">@lang('layout.ExpenseAccount')</label>
                    <v-select placeholder="@lang('layout.ExpenseAccount')" tabindex = "5" label="name"  :options="{{ json_encode($Expense) }}" v-model="expenseAccount" ></v-select>
                    <input type="hidden" name="expense_account" v-validate="'required'" data-vv-as="@lang('layout.ExpenseAccount')" :value="(expenseAccount)?expenseAccount.id:null">
                    <span class="required">@{{ errors.first('expense_account') }}</span>
                  </div>
                  <div class="col-md-4">
                    <label class="control-label">@lang('layout.Date')</label>
                    {{Form::text('date',null,['class' => 'form-control date' ,'step' => 'any','min' =>'0','autocomplete'=>'off'])}}
                  </div>
                  <div class="col-md-4">
                    <label class="control-label">@lang('layout.Employee')</label>
                    <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                    <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                  </div>
                </div>
                <div class="row">
                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                    <div class="">
                      <label class="control-label">@lang('layout.Number')</label>
                      <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $procurement->procurement_number }}" data-vv-as="@lang('layout.Number')" />
                      <span class="required">@{{ errors.first('number') }}</span>
                    </div>
                  </div>
                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                    <div class="">
                      <label class="control-label">@lang('layout.Customer')</label>
                      <v-select label="name" :options="customer" v-model="selected_customer" @search="MemberSearch1"></v-select>
                      <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id" v-validate="''" data-vv-as="@lang('layout.Customer')">
                      <span class="required">@{{ errors.first('customer_id') }}</span>
                    </div>
                  </div>
                  @if(systemConfig()[5] != 0 )
                    <div class="col-md-4">
                      <label class="control-label">@lang('layout.Project')</label>
                      <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                      </v-select>
                      <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                    </div>
                  @endif
                </div>
                <div class="row">
                  <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <div class="">
                      <label class="control-label">@lang('layout.Description')</label>
                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1)) !!}  
                    </div>
                  </div>
                  @if(systemConfig()[20] == 1)
                  <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                      <div class="form-group">
                          <div class="col-md-12">
                              <label class="control-label">@lang('layout.ContractName')</label>
                              <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                      v-model="selectedContract" label="company_name"
                                      @input="contractWagon()" :options="{{$contract}}">
                              </v-select>
                              <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                          </div>
                      </div>
                  </div>
                  <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                      <div class="form-group">
                          <div class="col-md-12">
                              <label class="control-label">@lang('layout.WagonNumber')</label>
                              <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                      v-model="selectedWagon" label="name"
                                      :options="wagon">
                              </v-select>
                              <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                          </div>
                      </div>
                  </div>
                  @endif
                </div>
                <div class="row">
                  @if(getNegativeSale() == 'true')
                  <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <div class="col-md-12 form-group">
                      <label class=" control-label">@lang('layout.NegativeQuantity')</label>
                      <div class="col-md-12 mt-checkbox">
                        <label class="mt-checkbox mt-checkbox-outline">
                          <input type="checkbox" name="negative_qty" <?php if($procurement->use_type == 'ok'){echo 'checked';} ?> value="ok">
                          <span></span>
                        </label>
                      </div>
                    </div>
                  </div>
                  @endif
                </div>
              </div>
              <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                  <div class="dashboard-stat2" style="margin-top: 1.2em;">
                    <table class="dashboard-tabel" width="100%">
                      <tr>
                        <td>
                          <small>@lang('layout.Total') :</small>
                        </td>
                        <td class="text-right"><span data-counter="counterup"
                            data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                        </td>
                      </tr>
                    </table>
                  </div>
                </div>
              </div>
              <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                <!-- begin inputs -->
                  <div class="row">
                      <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                          <div class="form-group">
                            <div class="col-md-12">
                              <label class="control-label">@lang('layout.ReferenceNumber')</label>
                            {{Form::number('ref_no',null,['class' => 'form-control' ,'step' => 'any','min' =>'0'])}}

                            </div>
                          </div> 
                      </div -->     
                  </div>
                  <div class="row">
                  </div>
                <!-- end inputs -->
              </div>
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"></div>
            </div> 
            <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
              <table id="table_content" class="table table-bordered table-advance">
                <thead>
                  <tr>
                    <th class="text-center" style="min-width: 8px;"> # </th>
                    <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                    <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                    <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                    <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                    <!-- th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th -->
                    <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                    <th style="min-width: 20px;"></th>
                  </tr>
                </thead>
                <tbody>
                  <tr v-for="(item,index) in inventories">
                    <td>@{{index+1}}</td>
                    <td v-show="showWhat('sale_category')=='yes'">
                      <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange(index)"></v-select>
                      <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                    </td>
                    <td class="highlight">
                      <v-select label="name" v-model="item.item" :options="temp_items" @Click.native="setIndex(index)" @search="onItemSearch"></v-select>
                      <input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">
                    </td>
                    <td class="highlight">
                      <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                          <option value="null">@lang('layout.Select')</option>
                          <span v-if="(item.item != null)">
                          <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                            @{{site.site_name}}
                          </option> 
                        </span>
                      </select>
                      <input type="hidden" name="from_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                    </td>
                    <td>
                      <input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" @click="addNew('inventory',index)" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                    </td>
                    <td> 
                      @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                    </td>
                    <td class="highlight">
                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                        <option value="null">@lang('layout.Select')</option>
                        <span v-if="(item.item ==null)?false:true">
                          <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                            @{{measure.measure_name}}
                          </option> 
                        </span>
                      </select>                                       
                      <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                    </td>
                    <td>
                      <div class="input-group">
                        <input type="hidden" name="cost[]"  placeholder="@lang('layout.Cost')"   :value="(item.item==null)?null:(item.item.new_rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                        <input type="number" class="form-control inner_input" :value="(item.item==null)?null:getItemTotals(item.item,1)" placeholder="@lang('layout.Total')" disabled>
                      </div>
                    </td>
                    <td>
                      <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                    </td>
                  </tr>
                </tbody>
              </table>
              <hr>
              <!-- begin service -->
              <!-- end service -->
              <hr>
              <!-- begin payments -->
              <!-- end payments -->
            </div>
            <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addItems('procurement')">@lang('layout.AddItem')</button>
            <div class="row">
              <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-center" style="margin-top: 10px;">
                <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('procurement.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
              </div>
            </div>               
          </div>
        {!! Form::close() !!}
      </div>                  
      <!-- END FORM-->
    </div>
  </div> 
@endsection
@push('scripts')
<script type="text/javascript">
  @if(App::getLocale())
  Vue.use(VeeValidate, {
    locale: '{{App::getLocale()}}',
  });
  @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif

  Vue.component('v-select', VueSelect.VueSelect);
  var selected_item = {!!$selectedItems!!}
  var inventory_category = {!! $inventory_category !!};
  var selectedMember = {!! json_encode($selectedMember) !!};
  var project={!! $project!!};
  var wagon= {!! $wagon !!};
  var procurement= {!! json_encode($procurement) !!};
  var selected_customer = {!! json_encode($selected_customer) !!};
  // end new member
  var v = new Vue({
    el: '#appInvoice',
    data: {
	    expenseAccount:null,
      temp_items:[],
      selected_item:selected_item,
      inventory_category:inventory_category,
      selected_index:0,
      selected_iventory_category:null,
      employee:[],
      selectedContract: null,
      wagon: wagon,
      wagonAll: wagon,
      selectedWagon: null,
      selectedProject: project,
      project_list: [],
      selected_employee:selectedMember,
      procurement:procurement,
      customer: [],
      selected_customer: selected_customer,
      newCost:[
      null,
      null,
      null,
      null],
      inventories:[],
    },
    computed:{
          // calculate subtotal
          subtotal:function (){
            var sum = 0;
            for (var i = 0; i < this.inventories.length; i++) {
              if (this.inventories[i].item && this.inventories[i].item !=null){  
                var quantity=this.inventories[i]['item']['quantity'];
                var rate=this.inventories[i]['item']['rate'];
                var new_rate=this.inventories[i]['item']['new_rate'];
                var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                var measure_unit=this.inventories[i]['item']['measure_unit'];
                if(new_rate !=rate && quantity>0)
                {
                    sum +=new_rate*quantity;
                }
                else
                {
                  sum +=quantity*((rate*smeasure_unit/measure_unit));
                }   
              }
            }
            return sum;
          },
          // check data validation
          isError: function () {
                var isError = false;
                var flag=false;
                 for (var i = 0; i < this.inventories.length; i++)
                 {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['price'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 }
                 if(this.inventories.length==0 || flag==false)
                 {
                    isError = true;
                 }
                return isError;
              

            },
    },
     mounted:function(){
       // initialize the selected item
       if(procurement.contract_id !='' && procurement.contract_id !=null)
         {
              this.selectedContract = _.find({!! $contract !!}, (a) => a.id == this.procurement.contract_id);
          }

          if(this.procurement.wagon_number !='' && this.procurement.wagon_number !=null)
          {
              this.selectedWagon = _.find({!! $wagon !!}, (a) => a.name == this.procurement.wagon_number);
          }


        for(var i=0;i<this.selected_item.length;i++)
        {
          console.log('ssssssss',this.selected_item[i]);
          this.inventories.push({item:this.selected_item[i],item_category:this.selected_item[i].item_category});
        }
        for(var m=4;m>this.selected_item.length;m--)
          {
            this.inventories.push({item:null});
          }
        },
    methods:
    {
    MemberSearch1: _.debounce((search, loading) => {
      loading(true);
      
      axios.get("{{route('callMethod.search')}}", {
          params: {
              method_name: 'SearchMember', 
              keyword: search,
              type: 'Customer'
          }
      })
      .then(function(response) {
          if (response.data.length > 0) {
              v.customer = [];
              v.customer = response.data;
          }
          loading(false);
      })
      .catch(function(error) {
          loading(false);
          console.log(error);
      })
    }, getDebounceTime()),
		handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
						// alert(e.target);
                        regForm(e.target);
                    }
                });
            },
		
         // set new price
       setNewRate(type=null,index)
       {
          if(type=='inventory')
          { 
              if(this.inventories[index].item)
              {
                 this.inventories[index].item.price = this.$refs.in[index].value;
              }
          }
        
       },
       // Search Project

       
      //  Contract Wagon Started ...........................................................

       contractWagon() {
          this.wagon = this.wagonAll;
          if (this.selectedContract) {
              // contract_id = this.inventories[index]['contract'].id;s
              this.wagon = this.wagonAll.filter((wagon) => {
                  return this.selectedContract.id == wagon.contract_id;
              });

          }
      },

      // Contract Wagon Finished .................................................................
      
				ProjectSearch:_.debounce((search,loading)=>{
				   v.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						v.project_list=response.data;
						// console.log('test 22',sales.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       
           // calculate item price based on measure change
       
        MemberSearch: _.debounce((search, loading) => {
          loading(true);
          axios.get("{{route('callMethod.search')}}", {
              params: {
                  method_name: 'SearchMember', 
                  keyword: search,
                  type: 'Employee'
              }
          })
          .then(function(response) {
              if (response.data.length > 0) {
                  // console.log(response.data);
                  v.employee = [];
                  v.employee = response.data;
              }
              loading(false);
          })
          .catch(function(error) {
              loading(false);
              console.log(error);
          })
        }, getDebounceTime()),
       
   onItemSearch:_.debounce((search,loading)=>{
          loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'itemSearchProcurment',
              keyword:search,
            }
           })
           .then(function (response)
           {
             v.temp_items=[];
             if(response.data.length>0)
             {
                v.temp_items=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
        addItems(type)
       { 
            if(type !=null)
            {
                if(type=="procurement")
                { 
                    this.temp_items=[];
                   this.inventories.push({item:null}); 
                }
                
            }
                 
          },

       // end item search
	   
	   //ajax call to get items
        setIndex(e)
        {
           //v.temp_items=[];
          this.selected_index=e;
        },

		 itemCategoryChange(index){
           v.setIndex(index);
            v.selected_iventory_category=this.inventories[this.selected_index]['item_category'];
          if(this.inventories[this.selected_index]['item_category'] !=null)
          {
           let inventory_category_id = (v.inventories[v.selected_index]['item_category'] !=undefined)?v.inventories[v.selected_index]['item_category'].id:'';
           
           axios.get("{{route('callMethod.search')}}",{
            params:{
              member_id:v.member_id,
              method_name:'itemSearchProcurment',
              inventory_category_id: inventory_category_id
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;
            }
          })
          .catch(function(error){
            console.log(error);
          });
        }

        },

       // contract search


      
        
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }
             
             
          }
          
       },

       // in here you can check and decide to allow duplicate bank for payment or not
       
       
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
             
         }
          
       },
       // submit the form
	   setData:function() {
		this.expenseAccount               = _.find({!!json_encode($Expense) !!}, (o) => o.id == {{$procurement->account_id}});

	}
       
    },
    

  });

v.setData();
</script>



@endpush