@extends('layouts.factor-master')
<?php 
  $reportTitle = __('layout.ProcurementReport');
?>
@section('content')
<?php
  $report=customeReport('adjustment','index');
?>
<?php
  $report = customeReportNew('procurement_index');
    $_number = !in_array('number', $report);
    $_account = !in_array('account', $report);
    $_customer = !in_array('customer', $report);
    $_date = !in_array('date', $report);
    $_project = !in_array('project', $report);
    $_contract = !in_array('contract', $report);
    $_description = !in_array('description', $report);
    $_employee = !in_array('employee', $report);
    $_totalAmount = !in_array('totalAmount', $report);
    $_user = !in_array('user', $report);
    $_item_name = !in_array('item_name', $report);
    $_site = !in_array('site', $report);
    $_measure = !in_array('measure', $report);
    $_quantity = !in_array('quantity', $report);
    $_currency = !in_array('currency', $report);
    $_price = !in_array('price', $report);

  $report_percent = customeReportNewPercent('procurement_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_project_percent= (array_key_exists('project___percent', $report_percent))?$report_percent['project___percent']:null;
    $_contract_percent= (array_key_exists('contract___percent', $report_percent))?$report_percent['contract___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
    $_totalAmount_percent= (array_key_exists('totalAmount___percent', $report_percent))?$report_percent['totalAmount___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;

  // $reports=customeReport('adjustment_detail');
  //   $_item_name=in_array('item_name', $reports);
  //   $_site=in_array('site', $reports);
  //   $_measure=in_array('measure', $reports);
  //   $_quantity=in_array('quantity', $reports);
  //   $_currency=in_array('currency', $reports);
  //   $_price=in_array('price', $reports);  
  //   $_contarct=in_array('contract_name', $reports);  
  //   $_total_amount=in_array('total_amount', $reports);
?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.ProcurementReport')</h3>
  <table class="main-table">
    <tr>
      @if($from_date)
      <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
      </td>
      @endif
      @if($to_date)
      <td>
        <span>@lang('layout.ToDate')</span>:
        <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
      </td>
      @endif
      @if($contract_name)
      <td>
        <span>@lang('layout.Contract')</span>:{{$contract_name}}
      </td>
      @endif
    </tr>
  </table>
<br>
@if(count($data) > 0) 
<table class="main-table">
  <thead>
    <tr class="bg">
      @if($_number)
      <td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.Number')</div></td>
      @endif
      @if($_account)
      <td @if($_account_percent) width="{{$_account_percent}}%" @endif style="display: <?=(!show('account',$report))?'none':'';?>" class="center">@lang('layout.Account')</td>
      @endif
      @if($_customer)
      <td @if($_customer_percent) width="{{$_customer_percent}}%" @endif style="display: <?=(!show('account',$report))?'none':'';?>" class="center">@lang('layout.Customer')</td>
      @endif
      @if($_date)
      <td @if($_date_percent) width="{{$_date_percent}}%" @endif style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Date')</td>
      @endif
      @if($_project)
      <td @if($_project_percent) width="{{$_project_percent}}%" @endif style="display: <?=(!show('project',$report))?'none':'';?>" class="center">@lang('layout.Project')</td>
      @endif
      @if($_contract)
      <td @if($_contract_percent) width="{{$_contract_percent}}%" @endif style="display: <?=(!show('contarct',$report))?'none':'';?>" class="center">@lang('layout.Contract')</td>
      @endif
      @if($_description)
      <td @if($_description_percent) width="{{$_description_percent}}%" @endif style="display: <?=(!show('description',$report))?'none':'';?>" class="center">@lang('layout.Description')</td>
      @endif
      @if($_employee)
      <td @if($_employee_percent) width="{{$_employee_percent}}%" @endif style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Employee')</td>
      @endif
      <!-- <td style="display: <?=(!show('reference_number',$report))?'none':'';?>" class="center">@lang('layout.ReferenceNumber')</td> 
      <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">@lang('layout.Quantity')</td> -->
      @if($_totalAmount)
      <td @if($_totalAmount_percent) width="{{$_totalAmount_percent}}%" @endif style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">@lang('layout.TotalAmount')</td>
      @endif
      @if($_user)
      <td @if($_user_percent) width="{{$_user_percent}}%" @endif class="center">@lang('layout.User')</td>
      @endif
    </tr>
  </thead> 
  <tbody>
  <?php
    $count = 0;
    $total = 0;
    $colspan = 8;
  ?>
  @foreach($data AS $record) 
  <?php
    $total += $record->total;
  ?>
  <tr>
      @if($_number)
      <td class="center">{{$record->procurement_number}}</td>
      @endif
      @if($_account)
      <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->name}}</td>
      @endif
      @if($_customer)
      <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->customer_name}}</td>
      @endif
      @if($_date)
      <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{convertDate($record->date)}}</td>
      @endif
      @if($_project)
      <td style="display: <?=(!show('project',$report))?'none':'';?>" class="center">{{$record->project_name}}</td>
      @endif
      @if($_contract)
      <td style="display: <?=(!show('contarct',$report))?'none':'';?>" class="center">{{$record->contract_name}}</td>
      @endif
      @if($_description)
      <td style="display: <?=(!show('description',$report))?'none':'';?>" class="center">{{$record->description}}</td>
      @endif
      @if($_employee)
      <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{$record->employee}}</td>
      @endif
      <!-- td style="display: <?=(!show('reference_number',$report))?'none':'';?>" class="center">{{$record->ref_no}}</td>
      <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->quantity}}</td -->
        @if($_totalAmount)
      <td style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">{{$record->total}}</td>
      @endif
      @if($_user)
      <td class="center">{{$record->user}}</td>
      @endif
    </tr>
    @endforeach
      @if(!$_employee)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_description)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_contract)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_project)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_date)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_customer)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_account)<?php  $colspan = $colspan-1; ?>@endif    
      @if(!$_number)<?php  $colspan = $colspan-1; ?>@endif    
    <tr>
      <td colspan="{{$colspan}}" class="center" style="font-weight: bold;">@lang('layout.TotalAmount')</td>
      <td colspan="1" class="center">{{$total}} {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
  </tbody>
</table>
@endif
@if(count($detail) > 0) 
<table class="main-table">
  <tr class="bg"> 
    @if($_number)
    <th>
      <div class="center"> @lang('layout.Number')</div>
    </th>
    @endif
    @if($_account)
    <th style="display: <?=(!show('account',$report))?'none':'';?>" class="center">
      @lang('layout.Account')
    </th>
    @endif
    @if($_customer)
    <th style="display: <?=(!show('account',$report))?'none':'';?>" class="center">
      @lang('layout.Customer')
    </th>
    @endif
    @if($_date)
    <th style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
      @lang('layout.Date')
    </th>
    @endif
    @if($_description)
    <th class="center">
      @lang('layout.Description')
    </th>
    @endif
    @if($_employee)
    <th style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
      @lang('layout.Employee')
    </th>
    @endif
    @if($_item_name)
      <th  class="center">@lang('layout.ItemName')</th>
    @endif
    @if($_site)
      <th  class="center">@lang('layout.Site')</th>
     @endif
    @if($_measure)
      <th  class="center">@lang('layout.MeasureUnit')</th>
    @endif
    @if($_quantity)
      <th class="center">@lang('layout.Quantity')</th>
    @endif
    @if($_currency)
      <th  class="center">@lang('layout.Currency')</th>
    @endif
    @if($_price)
      <th class="center">@lang('layout.Price')</th>
    @endif
    @if($_totalAmount)
      <th  class="center">@lang('layout.TotalAmount')</th>
    @endif
  </tr>
  <?php
    $count = 0;
    $total=0;
    $colspan = 12;
  ?>
  @foreach($detail AS $record)
  <?php
    $total+=$record->cost*$record->quantity;
  ?>
  <tr>
    @if($_number)
    <td class="center">
      {{$record->procurement_number}}
    </td>
    @endif
    @if($_account)
    <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">
      {{$record->name}}
    </td>
    @endif
    @if($_customer)
    <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">
      {{$record->customer_name}}
    </td>
    @endif
    @if($_date)
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
      {{convertDate($record->date)}}
    </td>
    @endif
    @if($_description)
    <td class="center">
      {{$record->description}}
    </td>
    @endif
    @if($_employee)
    <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
      {{$record->employee}}
    </td>
    @endif
    @if($_item_name)
      <td  class="center">{{$record->item}}</td>
    @endif
    @if($_site)
      <td  class="center">{{$record->site}}</td>
    @endif
    @if($_measure)
      <td  class="center">{{$record->measure}}</td>
    @endif
    @if($_quantity)
      <td  class="center">{{$record->quantity}}</td>
    @endif
    @if($_currency)
      <td  class="center">{{Currency()->code}}</td>
    @endif
    @if($_price)
      <td  class="center">{{round($record->cost,2)}}</td>
    @endif
    @if($_totalAmount)
      <td  class="center">{{$record->cost*$record->quantity}}</td>
    @endif
  </tr>
  @endforeach
  @if(!$_number)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_account)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_customer)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_date)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_description)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_employee)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_item_name)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_site)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_measure)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_quantity)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_currency)      <?php  $colspan = $colspan-1;  ?>  @endif
  @if(!$_price)      <?php  $colspan = $colspan-1;  ?>  @endif
  <tr class="bg">
    <td class="center" colspan="{{$colspan}}" style="font-weight: bold;">@lang('layout.Total')</td>
    @if($_totalAmount)
    <td class="center" style="font-weight: bold;">{{$total}}&nbsp;{{Currency()->code}}</td>
    @endif
  </tr> 
</table>
@endif
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>     
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection