@push('scripts')
    <script type="text/javascript">
        Vue.component('report-modal', {
            props: ['pdfRoute', 'excelRoute', 'valueType'],
            data: function () {
                return {
                    print_type: 'pdf',
                    form_route: ''
                }
            },
            watch: {
                print_type(newVal, oldVal) {
                    console.log('print modal created');
                    console.log(this.pdfRoute);
                    console.log(this.excelRoute);
                    switch (newVal) {
                        case 'excel':
                            this.form_route = this.excelRoute;
                            break;
                        case 'pdf':
                            this.form_route = this.pdfRoute;
                            break;
                        default:
                            this.form_route = null;
                    }
                }
            },
            created() {
                if (this.pdfRoute == '' || typeof this.pdfRoute == undefined) {
                    this.form_route = this.excelRoute;
                } else if (this.excelRoute == '' || typeof this.pdfRoute == undefined) {
                    this.form_route = this.pdfRoute
                }
                else {
                    this.form_route = this.pdfRoute;
                }
                console.log('print modal created');
                console.log(this.pdfRoute);
                console.log(this.excelRoute);
                this.$nextTick(function () {
                    $(document).ready(function () {
                        $(".date").persianDatepicker(modelDate());
                    });
                });
            },
            template:
                `
                    <transition name="modal">
                        <div class="modal-mask" >
                            <div class="modal-wrapper" >
                                <div class="modal-container">
                                    <div class="modal-header">
                                        <slot name="header"></slot>
                                    </div>
                                    <div class="modal-body">
                                        <div class="form-group" v-if="pdfRoute !='' && excelRoute != ''">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label"><i class="fa fa file-pdf-o"></i> @lang('layout.PDF')</label>
                                                    <div class="input-group">
                                                        <input type="radio" name="print_type" value="pdf" v-model="print_type">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label"><i class="fa fa file-excel-o"></i> @lang('layout.Excel')</label>
                                                    <div class="input-group">
                                                        <input type="radio" name="print_type" :value="'excel'" v-model="print_type">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br/>
                                        <br/>
                                        <form v-bind:action="form_route" method="POST" class="inline" id="print-from000s">
                                            {!!  csrf_field() !!}
                                            <input type="hidden" name ="_method" value = "DELETE">
                                            <input type="hidden" name="type" :value="valueType"/>
                                            <input type="hidden" name="report_format" :value="print_type"/>
                                            <slot name="body"></slot>
                                        </form>
                                    </div>
                                    <div class="modal-footer">
                                        <slot name="footer">
                                            <button type=button class="modal-default-button btn btn-success" v-on:click="submitForPrint">
                                                @lang('layout.Submit')
                                            </button>
                                            <button type=button class="modal-default-button btn btn-danger" v-on:click="closeModal">
                                                @lang('layout.Cancel')
                                            </button>
                                        </slot>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </transition>
                `,
            methods: {
                closeModal() {
                    console.log("closed modal event triggered");
                    this.$emit('closed');
                },
                submitForPrint() {
                    // code for sumbiting the route
                    this.closeModal();
                    $("#print-from000s").submit();
                },
            }
        });
    </script>
@endpush

@section('styles')
    <style>
        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            overflow-y: auto;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }
        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }
        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
            transition: 1s; 
        }
        .modal-container:hover{
            /* transform: scale(1.1); */
        }
        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }
        .modal-body {
            margin: 20px 0;
        }
        .modal-default-button {
            float: right;
        }
        .modal-enter {
            opacity: 0;
        }
        .modal-leave-active {
            opacity: 0;
        }
        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }
    </style>
@endsection