@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PriceListDetails')
            </div>
            <div class=" pull-right">
                <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Item')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=""> {{ $priceList->source}}  </td>
                        <td class=""> {{ $priceList->item}}  </td>
                        <td class=""> {{ $priceList->currency }}  </td>
                        <td class=""> 
                            @if($priceList->status == 1) 
                            @lang('layout.Active')
                            @else
                            @lang('layout.Deactive')
                            @endif
                        </td>
                        <td class=""> {{ convertDate($priceList->date)}}  </td>
                        <td class=""> {{ $priceList->description }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th><center>@lang('layout.Destination')</center></th>
                        @foreach($priceListA as $row1)
                        <th style="min-width: 100px">
                            <center>
                            {{ $row1->name}}
                            </center>
                        </th>
                        @endforeach
                    </tr>
                    </thead>
                    <tbody>
                        @foreach($selectedDetail as $row)
                        <tr>
                            <td class=""> {{ $row['destination']}}  </td>
                            @foreach($row['cat'] as $row2)
                            <td class=""> {{ $row2['amount']}}  </td>
                            @endforeach
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


@endsection
@push('scripts')

    <script>
        
    </script>


@endpush
