@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'price_list'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Source') </label>
                                    <select name="source_id" id="" class="form-control">
                                        <option value="">@lang('layout.Select')</option>
                                        @foreach($inventorySite as  $site)
                                            <option value="{{$site->id}}">{{$site->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Status')</label>
                                    <select name="status" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="1">@lang('layout.Active')</option>
                                        <option value="deactive">@lang('layout.Deactive')</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Type') </label>
                                    <div class="input-group">
                                        <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                        <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.PriceList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('PriceList-export')

                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission
                    @permission('PriceList-create')
                    <a href="{{route('priceList.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="priceList">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Item')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


<script>

    function printFactore(id) {
        var a = document.createElement('a');
        a.href = "{{url('priceListFactor')}}/" + id;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

        Vue.component("v-select", VueSelect.VueSelect);

        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#priceList').DataTable({
                ajax: '{{route("priceList.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'price_lists.id'},
                    {data: 'source', name: 'inventory_sites.name'},
                    {data: 'item', name: 'price_lists.name'},
                    {data: 'currency', name: 'price_lists.currency'},
                    {data: 'status', name: 'price_lists.status', searchable: false},
                    {data: 'date', name: 'price_lists.date', searchable: false},
                    {data: 'description', name: 'price_lists.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("priceList.report") !!}',
                excelRoute: '{!! route("priceList.report") !!}',
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush
