@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense_detail');
$_name=in_array('name', $report);
$_symbol=in_array('symbol', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_total=in_array('total', $report);
$_otherCost=in_array('otherCost', $report);
$rate = 1;
?>
<h4></h4>
<table class="main-table">
 @if($info && $info !=[])
 <?php
 $rate = ($info->rate > 0)?$info->rate:1;
 ?>
 <tr>
  <td>
    <span>@lang('layout.Number')</span>:
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Type')</span>:
    <span>{{__('layout.'.ucfirst($info->type))}}</span>
  </td>
<td>
    <span>@lang('layout.TypeNumber')</span>:
    <span>{{$info->type_number}}</span>
  </td>
<td>
    <span>@lang('layout.Date')</span>:
    <span>{{ convertDate($info->date)}}</span>
  </td>
 
</tr>
<tr>

 <td>
  <span>@lang('layout.Account')</span>:
  <span>{{$info->account_name}}</span>
</td>
 <td>
  <span>@lang('layout.Amount')</span>:
  <span>{{$info->amount}}</span>
</td>
 <td>
  <span>@lang('layout.Currency')</span>:
  <span>{{$info->currency}}</span>
</td>
 <td>
  <span>@lang('layout.Rate')</span>:
  <span>{{$info->rate}}</span>
</td>

</tr>
@endif
</table>
<br/>
<!-- begin category List -->
<table class="main-table">
    <thead>
        <tr class="bg">
            <th class="text-center" >@lang('layout.ItemExpenseCategory')</th>
            <th class="text-center" >@lang('layout.Category')</th>
            <th class="text-center" >@lang('layout.Amount')</th>
        </tr>
    </thead>
    <tbody>
    @foreach($itemExpCategoryList AS $record1)
      <tr>
        <td  class="center">{{$record1->name}}</td>
        <td  class="center">{{__('layout.'.ucfirst($record1->category))}}</td>
        <td  class="center">{{$record1->amount}}</td>
      </tr>
    @endforeach 

    </tbody>
</table>
<!-- end category List -->
<br/>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseDetail')</h3>
@if(count($item_expense_detail))

<table class="main-table">

<thead>
  <tr class="bg">
 <td><div class="center">  @lang('layout.Record') </div></td>

 <td><div class="center"> @lang('layout.Category')</div></td>
 <td><div class="center"> @lang('layout.ItemName')</div></td>
  <td><div class="center"> @lang('layout.Measure')</div></td>
 <td><div class="center"> @lang('layout.Quantity')</div></td>
 @if($_total)<td><div class="center"> @lang('layout.UnitPrice')</div></td>@endif
 @if($_total)<td><div class="center"> @lang('layout.Total')</div></td>@endif


</tr>
</thead>
<?php
$count = 0;
$home_currency_total=0;

?>
@foreach($item_expense_detail AS $record)
<?php
$home_currency_total+=$record['items']['totalAmount'];
?>
<tr>
<td class="center">{{++$count}}</td>
<td  class="center">{{__('layout.'.ucfirst($record['items']['category']))}}</td>
<td  class="center">{{$record['items']['name']}}</td>
<td  class="center">{{$record['items']['measure']}}</td>
<td  class="center">{{$record['items']['qut_in']}}</td>
@if($_total)<td  class="center">{{myRound($record['items']['perAmount'])}}</td>@endif
@if($_total)<td  class="center">{{myRound($record['items']['totalAmount'])}}</td>@endif
</tr>
@endforeach  
</table>
<p>
{{myRound(($home_currency_total > 0)?($home_currency_total/$rate):0)}} {{getHomeCurrency()[getCurrencyType()]}}
</p>

@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection