@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop
@section('content')
@include('inventories.cmodal')  

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('layout.PriceListCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div id="priceList" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'priceList.store','method'=>'POST','class'=>'form-horizontal','id'=>'priceList-form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-lg-4 col-md-4">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>
                                <div class="col-lg-4 col-md-4">
                                    <label class="control-label ">@lang('layout.Source') </label>
                                    <select name="source_id" id="" class="form-control">
                                        <option value="">@lang('layout.Source')</option>
                                        @foreach($inventorySite as $site)
                                        <option value="{{$site->id}}">{{$site->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-4 col-md-4" >
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4" >
                                    <label class="control-label">@lang('layout.ItemName')</label>
                                    <input type="text" name="item" class="form-control" >
                                </div>
                                <div class="col-lg-8 col-md-8" >
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control" rows="1"></textarea>
                                </div>
                            </div>

                        </div>
                    </div>
                    <br>
                    <!-- begin items -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th><center>@lang('layout.Destination')</center></th>
                                <th style="min-width: 100px"  v-for="cat in priceListA">
                                    <center>
                                    @{{ cat.name }}
                                    </center>
                                </th>
                                <th> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select placeholder="@lang('layout.Destination') " label="name" :options="sites" @click.native="addNew(index)" @keyup.native="addNew(index)" v-model="item.site"></v-select>
                                    <input type="hidden" :name="'site_id['+index+']'" :value="(item.site)?item.site.id:null">
                                </td>
                                <template v-if="item.priceListA">
                                    <td v-for="cat in item.priceListA">
                                        <input type="number" class="form-control" :name="'priceList_amount_id['+index+']['+cat.id+']'" >
                                    </td>
                                </template>
                                <td>
                                    <span v-on:click="deleteItem(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <br/>
                        <br/>
                    </div>
                    <!-- end items -->

                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>        
                        <a href="{{route('priceList.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>

                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        var Modal = Vue.component('cmodal',
            {
                template:'#cmodal-template',
                props: ['show'],
            });

        var priceListA = {!! $priceListA !!};
        var currency = {!! $currency !!};
        var sites = {!! json_encode($inventorySite) !!};
        
        var vm = new Vue({
            el: '#priceList',
            data: {
                selected_type: 'purchase',
                type_number: '',
                selected_cost_type: 'posting',
                inventories: [],
                typeInfo: null,
                selected_expense_type: 'writeCheck',
                sites: sites,
                priceListA: priceListA,
                currency: currency,
                selected_currency: defaultCurrency(),
                banks: [],
                vendor: [],
                selected_vendor: null,
                selected_banks: null,
                defuilt_banks: null,
                rate: 0,
                payments: [],
                selected_category: null,
                showcModal: false,
                errorMessage: '',
                fieldErrors: [],
                className: null,
                description: null,
                itemExpenseCategory: []
            },
            computed: {
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    if (this.selected_vendor == null) {
                        isError = true;
                    }
                    return isError;


                },
                Total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {

						if (this.inventories[i] && this.inventories[i] != null) {

							
						if (this.inventories[i].item != null) {
							
							var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
							var cost = this.inventories[i].item.cost * rate;

                            sum+=Number(itemExpenseTotalItem(this.inventories[i].item,this.inventories[i].itemExpenseCategory));

						}
                           
                        }
						
                    }
                    return sum;

                },


                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },

                subtotal: function () {
					// console.log(this.inventories);
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i] && this.inventories[i] != null) {
                        var expenses = 0;
						if (this.inventories[i].itemExpenseCategory != null) {
							for(var z=0;z<this.inventories[i].itemExpenseCategory.length;z++)
							{
								if (this.inventories[i].itemExpenseCategory[z].amount != null) {
									expenses += Number.parseFloat(this.inventories[i].itemExpenseCategory[z].amount);
								}
							}
						}
							
						if (this.inventories[i].item != null) {
							
							var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
							var cost = this.inventories[i].item.cost * rate;
							if (this.inventories[i].item.category == 'total') {
								expenses = expenses / this.inventories[i].item.qut_in;
							}
							// total = cost + expenses;
								sum += expenses * rate;
						}

                    //  var sum = 0;
                    // for (var i = 0; i < this.inventories.length; i++) {
                        
                    //     if (this.inventories[i].item !=null && this.inventories[i].itemExpenseCategory) {

                    //         let itemExpenseCategoryArray=this.inventories[i].itemExpenseCategory;

                           
                    //             sum+=Number(itemExpenseTotalItem(this.inventories[i].item,itemExpenseCategoryArray));

                           
                        }

                    }
                    
                    return sum;
                },
                payeds: function () {

                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    this.selected_banks=null;
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        if (this.defuilt_banks) {
                            this.selected_banks = this.defuilt_banks;
                            this.defuilt_banks = null;
                        }else{
                            this.selected_banks = tempBank[0];
                        }
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                this.inventories.push({item:[],site:null,priceListA:priceListA});

            },
            methods: {
                
                numberChange() {
                    this.inventories = [];
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.vendor = [];
                            vm.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                
                getTotal(item = null) {
                    var total = 0;
                    if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += Number.parseFloat(item.itemExpenseCategory[i].amount);
							}
						}
					}
                        // var materialCost = Number(item.materialCost);
                        // var transportCost = Number(item.transportCost);
                        // var customeCost = Number(item.customeCost);
                        // var laborCost = Number(item.laborCost);
                        // var subContractorCost = Number(item.subContractorCost);
                        // var manufacturingCost = Number(item.manufacturingCost);
                        // var otherCost = Number(item.otherCost);
						
					if (item.item != null) {
						
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        var cost = item.item.cost * rate;
                        if (item.item.category == 'total') {
                            expenses = expenses / item.item.qut_in;
                        }
                        else {

                        }
                        total = cost + expenses;
                    }
                    }
                    return total;
                },

                //getTotalExpense
                getTotalExpense(item = null) {
                    var total = 0;
					if (item != null) {
                        var expenses = 0;
                    if (item.itemExpenseCategory != null) {
						for(var i=0;i<item.itemExpenseCategory.length;i++)
						{
							if (item.itemExpenseCategory[i].amount != null) {
								expenses += item.itemExpenseCategory[i].amount;
							}
						}
					}
					if (item.item != null) {
                        var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
                        var cost = item.item.cost * rate;
                        if (item.item.category == 'total') {
                            expenses = expenses;
                        }
                        else {

                        }
                        total = expenses;
                    }
                    }
                    return total;
                },

                // search stock based on type purchase/build/opening
                searchType() {
                    var id = document.getElementById('number').value;
                    this.inventories = [];
                    this.typeInfo = null;
                    if (id && this.selected_type) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemExpenseSearch',
                                type: this.selected_type,
                                number: id,
                            }
                        })
                            .then(function (response) {
                                // console.log('123', response.data);

                                if (response.data.length > 0) {

                                    if (response.data[0]) {
                                        vm.typeInfo = response.data[0].typeInfo;
                                        var myDataArray=response.data[0].myData;
                                        for(var i=0;i<myDataArray.length;i++)
                                        {
                                           
                                            vm.inventories.push({item:myDataArray[i].items,itemExpenseCategory:myDataArray[i].itemExpenseCategory});
                                            vm.itemExpenseCategory=myDataArray[i].itemExpenseCategory;

                                        }


                                    }

                                }
                                else {
                                    var id = response.data.id;
                                    if (id) {
                                        var url = "{{url('priceList')}}/" + id + '/edit';

                                        window.location.href = url;
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }

                },
                // end search type


                // in here you can check and decide to allow duplicate bank for payment or not
                checkExistingPayment(index = null, name = '') {
                    var bank_temp = this.banks.slice();
                    var bank_temp1 = [];
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                            if (fined != -1) {
                                var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                            }
                        }
                    }
                    this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
                    //this.payments[index].items =bank_temp;


                },
                saveAndNew() {
                    // console.log('eee');
                    var url = "{{route('priceList.store')}}";
                    form_id = 'priceList-form';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                    .then(function (response) {
                        toggleBlock(0);

                        if (response.data.result == 1) {
                            $('#' + form_id).trigger('reset');
                            //$('#success-sound')[0].play();
                            toastr.success('', response.data.message);
                            location.reload();
                            // sales.defaultValueM();
                        }
                        else {
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        }
                    })
                    .catch(function (error) {
                        toggleBlock(0);
                        console.log(error);
                        var message = "{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    });

                },

                // generic function for adding item to list
                addNew(index) {
                    if (this.inventories[index + 1] == undefined) {
                        this.inventories.push({item:[],site:null,priceListA:priceListA});
                    }


                },
                // delete item from list
                deleteItem(index) {
                    if (this.inventories.length > 1) {
                        this.inventories.splice(index, 1);
                    }

                },


            }
        });

    </script>
@endpush
 